/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dataaccess;

import java.util.Arrays;

class CommonData {
    public static final int HIGHER_NIBBLE_MASK = 240;
    public static final int LOWER_NIBBLE_MASK = 15;
    public static final int INTEGER_MASK = 255;
    static final byte PACKED_ZERO = 0;
    static final byte PACKED_SIGNED_ZERO = 12;
    static final byte PACKED_PLUS = 12;
    static final byte PACKED_MINUS = 13;
    private static final byte PACKED_ALT_PLUS = 15;
    private static final byte PACKED_ALT_PLUS1 = 14;
    private static final byte PACKED_ALT_PLUS2 = 10;
    private static final byte PACKED_ALT_MINUS = 11;
    protected static final byte EXTERNAL_SIGN_PLUS = 78;
    protected static final byte EXTERNAL_SIGN_MINUS = 96;
    protected static final byte EXTERNAL_EMBEDDED_SIGN_PLUS = -64;
    protected static final byte EXTERNAL_EMBEDDED_SIGN_MINUS = -48;
    protected static final byte EXTERNAL_EMBEDDED_SIGN_PLUS_ALTERNATE_A = -96;
    protected static final byte EXTERNAL_EMBEDDED_SIGN_PLUS_ALTERNATE_E = -32;
    protected static final byte EXTERNAL_EMBEDDED_SIGN_PLUS_ALTERNATE_F = -16;
    protected static final byte EXTERNAL_EMBEDDED_SIGN_MINUS_ALTERNATE_B = -80;
    protected static final byte PACKED_INVALID_DIGIT = -1;
    private static final int BYTE_ARITHMETICS_TABLE_LENGTH = 1024;
    private static final byte[] packedSumValues = new byte[1024];
    private static final byte[] packedSumPlusOneValues = new byte[1024];
    private static final byte[] packedDifferenceValues = new byte[1024];
    private static final byte[] packedDifferenceMinusOneValues = new byte[1024];

    CommonData() {
    }

    public static int getPackedSumValues(int input) {
        return packedSumValues[input] & 0xFF;
    }

    public static int getExternalByteCounts(int precision, int decimalType) {
        switch (decimalType) {
            case 1: 
            case 2: {
                return precision;
            }
            case 3: 
            case 4: {
                return precision + 1;
            }
        }
        throw new IllegalArgumentException("illegal decimalType.");
    }

    public static byte getPackedSumPlusOneValues(int input) {
        return packedSumPlusOneValues[input];
    }

    public static byte getPackedDifferenceValues(int input) {
        return packedDifferenceValues[input];
    }

    public static byte getPackedDifferenceMinusOneValues(int input) {
        return packedDifferenceMinusOneValues[input];
    }

    public static byte getPackedAddOneValues(byte input) {
        int carryHighDigit = (input & 0xF0) >> 4;
        int carryLowDigit = (input & 0xF) + 1;
        if (carryLowDigit == 10) {
            carryLowDigit = 0;
            if (++carryHighDigit == 10) {
                carryHighDigit = 0;
            }
        }
        return (byte)((carryHighDigit << 4) + carryLowDigit);
    }

    public static byte getPackedBorrowOneValues(byte input) {
        int borrowHighDigit = (input & 0xF0) >> 4;
        int borrowLowDigit = (input & 0xF) - 1;
        if (borrowLowDigit < 0) {
            borrowLowDigit = 9;
            if (--borrowHighDigit < 0) {
                borrowHighDigit = 9;
            }
        }
        return (byte)((borrowHighDigit << 4) + borrowLowDigit);
    }

    public static int getPackedToBinaryValues(int input) {
        return ((input & 0xF0) >> 4) * 10 + (input & 0xF);
    }

    public static byte getBinaryToPackedValues(int input) {
        int value = (input / 10 << 4) + input % 10;
        return (byte)value;
    }

    public static byte getSign(int i) {
        return (byte)(i == 13 || i == 11 ? 13 : 12);
    }

    public static int getPackedByteCount(int precision) {
        return precision / 2 + 1;
    }

    public static byte getPackedAddOneSignValues(byte input) {
        int digit = (input & 0xF0) >> 4;
        if (++digit == 10) {
            digit = 0;
        }
        return (byte)(digit << 4 | input & 0xF);
    }

    public static void setPackedSumArrays(int i, int j, int m, int n) {
        byte byteValue;
        int opAIndexValue = (i << 5) + j;
        int opBIndexValue = (m << 5) + n;
        int valueIdx = opAIndexValue + opBIndexValue;
        int onesValue = (j + n) % 10;
        int tensValue = onesValue < j ? (i + m + 1) % 10 : (i + m) % 10;
        CommonData.packedSumValues[valueIdx] = byteValue = (byte)((tensValue << 4) + onesValue);
        onesValue = (j + n + 1) % 10;
        tensValue = onesValue <= j ? (i + m + 1) % 10 : (i + m) % 10;
        CommonData.packedSumPlusOneValues[valueIdx] = byteValue = (byte)((tensValue << 4) + onesValue);
        valueIdx = opAIndexValue - opBIndexValue & 0x3FF;
        onesValue = (j - n + 10) % 10;
        tensValue = onesValue > j ? (i - m - 1 + 10) % 10 : (i - m + 10) % 10;
        byteValue = (byte)((tensValue << 4) + onesValue);
        if (packedDifferenceValues[valueIdx] == -1) {
            CommonData.packedDifferenceValues[valueIdx] = byteValue;
        }
        tensValue = (onesValue = (j - n - 1 + 10) % 10) >= j ? (i - m - 1 + 10) % 10 : (i - m + 10) % 10;
        CommonData.packedDifferenceMinusOneValues[valueIdx] = byteValue = (byte)((tensValue << 4) + onesValue);
    }

    static {
        Arrays.fill(packedSumValues, (byte)-1);
        Arrays.fill(packedSumPlusOneValues, (byte)-1);
        Arrays.fill(packedDifferenceValues, (byte)-1);
        Arrays.fill(packedDifferenceMinusOneValues, (byte)-1);
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                for (int m = 0; m < 10; ++m) {
                    for (int n = 0; n < 10; ++n) {
                        CommonData.setPackedSumArrays(i, j, m, n);
                    }
                }
            }
        }
    }
}

