/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.io;

import com.ibm.CORBA.ras.Trc;
import com.ibm.rmi.io.ObjectStreamClass;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;

public class IBMComputeSerialVersionUIDStrategy {
    private static final String CLASS = IBMComputeSerialVersionUIDStrategy.class.getName();
    private static final Method HASSTATICINITIALIZER;
    static final IBMComputeSerialVersionUIDStrategy INSTANCE;
    private static final String thisClassName;
    private static final int CLASS_MASK = 1553;
    private static final int FIELD_MASK = 223;
    private static final int METHOD_MASK = 3391;

    long _computeSerialVersionUID(Class clazz, boolean bl) {
        long l = 0L;
        if (bl) {
            return l;
        }
        try {
            Object object;
            int n;
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
            DigestOutputStream digestOutputStream = new DigestOutputStream(byteArrayOutputStream, messageDigest);
            DataOutputStream dataOutputStream = new DataOutputStream(digestOutputStream);
            dataOutputStream.writeUTF(clazz.getName());
            int n2 = clazz.getModifiers();
            Member[] memberArray = ObjectStreamClass.getDeclaredMethods(clazz);
            if (((n2 &= 0x611) & 0x200) != 0) {
                n2 &= 0xFFFFFBFF;
                if (memberArray.length > 0) {
                    n2 |= 0x400;
                }
            }
            dataOutputStream.writeInt(n2 &= 0x611);
            Class<?>[] classArray = clazz.getInterfaces();
            Arrays.sort(classArray, ObjectStreamClass.compareClassByName);
            for (int i = 0; i < classArray.length; ++i) {
                dataOutputStream.writeUTF(classArray[i].getName());
            }
            Field[] fieldArray = ObjectStreamClass.getDeclaredFields(clazz);
            Arrays.sort(fieldArray, ObjectStreamClass.compareMemberByName);
            for (int i = 0; i < fieldArray.length; ++i) {
                Field field = fieldArray[i];
                n = field.getModifiers();
                if (Modifier.isPrivate(n) && (Modifier.isTransient(n) || Modifier.isStatic(n))) continue;
                dataOutputStream.writeUTF(field.getName());
                dataOutputStream.writeInt(n &= 0xDF);
                dataOutputStream.writeUTF(ObjectStreamClass.getSignature(field.getType()));
            }
            if (IBMComputeSerialVersionUIDStrategy.hasStaticInitializer(clazz)) {
                dataOutputStream.writeUTF("<clinit>");
                dataOutputStream.writeInt(8);
                dataOutputStream.writeUTF("()V");
            }
            ObjectStreamClass.MethodSignature[] methodSignatureArray = ObjectStreamClass.MethodSignature.removePrivateAndSort(ObjectStreamClass.getDeclaredConstructors(clazz));
            for (n = 0; n < methodSignatureArray.length; ++n) {
                ObjectStreamClass.MethodSignature methodSignature = methodSignatureArray[n];
                object = methodSignature.signature;
                object = ((String)object).replace('/', '.');
                dataOutputStream.writeUTF("<init>");
                int n3 = methodSignature.member.getModifiers() & 0xD3F;
                dataOutputStream.writeInt(n3);
                dataOutputStream.writeUTF((String)object);
                methodSignature.clearMember();
            }
            ObjectStreamClass.MethodSignature[] methodSignatureArray2 = ObjectStreamClass.MethodSignature.removePrivateAndSort(memberArray);
            for (int i = 0; i < methodSignatureArray2.length; ++i) {
                object = methodSignatureArray2[i];
                String string = ((ObjectStreamClass.MethodSignature)object).signature;
                string = string.replace('/', '.');
                dataOutputStream.writeUTF(((ObjectStreamClass.MethodSignature)object).member.getName());
                int n4 = ((ObjectStreamClass.MethodSignature)object).member.getModifiers() & 0xD3F;
                dataOutputStream.writeInt(n4);
                dataOutputStream.writeUTF(string);
                ((ObjectStreamClass.MethodSignature)object).clearMember();
            }
            dataOutputStream.flush();
            byte[] byArray = messageDigest.digest();
            for (int i = 0; i < Math.min(8, byArray.length); ++i) {
                l += (long)(byArray[i] & 0xFF) << i * 8;
            }
        }
        catch (IOException iOException) {
            l = -1L;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Trc.ffdc(noSuchAlgorithmException, thisClassName, "_computeSerialVersionUID:223");
            SecurityException securityException = new SecurityException(clazz.getName() + ":" + noSuchAlgorithmException.toString());
            securityException.initCause(noSuchAlgorithmException);
            throw securityException;
        }
        return l;
    }

    static boolean hasStaticInitializer(Class clazz) {
        try {
            return (Boolean)HASSTATICINITIALIZER.invoke(null, clazz);
        }
        catch (Exception exception) {
            Trc.ffdc(exception, thisClassName, "hasStaticInitializer:239");
            RuntimeException runtimeException = new RuntimeException(clazz.getName());
            runtimeException.initCause(exception);
            throw runtimeException;
        }
    }

    static {
        INSTANCE = new IBMComputeSerialVersionUIDStrategy();
        thisClassName = IBMComputeSerialVersionUIDStrategy.class.getName();
        Method method = null;
        try {
            method = (Method)AccessController.doPrivileged(new InitAction());
        }
        catch (Exception exception) {
            if (Trc.enabled(2)) {
                Trc.info(Trc.FINEST, exception, thisClassName, "<clinit>:67");
            }
        }
        finally {
            HASSTATICINITIALIZER = method;
        }
    }

    private static class InitAction
    implements PrivilegedExceptionAction {
        private InitAction() {
        }

        public Object run() throws Exception {
            Class[] classArray = new Class[]{Class.class};
            Class<java.io.ObjectStreamClass> clazz = java.io.ObjectStreamClass.class;
            Method method = null;
            try {
                method = clazz.getDeclaredMethod("hasStaticInitializer", classArray);
                method.setAccessible(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return method;
        }
    }
}

