/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.amino.refq;

import com.ibm.CORBA.ras.Trc;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ReflectPermission;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import sun.misc.Cleaner;

public class ReferenceQueueLF<T>
extends ReferenceQueue<T> {
    private static final String CLASS = "ReferenceQueueLF";
    private Queue<Reference> references = new ConcurrentLinkedQueue<Reference>();
    private static final Class reflectRefClass;
    private static Method dequeueMethod;

    @Override
    public Reference<? extends T> poll() {
        Reference reference = this.references.poll();
        if (reference != null) {
            this.invokeDequeueMethod(reference);
        }
        return reference;
    }

    @Override
    public Reference<? extends T> remove() throws InterruptedException {
        return this.remove(0L);
    }

    @Override
    public Reference<? extends T> remove(long l) throws IllegalArgumentException, InterruptedException {
        if (l < 0L) {
            throw new IllegalArgumentException();
        }
        Reference reference = this.references.poll();
        if (reference != null) {
            this.invokeDequeueMethod(reference);
        }
        return reference;
    }

    private void invokeDequeueMethod(Reference reference) {
        try {
            dequeueMethod.invoke((Object)reference, (Object[])null);
        }
        catch (Exception exception) {
            Trc.ffdc(exception, CLASS, "invokeDequeueMethod:132");
            exception.printStackTrace();
        }
    }

    boolean enqueue(Reference reference) {
        if (reference instanceof Cleaner) {
            this.invokeDequeueMethod(reference);
            ((Cleaner)reference).clean();
            return true;
        }
        if (reference.getClass() == reflectRefClass) {
            this.invokeDequeueMethod(reference);
            ((Runnable)((Object)reference)).run();
            return true;
        }
        this.references.offer(reference);
        return true;
    }

    public static Method getDequeueMethod() {
        return dequeueMethod;
    }

    static {
        dequeueMethod = null;
        Class<Cleaner> clazz = Cleaner.class;
        Class<?> clazz2 = null;
        try {
            clazz2 = Class.forName("java.lang.Class$ReflectRef");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        reflectRefClass = clazz2;
        dequeueMethod = AccessController.doPrivileged(new AccessAction());
    }

    private static final class AccessAction
    implements PrivilegedAction<Method> {
        private static final Permission accessPermission = new ReflectPermission("suppressAccessChecks");

        AccessAction() {
        }

        @Override
        public Method run() {
            SecurityManager securityManager = System.getSecurityManager();
            try {
                if (null != securityManager) {
                    securityManager.checkPermission(accessPermission);
                }
            }
            catch (SecurityException securityException) {
                Trc.ffdc(securityException, ReferenceQueueLF.CLASS, "run:196");
                return null;
            }
            return this.getAccessibleDequeueMethod();
        }

        private Method getAccessibleDequeueMethod() {
            Method method = null;
            try {
                Class<?> clazz = Class.forName("java.lang.ref.Reference");
                method = clazz.getDeclaredMethod("dequeue", null);
                int n = method.getModifiers();
                if (!Modifier.isPublic(n)) {
                    method.setAccessible(true);
                }
            }
            catch (Exception exception) {
                method = null;
                Trc.ffdc(exception, ReferenceQueueLF.CLASS, "getAccessibleDequeueMethod:214");
            }
            return method;
        }
    }
}

