/*
 * Decompiled with CFR 0.152.
 */
package openj9.internal.tools.attach.target;

import com.ibm.oti.vm.VM;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import openj9.internal.tools.attach.target.Advertisement;
import openj9.internal.tools.attach.target.Attachment;
import openj9.internal.tools.attach.target.CommonDirectory;
import openj9.internal.tools.attach.target.FileLock;
import openj9.internal.tools.attach.target.IPC;
import openj9.internal.tools.attach.target.Reply;
import openj9.internal.tools.attach.target.TargetDirectory;
import openj9.internal.tools.attach.target.WaitLoop;

public class AttachHandler
extends Thread {
    private static final String VMID_PROPERTY = "com.ibm.tools.attach.id";
    private static final String DISPLAYNAME_PROPERTY = "com.ibm.tools.attach.displayName";
    static final String LOGGING_ENABLE_PROPERTY = "com.ibm.tools.attach.logging";
    static final String LOG_NAME_PROPERTY = "com.ibm.tools.attach.log.name";
    static final String VMID_VALID_PATTERN = "\\p{Alpha}\\w*";
    static final long shutdownTimeoutMs = Long.getLong("com.ibm.tools.attach.shutdown_timeout", 10000L);
    static AttachHandler mainHandler = new AttachHandler();
    static volatile Thread currentAttachThread = mainHandler;
    private Vector<Attachment> attachments = new Vector();
    static String vmId = "";
    private String displayName;
    private static AttachStateValues attachState = AttachStateValues.ATTACH_UNINITIALIZED;
    private static boolean waitingForSemaphore = false;
    static AttachStateSync stateSync = new AttachStateSync();
    static int notificationCount;
    private static boolean doCancelNotify;
    private final syncObject ignoreNotification = new syncObject();
    private static final syncObject accessorMutex;
    private static String nameProperty;
    private static String pidProperty;
    private static int numberOfTargets;
    public static final boolean selfAttachAllowed;
    FileLock syncFileLock;
    static volatile Thread fileAccessTimeUpdaterThread;

    private AttachHandler() {
        super("Attach API initializer");
        this.setDaemon(true);
    }

    static void initializeAttachAPI() {
        if (IPC.isUsingDefaultUid()) {
            AttachHandler.setAttachState(AttachStateValues.ATTACH_TERMINATED);
            return;
        }
        boolean enableAttach = !IPC.isZOS;
        String enableAttachProp = VM.internalGetProperties().getProperty("com.ibm.tools.attach.enable");
        if (null != enableAttachProp) {
            if (enableAttachProp.equalsIgnoreCase("no")) {
                enableAttach = false;
            } else if (enableAttachProp.equalsIgnoreCase("yes")) {
                enableAttach = true;
            }
        }
        if (enableAttach) {
            Runtime.getRuntime().addShutdownHook(new teardownHook());
            mainHandler.start();
        } else {
            AttachHandler.setAttachState(AttachStateValues.ATTACH_TERMINATED);
        }
    }

    private static String validateVmId(String id) {
        if (null != id && !id.matches(VMID_VALID_PATTERN)) {
            id = null;
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createFiles(String newDisplayName) throws IOException {
        try {
            if (CommonDirectory.tryObtainControllerLock("AttachHandler.createFiles(" + newDisplayName + ")_1")) {
                CommonDirectory.deleteStaleDirectories(pidProperty);
            } else {
                CommonDirectory.obtainControllerLock("AttachHandler.createFiles(" + newDisplayName + ")_2");
            }
            if (1 != IPC.loggingStatus) {
                IPC.logMessage("AttachHandler obtained controller lock");
            }
            CommonDirectory.createNotificationFile();
            if (AttachHandler.isAttachApiTerminated()) {
                boolean bl = false;
                return bl;
            }
            String myId = TargetDirectory.createMyDirectory(pidProperty, true);
            if (null == myId) {
                boolean bl = false;
                return bl;
            }
            AttachHandler.setVmId(myId);
            this.setDisplayName(newDisplayName);
            CommonDirectory.openSemaphore();
            Advertisement.createAdvertisementFile(AttachHandler.getVmId(), newDisplayName);
        }
        finally {
            CommonDirectory.releaseControllerLock("AttachHandler.createFiles(" + newDisplayName + ")");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        VM.markCurrentThreadAsSystem();
        AttachStateSync attachStateSync = stateSync;
        synchronized (attachStateSync) {
            if (AttachStateValues.ATTACH_UNINITIALIZED != AttachHandler.getAttachState()) {
                return;
            }
            AttachHandler.setAttachState(AttachStateValues.ATTACH_STARTING);
        }
        try {
            if (!this.initialize()) {
                IPC.logMessage("ERROR: failed to initialize");
                return;
            }
            WaitLoop waiter = new WaitLoop();
            AttachStateSync attachStateSync2 = stateSync;
            synchronized (attachStateSync2) {
                if (AttachHandler.isAttachApiTerminated()) {
                    return;
                }
                AttachHandler.setAttachState(AttachStateValues.ATTACH_INITIALIZED);
                currentAttachThread = waiter;
            }
            waiter.start();
        }
        catch (OutOfMemoryError e) {
            AttachHandler.setAttachState(AttachStateValues.ATTACH_TERMINATED);
            return;
        }
        catch (IOException e) {
            AttachHandler.setAttachState(AttachStateValues.ATTACH_TERMINATED);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initialize() throws IOException {
        Properties internalProperties = VM.internalGetProperties();
        String loggingProperty = internalProperties.getProperty(LOGGING_ENABLE_PROPERTY);
        String logName = internalProperties.getProperty(LOG_NAME_PROPERTY);
        logName = null != logName && !logName.equals("") ? logName + '_' : "";
        nameProperty = internalProperties.getProperty(DISPLAYNAME_PROPERTY);
        pidProperty = AttachHandler.validateVmId(internalProperties.getProperty(VMID_PROPERTY));
        if (null == pidProperty || 0 == pidProperty.length()) {
            long pid = IPC.getProcessId();
            pidProperty = Long.toString(pid);
        }
        if (null == nameProperty) {
            nameProperty = internalProperties.getProperty("sun.java.command");
        }
        Object pid = IPC.accessorMutex;
        synchronized (pid) {
            if (null == IPC.logStream && null != loggingProperty && loggingProperty.equalsIgnoreCase("yes")) {
                File logFile = new File(logName + pidProperty + ".log");
                IPC.logStream = new PrintStream(logFile);
                IPC.setDefaultVmId(pidProperty);
                IPC.printMessageWithHeader("AttachHandler initialized", IPC.logStream);
                IPC.loggingStatus = 2;
            } else {
                IPC.loggingStatus = 1;
            }
        }
        pid = stateSync;
        synchronized (pid) {
            if (AttachHandler.isAttachApiTerminated()) {
                IPC.logMessage("cancel initialize before prepareCommonDirectory");
                return false;
            }
            CommonDirectory.prepareCommonDirectory();
        }
        try {
            if (!this.createFiles(nameProperty)) {
                return false;
            }
        }
        catch (IOException e) {
            IPC.logMessage("AttachHandler IOException while creating files: ", e.getMessage());
            this.terminate(false);
            return false;
        }
        File syncFileObjectTemp = TargetDirectory.getSyncFileObject();
        if (AttachHandler.isAttachApiTerminated() || null == syncFileObjectTemp) {
            IPC.logMessage("cancel initialize before creating syncFileLock");
            return false;
        }
        this.syncFileLock = new FileLock(syncFileObjectTemp.getAbsolutePath(), 438);
        if (IPC.isLinux) {
            int sleepDays = 8;
            String fileAccessUpdateTime = internalProperties.getProperty("com.ibm.tools.attach.fileAccessUpdateTime", "8");
            IPC.logMessage("fileAccessUpdateTime = " + fileAccessUpdateTime);
            try {
                sleepDays = Integer.parseInt(fileAccessUpdateTime);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            IPC.logMessage("fileAccessTimeUpdaterThread sleepDays = " + sleepDays);
            if (sleepDays > 0) {
                final long targetIntervalMillis = TimeUnit.DAYS.toMillis(sleepDays);
                String lastAccessTime = "lastAccessTime";
                final String commonDir = CommonDirectory.getCommonDirFileObject().getPath();
                fileAccessTimeUpdaterThread = new Thread("Attach API update file access time"){

                    @Override
                    public void run() {
                        VM.markCurrentThreadAsSystem();
                        long lastMillis = System.currentTimeMillis();
                        long sleepMillis = targetIntervalMillis;
                        while (true) {
                            try {
                                Thread.sleep(sleepMillis);
                            }
                            catch (InterruptedException ie) {
                                IPC.logMessage("fileAccessTimeUpdaterThread received an InterruptedException: " + ie.getMessage());
                            }
                            if (AttachHandler.isAttachApiTerminated()) break;
                            long currentMillis = System.currentTimeMillis();
                            long passedMillis = currentMillis - lastMillis;
                            if (passedMillis >= sleepMillis) {
                                FileTime fileTime = FileTime.fromMillis(currentMillis);
                                IPC.logMessage("fileAccessTimeUpdaterThread currentMillis = " + currentMillis);
                                try {
                                    File attachLock = new File(commonDir, "_attachlock");
                                    if (attachLock.exists()) {
                                        Files.setAttribute(Paths.get(attachLock.getPath(), new String[0]), "lastAccessTime", fileTime, new LinkOption[0]);
                                        IPC.logMessage("fileAccessTimeUpdaterThread updated access time = " + attachLock);
                                    }
                                    Files.setAttribute(Paths.get(commonDir, "_controller"), "lastAccessTime", fileTime, new LinkOption[0]);
                                    Files.setAttribute(Paths.get(commonDir, "_notifier"), "lastAccessTime", fileTime, new LinkOption[0]);
                                    Files.setAttribute(Paths.get(TargetDirectory.getSyncFileObject().getPath(), new String[0]), "lastAccessTime", fileTime, new LinkOption[0]);
                                    Files.setAttribute(Paths.get(TargetDirectory.getAdvertisementFileObject().getPath(), new String[0]), "lastAccessTime", fileTime, new LinkOption[0]);
                                }
                                catch (IOException ioe) {
                                    IPC.logMessage("fileAccessTimeUpdaterThread received an IOException : " + ioe.getMessage());
                                }
                                sleepMillis = targetIntervalMillis;
                                lastMillis = currentMillis;
                                continue;
                            }
                            sleepMillis = targetIntervalMillis - passedMillis;
                            IPC.logMessage("fileAccessTimeUpdaterThread currentMillis = " + currentMillis + ", passedMillis = " + passedMillis + ", sleepMillis = " + sleepMillis);
                        }
                        IPC.logMessage("AttachAPI was terminated, fileAccessTimeUpdaterThread exits");
                    }
                };
                fileAccessTimeUpdaterThread.setDaemon(true);
                if (AttachHandler.isAttachApiTerminated()) {
                    IPC.logMessage("AttachAPI was already terminated, no need to start fileAccessTimeUpdaterThread");
                    return false;
                }
                fileAccessTimeUpdaterThread.start();
            }
        }
        return true;
    }

    public Attachment connectToAttacher() throws IOException {
        String targetDirectoryPath = TargetDirectory.getTargetDirectoryPath(AttachHandler.getVmId());
        IPC.checkOwnerAccessOnly(targetDirectoryPath);
        Reply attacherReply = Reply.readReply(targetDirectoryPath);
        Attachment at = null;
        if (null != attacherReply) {
            int portNumber = attacherReply.getPortNumber();
            IPC.logMessage(notificationCount + " connectToAttacher reply on port ", portNumber);
            if (portNumber >= 0) {
                at = new Attachment(mainHandler, attacherReply.getPortNumber(), attacherReply.getKey());
                this.addAttachment(at);
                at.start();
            }
        } else if (1 != IPC.loggingStatus) {
            IPC.logMessage("connectToAttacher ", notificationCount, " waitForNotification no reply file");
        }
        return at;
    }

    public void attachSelf(int portNumber, String key) {
        IPC.logMessage(notificationCount + " attachSelf on port ", portNumber);
        Attachment at = new Attachment(mainHandler, portNumber, key);
        this.addAttachment(at);
        at.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean terminate(boolean wakeHandler) {
        if (1 != IPC.loggingStatus) {
            IPC.logMessage("AttachHandler terminate: Attach API is being shut down, currentAttachThread = " + currentAttachThread);
        }
        AttachStateSync attachStateSync = stateSync;
        synchronized (attachStateSync) {
            AttachStateValues myAttachState = AttachHandler.getAttachState();
            AttachHandler.setAttachState(AttachStateValues.ATTACH_TERMINATED);
            switch (myAttachState) {
                case ATTACH_UNINITIALIZED: {
                    return false;
                }
                case ATTACH_STARTING: {
                    break;
                }
                case ATTACH_INITIALIZED: {
                    break;
                }
                case ATTACH_TERMINATED: {
                    return false;
                }
                default: {
                    IPC.logMessage("Unrecognized synchronization state " + stateSync.toString());
                }
            }
        }
        if (fileAccessTimeUpdaterThread != null && fileAccessTimeUpdaterThread.isAlive()) {
            IPC.logMessage("fileAccessTimeUpdaterThread interrupt");
            fileAccessTimeUpdaterThread.interrupt();
        }
        currentAttachThread.interrupt();
        if (wakeHandler) {
            if (1 != IPC.loggingStatus) {
                IPC.logMessage("AttachHandler terminate removing contents of directory : ", TargetDirectory.getTargetDirectoryPath(AttachHandler.getVmId()));
            }
            TargetDirectory.deleteMyFiles();
        } else {
            if (1 != IPC.loggingStatus) {
                IPC.logMessage("AttachHandler terminate removing directory : ", TargetDirectory.getTargetDirectoryPath(AttachHandler.getVmId()));
            }
            TargetDirectory.deleteMyDirectory(false);
        }
        for (Attachment a : this.attachments) {
            if (null == a) continue;
            a.teardown();
        }
        FileLock.shutDown();
        return AttachHandler.terminateWaitLoop(wakeHandler, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean terminateWaitLoop(boolean wakeHandler, int retryNumber) {
        boolean gotLock = false;
        boolean destroySemaphore = false;
        long lockDeadline = System.nanoTime() + shutdownTimeoutMs * 1000000L / 10L;
        try {
            gotLock = CommonDirectory.tryObtainControllerLock("AttachHandler.terminateWaitLoop(" + wakeHandler + "," + retryNumber + ")_1");
            while (!gotLock && AttachHandler.isWaitingForSemaphore()) {
                Thread.sleep(10L);
                gotLock = CommonDirectory.tryObtainControllerLock("AttachHandler.terminateWaitLoop(" + wakeHandler + "," + retryNumber + ")_2");
                if (System.nanoTime() <= lockDeadline) continue;
                break;
            }
        }
        catch (InterruptedException e) {
            IPC.logMessage("InterruptedException while waiting to shut down", e);
        }
        if (!AttachHandler.isWaitingForSemaphore()) {
            wakeHandler = false;
            if (1 != IPC.loggingStatus) {
                IPC.logMessage("VM already notified for termination, abandoning controller lock");
            }
            if (gotLock) {
                CommonDirectory.releaseControllerLock("AttachHandler.terminateWaitLoop(" + wakeHandler + "," + retryNumber + ")_3");
                gotLock = false;
            }
        }
        if (gotLock) {
            try {
                if (1 != IPC.loggingStatus) {
                    IPC.logMessage("AttachHandler terminate obtained controller lock");
                }
                int numTargets = CommonDirectory.countTargetDirectories() + retryNumber;
                AttachHandler.setNumberOfTargets(numTargets);
                if (numTargets <= 1) {
                    AttachHandler.setDoCancelNotify(false);
                    if (wakeHandler) {
                        CommonDirectory.notifyVm(1, true, "AttachHandler.terminateWaitLoop_1");
                    }
                    destroySemaphore = true;
                    return destroySemaphore;
                }
                if (!wakeHandler) return destroySemaphore;
                AttachHandler.setDoCancelNotify(true);
                CommonDirectory.notifyVm(numTargets, true, "AttachHandler.terminateWaitLoop_2");
                return destroySemaphore;
            }
            finally {
                CommonDirectory.releaseControllerLock("AttachHandler.terminateWaitLoop(" + wakeHandler + "," + retryNumber + ")_4");
                if (1 != IPC.loggingStatus) {
                    IPC.logMessage("AttachHandler terminate released controller lock");
                }
            }
        } else {
            IPC.logMessage("AttachHandler tryObtainControllerLock failed");
        }
        return destroySemaphore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean waitForAttachApiInitialization() {
        boolean status;
        AttachStateSync attachStateSync = stateSync;
        synchronized (attachStateSync) {
            AttachStateValues currentState = AttachHandler.getAttachState();
            if (AttachStateValues.ATTACH_INITIALIZED == currentState) {
                status = true;
            } else if (AttachStateValues.ATTACH_TERMINATED == currentState) {
                status = false;
            } else {
                int waitCycles = 2;
                status = false;
                block10: while (waitCycles > 0) {
                    --waitCycles;
                    try {
                        IPC.logMessage("AttachHandler.waitForAttachApiInitialization waitCycles = " + waitCycles);
                        stateSync.wait(30000L);
                        currentState = AttachHandler.getAttachState();
                        switch (currentState) {
                            case ATTACH_STARTING: {
                                continue block10;
                            }
                            case ATTACH_INITIALIZED: {
                                status = true;
                                waitCycles = 0;
                                continue block10;
                            }
                            case ATTACH_TERMINATED: {
                                waitCycles = 0;
                                continue block10;
                            }
                        }
                        waitCycles = 0;
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                        break;
                    }
                }
            }
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setNumberOfTargets(int numberOfTargets) {
        syncObject syncObject2 = accessorMutex;
        synchronized (syncObject2) {
            AttachHandler.numberOfTargets = numberOfTargets;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int getNumberOfTargets() {
        syncObject syncObject2 = accessorMutex;
        synchronized (syncObject2) {
            return numberOfTargets;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addAttachment(Attachment at) {
        syncObject syncObject2 = accessorMutex;
        synchronized (syncObject2) {
            this.attachments.add(at);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAttachment(Attachment attachment) {
        syncObject syncObject2 = accessorMutex;
        synchronized (syncObject2) {
            int pos = this.attachments.indexOf(attachment);
            if (pos > 0) {
                this.attachments.remove(pos);
            }
        }
    }

    static Properties getAgentProperties() {
        String[] agentPropertyNames = new String[]{"com.sun.management.jmxremote.localConnectorAddress", "sun.jvm.args", "sun.jvm.flags", "sun.java.command"};
        Attachment.saveLocalConnectorAddress();
        Properties agentProperties = new Properties();
        Properties internalProperties = VM.internalGetProperties();
        for (String pName : agentPropertyNames) {
            String pValue = internalProperties.getProperty(pName);
            if (null == pValue) continue;
            agentProperties.put(pName, pValue);
        }
        return agentProperties;
    }

    public static boolean isAttachApiInitialized() {
        return AttachStateValues.ATTACH_INITIALIZED == AttachHandler.getAttachState();
    }

    public static boolean isAttachApiTerminated() {
        return AttachStateValues.ATTACH_TERMINATED == AttachHandler.getAttachState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AttachStateValues getAttachState() {
        AttachStateSync attachStateSync = stateSync;
        synchronized (attachStateSync) {
            return attachState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isWaitingForSemaphore() {
        AttachStateSync attachStateSync = stateSync;
        synchronized (attachStateSync) {
            return waitingForSemaphore;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean startWaitingForSemaphore() {
        AttachStateSync attachStateSync = stateSync;
        synchronized (attachStateSync) {
            waitingForSemaphore = attachState != AttachStateValues.ATTACH_TERMINATED;
            return waitingForSemaphore;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void endWaitingForSemaphore() {
        AttachStateSync attachStateSync = stateSync;
        synchronized (attachStateSync) {
            waitingForSemaphore = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setAttachState(AttachStateValues attachState) {
        AttachStateSync attachStateSync = stateSync;
        synchronized (attachStateSync) {
            AttachHandler.attachState = attachState;
            stateSync.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getDisplayName() {
        syncObject syncObject2 = accessorMutex;
        synchronized (syncObject2) {
            return this.displayName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDisplayName(String displayName) {
        syncObject syncObject2 = accessorMutex;
        synchronized (syncObject2) {
            this.displayName = displayName;
        }
    }

    public Object getIgnoreNotification() {
        return this.ignoreNotification;
    }

    public static AttachHandler getMainHandler() {
        return mainHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getVmId() {
        syncObject syncObject2 = accessorMutex;
        synchronized (syncObject2) {
            return vmId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setVmId(String id) {
        syncObject syncObject2 = accessorMutex;
        synchronized (syncObject2) {
            vmId = id;
        }
    }

    public static long getProcessId() {
        return IPC.getProcessId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean getDoCancelNotify() {
        syncObject syncObject2 = accessorMutex;
        synchronized (syncObject2) {
            return doCancelNotify;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setDoCancelNotify(boolean doCancel) {
        syncObject syncObject2 = accessorMutex;
        synchronized (syncObject2) {
            doCancelNotify = doCancel;
        }
    }

    static {
        accessorMutex = new syncObject();
        String allowAttachSelf = VM.internalGetProperties().getProperty("jdk.attach.allowAttachSelf", "true");
        selfAttachAllowed = "".equals(allowAttachSelf) || Boolean.parseBoolean(allowAttachSelf);
    }

    static final class AttachStateSync {
        AttachStateSync() {
        }
    }

    private static enum AttachStateValues {
        ATTACH_UNINITIALIZED,
        ATTACH_TERMINATED,
        ATTACH_STARTING,
        ATTACH_INITIALIZED;

    }

    static final class syncObject {
        syncObject() {
        }
    }

    static final class teardownHook
    extends Thread {
        teardownHook() {
            super("Attach API teardown");
        }

        private static void threadJoinHelper(Thread thread, long shutdownDeadlineNs) {
            block7: {
                long timeout = 100L;
                int retryNumber = 0;
                while (true) {
                    long currentNanoTime;
                    long tempTimeout;
                    if ((tempTimeout = TimeUnit.NANOSECONDS.toMillis(shutdownDeadlineNs - (currentNanoTime = System.nanoTime()))) <= 0L) {
                        IPC.logMessage(thread + " already reached shutdownDeadlineNs : currentNanoTime = " + currentNanoTime + ", tempTimeout = " + tempTimeout);
                        break block7;
                    }
                    if (timeout > tempTimeout) {
                        timeout = tempTimeout;
                    }
                    IPC.logMessage(thread + ": currentNanoTime = " + currentNanoTime + ", tempTimeout = " + tempTimeout + ", timeout = " + timeout);
                    try {
                        thread.join(timeout);
                    }
                    catch (InterruptedException e) {
                        IPC.logMessage(thread + ": join() interrupted");
                        break block7;
                    }
                    Thread.State state = thread.getState();
                    if (state == Thread.State.TERMINATED) {
                        IPC.logMessage(thread + " is terminated, exit");
                        break block7;
                    }
                    IPC.logMessage(thread + ": state = " + (Object)((Object)state) + ", timeout waiting for termination. Retry #" + retryNumber + ", timeout = " + timeout);
                    timeout *= 2L;
                    ++retryNumber;
                    if (thread == currentAttachThread) {
                        IPC.logMessage(thread + ": currentAttachThread requires AttachHandler.terminateWaitLoop()");
                        AttachHandler.terminateWaitLoop(true, retryNumber);
                        continue;
                    }
                    if (thread != fileAccessTimeUpdaterThread) break;
                    IPC.logMessage(thread + ": fileAccessTimeUpdaterThread requires thread.interrupt()");
                    thread.interrupt();
                }
                throw new InternalError(thread + ": unexpected");
            }
        }

        @Override
        public void run() {
            try {
                VM.markCurrentThreadAsSystem();
                if (1 != IPC.loggingStatus) {
                    IPC.logMessage("shutting down attach API : " + mainHandler);
                }
                if (null == mainHandler) {
                    return;
                }
                long currentNanoTime = System.nanoTime();
                long shutdownDeadlineNs = currentNanoTime + TimeUnit.MILLISECONDS.toNanos(shutdownTimeoutMs);
                IPC.logMessage("currentNanoTime = " + currentNanoTime + ", shutdownTimeoutMs = " + shutdownTimeoutMs + ", shutdownDeadlineNs = " + shutdownDeadlineNs);
                boolean destroySemaphore = mainHandler.terminate(true);
                try {
                    mainHandler.join(shutdownTimeoutMs / 2L);
                    teardownHook.threadJoinHelper(currentAttachThread, shutdownDeadlineNs);
                    if (fileAccessTimeUpdaterThread != null && fileAccessTimeUpdaterThread.isAlive()) {
                        teardownHook.threadJoinHelper(fileAccessTimeUpdaterThread, shutdownDeadlineNs);
                    }
                }
                catch (InterruptedException e) {
                    IPC.logMessage("teardown join with attach handler interrupted");
                }
                if (currentAttachThread.getState() != Thread.State.TERMINATED) {
                    IPC.logMessage("Attach API not terminated");
                }
                TargetDirectory.deleteMyDirectory(true);
                if (destroySemaphore) {
                    if (CommonDirectory.tryObtainControllerLock("AttachHandler.teardownHook")) {
                        CommonDirectory.destroySemaphore();
                        if (1 != IPC.loggingStatus) {
                            IPC.logMessage("AttachHandler destroyed semaphore");
                        }
                        CommonDirectory.releaseControllerLock("AttachHandler.teardownHook");
                    } else {
                        if (1 != IPC.loggingStatus) {
                            IPC.logMessage("could not obtain lock, semaphore not destroyed");
                        }
                        CommonDirectory.closeSemaphore();
                    }
                } else {
                    CommonDirectory.closeSemaphore();
                    if (1 != IPC.loggingStatus) {
                        IPC.logMessage("AttachHandler closed semaphore");
                    }
                }
                if (null != IPC.logStream) {
                    IPC.logStream.close();
                }
            }
            catch (OutOfMemoryError e) {
                IPC.tracepoint(-3, e.getMessage());
                return;
            }
        }
    }
}

