/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.Comparator;
import java.lang.invoke.InterfaceHandle;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleResolver;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.PrimitiveHandle;
import java.lang.reflect.Method;

abstract class IndirectHandle
extends PrimitiveHandle {
    IndirectHandle(MethodType type, Class<?> referenceClass, String name, byte kind, int modifiers) {
        super(type, referenceClass, name, kind, modifiers, null);
    }

    IndirectHandle(MethodType type, Class<?> referenceClass, String name, byte kind) {
        super(type, referenceClass, name, kind, null);
    }

    IndirectHandle(IndirectHandle originalHandle, MethodType newType) {
        super(originalHandle, newType);
    }

    protected abstract long vtableOffset(Object var1);

    protected final long vtableIndexArgument(Object receiver) {
        return -this.vtableOffset(receiver);
    }

    protected final long jittedMethodAddress(Object receiver) {
        long receiverClass = MethodHandleResolver.getJ9ClassFromClass(receiver.getClass());
        long result = VTABLE_ENTRY_SIZE == 4 ? (long)MethodHandleResolver.UNSAFE.getInt(receiverClass - this.vtableOffset(receiver)) : MethodHandleResolver.UNSAFE.getLong(receiverClass - this.vtableOffset(receiver));
        return result;
    }

    @Override
    boolean canRevealDirect() {
        return true;
    }

    protected static final MethodType indirectMethodType(Method method) {
        MethodType originalType = MethodType.methodType(method.getReturnType(), method.getParameterTypes());
        return IndirectHandle.indirectMethodType(originalType, method.getDeclaringClass());
    }

    protected static final MethodType indirectMethodType(MethodType type, Class<?> referenceClazz) {
        return type.insertParameterTypes(0, referenceClazz);
    }

    @Override
    public MethodHandle bindTo(Object value) throws IllegalArgumentException, ClassCastException {
        if (null == value) {
            return super.bindTo(value);
        }
        Class<?> firstParameterType = this.type().parameterType(0);
        if (firstParameterType.isPrimitive()) {
            throw new IllegalArgumentException();
        }
        value = firstParameterType.cast(value);
        try {
            MethodHandle result = MethodHandles.Lookup.internalPrivilegedLookup.bind(value, this.name, this.type().dropFirstParameterType());
            if (this instanceof InterfaceHandle && (result.getModifiers() & 1) == 0) {
                throw new IllegalAccessException();
            }
            return result;
        }
        catch (IllegalAccessException e) {
            return MethodHandles.insertArguments(this, 0, value);
        }
        catch (NoSuchMethodException e) {
            throw new Error(e);
        }
    }

    final void compareWithIndirect(IndirectHandle left, Comparator c) {
        c.compareStructuralParameter(left.referenceClass, this.referenceClass);
        c.compareStructuralParameter(left.vmSlot, this.vmSlot);
    }
}

