/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lang.management.internal;

import com.ibm.java.lang.management.internal.MemoryMXBeanImpl;
import com.ibm.lang.management.MemoryMXBean;
import com.ibm.lang.management.internal.ExtendedGarbageCollectorMXBeanImpl;
import com.ibm.lang.management.internal.ExtendedOperatingSystemMXBeanImpl;
import com.ibm.lang.management.internal.MemoryNotificationThread;
import com.ibm.lang.management.internal.MemoryPoolMXBeanImpl;
import com.ibm.oti.vm.VM;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;

public final class ExtendedMemoryMXBeanImpl
extends MemoryMXBeanImpl
implements MemoryMXBean {
    private static final ExtendedMemoryMXBeanImpl instance = new ExtendedMemoryMXBeanImpl();
    private static final ExtendedOperatingSystemMXBeanImpl osinstance = ExtendedOperatingSystemMXBeanImpl.getInstance();
    private final AtomicBoolean notificationThreadStarted = new AtomicBoolean();

    public static ExtendedMemoryMXBeanImpl getInstance() {
        return instance;
    }

    private ExtendedMemoryMXBeanImpl() {
    }

    @Override
    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
        this.startNotificationThread();
        super.addNotificationListener(listener, filter, handback);
    }

    @Override
    protected void startNotificationThread() {
        if (!this.notificationThreadStarted.getAndSet(true)) {
            PrivilegedAction<Thread> createThread = () -> {
                Thread thread = VM.getVMLangAccess().createThread(new MemoryNotificationThread(this), "MemoryMXBean notification dispatcher", true, false, true, ClassLoader.getSystemClassLoader());
                thread.setPriority(6);
                return thread;
            };
            Thread notifier = AccessController.doPrivileged(createThread);
            notifier.start();
        }
    }

    @Deprecated
    public long getTotalPhysicalMemory() {
        return osinstance.getTotalPhysicalMemorySize();
    }

    public long getTotalPhysicalMemorySize() {
        return osinstance.getTotalPhysicalMemorySize();
    }

    public long getUsedPhysicalMemory() {
        return osinstance.getTotalPhysicalMemorySize() - osinstance.getFreePhysicalMemorySize();
    }

    @Override
    protected GarbageCollectorMXBean makeGCBean(String domainName, String name, int internalID) {
        return new ExtendedGarbageCollectorMXBeanImpl(domainName, name, internalID, this);
    }

    @Override
    protected MemoryPoolMXBean makeMemoryPoolBean(String name, MemoryType type, int internalID) {
        return new MemoryPoolMXBeanImpl(name, type, internalID, this);
    }
}

