/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.lang.management.internal;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;

class LazyDelegatingNotifier
implements NotificationEmitter {
    private final AtomicReference<NotificationBroadcasterSupport> reference = new AtomicReference();

    private static final UnaryOperator<NotificationBroadcasterSupport> creator() {
        return new UnaryOperator<NotificationBroadcasterSupport>(){

            @Override
            public NotificationBroadcasterSupport apply(NotificationBroadcasterSupport support) {
                return support != null ? support : new NotificationBroadcasterSupport();
            }
        };
    }

    LazyDelegatingNotifier() {
    }

    @Override
    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
        this.createAndGet().addNotificationListener(listener, filter, handback);
    }

    private NotificationBroadcasterSupport createAndGet() {
        NotificationBroadcasterSupport notifier = this.reference.get();
        return notifier != null ? notifier : this.reference.updateAndGet(LazyDelegatingNotifier.creator());
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return this.createAndGet().getNotificationInfo();
    }

    @Override
    public final void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.createAndGet().removeNotificationListener(listener);
    }

    @Override
    public final void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        this.createAndGet().removeNotificationListener(listener, filter, handback);
    }

    public final void sendNotification(Notification notification) {
        NotificationBroadcasterSupport notifier = this.reference.get();
        if (notifier != null) {
            notifier.sendNotification(notification);
        }
    }
}

