/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.corereaders.zos.le;

import com.ibm.dtfj.corereaders.zos.dumpreader.AddressSpace;
import com.ibm.dtfj.corereaders.zos.dumpreader.AddressSpaceImageInputStream;
import com.ibm.dtfj.corereaders.zos.le.Caa;
import com.ibm.dtfj.corereaders.zos.le.CeedsaTemplate;
import com.ibm.dtfj.corereaders.zos.le.Ceedsahp32Template;
import com.ibm.dtfj.corereaders.zos.le.Ceedsahp64Template;
import com.ibm.dtfj.corereaders.zos.le.CeedsahpTemplate;
import com.ibm.dtfj.corereaders.zos.le.Ceedsahp_transitionTemplate;
import com.ibm.dtfj.corereaders.zos.le.CeexcibTemplate;
import com.ibm.dtfj.corereaders.zos.le.CeexcibhTemplate;
import com.ibm.dtfj.corereaders.zos.le.Ceexhcom32Template;
import com.ibm.dtfj.corereaders.zos.le.Ceexhcom64Template;
import com.ibm.dtfj.corereaders.zos.le.CeexhcomTemplate;
import com.ibm.dtfj.corereaders.zos.le.CeexhepvTemplate;
import com.ibm.dtfj.corereaders.zos.le.Ceexhp1bTemplate;
import com.ibm.dtfj.corereaders.zos.le.CeexoepvTemplate;
import com.ibm.dtfj.corereaders.zos.le.Ceexpp1bTemplate;
import com.ibm.dtfj.corereaders.zos.le.Ceexrcb32Template;
import com.ibm.dtfj.corereaders.zos.le.Ceexrcb64Template;
import com.ibm.dtfj.corereaders.zos.le.CeexrcbTemplate;
import com.ibm.dtfj.corereaders.zos.le.CeexsfxmTemplate;
import com.ibm.dtfj.corereaders.zos.le.Function;
import com.ibm.dtfj.corereaders.zos.mvs.RegisterSet;
import java.io.IOException;
import java.util.HashSet;
import java.util.logging.Logger;

public class DsaStackFrame {
    private long address;
    private boolean isDownStack;
    private boolean isParentDownStack;
    private boolean isParentTransitionFrame;
    private long parentAddress;
    private long parentCallingAddress;
    private DsaStackFrame childDsa;
    private RegisterSet registers;
    private long entryPoint;
    private long entryOffset;
    private String entryName;
    private AddressSpace space;
    private AddressSpaceImageInputStream inputStream;
    private Caa caa;
    CeedsahpTemplate ceedsahpTemplate;
    CeexhcomTemplate ceexhcomTemplate;
    CeexrcbTemplate ceexrcbTemplate;
    static final long Ceedsahp_UpTran_Ind = 0xFFFFFFFFL;
    private static final long Ceedsahp_UpToDown = 2L;
    private static final long Ceedsahp_DownToUp = 3L;
    private static final long Hpcl_Basr_Call = 0L;
    private static final long Hpcl_Bras_Call = 1L;
    private static final long Hpcl_Brasl_Call = 3L;
    private static final int US_FORMAT = 0;
    private static final int DS_FORMAT = 1;
    private static final int UK_FORMAT = -1;
    private static final int CEEEYECAT = 0xC3C5C5;
    private static final short BASSM1415 = 3311;
    private static final int L14DSAMODE = 1491128428;
    private static Logger log = Logger.getLogger(DsaStackFrame.class.getName());

    public DsaStackFrame(long address, boolean isDownStack, RegisterSet registers, AddressSpace space, Caa caa) throws IOException {
        this.address = address;
        this.isDownStack = isDownStack;
        this.registers = registers;
        this.space = space;
        this.inputStream = space.getImageInputStream();
        this.caa = caa;
        this.createTemplates(space);
        this.ceextbck(address, isDownStack, caa);
    }

    void createTemplates(AddressSpace space) {
        if (this.ceedsahpTemplate == null) {
            if (space.is64bit()) {
                this.ceedsahpTemplate = new Ceedsahp64Template();
                this.ceexhcomTemplate = new Ceexhcom64Template();
                this.ceexrcbTemplate = new Ceexrcb64Template();
            } else {
                this.ceedsahpTemplate = new Ceedsahp32Template();
                this.ceexhcomTemplate = new Ceexhcom32Template();
                this.ceexrcbTemplate = new Ceexrcb32Template();
            }
        }
    }

    public AddressSpace getAddressSpace() {
        return this.space;
    }

    public long getDsaAddress() {
        return this.address;
    }

    public RegisterSet getRegisterSet() {
        return this.registers;
    }

    public long getEntryOffset() {
        if (this.registers != null) {
            return this.space.stripTopBit(this.registers.getPSW() & Integer.MAX_VALUE) - this.getEntryPoint();
        }
        if (this.childDsa != null) {
            return this.childDsa.parentCallingAddress - this.entryPoint;
        }
        return this.entryOffset;
    }

    public long getEntryPoint() {
        return this.entryPoint;
    }

    public String getEntryName() {
        return this.entryName;
    }

    public DsaStackFrame getParentFrame() {
        if (this.parentAddress == 0L || this.parentAddress == this.caa.ceecaaddsa()) {
            return null;
        }
        try {
            DsaStackFrame parent = new DsaStackFrame(this.parentAddress, this.isParentDownStack, null, this.space, this.caa);
            parent.childDsa = this;
            return parent;
        }
        catch (IOException e) {
            return null;
        }
    }

    public Function getFunction() {
        return new Function(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void ceextbck(long dsaptr, boolean isDownStack, Caa caa) throws IOException {
        long callers_instruction_address;
        int oepv_cnameoffs;
        boolean cel_enabled;
        long callers_dsaptr;
        log.fine("ceextbck, dsaptr = " + DsaStackFrame.hex(dsaptr) + " downstack = " + isDownStack);
        int dsa_format = isDownStack ? 1 : 0;
        long entry_address = -4995072469322842385L;
        int dsaformat8 = dsa_format;
        if (dsa_format == -1) {
            throw new Error("tbc");
        }
        int callers_dsa_format = dsaformat8;
        boolean transition = this.verifyFormat(dsaptr, dsa_format);
        if (dsaptr < 0L) {
            throw new Error("tbc");
        }
        Ceexdsaf dsaf = new Ceexdsaf(this.space, dsaptr, dsa_format);
        callers_dsa_format = dsaf.DSA_Format;
        this.parentAddress = callers_dsaptr = dsaf.DSA_Prev;
        this.isParentDownStack = callers_dsa_format == 1;
        long cibptr = this.findCib(dsaptr);
        long callers_cibptr = this.findCib(callers_dsaptr);
        long sfxmptr = this.findSfxm(dsaptr, dsaformat8);
        long callers_sfxmptr = this.findSfxm(callers_dsaptr, callers_dsa_format);
        if (dsaformat8 == 1) {
            this.processDsfmt(dsaptr, dsaformat8, callers_dsaptr, callers_dsa_format, transition, cibptr, callers_cibptr, sfxmptr);
            return;
        }
        if (!transition) {
            int hdsp_signature = this.space.readInt(dsaptr + 72L);
            if ((hdsp_signature & 0xFFFFFFF0) == 134794976) {
                throw new Error("tbc");
            }
            entry_address = CeedsaTemplate.getCeedsar15(this.inputStream, callers_dsaptr);
            log.fine("upstack entry address = " + DsaStackFrame.hex(entry_address));
        } else {
            long ceedsatran = CeedsaTemplate.getCeedsatran(this.inputStream, dsaptr);
            entry_address = Ceedsahp_transitionTemplate.getCeedsahp_tran_ep(this.inputStream, ceedsatran);
            log.fine("upstack transition entry address = " + DsaStackFrame.hex(entry_address));
        }
        try {
            this.space.readLong(entry_address);
        }
        catch (IOException e) {
            entry_address = 0L;
        }
        long signaturePtr = entry_address;
        if (entry_address == 0L) {
            cel_enabled = false;
        } else {
            int signature = 0;
            try {
                signature = (int)CeexoepvTemplate.getOepv_eyecatch(this.inputStream, signaturePtr);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            log.fine("signature = " + DsaStackFrame.hex(signature));
            int msb = signature >>> 24;
            if ((msb == 0 || msb == 1) && (signature & 0xFFFFFF) == 0xC3C5C5) {
                try {
                    signature = this.getPpa1Sig(signaturePtr);
                }
                catch (IOException e) {
                    signature = 0;
                }
                cel_enabled = (signature & 0xFF) == 206;
            } else {
                cel_enabled = false;
                try {
                    signature = (int)CeexoepvTemplate.getOepv_oldep(this.inputStream, signaturePtr);
                    log.fine("oldep signature = " + DsaStackFrame.hex(signature));
                    int bcrinstr = signature >>> 12;
                    if (bcrinstr == 294671) {
                        int bcrdispl = signature & 0xFFF;
                        int oepvLength = CeexoepvTemplate.length();
                        assert (oepvLength == 20) : oepvLength;
                        signature = (int)CeexoepvTemplate.getOepv_oldep(this.inputStream, signaturePtr = signaturePtr + (long)bcrdispl - (long)oepvLength);
                        if (signature == 0) {
                            signature = (int)CeexoepvTemplate.getOepv_eyecatch(this.inputStream, signaturePtr);
                            if ((signature & 0xFFFFFF) != 0xC3C5C5) throw new Error("tbc");
                            signature = this.getPpa1Sig(signaturePtr);
                            if ((signature & 0xFF) != 206) throw new Error("tbc");
                            cel_enabled = true;
                            log.fine("found a good ppa1 eyecatcher");
                        } else {
                            signaturePtr = entry_address;
                        }
                    } else {
                        signaturePtr = entry_address;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new Error("tbc");
                }
            }
        }
        boolean v2ppa = false;
        if (cel_enabled && (oepv_cnameoffs = (int)CeexoepvTemplate.getOepv_cnameoffs(this.inputStream, signaturePtr)) == 1) {
            v2ppa = true;
        }
        this.parentCallingAddress = callers_instruction_address = this.getCallingAddr(callers_dsaptr, callers_dsa_format, dsaptr, dsaformat8, transition, callers_cibptr, callers_sfxmptr);
        if (cel_enabled) {
            int offset_to_name;
            if (this.registers != null) {
                long call_instruction_address = this.getCallingAddr(dsaptr, dsaformat8, 0L, 0, false, cibptr, sfxmptr);
                log.fine("found call_instruction_address at top of stack: 0x" + DsaStackFrame.hex(call_instruction_address));
            }
            if ((offset_to_name = this.getPpa1Nmo(signaturePtr)) == 0) {
                throw new Error("tbc");
            }
            int ppa1offset = (int)CeexoepvTemplate.getOepv_ppa1offset(this.inputStream, signaturePtr);
            long ppa1 = signaturePtr + (long)ppa1offset;
            long ppa1_epn_address = v2ppa ? ppa1 + (long)(offset_to_name * 2) : ppa1 + (long)offset_to_name;
            this.entryName = this.space.readEbcdicString(ppa1_epn_address);
            log.fine("read entry name: " + this.entryName);
        } else {
            this.entryName = "(unknown)";
        }
        this.entryPoint = this.space.stripTopBit(entry_address);
    }

    void processDsfmt(long in_dsa, int in_dsafmt, long in_callerdsa, int in_caller_dsafmt, boolean in_dsatrans, long in_cibptr, long in_caller_cibptr, long in_sfxmptr) throws IOException {
        Ceexepaf epaf = new Ceexepaf(in_dsa, in_dsafmt);
        this.entryPoint = this.space.stripTopBit(epaf.entry_address);
        if (epaf.ppa1_addr != 0L) {
            long callers_instruction_address;
            if (this.registers != null) {
                long call_instruction_address = this.getCallingAddr(in_dsa, in_dsafmt, 0L, 0, false, in_cibptr, 0L);
                log.fine("found call_instruction_address at top of stack: 0x" + DsaStackFrame.hex(call_instruction_address));
            }
            this.parentCallingAddress = callers_instruction_address = this.getCallingAddr(in_callerdsa, in_caller_dsafmt, in_dsa, in_dsafmt, in_dsatrans, in_caller_cibptr, in_sfxmptr);
            assert (this.parentCallingAddress != 0L);
        } else {
            throw new Error("tbc");
        }
        Ceexppaf ppaf = new Ceexppaf(epaf.ppa1_addr, "NAM");
        this.entryName = ppaf.opt_ptr == 0L ? "(unknown)" : this.space.readEbcdicString(ppaf.opt_ptr);
        log.fine("read entry name: " + this.entryName);
    }

    private int getPpa1Sig(long signaturePtr) throws IOException {
        int ppa1offset = (int)CeexoepvTemplate.getOepv_ppa1offset(this.inputStream, signaturePtr);
        long ppa1 = signaturePtr + (long)ppa1offset;
        int signature = (int)Ceexpp1bTemplate.getPpa1_sig(this.inputStream, ppa1);
        log.fine("read ppa1 signature " + DsaStackFrame.hex(signature) + " from entry point " + DsaStackFrame.hex(signaturePtr));
        return signature;
    }

    private int getPpa1Nmo(long signaturePtr) throws IOException {
        int ppa1offset = (int)CeexoepvTemplate.getOepv_ppa1offset(this.inputStream, signaturePtr);
        long ppa1 = signaturePtr + (long)ppa1offset;
        int nmo = (int)Ceexpp1bTemplate.getPpa1_nmo(this.inputStream, ppa1);
        log.fine("read ppa1 nmo " + DsaStackFrame.hex(nmo &= 0xFF) + " from entry point " + DsaStackFrame.hex(signaturePtr));
        return nmo;
    }

    boolean verifyFormat(long dsaptr, int dsa_format) throws IOException {
        long ceedsahptran;
        long ceedsahp_trtype;
        long ceedsahpr7;
        if (dsa_format == 0) {
            long ceedsabkc = CeedsaTemplate.getCeedsabkc(this.inputStream, dsaptr);
            log.fine("read ceedsabkc " + DsaStackFrame.hex(ceedsabkc));
            if (ceedsabkc == 0xFFFFFFFFL) {
                long ceedsatran = CeedsaTemplate.getCeedsatran(this.inputStream, dsaptr);
                log.fine("read ceedsatran " + DsaStackFrame.hex(ceedsatran));
                long ceedsahp_trtype2 = Ceedsahp_transitionTemplate.getCeedsahp_trtype(this.inputStream, ceedsatran);
                if (ceedsahp_trtype2 > 0L && ceedsahp_trtype2 <= 6L) {
                    return true;
                }
            }
        } else if (dsa_format == 1 && (ceedsahpr7 = this.ceedsahpTemplate.getCeedsahpr7(this.inputStream, dsaptr)) == 0L && (ceedsahp_trtype = Ceedsahp_transitionTemplate.getCeedsahp_trtype(this.inputStream, ceedsahptran = this.ceedsahpTemplate.getCeedsahptran(this.inputStream, dsaptr))) > 0L && ceedsahp_trtype <= 6L) {
            return true;
        }
        return false;
    }

    long getCallingAddr(long in_dsa, int in_dsafmt, long fo_dsa, int fo_dsafmt, boolean fo_dsatrans, long in_cib, long in_sfxm) throws IOException {
        long callingaddr = -4995072469322842385L;
        long next_instruction_address = 0L;
        if (in_cib != 0L) {
            callingaddr = CeexcibTemplate.getCib_int(this.inputStream, in_cib);
            log.fine("got calling address " + DsaStackFrame.hex(callingaddr) + " from cib");
        } else {
            if (in_sfxm != 0L) {
                throw new Error("tbc");
            }
            if (in_dsafmt == 0) {
                next_instruction_address = CeedsaTemplate.getCeedsar14(this.inputStream, in_dsa);
            } else if (fo_dsa != 0L) {
                if (fo_dsafmt == 0 && fo_dsatrans) {
                    long ceedsatran = CeedsaTemplate.getCeedsatran(this.inputStream, fo_dsa);
                    next_instruction_address = Ceedsahp_transitionTemplate.getCeedsahp_retaddr(this.inputStream, ceedsatran);
                } else if (fo_dsafmt == 1 && fo_dsatrans) {
                    long ceedsahptran = this.ceedsahpTemplate.getCeedsahptran(this.inputStream, fo_dsa);
                    next_instruction_address = Ceedsahp_transitionTemplate.getCeedsahp_retaddr(this.inputStream, ceedsahptran);
                } else {
                    next_instruction_address = this.ceedsahpTemplate.getCeedsahpr7(this.inputStream, fo_dsa);
                }
            }
            if (next_instruction_address != 0L) {
                if (!this.space.is64bit()) {
                    next_instruction_address = in_dsafmt == 0 && (next_instruction_address & Integer.MIN_VALUE) == 0L ? (next_instruction_address &= 0xFFFFFFL) : (next_instruction_address &= Integer.MAX_VALUE);
                }
                if (in_dsafmt == 0) {
                    if (next_instruction_address == this.caa.getEdb().ceeedb_ceeosigr()) {
                        throw new Error("tbc");
                    }
                    try {
                        int rx_inst;
                        short rr_inst = this.space.readShort(next_instruction_address - 2L);
                        if (rr_inst == 3311 && (rx_inst = this.space.readInt(next_instruction_address)) == 1491128428) {
                            next_instruction_address = CeedsaTemplate.getCeedsamode(this.inputStream, in_dsa);
                            if (!this.space.is64bit()) {
                                next_instruction_address = (next_instruction_address & Integer.MIN_VALUE) == 0L ? (next_instruction_address &= 0xFFFFFFL) : (next_instruction_address &= Integer.MAX_VALUE);
                            }
                        }
                        boolean fstlink_call = false;
                        int rx_inst2 = this.space.readInt(next_instruction_address);
                        if (rx_inst2 >>> 16 == 18176) {
                            fstlink_call = true;
                        }
                        callingaddr = next_instruction_address - 2L;
                        log.fine("found callingaddr = 0x" + DsaStackFrame.hex(callingaddr));
                    }
                    catch (IOException e) {
                        log.fine("could not read next_instruction_address at " + DsaStackFrame.hex(next_instruction_address));
                        callingaddr = 0L;
                        throw e;
                    }
                } else {
                    long ceecaarcb = this.caa.ceecaarcb();
                    long ceercb_ceeosigx = this.ceexrcbTemplate.getCeercb_ceeosigx(this.inputStream, ceecaarcb);
                    if (next_instruction_address == ceercb_ceeosigx) {
                        throw new Error("tbc");
                    }
                    int rx_inst = this.space.readInt(next_instruction_address);
                    int Hpcl_Call_Type = rx_inst >> 16 & 0xF;
                    if (rx_inst >>> 20 != (this.space.is64bit() ? 112 : 1136)) {
                        callingaddr = 0L;
                        log.fine("did not find expected nop");
                    } else if ((long)Hpcl_Call_Type == 0L) {
                        callingaddr = next_instruction_address - 2L;
                    } else if ((long)Hpcl_Call_Type == 1L) {
                        callingaddr = next_instruction_address - 4L;
                    } else if ((long)Hpcl_Call_Type == 3L) {
                        callingaddr = next_instruction_address - 6L;
                    } else {
                        callingaddr = 0L;
                        log.fine("did not recognize call type " + Hpcl_Call_Type);
                    }
                }
            } else {
                log.fine("next_instruction_address zero, cannot get calling address");
            }
        }
        return callingaddr;
    }

    long findCib(long in_dsa) {
        try {
            long cibh_ptr_cib = 0L;
            long ceecaaerrcm = this.caa.ceecaaerrcm();
            long cibhptr = this.ceexhcomTemplate.getHcom_cibh(this.inputStream, ceecaaerrcm);
            while (cibhptr != 0L) {
                boolean cibh_in_use = CeexcibhTemplate.getCibh_in_use(this.inputStream, cibhptr) != 0L;
                cibh_ptr_cib = CeexcibhTemplate.getCibh_ptr_cib(this.inputStream, cibhptr);
                long cib_sv1 = CeexcibTemplate.getCib_sv1(this.inputStream, cibh_ptr_cib);
                if (cibh_in_use && cib_sv1 == in_dsa) break;
                cibhptr = CeexcibhTemplate.getCibh_back(this.inputStream, cibhptr);
            }
            if (cibhptr == 0L) {
                return 0L;
            }
            log.fine("found a cib: " + DsaStackFrame.hex(cibh_ptr_cib));
            return cibh_ptr_cib;
        }
        catch (Exception e) {
            throw new Error("oops: " + e);
        }
    }

    long findSfxm(long sfxm_dsa, int p_dsafmt) throws IOException {
        long p_sfxm;
        block10: {
            long HEPV_Entry_Sig = 214408072578304L;
            p_sfxm = 0L;
            HashSet<Long> visited = new HashSet<Long>();
            try {
                if (p_dsafmt == 0) {
                    log.fine("findSfxm processing upstack dsa");
                    long hcom_exit_stk = this.ceexhcomTemplate.getHcom_exit_stk(this.inputStream, this.caa.ceecaaerrcm());
                    log.fine("findSfxm hcom_exit_stk = 0x" + DsaStackFrame.hex(hcom_exit_stk));
                    long tptr = hcom_exit_stk;
                    while (tptr != 0L) {
                        long sfxm_parm_sf;
                        long ceedsabkc;
                        if (!visited.add(tptr)) {
                            log.fine("back-link cycle found in upstack dsm at " + DsaStackFrame.hex(tptr));
                            break block10;
                        }
                        long sfxm_code_eyecatch = CeexsfxmTemplate.getSfxm_code_eyecatch(this.inputStream, tptr);
                        if (sfxm_code_eyecatch >>> 8 != 214408072578304L && (ceedsabkc = CeedsaTemplate.getCeedsabkc(this.inputStream, sfxm_parm_sf = CeexsfxmTemplate.getSfxm_parm_sf(this.inputStream, tptr))) == sfxm_dsa) {
                            log.fine("found the upstack sfxm at " + DsaStackFrame.hex(tptr));
                            p_sfxm = tptr;
                        }
                        tptr = CeexsfxmTemplate.getSfxm_next(this.inputStream, tptr);
                    }
                    break block10;
                }
                log.fine("findSfxm processing downstack dsa");
                long hcom_exit_stk = this.ceexhcomTemplate.getHcom_exit_stk(this.inputStream, this.caa.ceecaaerrcm());
                log.fine("findSfxm hcom_exit_stk = 0x" + DsaStackFrame.hex(hcom_exit_stk));
                int offset = CeexsfxmTemplate.getSfxm_code_return_pt$offset();
                long ceedsahpr7 = this.ceedsahpTemplate.getCeedsahpr7(this.inputStream, sfxm_dsa);
                ceedsahpr7 = this.space.stripTopBit(ceedsahpr7);
                long tptr = hcom_exit_stk;
                while (tptr != 0L) {
                    if (!visited.add(tptr)) {
                        log.fine("back-link cycle found in downstack dsm at " + DsaStackFrame.hex(tptr));
                        break;
                    }
                    if (tptr + (long)offset == ceedsahpr7) {
                        throw new Error("tbc");
                    }
                    tptr = CeexsfxmTemplate.getSfxm_next(this.inputStream, tptr);
                }
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new Error("oops: " + e);
            }
        }
        return p_sfxm;
    }

    static long hpclEntryPoint(AddressSpace space, long DSA_In, long ceedsahpr7, CeedsahpTemplate ceedsahpTemplate) throws Exception {
        long Entry_Temp;
        log.fine("ceedsahpr7: " + DsaStackFrame.hex(ceedsahpr7));
        AddressSpaceImageInputStream inputStream = space.getImageInputStream();
        int Hpcl_Call_Type = space.readInt(ceedsahpr7) >> 16 & 0xF;
        if ((long)Hpcl_Call_Type == 0L) {
            Entry_Temp = ceedsahpTemplate.getCeedsahpr6(inputStream, DSA_In);
            log.fine("BASR 7,6: " + DsaStackFrame.hex(Entry_Temp));
        } else if ((long)Hpcl_Call_Type == 1L) {
            short offset = space.readShort(ceedsahpr7 - 2L);
            log.fine("offset: " + DsaStackFrame.hex(offset));
            Entry_Temp = ceedsahpr7 - 4L + (long)(offset * 2);
            log.fine("BRAS 7,xxx: " + DsaStackFrame.hex(Entry_Temp) + (Entry_Temp < 0L ? " (neg)" : "") + " offset = " + offset);
        } else if ((long)Hpcl_Call_Type == 3L) {
            int offset = space.readInt(ceedsahpr7 - 4L);
            Entry_Temp = ceedsahpr7 - 6L + (long)(offset * 2);
            log.fine("BRASL 7,xxx: " + DsaStackFrame.hex(Entry_Temp));
        } else {
            return 0L;
        }
        if (space.readInt(Entry_Temp - 16L) != 12779717) {
            Entry_Temp = 0L;
        }
        return Entry_Temp;
    }

    public static String getEntryPointName(AddressSpace space, long ep) throws IOException {
        Long mapKey = ep;
        String function = (String)space.getUserMap().get(mapKey);
        if (function != null) {
            return function;
        }
        int eyecatcher = space.readInt(ep + 4L);
        if (eyecatcher == 0xC3C5C5 || eyecatcher == 29607365) {
            long ppa1 = ep + (long)space.readInt(ep + 12L);
            int offset = space.readUnsignedByte(ppa1);
            if (eyecatcher == 29607365) {
                offset <<= 1;
            }
            function = space.readEbcdicString(ppa1 + (long)offset);
        } else if ((eyecatcher & 0xFF0000) == 0xCE0000) {
            long ppa1 = ep;
            int offset = eyecatcher >>> 24;
            function = space.readEbcdicString(ppa1 + (long)offset);
        } else if ((space.readInt(ep) & 0xFFFFF000) == 1206972416) {
            int length = space.readUnsignedByte(ep + 4L);
            function = space.readEbcdicString(ep + 5L, length);
            for (int i = 0; i < function.length(); ++i) {
                char c = function.charAt(i);
                if (Character.isLetterOrDigit(c) || Character.isSpaceChar(c)) continue;
                function = "(unknown)";
                break;
            }
        } else {
            long xplhdr = ep - 16L;
            long ceesig = space.readLong(xplhdr);
            if (ceesig == 54888466580046065L) {
                int ppa1off = space.readInt(xplhdr + 8L);
                long ptrppa1 = xplhdr + (long)ppa1off;
                long ptrnam = ptrppa1 + 20L;
                int ppa1flags3 = space.readUnsignedByte(ptrppa1 + 10L);
                int ppa1flags4 = space.readUnsignedByte(ptrppa1 + 11L);
                if ((ppa1flags3 & 0x80) != 0) {
                    ptrnam += 4L;
                }
                if ((ppa1flags3 & 0x40) != 0) {
                    ptrnam += 4L;
                }
                if ((ppa1flags3 & 0x20) != 0) {
                    ptrnam += 4L;
                }
                if ((ppa1flags3 & 0x10) != 0) {
                    ptrnam += 4L;
                }
                if ((ppa1flags3 & 8) != 0) {
                    ptrnam += 4L;
                }
                if ((ppa1flags3 & 4) != 0) {
                    ptrnam += 4L;
                }
                if ((ppa1flags3 & 2) != 0) {
                    ptrnam += 4L;
                }
                if ((ppa1flags3 & 1) != 0) {
                    ptrnam += 8L;
                }
                function = (ppa1flags4 & 1) == 0 ? "(bad ppa1flags4)" : space.readEbcdicString(ptrnam);
            } else {
                function = "(unknown)";
            }
        }
        space.getUserMap().put(mapKey, function);
        return function;
    }

    private static String hex(long i) {
        return Long.toHexString(i);
    }

    static class Ceexdsaf {
        long DSA_Prev;
        int DSA_Format;
        private AddressSpaceImageInputStream inputStream;

        Ceexdsaf(AddressSpace space, long DSA_In, int dsa_fmt) throws IOException {
            log.fine("enter Ceexdsaf for dsa " + DsaStackFrame.hex(DSA_In));
            CeedsahpTemplate ceedsahpTemplate = space.is64bit() ? new Ceedsahp64Template() : new Ceedsahp32Template();
            this.inputStream = space.getImageInputStream();
            this.DSA_Format = dsa_fmt;
            try {
                if (this.DSA_Format == 0) {
                    long ceedsabkc = CeedsaTemplate.getCeedsabkc(this.inputStream, DSA_In);
                    if (ceedsabkc == 0xFFFFFFFFL) {
                        boolean isTransitional = true;
                        long ceedsatran = CeedsaTemplate.getCeedsatran(this.inputStream, DSA_In);
                        long ceedsahp_trtype = Ceedsahp_transitionTemplate.getCeedsahp_trtype(this.inputStream, ceedsatran);
                        if (ceedsahp_trtype == 3L) {
                            this.DSA_Prev = Ceedsahp_transitionTemplate.getCeedsahp_bkc(this.inputStream, ceedsatran);
                            this.DSA_Format = 1;
                        } else {
                            this.DSA_Prev = ceedsabkc;
                        }
                    } else {
                        this.DSA_Prev = ceedsabkc;
                    }
                } else {
                    long ceedsahpr7 = ceedsahpTemplate.getCeedsahpr7(this.inputStream, DSA_In);
                    if (ceedsahpr7 == 0L) {
                        long ceedsahptran = ceedsahpTemplate.getCeedsahptran(this.inputStream, DSA_In);
                        long ceedsahp_trtype = Ceedsahp_transitionTemplate.getCeedsahp_trtype(this.inputStream, ceedsahptran);
                        if (ceedsahp_trtype == 2L) {
                            this.DSA_Format = 0;
                        }
                        boolean isTransitional = true;
                        this.DSA_Prev = Ceedsahp_transitionTemplate.getCeedsahp_bkc(this.inputStream, ceedsahptran);
                    } else {
                        long Entry_Temp = DsaStackFrame.hpclEntryPoint(space, DSA_In, ceedsahpr7, ceedsahpTemplate);
                        if (Entry_Temp == 0L) {
                            this.DSA_Prev = 0L;
                        } else {
                            int dsaFlags = space.readInt(Entry_Temp - 4L);
                            if ((dsaFlags & 4) == 4) {
                                this.DSA_Prev = ceedsahpTemplate.getCeedsahpr4(this.inputStream, DSA_In);
                            } else {
                                int dsaSize = dsaFlags & 0xFFFFFFF0;
                                this.DSA_Prev = DSA_In + (long)dsaSize;
                            }
                        }
                    }
                }
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new Error("oops: " + e);
            }
        }
    }

    class Ceexepaf {
        long ppa1_addr;
        long ppa2_addr;
        long entry_address;

        Ceexepaf(long DSA_In, int DSA_Format) throws IOException {
            try {
                long ceedsahpr7 = DsaStackFrame.this.ceedsahpTemplate.getCeedsahpr7(DsaStackFrame.this.inputStream, DSA_In);
                if (ceedsahpr7 == 0L) {
                    this.entry_address = DsaStackFrame.this.ceedsahpTemplate.getCeedsahpr6(DsaStackFrame.this.inputStream, DSA_In);
                } else {
                    this.entry_address = DsaStackFrame.hpclEntryPoint(DsaStackFrame.this.space, DSA_In, ceedsahpr7, DsaStackFrame.this.ceedsahpTemplate);
                    assert (this.entry_address != 0L);
                }
                log.fine("read entry_address 0x" + DsaStackFrame.hex(this.entry_address));
                int hepv_prefix_length = CeexhepvTemplate.getHepv_entry_point$offset();
                long hepv = this.entry_address - (long)hepv_prefix_length;
                long hepv_ppa1_offset_p = CeexhepvTemplate.getHepv_ppa1_offset_p(DsaStackFrame.this.inputStream, hepv);
                this.ppa1_addr = hepv + hepv_ppa1_offset_p;
                log.fine("ppa1 = 0x" + DsaStackFrame.hex(this.ppa1_addr));
                long ppa1h_ppa2_off = Ceexhp1bTemplate.getPpa1h_ppa2_off(DsaStackFrame.this.inputStream, this.ppa1_addr);
                this.ppa2_addr = this.ppa1_addr + ppa1h_ppa2_off;
                log.fine("ppa2 = 0x" + DsaStackFrame.hex(this.ppa2_addr));
            }
            catch (IOException ceedsahpr7) {
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new Error("oops: " + e);
            }
        }
    }

    class Ceexppaf {
        long opt_ptr;

        Ceexppaf(long ppa1_ptr, String opt_nam) throws IOException {
            try {
                int offset;
                int ppa1h_lgth = Ceexhp1bTemplate.length();
                assert (ppa1h_lgth == 20) : ppa1h_lgth;
                this.opt_ptr = ppa1_ptr + (long)ppa1h_lgth;
                if (opt_nam.equals("NAM")) {
                    long ceecaarcb = DsaStackFrame.this.caa.ceecaarcb();
                    log.fine("ceecaarcb = " + DsaStackFrame.hex(ceecaarcb));
                    long tabl_ptr = DsaStackFrame.this.ceexrcbTemplate.getCeercb_ppa1tabl(DsaStackFrame.this.inputStream, ceecaarcb);
                    log.fine("tabl_ptr = " + DsaStackFrame.hex(tabl_ptr));
                    long ppa1h_flag3 = Ceexhp1bTemplate.getPpa1h_flag3(DsaStackFrame.this.inputStream, ppa1_ptr);
                    log.fine("ppa1h_flag3 = " + DsaStackFrame.hex(ppa1h_flag3));
                    offset = DsaStackFrame.this.space.readUnsignedByte(tabl_ptr + (ppa1h_flag3 & 0xFFL));
                    this.opt_ptr += (long)offset;
                } else {
                    throw new Error("unsupported option: " + opt_nam);
                }
                log.fine("found offset of " + offset + ", opt_ptr now " + DsaStackFrame.hex(this.opt_ptr));
            }
            catch (IOException e) {
                this.opt_ptr = 0L;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new Error("oops: " + e);
            }
        }
    }
}

