/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.corereaders.zos.le;

import com.ibm.dtfj.corereaders.zos.dumpreader.AddressSpace;
import com.ibm.dtfj.corereaders.zos.dumpreader.AddressSpaceImageInputStream;
import com.ibm.dtfj.corereaders.zos.le.Ceexdlcb32Template;
import com.ibm.dtfj.corereaders.zos.le.Ceexdlcb64Template;
import com.ibm.dtfj.corereaders.zos.le.CeexdlcbTemplate;
import com.ibm.dtfj.corereaders.zos.le.Ciet2ExpFuncEntryTemplate;
import com.ibm.dtfj.corereaders.zos.le.Ciet2ExpVarEntryTemplate;
import com.ibm.dtfj.corereaders.zos.le.Ciet2Template;
import com.ibm.dtfj.corereaders.zos.le.CietExpEntryTemplate;
import com.ibm.dtfj.corereaders.zos.le.CietTemplate;
import com.ibm.dtfj.corereaders.zos.le.DllFunction;
import com.ibm.dtfj.corereaders.zos.le.DllVariable;
import com.ibm.dtfj.corereaders.zos.le.DllcsectTemplate;
import com.ibm.dtfj.corereaders.zos.le.DllexpfuncsTemplate;
import com.ibm.dtfj.corereaders.zos.le.DllexpvarsTemplate;
import com.ibm.dtfj.corereaders.zos.le.Edb;
import java.io.IOException;
import java.util.logging.Logger;

public class Dll {
    private long address;
    private AddressSpace space;
    private AddressSpaceImageInputStream inputStream;
    private String name;
    private long wsa;
    private Dll next;
    private DllVariable[] variables;
    private DllFunction[] functions;
    CeexdlcbTemplate ceexdlcbTemplate;
    private static Logger log = Logger.getLogger(Dll.class.getName());

    public Dll(long address, AddressSpace space) {
        this.address = address;
        this.space = space;
        this.inputStream = space.getImageInputStream();
        this.createTemplates(space);
    }

    void createTemplates(AddressSpace space) {
        if (this.ceexdlcbTemplate == null) {
            this.ceexdlcbTemplate = space.is64bit() ? new Ceexdlcb64Template() : new Ceexdlcb32Template();
        }
    }

    public String getName() throws IOException {
        if (this.name == null) {
            long dlcbnamelen = this.ceexdlcbTemplate.getDlcbnamelen(this.inputStream, this.address);
            long dlcbnameptr = this.ceexdlcbTemplate.getDlcbnameptr(this.inputStream, this.address);
            this.name = this.space.readEbcdicString(dlcbnameptr, (int)dlcbnamelen);
        }
        return this.name;
    }

    public long getLoadAddress() {
        throw new Error("tbc");
    }

    public long getWsa() throws IOException {
        if (this.wsa == 0L) {
            this.wsa = this.ceexdlcbTemplate.getDlcbwsaptr(this.inputStream, this.address);
        }
        return this.wsa;
    }

    public Dll getNext() throws IOException {
        long dlcbnextptr;
        if (this.next == null && (dlcbnextptr = this.ceexdlcbTemplate.getDlcbnextptr(this.inputStream, this.address)) != 0L) {
            this.next = new Dll(dlcbnextptr, this.space);
        }
        return this.next;
    }

    public DllVariable getVariable(String name) throws IOException {
        if (this.getVariables() == null) {
            return null;
        }
        for (int i = 0; i < this.variables.length; ++i) {
            if (!this.variables[i].name.equals(name)) continue;
            return this.variables[i];
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DllVariable[] getVariables() throws IOException {
        if (this.variables != null) {
            return this.variables;
        }
        long dlcbiewbcie = this.ceexdlcbTemplate.getDlcbiewbcie(this.inputStream, this.address);
        int eyecatcher = this.space.readInt(dlcbiewbcie);
        if (eyecatcher == -909777214) {
            long ciet2_version = Ciet2Template.getCiet2_version(this.inputStream, dlcbiewbcie);
            if (ciet2_version == 2L) {
                long ciet2_var_count = Ciet2Template.getCiet2_var_count(this.inputStream, dlcbiewbcie);
                assert (ciet2_var_count >= 0L && ciet2_var_count < 1000000L) : ciet2_var_count;
                long ciet2_var_addr = Ciet2Template.getCiet2_var_addr(this.inputStream, dlcbiewbcie);
                this.variables = new DllVariable[(int)ciet2_var_count];
                int i = 0;
                while ((long)i < ciet2_var_count) {
                    try {
                        long base = ciet2_var_addr + (long)(i * Ciet2ExpVarEntryTemplate.length());
                        long ciet2_exp_var_is_addr = Ciet2ExpVarEntryTemplate.getCiet2_exp_var_is_addr(this.inputStream, base);
                        long ciet2_exp_var_offset = Ciet2ExpVarEntryTemplate.getCiet2_exp_var_offset(this.inputStream, base);
                        long ciet2_exp_var_name_addr = Ciet2ExpVarEntryTemplate.getCiet2_exp_var_name_addr(this.inputStream, base);
                        String varName = this.space.readEbcdicString(ciet2_exp_var_name_addr);
                        long varAddr = ciet2_exp_var_is_addr == 0L ? ciet2_exp_var_offset + this.getWsa() : ciet2_exp_var_offset;
                        long varValue = this.space.readInt(varAddr);
                        this.variables[i] = new DllVariable(varName, varAddr, varValue);
                    }
                    catch (IOException e) {
                        this.variables[i] = new DllVariable(e.toString(), 0L, 0L);
                    }
                    ++i;
                }
                return this.variables;
            }
            if (ciet2_version != 1L) throw new Error("expected ciet2_version 1 or 2 but instead found " + ciet2_version);
            long ciet_var_count = CietTemplate.getCiet_var_count(this.inputStream, dlcbiewbcie);
            long ciet_var_addr = CietTemplate.getCiet_var_addr(this.inputStream, dlcbiewbcie);
            ciet_var_addr = this.space.readInt(ciet_var_addr);
            log.finer("ciet_var_addr = " + Dll.hex(ciet_var_addr));
            this.variables = new DllVariable[(int)ciet_var_count];
            log.finer("count = " + ciet_var_count);
            int i = 0;
            while ((long)i < ciet_var_count) {
                long base = ciet_var_addr + (long)(i * CietExpEntryTemplate.length());
                log.finer("base = " + Dll.hex(base));
                long ciet_is_addr = CietExpEntryTemplate.getCiet_is_addr(this.inputStream, base);
                log.finer("ciet_is_addr = " + ciet_is_addr);
                long ciet_is_function = CietExpEntryTemplate.getCiet_is_function(this.inputStream, base);
                log.finer("ciet_is_function = " + Dll.hex(ciet_is_function));
                long ciet_exp_offset = CietExpEntryTemplate.getCiet_exp_offset(this.inputStream, base);
                log.finer("ciet_exp_offset = " + Dll.hex(ciet_exp_offset));
                long ciet_exp_name_addr = CietExpEntryTemplate.getCiet_exp_name_addr(this.inputStream, base);
                log.finer("ciet_exp_name_addr = " + Dll.hex(ciet_exp_name_addr) + " length = " + this.space.readUnsignedShort(ciet_exp_name_addr));
                String varName = this.space.readEbcdicString(ciet_exp_name_addr);
                log.finer("varName = " + varName);
                long varAddr = ciet_is_addr == 0L ? ciet_exp_offset + this.getWsa() : ciet_exp_offset;
                log.finer("varAddr = " + Dll.hex(varAddr));
                log.finer("ciet_is_addr = " + Dll.hex(ciet_is_addr));
                long varValue = 0L;
                try {
                    varValue = this.space.readInt(varAddr);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.variables[i] = new DllVariable(varName, varAddr, varValue);
                ++i;
            }
            return this.variables;
        }
        if (!this.space.readEbcdicString(dlcbiewbcie, 8).equals("@@DL370$")) throw new Error("tbc");
        long dlloffexpvar = DllcsectTemplate.getDlloffexpvar(this.inputStream, dlcbiewbcie);
        long dllexpvars = dlcbiewbcie + dlloffexpvar;
        long dllexpvarscount = DllexpvarsTemplate.getDllexpvarscount(this.inputStream, dllexpvars);
        if (dllexpvarscount < 0L || dllexpvarscount > 1000000L) {
            log.config("impossible dllexpvarscount: " + dllexpvarscount);
            this.variables = new DllVariable[0];
            return this.variables;
        }
        this.variables = new DllVariable[(int)dllexpvarscount];
        int i = 0;
        while ((long)i < dllexpvarscount) {
            long dllexpvarsname = DllexpvarsTemplate.getDllexpvarsname(this.inputStream, dllexpvars);
            long dllexpvarsqcon = DllexpvarsTemplate.getDllexpvarsqcon(this.inputStream, dllexpvars);
            String varName = this.space.readEbcdicString(dlcbiewbcie + dllexpvarsname);
            long varAddr = this.getWsa() + dllexpvarsqcon;
            long varValue = this.space.readInt(varAddr);
            this.variables[i] = new DllVariable(varName, varAddr, varValue);
            dllexpvars += (long)(DllexpvarsTemplate.getDllexpvarsarray$length() / 8);
            ++i;
        }
        return this.variables;
    }

    public DllFunction getFunction(String name) throws IOException {
        if (this.getFunctions() == null) {
            return null;
        }
        for (int i = 0; i < this.functions.length; ++i) {
            if (!this.functions[i].name.equals(name)) continue;
            return this.functions[i];
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DllFunction[] getFunctions() throws IOException {
        if (this.functions != null) {
            return this.functions;
        }
        long dlcbiewbcie = this.ceexdlcbTemplate.getDlcbiewbcie(this.inputStream, this.address);
        int eyecatcher = this.space.readInt(dlcbiewbcie);
        if (eyecatcher == -909777214) {
            long ciet2_version = Ciet2Template.getCiet2_version(this.inputStream, dlcbiewbcie);
            if (ciet2_version == 2L) {
                long ciet2_func_count = Ciet2Template.getCiet2_func_count(this.inputStream, dlcbiewbcie);
                assert (ciet2_func_count >= 0L && ciet2_func_count < 1000000L) : ciet2_func_count;
                long ciet2_func_addr = Ciet2Template.getCiet2_func_addr(this.inputStream, dlcbiewbcie);
                this.functions = new DllFunction[(int)ciet2_func_count];
                int i = 0;
                while ((long)i < ciet2_func_count) {
                    try {
                        long base = ciet2_func_addr + (long)(i * Ciet2ExpFuncEntryTemplate.length());
                        long ciet2_exp_func_is_addr = Ciet2ExpFuncEntryTemplate.getCiet2_exp_func_is_addr(this.inputStream, base);
                        long ciet2_exp_func_offset = Ciet2ExpFuncEntryTemplate.getCiet2_exp_func_offset(this.inputStream, base);
                        long ciet2_exp_func_name_addr = Ciet2ExpFuncEntryTemplate.getCiet2_exp_func_name_addr(this.inputStream, base);
                        String funcName = this.space.readEbcdicString(ciet2_exp_func_name_addr);
                        long funcAddr = ciet2_exp_func_is_addr == 0L ? ciet2_exp_func_offset + this.getWsa() : ciet2_exp_func_offset;
                        long ciet2_exp_ada_is_addr = Ciet2ExpFuncEntryTemplate.getCiet2_exp_ada_is_addr(this.inputStream, base);
                        long ciet2_exp_func_ada_offset = Ciet2ExpFuncEntryTemplate.getCiet2_exp_func_ada_offset(this.inputStream, base);
                        long funcAda = ciet2_exp_ada_is_addr == 0L ? ciet2_exp_func_ada_offset + this.getWsa() : ciet2_exp_func_ada_offset;
                        this.functions[i] = new DllFunction(funcName, funcAddr, null, funcAda);
                    }
                    catch (IOException e) {
                        this.functions[i] = new DllFunction(e.toString(), 0L, null, -4995072469322842385L);
                    }
                    ++i;
                }
                return this.functions;
            }
            if (ciet2_version != 1L) throw new Error("expected ciet2_version 1 or 2 but instead found " + ciet2_version);
            long ciet_func_count = CietTemplate.getCiet_func_count(this.inputStream, dlcbiewbcie);
            long ciet_func_addr = CietTemplate.getCiet_func_addr(this.inputStream, dlcbiewbcie);
            ciet_func_addr = this.space.readInt(ciet_func_addr);
            this.functions = new DllFunction[(int)ciet_func_count];
            log.finer("count = " + ciet_func_count);
            int i = 0;
            while ((long)i < ciet_func_count) {
                long base = ciet_func_addr + (long)(i * CietExpEntryTemplate.length());
                log.finer("base = " + Dll.hex(base));
                long ciet_is_addr = CietExpEntryTemplate.getCiet_is_addr(this.inputStream, base);
                long ciet_is_function = CietExpEntryTemplate.getCiet_is_function(this.inputStream, base);
                log.finer("ciet_is_function = " + Dll.hex(ciet_is_function));
                long ciet_exp_offset = CietExpEntryTemplate.getCiet_exp_offset(this.inputStream, base);
                log.finer("ciet_exp_offset = " + Dll.hex(ciet_exp_offset));
                long ciet_exp_name_addr = CietExpEntryTemplate.getCiet_exp_name_addr(this.inputStream, base);
                log.finer("ciet_exp_name_addr = " + Dll.hex(ciet_exp_name_addr) + " length = " + this.space.readUnsignedShort(ciet_exp_name_addr));
                String funcName = this.space.readEbcdicString(ciet_exp_name_addr);
                log.finer("funcName = " + funcName);
                long funcAddr = ciet_is_addr == 0L ? ciet_exp_offset + this.getWsa() : ciet_exp_offset;
                log.finer("funcAddr = " + Dll.hex(funcAddr));
                log.finer("ciet_is_addr = " + Dll.hex(ciet_is_addr));
                this.functions[i] = new DllFunction(funcName, funcAddr, null, -4995072469322842385L);
                ++i;
            }
            return this.functions;
        }
        if (!this.space.readEbcdicString(dlcbiewbcie, 8).equals("@@DL370$")) throw new Error("tbc");
        long dlloffexpfunc = DllcsectTemplate.getDlloffexpfunc(this.inputStream, dlcbiewbcie);
        long dllexpfuncs = dlcbiewbcie + dlloffexpfunc;
        long dllexpfuncscount = DllexpfuncsTemplate.getDllexpfuncscount(this.inputStream, dllexpfuncs);
        if (dllexpfuncscount < 0L || dllexpfuncscount > 1000000L) {
            log.config("impossible dllexpfuncscount: " + dllexpfuncscount);
            this.functions = new DllFunction[0];
            return this.functions;
        }
        this.functions = new DllFunction[(int)dllexpfuncscount];
        int i = 0;
        while ((long)i < dllexpfuncscount) {
            long dllexpfuncsname = DllexpfuncsTemplate.getDllexpfuncsname(this.inputStream, dllexpfuncs);
            long dllexpfuncsaddr = DllexpfuncsTemplate.getDllexpfuncsaddr(this.inputStream, dllexpfuncs);
            String funcName = this.space.readEbcdicString(dlcbiewbcie + dllexpfuncsname);
            this.functions[i] = new DllFunction(funcName, dllexpfuncsaddr, null, this.getWsa());
            dllexpfuncs += (long)(DllexpfuncsTemplate.getDllexpfuncsarray$length() / 8);
            ++i;
        }
        return this.functions;
    }

    public static DllFunction getFunction(AddressSpace space, String name) throws IOException {
        DllFunction function = (DllFunction)space.getUserMap().get(name);
        if (function != null) {
            return function;
        }
        Edb edb = Edb.getSampleEdb(space);
        if (edb == null) {
            return null;
        }
        for (Dll dll = edb.getFirstDll(); dll != null; dll = dll.getNext()) {
            function = dll.getFunction(name);
            if (function == null) continue;
            space.getUserMap().put(name, function);
            return function;
        }
        return null;
    }

    public static void addFunction(AddressSpace space, String name, DllFunction function) {
        space.getUserMap().put(name, function);
    }

    private static String hex(long i) {
        return Long.toHexString(i);
    }

    private static String hex(int i) {
        return Integer.toHexString(i);
    }

    public String toString() {
        try {
            return this.getName();
        }
        catch (IOException e) {
            return "oops: " + e;
        }
    }
}

