/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.corereaders;

import com.ibm.dtfj.addressspace.DumpReaderAddressSpace;
import com.ibm.dtfj.addressspace.IAbstractAddressSpace;
import com.ibm.dtfj.corereaders.Builder;
import com.ibm.dtfj.corereaders.ClosingFileReader;
import com.ibm.dtfj.corereaders.CorruptCoreException;
import com.ibm.dtfj.corereaders.DumpReader;
import com.ibm.dtfj.corereaders.ICoreFileReader;
import com.ibm.dtfj.corereaders.J9RASReader;
import com.ibm.dtfj.corereaders.MemoryRange;
import com.ibm.dtfj.corereaders.zos.dumpreader.AddressRange;
import com.ibm.dtfj.corereaders.zos.dumpreader.AddressSpace;
import com.ibm.dtfj.corereaders.zos.dumpreader.Dump;
import com.ibm.dtfj.corereaders.zos.le.Caa;
import com.ibm.dtfj.corereaders.zos.le.CaaNotFound;
import com.ibm.dtfj.corereaders.zos.le.Dll;
import com.ibm.dtfj.corereaders.zos.le.DllFunction;
import com.ibm.dtfj.corereaders.zos.le.DllVariable;
import com.ibm.dtfj.corereaders.zos.le.DsaStackFrame;
import com.ibm.dtfj.corereaders.zos.le.Edb;
import com.ibm.dtfj.corereaders.zos.mvs.RegisterSet;
import com.ibm.dtfj.corereaders.zos.mvs.Tcb;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.stream.ImageInputStream;

public class NewZosDump
implements ICoreFileReader {
    private static final int DR1 = -992349888;
    private static final int DR2 = -992349632;
    private static final int SHARED_MEMORY_ASID = -910042680;
    private static final int RECORD_HEADER_LEN = 64;
    private static final int RECORD_BODY_LEN = 4096;
    private static final int RECORD_LEN = 4160;
    private List _additionalFileNames = new ArrayList();
    private IAbstractAddressSpace _space;
    private ImageInputStream stream;
    private boolean _is64Bit;
    private Object _failingThread = null;
    private HashMap _javaAddressSpaces = new LinkedHashMap();
    private static Logger log = Logger.getLogger(NewZosDump.class.getName());
    private Dump _dump;
    private AddressSpace[] _zebedeeAddressSpaces;
    private boolean zebedeeInitialized;
    private J9RASReader _j9rasReader = null;

    private NewZosDump(ImageInputStream in) {
        this.stream = in;
        this._is64Bit = false;
        List memoryRanges = this.readTDUMP();
        List keepList = null;
        for (int[] asidinfo : this._javaAddressSpaces.values()) {
            List onASID = this.keepMemoryRangesWithAsid(asidinfo, memoryRanges);
            if (keepList != null) {
                keepList.addAll(onASID);
            } else {
                keepList = onASID;
            }
            if (asidinfo[1] == 0) continue;
            this._is64Bit = true;
        }
        if (keepList != null) {
            MemoryRange[] rawRanges = keepList.toArray(new MemoryRange[keepList.size()]);
            this._space = new DumpReaderAddressSpace(rawRanges, new DumpReader(this.stream, this._is64Bit), false, this._is64Bit);
        }
        this._j9rasReader = new J9RASReader(this._space, this._is64Bit);
    }

    public String format(int i) {
        return "0x" + Integer.toHexString(i);
    }

    public String format(long l) {
        return "0x" + Long.toHexString(l);
    }

    private void initializeZebedeeDump(ClosingFileReader file) {
        if (!this.zebedeeInitialized) {
            try {
                log.fine("Building Zebedee dump from " + file);
                String fileName = file.getAbsolutePath();
                if (file.isMVSFile()) {
                    fileName = fileName.substring(fileName.lastIndexOf(47) + 1);
                }
                this._dump = new Dump(fileName, file, false);
                this._zebedeeAddressSpaces = this._dump.getAddressSpaces();
                this.zebedeeInitialized = true;
            }
            catch (FileNotFoundException e) {
                log.log(Level.FINE, "Problem for Zebedee finding dump file", e);
            }
        }
    }

    private void initializeZebedeeDump(ImageInputStream stream) {
        if (!this.zebedeeInitialized) {
            try {
                log.fine("Building Zebedee dump from stream");
                this._dump = new Dump("Stream", stream, false);
                this._zebedeeAddressSpaces = this._dump.getAddressSpaces();
                this.zebedeeInitialized = true;
            }
            catch (FileNotFoundException e) {
                log.log(Level.FINE, "Problem for Zebedee finding dump file", e);
            }
        }
    }

    private AddressSpace findZebedeeAddressSpace(int asid) {
        AddressSpace adrJava = null;
        if (this._zebedeeAddressSpaces != null) {
            for (int i = 0; i < this._zebedeeAddressSpaces.length; ++i) {
                if (asid != this._zebedeeAddressSpaces[i].getAsid()) continue;
                adrJava = this._zebedeeAddressSpaces[i];
                break;
            }
        }
        return adrJava;
    }

    private Edb[] getEdbs(AddressSpace as) {
        HashMap<Long, Edb> edbs = new HashMap<Long, Edb>();
        Tcb[] tc = Tcb.getTcbs(as);
        if (tc != null) {
            for (int i = 0; i < tc.length; ++i) {
                try {
                    Caa ca = new Caa(tc[i]);
                    Edb edb = ca.getEdb();
                    if (edb.getFirstDll() == null) continue;
                    edbs.put(edb.address(), edb);
                    continue;
                }
                catch (CaaNotFound caaNotFound) {
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        Edb[] edb = new Edb[edbs.size()];
        edbs.values().toArray(edb);
        return edb;
    }

    private List getThreads(Builder builder, Object imgAdr, AddressSpace addressSpace, Edb edb, Map stackSyms) {
        ArrayList<Object> threads = new ArrayList<Object>();
        long tid = -1L;
        if (null != this._j9rasReader) {
            try {
                tid = this._j9rasReader.getThreadID();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        AddressRange[] rr = addressSpace.getAddressRanges();
        Tcb[] tc = Tcb.getTcbs(addressSpace);
        if (tc != null) {
            for (int j = 0; j < tc.length; ++j) {
                try {
                    ArrayList<Object> stackSections;
                    ArrayList<Object> stackFrames;
                    Properties props;
                    ArrayList<Object> regs;
                    Caa caa;
                    block31: {
                        RegisterSet rs;
                        log.fine("TCB " + this.format(tc[j].address()));
                        caa = new Caa(tc[j]);
                        log.fine("CAA " + this.format(caa.address()) + " " + caa.whereFound());
                        if (caa.getEdb().address() != edb.address()) {
                            log.fine("Skipping CAA as edb " + this.format(caa.getEdb().address()) + " != edb for process " + this.format(edb.address()));
                            continue;
                        }
                        try {
                            rs = tc[j].getRegisters();
                        }
                        catch (IOException e) {
                            try {
                                rs = tc[j].getRegistersFromBPXGMSTA();
                            }
                            catch (IOException e2) {
                                rs = caa.getCurrentFrame().getRegisterSet();
                            }
                        }
                        regs = new ArrayList<Object>();
                        long psw = rs.getPSW();
                        String pswn = null;
                        switch ((int)(psw >> 31) & 3) {
                            case 0: {
                                pswn = "PSW:24";
                                break;
                            }
                            case 1: {
                                pswn = "PSW:31";
                                break;
                            }
                            default: {
                                pswn = "PSW:64";
                            }
                        }
                        regs.add(builder.buildRegister("PSW", psw));
                        for (int i = 0; i < 16; ++i) {
                            regs.add(builder.buildRegister("R" + i, rs.getRegister(i)));
                        }
                        props = new Properties();
                        props.setProperty("TCB", this.format(caa.getTcb().address()));
                        props.setProperty("CAA", this.format(caa.address()));
                        props.setProperty("EDB", this.format(caa.getEdb().address()));
                        props.setProperty(pswn, this.format(psw));
                        try {
                            props.setProperty("Stack direction", caa.ceecaa_stackdirection() == 0 ? "up" : "down");
                            props.setProperty("CAA CEL level", this.format(caa.ceecaalevel()));
                        }
                        catch (IOException e) {
                            log.log(Level.FINE, "Problem finding stack information", e);
                        }
                        try {
                            int code = tc[j].space().readInt(tc[j].address() + 16L);
                            props.setProperty("Task Completion Code", this.format(code));
                        }
                        catch (IOException code) {
                            // empty catch block
                        }
                        stackFrames = new ArrayList<Object>();
                        stackSections = new ArrayList<Object>();
                        boolean[] usedRange = new boolean[rr.length];
                        try {
                            DsaStackFrame dsa;
                            if (dsa == null) {
                                log.fine("Null current frame for CAA " + this.format(caa.address()));
                                stackSections.add(builder.buildCorruptData(imgAdr, "Null stack frame so no stack sections with CAA", caa.address()));
                                break block31;
                            }
                            try {
                                for (dsa = caa.getCurrentFrame(); dsa != null; dsa = dsa.getParentFrame()) {
                                    Object builderStackFrame = builder.buildStackFrame(imgAdr, dsa.getDsaAddress(), dsa.getEntryPoint() + dsa.getEntryOffset());
                                    stackSyms.put(dsa.getEntryPoint(), dsa.getEntryName());
                                    stackFrames.add(builderStackFrame);
                                    long dsaAddr = dsa.getDsaAddress();
                                    int i = this.findRange(dsaAddr, usedRange, rr);
                                    if (i >= 0) {
                                        stackSections.add(builder.buildStackSection(imgAdr, rr[i].getStartAddress(), rr[i].getStartAddress() + rr[i].getLength()));
                                        continue;
                                    }
                                    if (i != -2) continue;
                                    log.fine("Unable to find stack section for DSA " + this.format(dsa.getDsaAddress()));
                                }
                            }
                            catch (Error e) {
                                long dsaAddress = dsa != null ? dsa.getDsaAddress() : 0L;
                                log.log(Level.FINE, "Problem finding parent frame for DSA " + this.format(dsaAddress), e);
                                stackFrames.add(builder.buildCorruptData(imgAdr, "Corrupt stack frame with DSA " + e.getMessage(), dsaAddress));
                                stackSections.add(builder.buildCorruptData(imgAdr, "Corrupt stack frame with DSA " + e.getMessage(), dsaAddress));
                            }
                        }
                        catch (Error e) {
                            log.log(Level.FINE, "Problem finding current frame for CAA " + this.format(caa.address()), e);
                            stackFrames.add(builder.buildCorruptData(imgAdr, "Corrupt stack frames with CAA " + e.getMessage(), caa.address()));
                            stackSections.add(builder.buildCorruptData(imgAdr, "Corrupt stack frames with CAA " + e.getMessage(), caa.address()));
                        }
                    }
                    String threadId = "";
                    try {
                        threadId = this.format(caa.getPThreadID());
                    }
                    catch (IOException e) {
                        threadId = "<unknown>";
                    }
                    log.fine("Building thread " + threadId + " with " + stackSections.size() + " sections");
                    Object it = builder.buildThread(threadId, regs.iterator(), stackSections.iterator(), stackFrames.iterator(), props, 0);
                    if (-1L != tid && this.format(tid).equals(threadId)) {
                        this._failingThread = it;
                    }
                    threads.add(it);
                    continue;
                }
                catch (CaaNotFound e) {
                    log.log(Level.FINE, "Problem finding CAA for TCB " + this.format(tc[j].address()), e);
                }
            }
        }
        return threads;
    }

    private Dll closestDll(Edb edb, long address) throws IOException {
        Dll closestDll = null;
        long closestDist = Long.MAX_VALUE;
        for (Dll dll = edb.getFirstDll(); dll != null; dll = dll.getNext()) {
            DllFunction[] f = dll.getFunctions();
            for (int i = 0; i < f.length; ++i) {
                long dist = Math.abs(f[i].address - address);
                if (dist >= closestDist) continue;
                closestDll = dll;
                closestDist = dist;
            }
            DllVariable[] g = dll.getVariables();
            for (int i = 0; i < g.length; ++i) {
                long dist = Math.abs(g[i].address - address);
                if (dist >= closestDist) continue;
                closestDll = dll;
                closestDist = dist;
            }
        }
        return closestDll;
    }

    private List getModules(Builder builder, Object imgAdr, AddressSpace addressSpace, Edb edb, Map stackSyms) {
        ArrayList<Object> modules = new ArrayList<Object>();
        AddressRange[] rr = addressSpace.getAddressRanges();
        try {
            HashMap<Long, Dll> closestDlls = new HashMap<Long, Dll>();
            for (Long addr : stackSyms.keySet()) {
                long address = addr;
                Dll closest = this.closestDll(edb, address);
                closestDlls.put(addr, closest);
            }
            for (Dll dll = edb.getFirstDll(); dll != null; dll = dll.getNext()) {
                long loadAddress;
                int i;
                DllFunction[] f = dll.getFunctions();
                DllVariable[] g = dll.getVariables();
                String dllname = dll.getName();
                ArrayList<Object> symbols = new ArrayList<Object>();
                boolean[] usedRange = new boolean[rr.length];
                boolean[] usedDataRange = new boolean[rr.length];
                for (i = 0; i < f.length; ++i) {
                    symbols.add(builder.buildSymbol(imgAdr, f[i].name, f[i].address));
                    this.findRange(f[i].address, usedRange, rr);
                }
                for (i = 0; i < g.length; ++i) {
                    symbols.add(builder.buildSymbol(imgAdr, g[i].name, g[i].address));
                    this.findRange(g[i].address, usedDataRange, rr);
                }
                Iterator i2 = stackSyms.keySet().iterator();
                while (i2.hasNext()) {
                    int r;
                    Long addr = (Long)i2.next();
                    long address = addr;
                    Dll closest = (Dll)closestDlls.get(addr);
                    if (closest == null || !dll.getName().equals(closest.getName()) || (r = this.findRange(address, rr)) < 0 || !usedRange[r]) continue;
                    String name = (String)stackSyms.get(addr);
                    symbols.add(builder.buildSymbol(imgAdr, name, address));
                    i2.remove();
                }
                Properties props = new Properties();
                ArrayList<Object> sections = new ArrayList<Object>();
                for (int i3 = 0; i3 < usedRange.length; ++i3) {
                    if (usedRange[i3]) {
                        sections.add(builder.buildModuleSection(imgAdr, ".text", rr[i3].getStartAddress(), rr[i3].getStartAddress() + rr[i3].getLength()));
                        continue;
                    }
                    if (!usedDataRange[i3]) continue;
                    sections.add(builder.buildModuleSection(imgAdr, ".data", rr[i3].getStartAddress(), rr[i3].getStartAddress() + rr[i3].getLength()));
                }
                try {
                    loadAddress = dll.getLoadAddress();
                }
                catch (Error e) {
                    loadAddress = Long.MAX_VALUE;
                    for (int i4 = 0; i4 < f.length; ++i4) {
                        loadAddress = Math.min(f[i4].address, loadAddress);
                    }
                    loadAddress = this.guessLoadAddress(loadAddress, rr);
                }
                props.setProperty("Load address", this.format(loadAddress));
                props.setProperty("Writable Static Area address", this.format(dll.getWsa()));
                Object mod = builder.buildModule(dllname, props, sections.iterator(), symbols.iterator(), loadAddress);
                modules.add(mod);
            }
            if (stackSyms.size() > 0) {
                String dllname = "ExtraSymbolsModule";
                long loadAddress = Long.MAX_VALUE;
                ArrayList<Object> symbols = new ArrayList<Object>();
                boolean[] usedRange = new boolean[rr.length];
                Iterator i = stackSyms.keySet().iterator();
                while (i.hasNext()) {
                    Long addr = (Long)i.next();
                    long address = addr;
                    loadAddress = Math.min(address, loadAddress);
                    this.findRange(address, usedRange, rr);
                    String name = (String)stackSyms.get(addr);
                    symbols.add(builder.buildSymbol(imgAdr, name, address));
                    i.remove();
                }
                loadAddress = this.guessLoadAddress(loadAddress, rr);
                Properties props = new Properties();
                props.setProperty("Load address", this.format(loadAddress));
                ArrayList<Object> sections = new ArrayList<Object>();
                for (int i5 = 0; i5 < usedRange.length; ++i5) {
                    if (!usedRange[i5]) continue;
                    sections.add(builder.buildModuleSection(imgAdr, ".text", rr[i5].getStartAddress(), rr[i5].getStartAddress() + rr[i5].getLength()));
                }
                Object mod = builder.buildModule("ExtraSymbolsModule", props, sections.iterator(), symbols.iterator(), loadAddress);
                modules.add(mod);
            }
        }
        catch (IOException e) {
            log.log(Level.FINE, "Problem for Zebedee finding module information", e);
        }
        return modules;
    }

    private long guessLoadAddress(long loadAddress, AddressRange[] rr) {
        if (loadAddress != Long.MAX_VALUE) {
            int r = this.findRange(loadAddress, rr);
            if (r >= 0) {
                loadAddress = rr[r].getStartAddress();
            }
        } else {
            loadAddress = 0L;
        }
        return loadAddress;
    }

    private int findRange(long routine, boolean[] used, AddressRange[] rr) {
        int r = this.findRange(routine, rr);
        if (r >= 0) {
            if (used[r]) {
                r = -1;
            } else {
                used[r] = true;
            }
        }
        return r;
    }

    private int findRange(long routine, AddressRange[] rr) {
        for (int i = 0; i < rr.length; ++i) {
            if (rr[i].getStartAddress() > routine || routine > rr[i].getEndAddress()) continue;
            log.fine("Found address " + this.format(routine) + " at " + this.format(rr[i].getStartAddress()) + ":" + this.format(rr[i].getEndAddress()));
            return i;
        }
        log.fine("Didn't find address " + this.format(routine));
        return -2;
    }

    private Properties getEnvironment(Builder build, AddressSpace addressSpace, Edb edb) {
        try {
            log.fine("Get environment for EDB = " + edb);
            Properties p = edb.getEnvVars();
            return p;
        }
        catch (IOException e) {
            log.log(Level.FINE, "Problem for Zebedee environment", e);
            return new Properties();
        }
    }

    private long getCreationTime() {
        long tm = this._dump.getCreationDate().getTime();
        log.fine("Java time of dump:" + this.format(tm) + " as date:" + new Date(tm));
        return this._dump.getCreationDate().getTime();
    }

    private List keepMemoryRangesWithAsid(int[] asidinfo, List rangeArray) {
        ArrayList<MemoryRange> keep = new ArrayList<MemoryRange>();
        for (MemoryRange range : rangeArray) {
            boolean range64;
            boolean bl = range64 = range.getVirtualAddress() + range.getSize() >= 0x100000000L;
            if (range64) {
                log.finer("Found 64-bit address range " + this.format(range.getVirtualAddress()) + ":" + this.format(range.getSize()) + " in address space " + this.format(range.getAsid()));
            }
            if (range.getAsid() == asidinfo[0]) {
                keep.add(range);
                if (range64 && asidinfo[1] == 0) {
                    log.fine("Found 64-bit address in Java address space");
                    asidinfo[1] = 1;
                }
            }
            if (range.getAsid() != -910042680) continue;
            MemoryRange rangeCopy = new MemoryRange(range, asidinfo[0]);
            keep.add(rangeCopy);
        }
        return keep;
    }

    private boolean bufferHasJ9RASEyeCatcher(byte[] buf) {
        byte[] j9vmras = new byte[]{74, 57, 86, 77, 82, 65, 83, 0};
        for (int i = 0; i < buf.length; i += 8) {
            boolean found = true;
            for (int j = 0; j < j9vmras.length; ++j) {
                if (buf[i + j] == j9vmras[j]) continue;
                found = false;
            }
            if (!found) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator getAdditionalFileNames() {
        return this._additionalFileNames.iterator();
    }

    @Override
    public void extract(Builder builder) {
        builder.setOSType("z/OS");
        builder.setCPUType("s390");
        builder.setCPUSubType("");
        log.fine("Address spaces " + this._javaAddressSpaces.size());
        for (int[] asidinfo : this._javaAddressSpaces.values()) {
            this.buildAddressSpace(builder, asidinfo[0], asidinfo[1] != 0);
        }
        if (this._dump != null) {
            builder.setCreationTime(this.getCreationTime());
        }
    }

    private void buildAddressSpace(Builder builder, int asid, boolean is64Bit) {
        AddressSpace adrJava;
        log.fine("Building address space " + this.format(asid));
        Object addressSpace = builder.buildAddressSpace("z/OS Address Space", asid);
        if (addressSpace.getClass() == Object.class) {
            adrJava = null;
        } else {
            if (this.stream instanceof ClosingFileReader) {
                this.initializeZebedeeDump((ClosingFileReader)this.stream);
            } else {
                this.initializeZebedeeDump(this.stream);
            }
            adrJava = this.findZebedeeAddressSpace(asid);
        }
        Edb[] edbs = adrJava != null ? this.getEdbs(adrJava) : new Edb[1];
        for (int i = 0; i < edbs.length; ++i) {
            String pid;
            String commandLine;
            Object executable;
            Edb edb = edbs[i];
            Properties environment = edb == null ? new Properties() : this.getEnvironment(builder, adrJava, edb);
            HashMap stackSymbols = new HashMap();
            List threads = edb == null ? Collections.singletonList(builder.buildCorruptData(addressSpace, "unable to extract thread information this time!", 0L)) : this.getThreads(builder, addressSpace, adrJava, edb, stackSymbols);
            List modules = edb == null ? Collections.EMPTY_LIST : this.getModules(builder, addressSpace, adrJava, edb, stackSymbols);
            Iterator mods = modules.iterator();
            Object v0 = executable = mods.hasNext() ? mods.next() : null;
            if (executable == null) {
                builder.setExecutableUnavailable("unable to extract executable information");
            }
            if ((commandLine = environment.getProperty("OPENJ9_JAVA_COMMAND_LINE", null)) == null) {
                commandLine = environment.getProperty("IBM_JAVA_COMMAND_LINE", "");
            }
            String string = pid = edb != null ? this.format(edb.address()) : this.format(asid);
            if (null != this._j9rasReader) {
                try {
                    pid = this.format(this._j9rasReader.getProcessID());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (null == this._failingThread) {
                this._failingThread = adrJava == null ? null : threads.get(0);
            }
            int addressSize = 31;
            addressSize = adrJava != null ? (adrJava.getWordLength() == 8 ? 64 : 31) : (is64Bit ? 64 : 32);
            Object process = builder.buildProcess(addressSpace, pid, commandLine, environment, this._failingThread, threads.iterator(), executable, mods, addressSize);
            log.fine("Built process " + process);
        }
    }

    public static boolean isSupportedDump(ImageInputStream stream) throws IOException, CorruptCoreException {
        stream.seek(0L);
        int signature = stream.readInt();
        if (17490 == (0xFFFF & signature >> 16)) {
            throw new CorruptCoreException("This is a z/OS core file which has been corrupted by EBCDIC to ASCII conversion.  Reverse the conversion and try again.");
        }
        return signature == -992349888 || signature == -992349632;
    }

    public static ICoreFileReader dumpFromFile(ImageInputStream stream) throws IOException {
        block3: {
            try {
                assert (NewZosDump.isSupportedDump(stream)) : "Tried to create a core reader from an unsupported file type";
            }
            catch (CorruptCoreException e) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)"Tried to create a core reader from a corrupt core");
            }
        }
        return new NewZosDump(stream);
    }

    protected List readTDUMP() {
        log.fine("Reading address ranges");
        ArrayList<MemoryRange> ranges = new ArrayList<MemoryRange>();
        byte[] buf = new byte[4096];
        try {
            long pos = 0L;
            while (true) {
                MemoryRange range = this.readRecord(pos);
                pos += 4160L;
                if (null == range || 0 == range.getAsid() || 0L == range.getVirtualAddress()) continue;
                ranges.add(range);
                int asid = range.getAsid();
                if (this._javaAddressSpaces.containsKey(asid)) continue;
                this.stream.seek(range.getFileOffset());
                this.stream.readFully(buf);
                if (!this.bufferHasJ9RASEyeCatcher(buf)) continue;
                this._javaAddressSpaces.put(asid, new int[]{asid, 0});
                log.fine("Found Java asid " + this.format(asid) + " at " + this.format(range.getVirtualAddress()));
            }
        }
        catch (IOException iOException) {
            log.fine("Read " + ranges.size() + " address ranges");
            return ranges;
        }
    }

    protected MemoryRange readRecord(long pos) throws IOException {
        this.stream.seek(pos);
        int signature = this.stream.readInt();
        if (signature != -992349888 && signature != -992349632) {
            throw new IOException("Unrecognized dump record");
        }
        this.stream.seek(pos + 12L);
        int asid = this.stream.readInt();
        this.stream.seek(pos + 20L);
        long address = signature == -992349632 ? this.stream.readLong() : this.stream.readUnsignedInt();
        return new MemoryRange(address, pos + 64L, 4096L, asid);
    }

    @Override
    public IAbstractAddressSpace getAddressSpace() {
        return this._space;
    }

    @Override
    public boolean isTruncated() {
        return false;
    }

    @Override
    public void releaseResources() throws IOException {
        if (this.stream instanceof ClosingFileReader) {
            ((ClosingFileReader)this.stream).releaseResources();
        }
    }
}

