/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm;

import com.ibm.jvm.ProgramOption;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;

class OutputFile
extends ProgramOption {
    PrintWriter outputStream;

    OutputFile() {
    }

    @Override
    String getDescription() {
        return "The output file containing the formatted trace data. The default is to append \".fmt\" to the input file name";
    }

    @Override
    String getName() {
        return "output_file";
    }

    @Override
    Object getValue() {
        return this.outputStream;
    }

    @Override
    void setDefault() {
        if (ProgramOption.AnonymousArgs.isEmpty()) {
            throw new IllegalArgumentException("An input file must be specified before the output file when using anonymous arguments to specify input/output files");
        }
        if (ProgramOption.AnonymousArgs.size() == 1) {
            this.setValue(ProgramOption.AnonymousArgs.get(0).toString() + ".fmt");
        } else if (ProgramOption.AnonymousArgs.size() == 2) {
            this.setValue(ProgramOption.AnonymousArgs.get(1).toString());
        } else {
            StringBuffer sb = new StringBuffer("Usage error: too many positional arguments:" + System.getProperty("line.separator"));
            for (int i = 2; i < ProgramOption.AnonymousArgs.size(); ++i) {
                sb.append(ProgramOption.AnonymousArgs.get(i)).append(System.getProperty("line.separator"));
            }
            sb.append(System.getProperty("line.separator") + OutputFile.help());
            throw new IllegalArgumentException(sb.toString());
        }
    }

    @Override
    void setValue(String value) throws IllegalArgumentException {
        try {
            String encoding = System.getProperty("file.encoding", "UTF-8");
            try {
                this.outputStream = new PrintWriter(new File(value), encoding);
            }
            catch (UnsupportedEncodingException e) {
                System.err.println("Unable to set encoding of output file to UTF-8. Some formatted data may not be readable.");
                this.outputStream = new PrintWriter(new File(value));
            }
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("Unable to create file \"" + value + "\" for writing");
        }
        System.out.println("Writing formatted trace output to file " + value);
    }
}

