/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.crypto.provider.PKCS5KeySpec;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Arrays;
import javax.crypto.SecretKey;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.DestroyFailedException;

class PBEKey
implements SecretKey {
    private static final long serialVersionUID = 6550714301310581595L;
    private byte[] key;
    private String type;
    private static final String[] z;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PBEKey(KeySpec keySpec, String string) throws InvalidKeySpecException {
        int n2;
        KeySpec keySpec2;
        if (!(keySpec instanceof PBEKeySpec || keySpec instanceof PKCS5KeySpec || keySpec instanceof SecretKeySpec)) {
            throw new InvalidKeySpecException(z[8]);
        }
        char[] cArray = null;
        if (keySpec instanceof PBEKeySpec) {
            keySpec2 = (PBEKeySpec)keySpec;
            cArray = ((PBEKeySpec)keySpec2).getPassword();
        }
        if (keySpec instanceof PKCS5KeySpec) {
            keySpec2 = (PKCS5KeySpec)keySpec;
            cArray = ((PKCS5KeySpec)keySpec2).getPassword();
        }
        if (keySpec instanceof SecretKeySpec) {
            String string2;
            keySpec2 = (SecretKeySpec)keySpec;
            byte[] byArray = ((SecretKeySpec)keySpec2).getEncoded();
            try {
                string2 = new String(byArray, z[9]);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                string2 = new String(byArray);
            }
            cArray = string2.toCharArray();
        }
        if (cArray == null) {
            throw new InvalidKeySpecException(z[10]);
        }
        for (n2 = 0; n2 < cArray.length; ++n2) {
            if (cArray[n2] >= ' ' && cArray[n2] <= '~') continue;
            throw new InvalidKeySpecException(z[7]);
        }
        this.key = new byte[cArray.length];
        n2 = 0;
        while (true) {
            if (n2 >= cArray.length) {
                Arrays.fill(cArray, ' ');
                this.type = string;
                return;
            }
            this.key[n2] = (byte)(cArray[n2] & 0x7F);
            ++n2;
        }
    }

    @Override
    public synchronized byte[] getEncoded() {
        return (byte[])this.key.clone();
    }

    @Override
    public String getAlgorithm() {
        return this.type;
    }

    @Override
    public String getFormat() {
        return z[3];
    }

    public int hashCode() {
        int n2 = 0;
        for (int i2 = 1; i2 < this.key.length; ++i2) {
            n2 += this.key[i2] * i2;
        }
        return n2 ^ this.getAlgorithm().toLowerCase().hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SecretKey)) {
            return false;
        }
        SecretKey secretKey = (SecretKey)object;
        if (this.isDestroyed() || secretKey.isDestroyed()) {
            return false;
        }
        if (!(secretKey.getAlgorithm().equalsIgnoreCase(this.type) || secretKey.getAlgorithm().toUpperCase().equals(z[0]) || this.type.equals(z[2]) && secretKey.getAlgorithm().toUpperCase().startsWith(z[1]))) {
            return false;
        }
        byte[] byArray = secretKey.getEncoded();
        boolean bl2 = MessageDigest.isEqual(this.key, byArray);
        Arrays.fill(byArray, (byte)0);
        return bl2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.type == null) {
            this.type = z[4];
        }
        if (this.key == null) {
            throw new InvalidObjectException(z[6]);
        }
        this.key = (byte[])this.key.clone();
        if (this.key.length != 1 || this.key[0] != 0) {
            for (int n2 = 0; n2 < this.key.length; ++n2) {
                if (this.key[n2] >= 32 && this.key[n2] <= 126) continue;
                throw new InvalidObjectException(z[5]);
            }
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.destroy();
        }
        catch (DestroyFailedException destroyFailedException) {
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() throws DestroyFailedException {
        PBEKey pBEKey = this;
        synchronized (pBEKey) {
            if (!this.isDestroyed()) {
                Arrays.fill(this.key, (byte)0);
                this.key = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDestroyed() {
        PBEKey pBEKey = this;
        synchronized (pBEKey) {
            return null == this.key;
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[11];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "W0\u001b";
        int n3 = -1;
        block18: while (true) {
            char[] cArray;
            block22: {
                int n4;
                int n5;
                block21: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block21;
                    n5 = n5;
                    if (n5 <= n4) break block22;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 7;
                            break;
                        }
                        case 1: {
                            n6 = 114;
                            break;
                        }
                        case 2: {
                            n6 = 94;
                            break;
                        }
                        case 3: {
                            n6 = 50;
                            break;
                        }
                        default: {
                            n6 = 37;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "W0\u001b";
                    n3 = 0;
                    continue block18;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "W0\u001b";
                    n3 = 1;
                    continue block18;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "U3\t";
                    n3 = 2;
                    continue block18;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "W0\u001b";
                    n3 = 3;
                    continue block18;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "W0\u001by@~R6SA'\u001c1\\\bF!\u001d{l'\u00116SWt";
                    n3 = 4;
                    continue block18;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "W0\u001by@~R=]Pk\u00160\u0015Q'\u0010;\u0012Ab\u0001;@Lf\u001e7H@c";
                    n3 = 5;
                    continue block18;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "W\u0013-ARh\u0000:\u0012LtR0]Q'3\rqlN";
                    n3 = 6;
                    continue block18;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "N\u001c?BUu\u001d.@Lf\u0006;\u0012Nb\u000b~AUb\u00117TLd\u0013*[Ji";
                    n3 = 7;
                    continue block18;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "?Jk\u000bz6";
                    n3 = 8;
                    continue block18;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "B\u001f.F\\'\u0002?AVp\u001d,V";
                    n3 = 9;
                    continue block18;
                }
                case 9: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

