/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands.infocommands;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImageThread;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaMonitor;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.JavaRuntime;
import com.ibm.dtfj.java.JavaThread;
import com.ibm.java.diagnostics.utils.IContext;
import com.ibm.java.diagnostics.utils.commands.CommandException;
import com.ibm.java.diagnostics.utils.plugins.DTFJPlugin;
import com.ibm.jvm.dtfjview.commands.BaseJdmpviewCommand;
import com.ibm.jvm.dtfjview.commands.helpers.Exceptions;
import com.ibm.jvm.dtfjview.commands.helpers.Utils;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;

@DTFJPlugin(version="1.*", runtime=false)
public class InfoLockCommand
extends BaseJdmpviewCommand {
    public InfoLockCommand() {
        this.addCommand("info lock", "", "outputs a list of system monitors and locked objects");
    }

    public void run(String command, String[] args, IContext context, PrintStream out) throws CommandException {
        if (this.initCommand(command, args, context, out)) {
            return;
        }
        if (args.length != 0) {
            out.println("\"info lock\" command does not take any parameters");
            return;
        }
        this.showSystemLocks();
        this.showJavaUtilConcurrentLocks();
    }

    private void showSystemLocks() {
        Vector<JavaMonitor> vMonitorsWithLockedObjects = new Vector<JavaMonitor>();
        JavaRuntime jRuntime = this.ctx.getRuntime();
        Iterator monitors = jRuntime.getMonitors();
        this.out.println("\nSystem locks...");
        while (monitors.hasNext()) {
            JavaMonitor jMonitor = (JavaMonitor)monitors.next();
            JavaObject jObject = jMonitor.getObject();
            try {
                String monitorName = jMonitor.getName().trim();
                if (monitorName.equalsIgnoreCase("")) {
                    monitorName = "<un-named monitor>";
                }
                this.out.println("id: 0x" + jMonitor.getID() + " name: " + jMonitor.getName());
                JavaThread owner = jMonitor.getOwner();
                if (null != owner) {
                    try {
                        this.out.println("\towner thread id: " + owner.getImageThread().getID() + " name: " + owner.getName());
                    }
                    catch (DataUnavailable e) {
                        this.out.println("\towner thread id: " + Exceptions.getDataUnavailableString());
                        this.logger.log(Level.FINE, Exceptions.getDataUnavailableString(), e);
                    }
                }
                this.showWaiters(jMonitor);
            }
            catch (CorruptDataException cde) {
                this.out.println("\nwarning, corrupt data encountered during scan for system locks...");
            }
            if (null == jObject) continue;
            vMonitorsWithLockedObjects.add(jMonitor);
        }
        this.showLockedObjects(vMonitorsWithLockedObjects);
    }

    private void showWaiters(JavaMonitor jMonitor) throws CorruptDataException {
        Iterator itEnterWaiter = jMonitor.getEnterWaiters();
        while (itEnterWaiter.hasNext()) {
            Object t = itEnterWaiter.next();
            if (!(t instanceof JavaThread)) continue;
            JavaThread jThread = (JavaThread)t;
            try {
                this.out.println("\twaiting thread id: " + jThread.getImageThread().getID() + " name: " + jThread.getName());
            }
            catch (DataUnavailable dae) {
                this.out.println("\twaiting thread id: <unknown>");
                this.logger.log(Level.FINE, Exceptions.getDataUnavailableString(), dae);
            }
        }
        Iterator itNotifyWaiter = jMonitor.getNotifyWaiters();
        while (itNotifyWaiter.hasNext()) {
            Object t = itNotifyWaiter.next();
            if (!(t instanceof JavaThread)) continue;
            JavaThread jThread = (JavaThread)t;
            try {
                this.out.println("\twaiting thread id: " + jThread.getImageThread().getID() + " name: " + jThread.getName());
            }
            catch (DataUnavailable dae) {
                this.out.println("\twaiting thread id: <unknown>");
                this.logger.log(Level.FINE, Exceptions.getDataUnavailableString(), dae);
            }
        }
    }

    private void showLockedObjects(Vector<JavaMonitor> vMonitorsWithLockedObjects) {
        this.out.println("\nObject Locks in use...");
        if (0 == vMonitorsWithLockedObjects.size()) {
            this.out.println("\t...None.");
            return;
        }
        for (JavaMonitor jMonitor : vMonitorsWithLockedObjects) {
            JavaObject jObject = jMonitor.getObject();
            try {
                JavaThread owner = jMonitor.getOwner();
                String className = "<unknown class>";
                JavaClass jClass = jObject.getJavaClass();
                if (null != jClass) {
                    className = jClass.getName();
                }
                String jObjectID = Long.toHexString(jObject.getID().getAddress());
                if (null == owner) {
                    this.out.println(className + "@0x" + jObjectID);
                } else {
                    String owningThreadID = null;
                    try {
                        owningThreadID = owner.getImageThread().getID();
                    }
                    catch (DataUnavailable e) {
                        owningThreadID = Exceptions.getDataUnavailableString();
                    }
                    this.out.println(className + "@0x" + jObjectID);
                    this.out.println("\towner thread id: " + owningThreadID + " name: " + owner.getName());
                }
                this.showWaiters(jMonitor);
            }
            catch (CorruptDataException cde) {
                this.logger.log(Level.FINE, Exceptions.getCorruptDataExceptionString(), cde);
            }
        }
    }

    private void showJavaUtilConcurrentLocks() {
        JavaObject lock;
        HashMap<JavaObject, LinkedList<JavaThread>> locksToThreads = new HashMap<JavaObject, LinkedList<JavaThread>>();
        JavaRuntime jr = this.ctx.getRuntime();
        Iterator itThread = jr.getThreads();
        while (itThread.hasNext()) {
            try {
                JavaThread jt;
                Object o = itThread.next();
                if (!(o instanceof JavaThread) || ((jt = (JavaThread)o).getState() & 0x200) == 0 || (lock = jt.getBlockingObject()) == null) continue;
                LinkedList<JavaThread> parkedList = (LinkedList<JavaThread>)locksToThreads.get(lock);
                if (parkedList == null) {
                    parkedList = new LinkedList<JavaThread>();
                    locksToThreads.put(lock, parkedList);
                }
                parkedList.add(jt);
            }
            catch (CorruptDataException cde) {
                this.out.println("\nwarning, corrupt data encountered during scan for java.util.concurrent locks...");
                this.logger.log(Level.FINE, Exceptions.getCorruptDataExceptionString(), cde);
            }
            catch (DataUnavailable du) {
                this.out.println("\nwarning, data unavailable encountered during scan for java.util.concurrent locks...");
                this.logger.log(Level.FINE, Exceptions.getDataUnavailableString(), du);
            }
        }
        this.out.println("\njava.util.concurrent locks in use...");
        if (locksToThreads.size() == 0) {
            this.out.println("\t...None.");
            this.out.println();
        }
        for (Map.Entry entry : locksToThreads.entrySet()) {
            try {
                JavaObject lockOwnerObj;
                lock = (JavaObject)entry.getKey();
                List threads = (List)entry.getValue();
                String threadName = "<unowned>";
                JavaThread lockOwnerThread = Utils.getParkBlockerOwner(lock, this.ctx.getRuntime());
                threadName = lockOwnerThread != null ? lockOwnerThread.getName() : ((lockOwnerObj = Utils.getParkBlockerOwnerObject(lock, this.ctx.getRuntime())) != null ? Utils.getThreadNameFromObject(lockOwnerObj, this.ctx.getRuntime(), this.out) : "<unknown>");
                if (threads == null || threads.size() <= 0) continue;
                String lockID = Long.toHexString(lock.getID().getAddress());
                ImageThread imageThread = lockOwnerThread != null ? lockOwnerThread.getImageThread() : null;
                this.out.println(lock.getJavaClass().getName() + "@0x" + lockID + "\n\tlocked by java thread id: " + (imageThread != null ? imageThread.getID() : "<null>") + " name: " + threadName);
                for (Object t : threads) {
                    JavaThread waiter = (JavaThread)t;
                    this.out.println("\twaiting thread id: " + waiter.getImageThread().getID() + " name: " + waiter.getName());
                }
            }
            catch (CorruptDataException cde) {
                this.out.println("\nwarning, corrupt data encountered during scan for java.util.concurrent locks...");
                this.logger.log(Level.FINE, Exceptions.getCorruptDataExceptionString(), cde);
            }
            catch (MemoryAccessException ma) {
                this.out.println("\nwarning, memory access error encountered during scan for java.util.concurrent locks...");
                this.logger.log(Level.FINE, Exceptions.getMemoryAccessExceptionString(), ma);
            }
            catch (DataUnavailable du) {
                this.out.println("\nwarning, data unavailable encountered during scan for java.util.concurrent locks...");
                this.logger.log(Level.FINE, Exceptions.getDataUnavailableString(), du);
            }
        }
    }

    @Override
    public void printDetailedHelp(PrintStream out) {
        out.println("outputs a list of system monitors and locked objects\n\nparameters: none\n\nThe info lock command outputs a list of system monitors and locked objects.");
    }
}

