/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.util;

import com.ibm.deploy.common.DeployCommonUtils;
import com.sun.deploy.cache.MemoryCache;
import com.sun.deploy.net.proxy.DynamicProxyManager;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.CertificateHostnameVerifier;
import com.sun.deploy.security.TrustDecider;
import com.sun.deploy.security.X509DeployTrustManager;
import com.sun.deploy.trace.LoggerTraceListener;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.uitoolkit.ui.ConsoleController;
import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.security.AccessController;
import java.security.Policy;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.plugin.ClassLoaderInfo;
import sun.plugin.WJcovUtil;
import sun.plugin.util.PluginSysUtil;
import sun.plugin.util.UserProfile;
import sun.security.action.GetPropertyAction;

public class PluginConsoleController
implements ConsoleController {
    private boolean onWindows = false;
    private Logger logger = null;

    public PluginConsoleController() {
        try {
            String string = AccessController.doPrivileged(new GetPropertyAction("os.name"));
            if (string.indexOf("Windows") != -1) {
                this.onWindows = true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean isIconifiedOnClose() {
        return false;
    }

    public boolean isDumpStackSupported() {
        return true;
    }

    public ThreadGroup getMainThreadGroup() {
        return PluginSysUtil.getPluginThreadGroup().getParent();
    }

    public boolean isSecurityPolicyReloadSupported() {
        return true;
    }

    public void reloadSecurityPolicy() {
        Policy policy = Policy.getPolicy();
        policy.refresh();
    }

    public boolean isProxyConfigReloadSupported() {
        return true;
    }

    public void reloadProxyConfig() {
        DynamicProxyManager.reset();
    }

    public boolean isDumpClassLoaderSupported() {
        return true;
    }

    public String dumpClassLoaders() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        ClassLoaderInfo.dumpClassLoaderCache(printWriter);
        return stringWriter.toString();
    }

    public boolean isClearClassLoaderSupported() {
        return true;
    }

    public void clearClassLoaders() {
        MemoryCache.clearLoadedResources();
        ClassLoaderInfo.clearClassLoaderCache();
        TrustDecider.reset();
        X509DeployTrustManager.reset();
        CertificateHostnameVerifier.reset();
    }

    public boolean isLoggingSupported() {
        return true;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public boolean toggleLogging() {
        Serializable serializable;
        if (this.logger == null) {
            serializable = new File(UserProfile.getLogDirectory());
            File file = Trace.createTempFile((String)"plugin", (String)".log", (File)serializable);
            LoggerTraceListener loggerTraceListener = new LoggerTraceListener("sun.plugin", file.getPath());
            this.logger = loggerTraceListener.getLogger();
        }
        serializable = (serializable = this.logger.getLevel()) == Level.OFF ? Level.ALL : Level.OFF;
        this.logger.setLevel((Level)serializable);
        return serializable == Level.ALL;
    }

    public boolean isJCovSupported() {
        boolean bl = false;
        if (this.onWindows) {
            String string = AccessController.doPrivileged(new GetPropertyAction("javaplugin.vm.options"));
            bl = string != null && string.indexOf("-Xrunjcov") != -1;
        }
        return bl;
    }

    public boolean dumpJCovData() {
        return WJcovUtil.dumpJcovData();
    }

    public String getProductName() {
        return ResourceManager.getString((String)"product.javapi.name", (String)DeployCommonUtils.getJavaVersion());
    }

    public void notifyConsoleClosed() {
    }
}

