/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.plus.provider;

import com.ibm.crypto.plus.provider.IBMJCEPlusProvider;
import com.ibm.crypto.plus.provider.icc.ICCException;
import com.ibm.crypto.plus.provider.icc.PBKDF;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.security.KeyRep;
import java.security.MessageDigest;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.PBEKey;
import javax.crypto.spec.PBEKeySpec;

final class PBKDF2KeyImpl
implements PBEKey {
    private static final long serialVersionUID = -2234868909660948157L;
    private char[] passwd;
    private final byte[] salt;
    private final int iterCount;
    private byte[] key;
    private String prfAlgo;
    private static final String[] z;

    private static byte[] a(char[] cArray) {
        Charset charset = Charset.forName(z[3]);
        CharBuffer charBuffer = CharBuffer.wrap(cArray);
        ByteBuffer byteBuffer = charset.encode(charBuffer);
        int n2 = byteBuffer.limit();
        byte[] byArray = new byte[n2];
        byteBuffer.get(byArray, 0, n2);
        return byArray;
    }

    PBKDF2KeyImpl(IBMJCEPlusProvider iBMJCEPlusProvider, PBEKeySpec pBEKeySpec, String string) throws InvalidKeySpecException, ICCException {
        char[] cArray = pBEKeySpec.getPassword();
        this.passwd = cArray == null ? new char[0] : (char[])cArray.clone();
        byte[] byArray = PBKDF2KeyImpl.a(this.passwd);
        this.salt = pBEKeySpec.getSalt();
        if (this.salt == null) {
            throw new InvalidKeySpecException(z[4]);
        }
        this.iterCount = pBEKeySpec.getIterationCount();
        if (this.iterCount == 0) {
            throw new InvalidKeySpecException(z[8]);
        }
        if (this.iterCount < 0) {
            throw new InvalidKeySpecException(z[7]);
        }
        int n2 = pBEKeySpec.getKeyLength();
        if (n2 == 0) {
            throw new InvalidKeySpecException(z[5]);
        }
        if (n2 < 0) {
            throw new InvalidKeySpecException(z[6]);
        }
        this.prfAlgo = string;
        this.key = this.a(iBMJCEPlusProvider, string, byArray, this.salt, this.iterCount, n2);
    }

    @Override
    public synchronized byte[] getEncoded() {
        return (byte[])this.key.clone();
    }

    @Override
    public String getAlgorithm() {
        return z[9] + this.prfAlgo;
    }

    @Override
    public int getIterationCount() {
        return this.iterCount;
    }

    @Override
    public synchronized char[] getPassword() {
        return (char[])this.passwd.clone();
    }

    @Override
    public byte[] getSalt() {
        return (byte[])this.salt.clone();
    }

    @Override
    public String getFormat() {
        return z[1];
    }

    public int hashCode() {
        int n2 = 0;
        for (int i2 = 1; i2 < this.key.length; ++i2) {
            n2 += this.key[i2] * i2;
        }
        return n2 ^= this.getAlgorithm().toLowerCase().hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SecretKey)) {
            return false;
        }
        SecretKey secretKey = (SecretKey)object;
        if (!secretKey.getAlgorithm().equalsIgnoreCase(this.getAlgorithm())) {
            return false;
        }
        if (!secretKey.getFormat().equalsIgnoreCase(z[2])) {
            return false;
        }
        byte[] byArray = secretKey.getEncoded();
        boolean bl = MessageDigest.isEqual(this.key, secretKey.getEncoded());
        Arrays.fill(byArray, (byte)0);
        return bl;
    }

    private Object writeReplace() throws ObjectStreamException {
        return new KeyRep(KeyRep.Type.SECRET, this.getAlgorithm(), this.getFormat(), this.getEncoded());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        throw new InvalidObjectException(z[0]);
    }

    protected void finalize() throws Throwable {
        try {
            if (this.passwd != null) {
                Arrays.fill(this.passwd, '0');
                this.passwd = null;
            }
            if (this.key != null) {
                Arrays.fill(this.key, (byte)0);
                this.key = null;
            }
        }
        finally {
            super.finalize();
        }
    }

    private byte[] a(IBMJCEPlusProvider iBMJCEPlusProvider, String string, byte[] byArray, byte[] byArray2, int n2, int n3) throws InvalidKeySpecException, ICCException {
        int n4 = n3 / 8;
        byte[] byArray3 = PBKDF.deriveKeyPBKDF2(iBMJCEPlusProvider.a(), string, byArray, byArray2, n2, n4);
        return byArray3;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[10];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "#V\u0006*YA_(\u0017V\u001ed!Nt\u0016m>N~\u0001qm\u0000p\u00074)\u0007m\u0016w9\u0002fSp(\u001dz\u0001},\u0002v\tu/\u0002z";
        int n3 = -1;
        block17: while (true) {
            char[] cArray;
            block21: {
                int n4;
                int n5;
                block20: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block20;
                    n5 = n5;
                    if (n5 <= n4) break block21;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 115;
                            break;
                        }
                        case 1: {
                            n6 = 20;
                            break;
                        }
                        case 2: {
                            n6 = 77;
                            break;
                        }
                        case 3: {
                            n6 = 110;
                            break;
                        }
                        default: {
                            n6 = 31;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "!U\u001a";
                    n3 = 0;
                    continue block17;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "!U\u001a";
                    n3 = 1;
                    continue block17;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "&@\u000bC'";
                    n3 = 2;
                    continue block17;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = " u!\u001a?\u001d{9Ny\u001ca#\n";
                    n3 = 3;
                    continue block17;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "8q4Ns\u0016z*\u001awSz\"\u001a?\u0015{8\u0000{";
                    n3 = 4;
                    continue block17;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "8q4Ns\u0016z*\u001awS}>Nq\u0016s,\u001av\u0005q";
                    n3 = 5;
                    continue block17;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = ":`(\u001c~\u0007}\"\u0000?\u0010{8\u0000kS}>Nq\u0016s,\u001av\u0005q";
                    n3 = 6;
                    continue block17;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = ":`(\u001c~\u0007}\"\u0000?\u0010{8\u0000kSz\"\u001a?\u0015{8\u0000{";
                    n3 = 7;
                    continue block17;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "#V\u0006*YAC$\u001aw";
                    n3 = 8;
                    continue block17;
                }
                case 8: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

