/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.vmControl.data;

import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TracePointEntry
implements Comparable<TracePointEntry> {
    private static final String EMPTY_STRING = "".intern();
    private static final String LEADING_ZERO_REGEX = "(?<=\\.)\\b[0]+(?=([1-9][\\d]*)|[0]\\b)";
    private static final Pattern LEADING_ZERO_TRACEPOINT_NUMBER_PATTERN = Pattern.compile("(?<=\\.)\\b[0]+(?=([1-9][\\d]*)|[0]\\b)");
    private static final String TRACE_COMPONENT_REGEX = "\\b([\\w]+)\\b";
    private static final String TRACE_IDENTIFIER_REGEX = "\\.\\b([\\d]+)\\b";
    private static final Pattern TRACE_SPECIFICATION = Pattern.compile("\\b([\\w]+)\\b(?:\\.\\b([\\d]+)\\b)?");
    private static final Comparator<String> comparator = TracePointEntry.createTracePointIdComparator();
    private String tracePointId;
    private boolean isEnabled;

    public TracePointEntry(String string, boolean bl) {
        this.tracePointId = string;
        this.isEnabled = bl;
        this.tracePointId = TracePointEntry.normalizeTracePointSpecification(string);
    }

    public String getTracePointId() {
        return this.tracePointId;
    }

    public void setEnabled(boolean bl) {
        this.isEnabled = bl;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public static String normalizeTracePointSpecification(String string) {
        Matcher matcher = LEADING_ZERO_TRACEPOINT_NUMBER_PATTERN.matcher(string);
        if (matcher.find()) {
            return matcher.replaceFirst(EMPTY_STRING);
        }
        return string;
    }

    public static boolean isValidTracePointSpecification(String string) {
        boolean bl = true;
        if (string.isEmpty()) {
            bl = false;
        } else {
            Matcher matcher = TRACE_SPECIFICATION.matcher(string);
            if (!matcher.matches()) {
                bl = false;
            }
        }
        return bl;
    }

    public String toString() {
        return this.getTracePointId();
    }

    public boolean equals(Object object) {
        if (object instanceof TracePointEntry) {
            return TracePointEntry.getTracePointIdComparator().compare(this.getTracePointId(), ((TracePointEntry)object).getTracePointId()) == 0;
        }
        return false;
    }

    public int hashCode() {
        return this.getTracePointId().hashCode();
    }

    @Override
    public int compareTo(TracePointEntry tracePointEntry) {
        return TracePointEntry.getTracePointIdComparator().compare(this.getTracePointId(), tracePointEntry.getTracePointId());
    }

    public static Comparator<String> getTracePointIdComparator() {
        return comparator;
    }

    private static Comparator<String> createTracePointIdComparator() {
        return new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                int n;
                String string3;
                int n2 = -1;
                int n3 = -1;
                String string4 = string;
                Matcher matcher = TRACE_SPECIFICATION.matcher(string4);
                if (matcher.matches()) {
                    if (matcher.groupCount() > 0) {
                        string4 = matcher.group(1);
                    }
                    if (matcher.groupCount() > 1) {
                        string3 = matcher.group(2);
                        try {
                            n2 = Integer.valueOf(string3);
                        }
                        catch (NumberFormatException numberFormatException) {
                            n2 = -1;
                        }
                    }
                }
                String string5 = string2;
                matcher.reset(string5);
                if (matcher.matches()) {
                    if (matcher.groupCount() > 0) {
                        string5 = matcher.group(1);
                    }
                    if (matcher.groupCount() > 1) {
                        string3 = matcher.group(2);
                        try {
                            n3 = Integer.valueOf(string3);
                        }
                        catch (NumberFormatException numberFormatException) {
                            n3 = -1;
                        }
                    }
                }
                if ((n = string4.compareTo(string5)) != 0) {
                    return n;
                }
                if (n2 < n3) {
                    return -1;
                }
                if (n2 == n3) {
                    return 0;
                }
                return 1;
            }
        };
    }
}

