/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.impl.marshalling.source;

import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.ProviderModificationException;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.HealthCenterClientConnectedException;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.HealthCenterMBean;
import com.ibm.java.diagnostics.healthcenter.connection.ConnectionDataBuilder;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.source.JmxSourceImpl;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.source.SourceImpl;
import com.ibm.java.diagnostics.healthcenter.marshalling.util.Messages;
import com.ibm.java.diagnostics.healthcenter.sources.ConfigurableSource;
import com.ibm.java.diagnostics.healthcenter.sources.SourceListener;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.UndeclaredThrowableException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class JmxEnablementConfigurationSourceImpl
extends SourceImpl
implements ConfigurableSource {
    private static final String CONFIGURATION = "Configuration";
    private static final Logger TRACE = LogFactory.getTrace(JmxEnablementConfigurationSourceImpl.class);
    private static final String STATE_INFO_SPLITTING_STRING = "[,\n]";
    private static final String ON_SUFFIX = "=on";
    private final int sourceIndex;
    private final HealthCenterMBean proxy;
    private String configuration;
    private JmxSourceImpl jmxSourceImpl;
    private static final String COMMA = ",";
    private volatile boolean isShutdown = false;
    private int sessionId;

    public JmxEnablementConfigurationSourceImpl(HealthCenterMBean healthCenterMBean, int n, ConnectionDataBuilder connectionDataBuilder, int n2, JmxSourceImpl jmxSourceImpl, Map<String, String> map) {
        super(map.get("name") + CONFIGURATION, connectionDataBuilder);
        this.proxy = healthCenterMBean;
        this.sourceIndex = n;
        this.sessionId = n2;
        this.jmxSourceImpl = jmxSourceImpl;
        this.configuration = map.get("state");
        this.updateIterators();
    }

    @Override
    public InputStream getBackingStream() {
        if (this.configuration != null) {
            String string = Messages.getString("JmxSourceImpl.configuration.comment.template");
            String string2 = MessageFormat.format(string, "#Configuration saved by", this.getName());
            String string3 = string2 + "\n" + this.configuration;
            try {
                return new ByteArrayInputStream(string3.getBytes("UTF8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                TRACE.fine(unsupportedEncodingException.toString());
                return new ByteArrayInputStream(string3.getBytes());
            }
        }
        return null;
    }

    public void refresh() {
        this.configuration = this.proxy.getLiveSourceDetails().get(this.sourceIndex).get("state");
        this.updateIterators();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateIterators() {
        Object object = this.listenerListLock;
        synchronized (object) {
            for (SourceListener sourceListener : this.sourceListeners) {
                InputStream inputStream = this.getBackingStream();
                if (inputStream == null) continue;
                sourceListener.notifySourceChanged(inputStream);
            }
        }
        if (this.jmxSourceImpl.getUpdateIntervalTime() != 0L) {
            this.jmxSourceImpl.triggerImmediateRefresh();
        }
    }

    @Override
    protected void tellNewSlicerAboutExistingData(SourceListener sourceListener) {
        InputStream inputStream = this.getBackingStream();
        if (inputStream != null) {
            sourceListener.notifySourceChanged(inputStream);
        }
    }

    @Override
    public void disable(String string) {
        this.modify("off", string);
    }

    @Override
    public void disable(Collection<String> collection) {
        this.modify("off", collection.toArray(new String[0]));
    }

    public void modify(String string, String ... stringArray) {
        final String string2 = string;
        final String[] stringArray2 = stringArray;
        Thread thread = new Thread(string){

            @Override
            public void run() {
                try {
                    if (!JmxEnablementConfigurationSourceImpl.this.isShutdown) {
                        JmxEnablementConfigurationSourceImpl.this.proxy.modify(JmxEnablementConfigurationSourceImpl.this.sourceIndex, JmxEnablementConfigurationSourceImpl.this.sessionId, string2, stringArray2);
                        JmxEnablementConfigurationSourceImpl.this.refresh();
                    }
                }
                catch (HealthCenterClientConnectedException healthCenterClientConnectedException) {
                    JmxEnablementConfigurationSourceImpl.this.handleHealthCenterConnectionException(healthCenterClientConnectedException);
                }
                catch (ProviderModificationException providerModificationException) {
                    StringBuffer stringBuffer = new StringBuffer();
                    for (String string : stringArray2) {
                        stringBuffer.append(string + JmxEnablementConfigurationSourceImpl.COMMA);
                    }
                    TRACE.warning(MessageFormat.format(Messages.getString("JMXSourceAdapter.modification.exception"), string2, stringBuffer.toString()));
                }
                catch (UndeclaredThrowableException undeclaredThrowableException) {
                    StringBuffer stringBuffer = new StringBuffer();
                    for (String string : stringArray2) {
                        stringBuffer.append(string + JmxEnablementConfigurationSourceImpl.COMMA);
                    }
                    TRACE.warning(MessageFormat.format(Messages.getString("JMXSourceAdapter.modification.exception"), string2, stringBuffer.toString()));
                }
                catch (Throwable throwable) {
                    StringBuffer stringBuffer = new StringBuffer();
                    for (String string : stringArray2) {
                        stringBuffer.append(string + JmxEnablementConfigurationSourceImpl.COMMA);
                    }
                    TRACE.warning(MessageFormat.format(Messages.getString("JMXSourceAdapter.modification.exception"), string2, stringBuffer.toString()));
                }
            }
        };
        thread.start();
    }

    @Override
    public void enable(String string) {
        this.modify("on", string);
    }

    @Override
    public void enable(Collection<String> collection) {
        this.modify("on", collection.toArray(new String[0]));
    }

    @Override
    public boolean isEnabled(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        Boolean bl = this.isEnabled(arrayList).get(string);
        return bl;
    }

    @Override
    public Map<String, Boolean> isEnabled(Collection<String> collection) {
        boolean bl = true;
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        List<String> list = null;
        String string = this.configuration;
        if (string != null) {
            list = Arrays.asList(string.split(STATE_INFO_SPLITTING_STRING));
        } else {
            bl = false;
        }
        for (String string2 : collection) {
            boolean bl2;
            boolean bl3 = bl2 = list != null && (list.contains(string2 + ON_SUFFIX) || list.contains(string2));
            if (!bl || bl2) {
                hashMap.put(string2, true);
                continue;
            }
            hashMap.put(string2, false);
        }
        return hashMap;
    }

    @Override
    public void disable() {
    }

    @Override
    public void enable() {
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public boolean isSupported() {
        return this.configuration != null;
    }

    private void handleHealthCenterConnectionException(HealthCenterClientConnectedException healthCenterClientConnectedException) {
        String string = Messages.getString("JmxSourceAdapter.another.client.connected");
        this.tellConnectionAboutError(string, string, healthCenterClientConnectedException);
        this.shutdown();
    }
}

