/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.common.datamodel.impl.properties;

import com.ibm.java.diagnostics.common.datamodel.data.Data;
import com.ibm.java.diagnostics.common.datamodel.data.DataPoint;
import com.ibm.java.diagnostics.common.datamodel.data.axes.DataAxis;
import com.ibm.java.diagnostics.common.datamodel.data.axes.XAxis;
import com.ibm.java.diagnostics.common.datamodel.data.axes.XDataAxis;
import com.ibm.java.diagnostics.common.datamodel.data.axes.YAxis;
import com.ibm.java.diagnostics.common.datamodel.data.axes.YDataAxis;
import com.ibm.java.diagnostics.common.datamodel.impl.axes.DataAxisImpl;
import com.ibm.java.diagnostics.common.datamodel.properties.OutputProperties;
import com.ibm.java.diagnostics.common.datamodel.properties.OutputPropertiesChangedEvent;
import com.ibm.java.diagnostics.common.datamodel.properties.OutputPropertiesListener;
import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import com.ibm.java.diagnostics.common.util.weak.WeakHashSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OutputPropertiesImpl
implements OutputProperties {
    private static final String CONSTRUCTOR = "constructor";
    private static final Logger TRACE = LogFactory.getTrace(OutputProperties.class);
    private final String CLASSNAME = this.getClass().getName();
    private final Map<String, Object> displayerProperties;
    private final Map<String, DataPoint> minimumX;
    private final Map<String, DataPoint> maximumX;
    private final Map<String, DataPoint> minimumY;
    private final Map<String, DataPoint> maximumY;
    private final Map<String, Set<DataAxisImpl>> xboundsListeners;
    private final Map<String, Set<DataAxisImpl>> yboundsListeners;
    private boolean notificationsEnabled = true;
    private final Set<OutputPropertiesListener> listeners;
    private double rawOffset = Double.MAX_VALUE;
    private final Object listenerLock = new Object();
    private Hashtable<String, YAxis> yAxisCache;
    private XAxis xAxis;
    private XDataAxis xDataAxis;
    private Hashtable<String, YDataAxis> yDataAxisCache;
    private TimeZone zone;

    public OutputPropertiesImpl(Data data) {
        TRACE.entering(this.CLASSNAME, CONSTRUCTOR);
        this.displayerProperties = new HashMap<String, Object>();
        this.listeners = new WeakHashSet<OutputPropertiesListener>();
        this.xboundsListeners = new WeakHashMap<String, Set<DataAxisImpl>>();
        this.yboundsListeners = new WeakHashMap<String, Set<DataAxisImpl>>();
        this.minimumX = new TreeMap<String, DataPoint>();
        this.maximumX = new TreeMap<String, DataPoint>();
        this.minimumY = new TreeMap<String, DataPoint>();
        this.maximumY = new TreeMap<String, DataPoint>();
        this.yAxisCache = new Hashtable();
        this.yDataAxisCache = new Hashtable();
        this.xAxis = null;
        TRACE.exiting(this.CLASSNAME, CONSTRUCTOR);
    }

    public Object getDisplayerProperties(String string) {
        return this.displayerProperties.get(string);
    }

    public void setDisplayerProperties(String string, Object object) {
        this.displayerProperties.put(string, object);
    }

    @Override
    public void setMinimumX(String string, DataPoint dataPoint) {
        this.minimumX.put(string, dataPoint);
        this.notifyXBoundsListeners(string);
        this.notifyListeners(new OutputPropertiesChangedEvent(true));
    }

    @Override
    public void setMaximumX(String string, DataPoint dataPoint) {
        this.maximumX.put(string, dataPoint);
        this.notifyXBoundsListeners(string);
        this.notifyListeners(new OutputPropertiesChangedEvent(true));
    }

    @Override
    public void setMinimumY(String string, DataPoint dataPoint) {
        this.minimumY.put(string, dataPoint);
        this.notifyYBoundsListeners(string);
        this.notifyListeners(new OutputPropertiesChangedEvent(true));
    }

    @Override
    public void setMaximumY(String string, DataPoint dataPoint) {
        this.maximumY.put(string, dataPoint);
        this.notifyYBoundsListeners(string);
        this.notifyListeners(new OutputPropertiesChangedEvent(true));
    }

    @Override
    public DataPoint getMinimumX(String string) {
        DataPoint dataPoint = this.minimumX.get(string);
        return dataPoint;
    }

    @Override
    public DataPoint getMaximumX(String string) {
        DataPoint dataPoint = this.maximumX.get(string);
        return dataPoint;
    }

    @Override
    public DataPoint getMinimumY(String string) {
        DataPoint dataPoint = this.minimumY.get(string);
        return dataPoint;
    }

    @Override
    public DataPoint getMaximumY(String string) {
        DataPoint dataPoint = this.maximumY.get(string);
        return dataPoint;
    }

    @Override
    public void clearMaximumX() {
        this.maximumX.clear();
        this.notifyListeners(new OutputPropertiesChangedEvent(true));
    }

    private void notifyAllXBoundsListeners() {
        for (String string : this.xboundsListeners.keySet()) {
            this.notifyXBoundsListeners(string);
        }
    }

    @Override
    public void clearMaximumY() {
        this.maximumY.clear();
        this.notifyListeners(new OutputPropertiesChangedEvent(true));
    }

    @Override
    public void clearMinimumX() {
        this.minimumX.clear();
        this.notifyListeners(new OutputPropertiesChangedEvent(true));
    }

    @Override
    public void clearMinimumY() {
        this.minimumY.clear();
        this.notifyListeners(new OutputPropertiesChangedEvent(true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyAllYBoundsListeners() {
        Object object = this.listenerLock;
        synchronized (object) {
            for (String string : this.yboundsListeners.keySet()) {
                this.notifyYBoundsListeners(string);
            }
        }
    }

    public void addListener(OutputPropertiesListener outputPropertiesListener) {
        this.listeners.add(outputPropertiesListener);
    }

    public void removeListener(OutputPropertiesListener outputPropertiesListener) {
        this.listeners.remove(outputPropertiesListener);
    }

    @Override
    public void disableNotifications() {
        this.notificationsEnabled = false;
    }

    @Override
    public void enableNotifications() {
        this.notificationsEnabled = true;
    }

    @Override
    public void notifyListeners(boolean bl) {
        this.notifyListeners(new OutputPropertiesChangedEvent(bl));
    }

    public void notifyListeners(OutputPropertiesChangedEvent outputPropertiesChangedEvent) {
        if (this.notificationsEnabled) {
            this.notifyAllXBoundsListeners();
            this.notifyAllYBoundsListeners();
            for (OutputPropertiesListener outputPropertiesListener : this.listeners) {
                if (TRACE.isLoggable(Level.FINE)) {
                    TRACE.fine("Notifying " + outputPropertiesListener);
                }
                outputPropertiesListener.outputPropertiesChanged(outputPropertiesChangedEvent);
            }
        }
    }

    @Override
    public void registerXAxisListener(XDataAxis xDataAxis) {
        this.registerAxis(xDataAxis, this.xboundsListeners);
    }

    @Override
    public void registerYAxisListener(YDataAxis yDataAxis) {
        this.registerAxis(yDataAxis, this.yboundsListeners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerAxis(DataAxis dataAxis, Map<String, Set<DataAxisImpl>> map) {
        Object object = this.listenerLock;
        synchronized (object) {
            String string = dataAxis.getBaseUnitName();
            Set<DataAxisImpl> set = map.get(string);
            if (set == null) {
                set = new HashSet<DataAxisImpl>();
                map.put(string, set);
            }
            set.add((DataAxisImpl)dataAxis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyXBoundsListeners(String string) {
        if (this.notificationsEnabled) {
            Object object = this.listenerLock;
            synchronized (object) {
                Set<DataAxisImpl> set = this.xboundsListeners.get(string);
                if (set != null) {
                    for (DataAxisImpl dataAxisImpl : set) {
                        dataAxisImpl.updateBounds();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyYBoundsListeners(String string) {
        if (this.notificationsEnabled) {
            Object object = this.listenerLock;
            synchronized (object) {
                Set<DataAxisImpl> set = this.yboundsListeners.get(string);
                if (set != null) {
                    for (DataAxisImpl dataAxisImpl : set) {
                        dataAxisImpl.updateBounds();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearListenerCaches() {
        Object object = this.listenerLock;
        synchronized (object) {
            this.xboundsListeners.clear();
            this.yboundsListeners.clear();
        }
    }

    @Override
    public double getRawXOffset() {
        return this.rawOffset;
    }

    @Override
    public void setRawXOffset(double d) {
        this.rawOffset = d;
    }

    @Override
    public XAxis getXAxis() {
        return this.xAxis;
    }

    @Override
    public XDataAxis getXDataAxis() {
        return this.xDataAxis;
    }

    @Override
    public void setXDataAxis(XDataAxis xDataAxis) {
        this.xDataAxis = xDataAxis;
    }

    @Override
    public YAxis getYAxis(String string) {
        return this.yAxisCache.get(string);
    }

    @Override
    public void setXAxis(XAxis xAxis) {
        this.xAxis = xAxis;
    }

    @Override
    public void setYAxis(String string, YAxis yAxis) {
        this.yAxisCache.put(string, yAxis);
    }

    @Override
    public YDataAxis getYDataAxis(String string) {
        return this.yDataAxisCache.get(string);
    }

    @Override
    public void setYDataAxis(String string, YDataAxis yDataAxis) {
        this.yDataAxisCache.put(string, yDataAxis);
    }

    @Override
    public void removeAllListeners() {
        this.listeners.clear();
    }

    @Override
    public TimeZone getTimeZone() {
        return this.zone;
    }

    @Override
    public void setTimeZone(TimeZone timeZone) {
        this.zone = timeZone;
    }
}

