/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container.activator;

import com.ibm.ejs.container.BeanId;
import com.ibm.ejs.container.BeanMetaData;
import com.ibm.ejs.container.BeanNotReentrantException;
import com.ibm.ejs.container.BeanO;
import com.ibm.ejs.container.ContainerException;
import com.ibm.ejs.container.ContainerTx;
import com.ibm.ejs.container.EJBThreadData;
import com.ibm.ejs.container.EJSDeployedSupport;
import com.ibm.ejs.container.SessionBeanTimeoutException;
import com.ibm.ejs.container.StatefulBeanO;
import com.ibm.ejs.container.StatefulBeanReaper;
import com.ibm.ejs.container.TimeoutElement;
import com.ibm.ejs.container.activator.ActivationStrategy;
import com.ibm.ejs.container.activator.Activator;
import com.ibm.ejs.container.activator.MainKey;
import com.ibm.ejs.container.passivator.StatefulPassivator;
import com.ibm.ejs.container.util.EJSPlatformHelper;
import com.ibm.websphere.csi.CacheElement;
import com.ibm.websphere.csi.IllegalOperationException;
import com.ibm.websphere.csi.PassivationPolicy;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ejbcontainer.failover.SfFailoverCache;
import com.ibm.ws.ejbcontainer.failover.SfFailoverClient;
import com.ibm.ws.ffdc.FFDCFilter;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.util.concurrent.TimeUnit;
import javax.transaction.TransactionRolledbackException;

public abstract class StatefulSessionActivationStrategy
extends ActivationStrategy {
    protected PassivationPolicy passivationPolicy;
    protected StatefulBeanReaper reaper;
    public StatefulPassivator ivPassivator;
    public SfFailoverCache ivSfFailoverCache;
    private static final TraceComponent tc = Tr.register(StatefulSessionActivationStrategy.class, (String)"EJBContainer", (String)"com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.container.activator.StatefulSessionActivationStrategy";

    StatefulSessionActivationStrategy(Activator activator, PassivationPolicy passivationPolicy) {
        this(activator, passivationPolicy, null);
    }

    StatefulSessionActivationStrategy(Activator activator, PassivationPolicy passivationPolicy, SfFailoverCache failoverCache) {
        super(activator);
        this.passivationPolicy = passivationPolicy;
        this.reaper = activator.statefulBeanReaper;
        this.ivPassivator = activator.passivator;
        this.ivSfFailoverCache = failoverCache;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("<init> : " + this + ", " + passivationPolicy + ", " + this.reaper + ", " + this.ivPassivator + ", " + failoverCache), (Object[])new Object[0]);
        }
    }

    private void cacheInsert(MainKey key, StatefulBeanO sfbean) {
        CacheElement cacheElement;
        sfbean.ivCacheElement = cacheElement = this.cache.insert(key, sfbean);
        sfbean.ivCacheKey = key;
        if (!sfbean.getHome().getBeanMetaData().isPassivationCapable()) {
            this.cache.markElementEvictionIneligible(cacheElement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    BeanO atCreate(ContainerTx tx, BeanO bean) throws RemoteException {
        Object object;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"atCreate", (Object[])new Object[0]);
        }
        StatefulBeanO sfbean = (StatefulBeanO)bean;
        BeanId id = bean.getId();
        MainKey key = new MainKey(id);
        boolean success = false;
        sfbean.ivCacheLock = this.locks.getLock(key);
        try {
            object = sfbean.ivCacheLock;
            synchronized (object) {
                this.cacheInsert(key, sfbean);
                this.reaper.add(sfbean);
                if (sfbean.sfsbFailoverEnabled()) {
                    sfbean.createFailoverEntry();
                }
            }
            if (!bean.enlist(tx)) {
                this.cache.unpinElement(sfbean.ivCacheElement);
            }
            success = true;
        }
        finally {
            if (!success) {
                bean.destroy();
                object = sfbean.ivCacheLock;
                synchronized (object) {
                    this.cache.removeElement(sfbean.ivCacheElement, true);
                    sfbean.ivCacheElement = null;
                    sfbean.ivCacheKey = null;
                    this.reaper.remove(id);
                    if (sfbean.sfsbFailoverEnabled()) {
                        sfbean.ivSfFailoverClient.removeEntry(id);
                    }
                }
                if (isTraceOn && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"atCreate: exception");
                }
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"atCreate");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void atCommit(ContainerTx tx, BeanO bean) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"atCommit", (Object[])new Object[]{tx, bean});
        }
        StatefulBeanO sfbean = (StatefulBeanO)bean;
        Object object = sfbean.ivCacheLock;
        synchronized (object) {
            if (bean.isRemoved()) {
                this.cache.removeElement(sfbean.ivCacheElement, true);
                bean.ivCacheKey = null;
                bean.destroy();
            } else {
                this.cache.unpinElement(sfbean.ivCacheElement);
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"atCommit");
        }
    }

    @Override
    void atEnlist(ContainerTx tx, BeanO bean) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"atEnlist", (Object[])new Object[]{tx, bean});
        }
        StatefulBeanO sfbean = (StatefulBeanO)bean;
        this.cache.pinElement(sfbean.ivCacheElement);
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"atEnlist");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    BeanO atActivate(EJBThreadData threadData, ContainerTx tx, BeanId beanId) throws RemoteException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("atActivate (" + beanId + ") : " + tx), (Object[])new Object[0]);
        }
        Exception exception = null;
        MainKey key = new MainKey(beanId);
        TimeoutElement elt = null;
        boolean found = false;
        boolean locked = false;
        boolean pushedCallbackBeanO = false;
        EJSDeployedSupport methodContext = threadData.getMethodContext();
        StatefulBeanO bean = methodContext.getCachedWrapperBeanO();
        Object lock = bean != null ? bean.ivCacheLock : this.locks.getLock(key);
        long accessTimeoutMillis = Long.MIN_VALUE;
        boolean accessTimeoutReached = false;
        long waitTime = 0L;
        long endTime = 0L;
        Object object = lock;
        synchronized (object) {
            block53: {
                try {
                    if (bean == null || bean.ivCacheKey == null) {
                        bean = (StatefulBeanO)this.cache.find(key);
                    } else {
                        this.cache.pinElement(bean.ivCacheElement);
                    }
                    while (true) {
                        boolean bl = found = bean != null;
                        if (!found) {
                            boolean timedOut;
                            if (isTraceOn && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Bean not in cache", (Object[])new Object[0]);
                            }
                            elt = this.reaper.getTimeoutElement(beanId);
                            if (EJSPlatformHelper.isZOS()) {
                                timedOut = this.reaper.beanExistsAndTimedOut(elt, beanId) || this.passivationPolicy.equals(PassivationPolicy.ON_DEMAND);
                            } else {
                                boolean bl2 = timedOut = this.reaper.beanDoesNotExistOrHasTimedOut(elt, beanId) || this.passivationPolicy.equals(PassivationPolicy.ON_DEMAND);
                            }
                            if (timedOut) {
                                if (this.reaper.beanExistsAndTimedOut(elt, beanId)) {
                                    if (!isTraceOn) throw new SessionBeanTimeoutException("Stateful bean " + beanId + " timed out.");
                                    if (!tc.isDebugEnabled()) throw new SessionBeanTimeoutException("Stateful bean " + beanId + " timed out.");
                                    Tr.debug((TraceComponent)tc, (String)("Bean " + beanId + " in passivated filesystem or SfFailoverCache,  but timed out."), (Object[])new Object[0]);
                                    throw new SessionBeanTimeoutException("Stateful bean " + beanId + " timed out.");
                                }
                                if (!isTraceOn) throw new NoSuchObjectException("Stateful bean " + beanId + " was removed or timed out.");
                                if (!tc.isDebugEnabled()) throw new NoSuchObjectException("Stateful bean " + beanId + " was removed or timed out.");
                                Tr.debug((TraceComponent)tc, (String)("Bean " + beanId + " not in the passivated filesystem either."), (Object[])new Object[0]);
                                throw new NoSuchObjectException("Stateful bean " + beanId + " was removed or timed out.");
                            }
                            bean = (StatefulBeanO)beanId.getHome().createBeanO(threadData, tx, beanId);
                            pushedCallbackBeanO = true;
                            bean.ivCacheLock = lock;
                            this.cacheInsert(key, bean);
                            found = true;
                            bean.initializeTimeout(elt);
                            bean.activate(beanId, tx);
                            if (elt == null) {
                                this.reaper.add(bean);
                            }
                            if (bean.sfsbFailoverEnabled()) {
                                bean.updateFailoverSetActiveProp();
                            }
                            bean.lock(methodContext, tx);
                            locked = true;
                            break;
                        }
                        locked = bean.lock(methodContext, tx);
                        tx = methodContext.getCurrentTx();
                        if (locked) {
                            if (isTraceOn && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Found bean - locked, attempting to use", (Object[])new Object[0]);
                            }
                            threadData.pushCallbackBeanO(bean);
                            pushedCallbackBeanO = true;
                            break;
                        }
                        if (accessTimeoutMillis == Long.MIN_VALUE) {
                            accessTimeoutMillis = methodContext.getConcurrencyAccessTimeout();
                            boolean bl3 = accessTimeoutReached = accessTimeoutMillis == 0L;
                        }
                        if (accessTimeoutReached) {
                            bean = null;
                            this.cache.unpin(key);
                            String msg = "Stateful bean in use on another thread; access-timeout reached (" + accessTimeoutMillis + " ms)";
                            if (!isTraceOn) throw new BeanNotReentrantException(msg, true);
                            if (!tc.isDebugEnabled()) throw new BeanNotReentrantException(msg, true);
                            Tr.debug((TraceComponent)tc, (String)msg, (Object[])new Object[0]);
                            throw new BeanNotReentrantException(msg, true);
                        }
                        bean.addLockWaiter();
                        bean = null;
                        this.cache.unpin(key);
                        if (accessTimeoutMillis > 0L && waitTime == 0L) {
                            waitTime = TimeUnit.MILLISECONDS.toNanos(accessTimeoutMillis);
                            endTime = System.nanoTime() + waitTime;
                        }
                        if (isTraceOn && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Found bean - in use, waiting : " + waitTime + " ns, lock = " + lock), (Object[])new Object[0]);
                        }
                        if (waitTime == 0L) {
                            lock.wait();
                        } else {
                            TimeUnit.NANOSECONDS.timedWait(lock, waitTime);
                        }
                        if (accessTimeoutMillis > 0L && (waitTime = endTime - System.nanoTime()) <= 0L) {
                            if (isTraceOn && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"AccessTimeout reached", (Object[])new Object[0]);
                            }
                            accessTimeoutReached = true;
                        }
                        bean = (StatefulBeanO)this.cache.find(key);
                    }
                    if (bean.isTimedOut()) {
                        throw new SessionBeanTimeoutException("Stateful bean " + bean + " timed out");
                    }
                    if (bean.enlist(tx, methodContext.isTxEnlistNeededForActivate())) {
                        this.cache.pinElement(bean.ivCacheElement);
                    }
                    if (exception == null || !isTraceOn) break block53;
                }
                catch (InterruptedException iex) {
                    try {
                        FFDCFilter.processException((Throwable)iex, (String)"com.ibm.ejs.container.activator.StatefulSessionActivationStrategy.atActivate", (String)"384", (Object)this);
                        exception = iex;
                        throw new ContainerException(iex);
                        catch (NoSuchObjectException e) {
                            exception = e;
                            throw e;
                        }
                        catch (RemoteException e) {
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.container.activator.StatefulSessionActivationStrategy.atActivate", (String)"169", (Object)this);
                            exception = e;
                            throw e;
                        }
                        catch (RuntimeException e) {
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.container.activator.StatefulSessionActivationStrategy.atActivate", (String)"175", (Object)this);
                            exception = e;
                            throw e;
                        }
                    }
                    catch (Throwable throwable) {
                        if (exception != null && isTraceOn && tc.isEventEnabled()) {
                            Tr.event((TraceComponent)tc, (String)"atActivation: exception raised", (Object[])new Object[]{exception});
                        }
                        if (exception == null) throw throwable;
                        if (bean == null) throw throwable;
                        if (pushedCallbackBeanO) {
                            threadData.popCallbackBeanO();
                        }
                        if (!found) {
                            bean.destroy();
                            throw throwable;
                        }
                        try {
                            this.cache.remove(key, true);
                            bean.ivCacheKey = null;
                            this.reaper.remove(beanId);
                            bean.destroy();
                            throw throwable;
                        }
                        catch (IllegalOperationException ex) {
                            this.cache.unpin(key);
                            throw throwable;
                        }
                        finally {
                            if (locked) {
                                bean.unlock(lock);
                            }
                        }
                    }
                }
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"atActivation: exception raised", (Object[])new Object[]{exception});
                }
            }
            if (exception != null && bean != null) {
                if (pushedCallbackBeanO) {
                    threadData.popCallbackBeanO();
                }
                if (found) {
                    try {
                        this.cache.remove(key, true);
                        bean.ivCacheKey = null;
                        this.reaper.remove(beanId);
                        bean.destroy();
                    }
                    catch (IllegalOperationException ex) {
                        this.cache.unpin(key);
                    }
                    finally {
                        if (locked) {
                            bean.unlock(lock);
                        }
                    }
                } else {
                    bean.destroy();
                }
            }
        }
        if (!isTraceOn) return bean;
        if (!tc.isEntryEnabled()) return bean;
        Tr.exit((TraceComponent)tc, (String)("atActivate : " + bean));
        return bean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void atPostInvoke(ContainerTx tx, BeanO bean) {
        Object lock;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("atPostInvoke : " + tx + ", " + bean), (Object[])new Object[0]);
        }
        StatefulBeanO sfbean = (StatefulBeanO)bean;
        BeanId id = bean.getId();
        Object object = lock = sfbean.ivCacheLock;
        synchronized (object) {
            if (sfbean.ivCacheKey != null) {
                this.cache.unpinElement(sfbean.ivCacheElement);
                if (sfbean.isRemoved() || sfbean.isDiscarded()) {
                    block11: {
                        if (tx != null) {
                            try {
                                tx.delist(sfbean);
                            }
                            catch (TransactionRolledbackException ex) {
                                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.container.activator.StatefulSessionActivationStrategy.atPostInvoke", (String)"261", (Object)this);
                                if (!isTraceOn || !tc.isDebugEnabled()) break block11;
                                Tr.debug((TraceComponent)tc, (String)"atPostInvoke : transaction has rolledback", (Object[])new Object[0]);
                            }
                        }
                    }
                    this.cache.removeElement(sfbean.ivCacheElement, true);
                    sfbean.destroy();
                    sfbean.ivCacheKey = null;
                    this.reaper.remove(id);
                } else {
                    sfbean.setLastAccessTime(System.currentTimeMillis());
                }
                sfbean.unlock(lock);
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"atPostInvoke");
        }
    }

    @Override
    void atDiscard(BeanO bean) throws RemoteException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("atDiscard : " + bean), (Object[])new Object[0]);
        }
        try {
            BeanId beanId = ((StatefulBeanO)bean).getId();
            StatefulBeanO statefulBeanO = (StatefulBeanO)bean;
            bean.ivCacheKey = null;
            if (!statefulBeanO.isTimedOut()) {
                bean.passivate();
            } else {
                if (isTraceOn && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Discarding session bean : " + bean), (Object[])new Object[0]);
                }
                this.reaper.remove(beanId);
                statefulBeanO.destroy();
            }
        }
        catch (RemoteException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.container.activator.StatefulSessionActivationStrategy.atDiscard", (String)"368", (Object)this);
            Tr.warning((TraceComponent)tc, (String)"UNABLE_TO_PASSIVATE_EJB_CNTR0005W", (Object[])new Object[]{bean, this, e});
            throw e;
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"atDiscard");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void atRemove(ContainerTx tx, BeanO bean) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"atRemove", (Object[])new Object[]{tx, bean});
        }
        StatefulBeanO sfbean = (StatefulBeanO)bean;
        Object object = sfbean.ivCacheLock;
        synchronized (object) {
            this.cache.removeElement(sfbean.ivCacheElement, true);
            bean.ivCacheKey = null;
        }
        this.reaper.remove(bean.getId());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"atRemove");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    void atTimeout(BeanId beanId) throws RemoteException {
        boolean isTraceOn;
        block23: {
            isTraceOn = TraceComponent.isAnyTracingEnabled();
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)("atTimeout " + beanId), (Object[])new Object[0]);
            }
            BeanO bean = null;
            Exception exception = null;
            MainKey key = new MainKey(beanId);
            try {
                Object object = this.locks.getLock(key);
                synchronized (object) {
                    block22: {
                        block24: {
                            bean = (BeanO)this.cache.findDontPinNAdjustPinCount(key, 0);
                            if (bean != null) break block24;
                            TimeoutElement elt = this.reaper.getTimeoutElement(beanId);
                            if (this.reaper.beanExistsAndTimedOut(elt, beanId)) {
                                if (isTraceOn && tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"Bean not in cache: removing file", (Object[])new Object[0]);
                                }
                                this.ivPassivator.remove(beanId, true);
                                this.reaper.remove(beanId);
                                BeanMetaData bmd = beanId.getBeanMetaData();
                                SfFailoverClient failover = bmd.getSfFailoverClient();
                                if (failover != null) {
                                    failover.removeEntry(beanId);
                                }
                                break block22;
                            } else if (isTraceOn && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Bean not in cache: already removed", (Object[])new Object[0]);
                            }
                            break block22;
                        }
                        StatefulBeanO sfbean = (StatefulBeanO)bean;
                        if (sfbean.isTimedOut()) {
                            if (isTraceOn && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Found bean in cache: passivating / removing", (Object[])new Object[0]);
                            }
                            try {
                                bean = (BeanO)this.cache.remove(key, false);
                                bean.ivCacheKey = null;
                                this.reaper.remove(beanId);
                                BeanMetaData bmd = beanId.getBeanMetaData();
                                SfFailoverClient failover = bmd.getSfFailoverClient();
                                if (failover != null) {
                                    failover.removeEntry(beanId);
                                }
                                ((StatefulBeanO)bean).uninstall();
                            }
                            catch (IllegalOperationException ioe) {
                                if (isTraceOn && tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"Found bean in cache: active", (Object[])new Object[0]);
                                }
                                break block22;
                            }
                        }
                        if (isTraceOn && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Found bean in cache: no longer timed out", (Object[])new Object[0]);
                        }
                    }
                    if (exception == null || !isTraceOn) break block23;
                }
            }
            catch (RemoteException e) {
                try {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.container.activator.StatefulSessionActivationStrategy.atTimeout", (String)"474", (Object)this);
                    exception = e;
                    throw e;
                    catch (RuntimeException e2) {
                        FFDCFilter.processException((Throwable)e2, (String)"com.ibm.ejs.container.activator.StatefulSessionActivationStrategy.atTimeout", (String)"480", (Object)this);
                        exception = e2;
                        throw e2;
                    }
                }
                catch (Throwable throwable) {
                    if (exception != null && isTraceOn && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"atTimeout: exception raised", (Object[])new Object[]{exception});
                    }
                    if (!isTraceOn) throw throwable;
                    if (!tc.isEntryEnabled()) throw throwable;
                    Tr.exit((TraceComponent)tc, (String)"atTimeout");
                    throw throwable;
                }
            }
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"atTimeout: exception raised", (Object[])new Object[]{exception});
            }
        }
        if (!isTraceOn) return;
        if (!tc.isEntryEnabled()) return;
        Tr.exit((TraceComponent)tc, (String)"atTimeout");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void atPassivate(BeanId beanId) throws RemoteException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("atPassivate " + beanId), (Object[])new Object[0]);
        }
        BeanO bean = null;
        MainKey key = new MainKey(beanId);
        try {
            Object object = this.locks.getLock(key);
            synchronized (object) {
                bean = (BeanO)this.cache.findDontPinNAdjustPinCount(key, 0);
                if (bean != null) {
                    bean.passivate();
                    this.cache.remove(key, false);
                    bean.ivCacheKey = null;
                    if (EJSPlatformHelper.isZOS() || this.passivationPolicy.equals(PassivationPolicy.ON_DEMAND)) {
                        this.reaper.remove(beanId);
                    }
                }
            }
        }
        catch (RemoteException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.container.activator.StatefulSessionActivationStrategy.atPassivate", (String)"525", (Object)this);
            Tr.warning((TraceComponent)tc, (String)"UNABLE_TO_PASSIVATE_EJB_CNTR0005W", (Object[])new Object[]{bean, this, ex});
            throw ex;
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"atPassivate");
        }
    }

    @Override
    BeanO atGet(ContainerTx tx, BeanId id) {
        throw new IllegalStateException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void atUninstall(BeanId beanId, BeanO bean) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("atUninstall (" + beanId + ")"), (Object[])new Object[0]);
        }
        MainKey key = new MainKey(beanId);
        Object object = this.locks.getLock(key);
        synchronized (object) {
            bean = (BeanO)this.cache.find(key);
            if (bean != null) {
                if (isTraceOn && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Found bean in cache: uninstalling", (Object[])new Object[0]);
                }
                try {
                    this.cache.remove(key, true);
                    bean.ivCacheKey = null;
                    this.reaper.remove(beanId);
                    ((StatefulBeanO)bean).uninstall();
                }
                catch (IllegalOperationException ioe) {
                    FFDCFilter.processException((Throwable)ioe, (String)"com.ibm.ejs.container.activator.StatefulSessionActivationStrategy.atUninstall", (String)"590", (Object)this);
                    if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Found bean in cache: active!", (Object[])new Object[0]);
                    }
                    this.cache.unpin(key);
                }
            } else {
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Bean not in cache: removing file", (Object[])new Object[0]);
                }
                try {
                    if (this.reaper.remove(beanId)) {
                        this.ivPassivator.remove(beanId, false);
                    }
                }
                catch (RemoteException rex) {
                    FFDCFilter.processException((Throwable)rex, (String)"com.ibm.ejs.container.activator.StatefulSessionActivationStrategy.atUninstall", (String)"598", (Object)this);
                    Tr.warning((TraceComponent)tc, (String)"REMOVE_FROM_PASSIVATION_STORE_FAILED_CNTR0016W", (Object[])new Object[]{beanId, rex});
                }
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"atUninstall");
        }
    }

    public StatefulBeanReaper getReaper() {
        return this.reaper;
    }
}

