/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.krb5;

import com.ibm.security.jgss.i18n.I18NException;
import com.ibm.security.krb5.Asn1Exception;
import com.ibm.security.krb5.EncryptionKey;
import com.ibm.security.krb5.KrbCryptoException;
import com.ibm.security.krb5.internal.Config;
import com.ibm.security.krb5.internal.KdcErrException;
import com.ibm.security.krb5.internal.KrbApErrException;
import com.ibm.security.krb5.internal.crypto.s;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.math.BigInteger;

public class EncryptedData
implements Cloneable {
    int a;
    Integer b;
    byte[] c;
    byte[] d;
    public static final int ETYPE_NULL = 0;
    public static final int ETYPE_DES_CBC_CRC = 1;
    public static final int ETYPE_DES_CBC_MD4 = 2;
    public static final int ETYPE_DES_CBC_MD5 = 3;
    public static final int ETYPE_ARCFOUR_HMAC = 23;
    public static final int KERB_ETYPE_RC4_HMAC = 23;
    public static final int ETYPE_ARCFOUR_HMAC_EXP = 24;
    public static final int KERB_ETYPE_RC4_HMAC_EXP = 24;
    public static final int ETYPE_DES3_CBC_HMAC_SHA1_KD = 16;
    public static final int ETYPE_DES3_CBC_SHA1 = 16;
    public static final int ETYPE_AES128_CTS_HMAC_SHA1_96 = 17;
    public static final int ETYPE_AES256_CTS_HMAC_SHA1_96 = 18;
    public static final int KERB_ETYPE_AES_HMAC_SHA1_128 = 17;
    public static final int KERB_ETYPE_AES_HMAC_SHA1_256 = 18;
    private static final String[] z;

    private EncryptedData() {
    }

    public Object clone() {
        EncryptedData encryptedData = new EncryptedData();
        encryptedData.a = this.a;
        if (this.b != null) {
            encryptedData.b = new Integer(this.b);
        }
        if (this.c != null) {
            encryptedData.c = new byte[this.c.length];
            System.arraycopy(this.c, 0, encryptedData.c, 0, this.c.length);
        }
        return encryptedData;
    }

    public EncryptedData(int n2, Integer n3, byte[] byArray) {
        this.a = n2;
        this.b = n3;
        this.c = byArray;
    }

    public EncryptedData(EncryptionKey encryptionKey, byte[] byArray, int n2) throws KdcErrException, KrbCryptoException {
        s s2 = s.a(encryptionKey.getEType());
        this.c = s2.encrypt(byArray, encryptionKey.getBytes(), n2);
        this.a = encryptionKey.getEType();
        this.b = encryptionKey.getKeyVersionNumber();
    }

    public byte[] decrypt(EncryptionKey encryptionKey, int n2) throws KdcErrException, KrbApErrException, KrbCryptoException {
        if (this.a != encryptionKey.getEType()) {
            throw new KrbCryptoException(z[12] + s.c(this.a) + z[13] + s.c(encryptionKey.getEType()));
        }
        s s2 = s.a(this.a);
        this.d = s2.decrypt(this.c, encryptionKey.getBytes(), n2);
        return s2.decryptedData(this.d);
    }

    private EncryptedData(DerValue derValue) throws Asn1Exception, IOException {
        block15: {
            block14: {
                DerValue derValue2;
                block13: {
                    block12: {
                        derValue2 = null;
                        if (derValue.getTag() != 48) {
                            throw new Asn1Exception(906);
                        }
                        derValue2 = derValue.getData().getDerValue();
                        if ((derValue2.getTag() & 0x1F) != 0) break block12;
                        this.a = derValue2.getData().getBigInteger().intValue();
                        break block13;
                    }
                    throw new Asn1Exception(906);
                }
                if ((derValue.getData().peekByte() & 0x1F) == 1) {
                    derValue2 = derValue.getData().getDerValue();
                    int n2 = derValue2.getData().getBigInteger().intValue();
                    this.b = new Integer(n2);
                } else {
                    this.b = null;
                }
                derValue2 = derValue.getData().getDerValue();
                if ((derValue2.getTag() & 0x1F) != 2) break block14;
                this.c = derValue2.getData().getOctetString();
                break block15;
            }
            throw new Asn1Exception(906);
        }
        if (derValue.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(BigInteger.valueOf(this.a));
        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)0), derOutputStream2);
        derOutputStream2 = new DerOutputStream();
        if (this.b != null) {
            derOutputStream2.putInteger(BigInteger.valueOf(this.b.longValue()));
            derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)1), derOutputStream2);
            derOutputStream2 = new DerOutputStream();
        }
        derOutputStream2.putOctetString(this.c);
        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)2), derOutputStream2);
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.write((byte)48, derOutputStream);
        return derOutputStream2.toByteArray();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static EncryptedData parse(DerInputStream derInputStream, byte by, boolean bl) throws Asn1Exception, IOException {
        if (bl && ((byte)derInputStream.peekByte() & 0x1F) != by) {
            return null;
        }
        DerValue derValue = derInputStream.getDerValue();
        if (by != (derValue.getTag() & 0x1F)) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        return new EncryptedData(derValue2);
    }

    public byte[] reset(byte[] byArray) {
        byte[] byArray2 = null;
        if ((byArray[1] & 0xFF) < 128) {
            byArray2 = new byte[byArray[1] + 2];
            System.arraycopy(byArray, 0, byArray2, 0, byArray[1] + 2);
        } else if ((byArray[1] & 0xFF) > 128) {
            int n2 = byArray[1] & 0x7F;
            int n3 = 0;
            for (int i2 = 0; i2 < n2; ++i2) {
                n3 |= (byArray[i2 + 2] & 0xFF) << 8 * (n2 - i2 - 1);
            }
            byArray2 = new byte[n3 + n2 + 2];
            System.arraycopy(byArray, 0, byArray2, 0, n3 + n2 + 2);
        }
        return byArray2;
    }

    public int getEType() {
        return this.a;
    }

    public Integer getKeyVersionNumber() {
        return this.b;
    }

    public byte[] getBytes() {
        return this.c;
    }

    public static int stringToEncType(String string) throws Exception {
        block6: {
            int n2;
            block5: {
                if (string == null) {
                    I18NException.throwException(z[11]);
                }
                n2 = Config.getType(string);
                if (n2 != -1) break block5;
                I18NException.throwException(z[10], new String[]{string});
                break block6;
            }
            return n2;
        }
        return -999;
    }

    public static boolean isSupportedEncType(int n2) {
        return n2 == 16 || n2 == 1 || n2 == 3 || n2 == 23 || n2 == 24 || n2 == 17 || n2 == 18 || n2 == 0;
    }

    public String encTypeToString() {
        return EncryptedData.encTypeToString(this.a);
    }

    public static String encTypeToString(int n2) {
        switch (n2) {
            case 16: {
                return z[0];
            }
            case 1: {
                return z[8];
            }
            case 3: {
                return z[2];
            }
            case 23: {
                return z[3];
            }
            case 24: {
                return z[5];
            }
            case 17: {
                return z[4];
            }
            case 18: {
                return z[1];
            }
            case 2: {
                return z[9];
            }
            case 0: {
                return z[7];
            }
        }
        I18NException.throwIllegalArgumentException(z[6], new Integer[]{new Integer(n2)});
        return null;
    }

    public boolean isDesEncType() {
        return this.a == 16 || this.a == 3 || this.a == 1;
    }

    public static boolean isDes3EncType(int n2) {
        return n2 == 16;
    }

    public static boolean isDesEncType(int n2) {
        return n2 == 16 || n2 == 3 || n2 == 1;
    }

    public boolean isRc4HMacEncType() {
        return this.a == 23 || this.a == 24;
    }

    public static boolean isRc4HMacEncType(int n2) {
        return n2 == 23 || n2 == 24;
    }

    public boolean isAES128EncType() {
        return this.a == 17;
    }

    public static boolean isAES128EncType(int n2) {
        return n2 == 17;
    }

    public boolean isAES256EncType() {
        return this.a == 18;
    }

    public static boolean isAES256EncType(int n2) {
        return n2 == 18;
    }

    public byte[] reset(byte[] byArray, boolean bl) {
        if (this.isRc4HMacEncType()) {
            return byArray;
        }
        byte[] byArray2 = null;
        if (bl) {
            byArray2 = this.reset(byArray);
        } else {
            byArray2 = new byte[byArray.length - byArray[byArray.length - 1]];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length - byArray[byArray.length - 1]);
        }
        return byArray2;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[14];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\u0006VC\u00040\u0001QS\u001an\nR\u0001";
        int n3 = -1;
        block21: while (true) {
            char[] cArray;
            block26: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block25: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block25;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block26;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 98;
                                break;
                            }
                            case 1: {
                                n9 = 51;
                                break;
                            }
                            case 2: {
                                n9 = 48;
                                break;
                            }
                            case 3: {
                                n9 = 55;
                                break;
                            }
                            default: {
                                n9 = 29;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\u0003VC\u0005(T\u001eSCnO[]V~O@XV,O\n\u0006";
                    n3 = 0;
                    continue block21;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "\u0006VC\u001a~\u0000P\u001dZyW";
                    n3 = 1;
                    continue block21;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "\u0010P\u0004\u001au\u000fRS";
                    n3 = 2;
                    continue block21;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "\u0003VC\u0006/Z\u001eSCnO[]V~O@XV,O\n\u0006\u0017";
                    n3 = 3;
                    continue block21;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "\u0010P\u0004\u001au\u000fRS\u001ax\u001aC";
                    n3 = 4;
                    continue block21;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = " RTrs\u0001gIGx";
                    n3 = 5;
                    continue block21;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "\fF\\[";
                    n3 = 6;
                    continue block21;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "\u0006VC\u001a~\u0000P\u001dTo\u0001";
                    n3 = 7;
                    continue block21;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "\u0006VC\u001a~\u0000P\u001dZyV";
                    n3 = 8;
                    continue block21;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = " RTrs\u0001gIGx1GB^s\u0005";
                    n3 = 9;
                    continue block21;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = ",F\\[X\fPdNm\u0007`DEt\fT";
                    n3 = 10;
                    continue block21;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "']SEd\u0012GUSY\u0003GQ\u0017t\u0011\u0013UY~\u0010J@Cx\u0006\u0013EDt\fT\u0010\\x\u001bGIGxB";
                    n3 = 11;
                    continue block21;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = "BQEC=\u0006VSEd\u0012GYXsBXUN=\u000b@\u0010X{BGIGxB";
                    n3 = 12;
                    continue block21;
                }
                case 12: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

