/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AttributeNameEnumeration;
import com.ibm.security.x509.CertAttrSet;
import com.ibm.security.x509.DistributionPointName;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.GeneralNames;
import com.ibm.security.x509.GeneralNamesException;
import com.ibm.security.x509.PKIXExtensions;
import com.ibm.security.x509.RDN;
import com.ibm.security.x509.ReasonFlags;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.Enumeration;

public final class IssuingDistributionPointExtension
extends Extension
implements CertAttrSet<String> {
    public static final String IDENT = "x509.info.extensions.IssuingDistributionPoint";
    public static final String NAME = "IssuingDistributionPoint";
    public static final String DISTRIBUTION_PT = "distribution_pt";
    public static final String USER_CERTS_ONLY = "user_certs_only";
    public static final String CA_CERTS_ONLY = "ca_certs_only";
    public static final String LIMITED_REASONS = "limited_reasons";
    public static final String INDIRECT_CRL = "indirect_crl";
    public static final String ONLY_ATTRIBUTE_CERTS = "only_attribute_certs";
    public static final byte USER_ONLY = 1;
    public static final byte CA_ONLY = 16;
    public static final byte USER_AND_CA = 17;
    public static final byte ATTRIBUTE_ONLY = 2;
    private static final byte TAG_DPOINT = 0;
    private static final byte TAG_USERCERTS = 1;
    private static final byte TAG_CACERTS = 2;
    private static final byte TAG_REASONS = 3;
    private static final byte TAG_INDIRECT = 4;
    private static final byte TAG_ONLY_ATTRIBUTE_CERTS = 5;
    private DistributionPointName dPoint = null;
    private boolean userCerts = false;
    private boolean caCerts = false;
    private ReasonFlags reasons = null;
    private boolean indirectCRL = false;
    private boolean attributeCerts = false;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.IssuingDistributionPointExtension";

    public IssuingDistributionPointExtension(DistributionPointName dPoint, byte certType, ReasonFlags reasons, boolean indirect) throws IOException {
        if (debug != null) {
            Object[] parms = new Object[]{dPoint, new Byte(certType), reasons, new Boolean(indirect)};
            debug.entry(16384L, (Object)className, "IssuingDistributionPointExtension", parms);
        }
        this.extensionId = PKIXExtensions.IssuingDistributionPoint_Id;
        this.critical = true;
        if (dPoint != null) {
            this.dPoint = dPoint instanceof GeneralNames ? (GeneralNames)((GeneralNames)dPoint).clone() : dPoint;
        }
        if (certType == 1) {
            this.userCerts = true;
        } else if (certType == 16) {
            this.caCerts = true;
        } else if (certType == 17) {
            this.userCerts = true;
            this.caCerts = true;
        } else if (certType == 2) {
            this.attributeCerts = true;
        } else {
            if (debug != null) {
                debug.text(16384L, className, "IssuingDistributionPointExtension", "Invalid certificate type.");
            }
            throw new IOException("Invalid certificate type.");
        }
        if (reasons != null) {
            DerOutputStream derout = new DerOutputStream();
            reasons.encode(derout);
            DerInputStream derin = new DerInputStream(derout.toByteArray());
            this.reasons = new ReasonFlags(derin);
        }
        if (indirect) {
            this.indirectCRL = true;
        }
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "IssuingDistributionPointExtension");
        }
    }

    public IssuingDistributionPointExtension(byte[] value) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "IssuingDistributionPointExtension", (Object)value);
        }
        this.extensionId = PKIXExtensions.IssuingDistributionPoint_Id;
        this.critical = true;
        this.extensionValue = new byte[value.length];
        System.arraycopy(value, 0, this.extensionValue, 0, value.length);
        this.decodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "IssuingDistributionPointExtension");
        }
    }

    public IssuingDistributionPointExtension(Boolean critical, Object value) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "IssuingDistributionPointExtension", critical, value);
        }
        this.extensionId = PKIXExtensions.IssuingDistributionPoint_Id;
        this.critical = critical;
        if (!this.critical) {
            if (debug != null) {
                debug.text(16384L, className, "IssuingDistributionPointExtension", "Illegal argument - criticality must be true.");
            }
            throw new IOException("Illegal argument - criticality must be true.");
        }
        if (!(value instanceof byte[])) {
            if (debug != null) {
                debug.text(16384L, className, "IssuingDistributionPointExtension", "Illegal argument type.");
            }
            throw new IOException("Illegal argument type.");
        }
        int len = Array.getLength(value);
        byte[] extValue = new byte[len];
        System.arraycopy(value, 0, extValue, 0, len);
        this.extensionValue = extValue;
        this.decodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "IssuingDistributionPointExtension");
        }
    }

    public IssuingDistributionPointExtension(DerValue derval) throws IOException {
        super(derval);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "IssuingDistributionPointExtension", derval);
        }
        if (!this.critical) {
            if (debug != null) {
                debug.text(16384L, className, "IssuingDistributionPointExtension", "Invalid criticality value - must be true.");
            }
            throw new IOException("Invalid criticality value - must be true.");
        }
        this.decodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "IssuingDistributionPointExtension");
        }
    }

    @Override
    public Enumeration<String> getElements() {
        if (debug != null) {
            debug.entry(16384L, className, "getElements");
        }
        AttributeNameEnumeration elements = new AttributeNameEnumeration();
        elements.addElement(DISTRIBUTION_PT);
        elements.addElement(USER_CERTS_ONLY);
        elements.addElement(CA_CERTS_ONLY);
        elements.addElement(LIMITED_REASONS);
        elements.addElement(INDIRECT_CRL);
        elements.addElement(ONLY_ATTRIBUTE_CERTS);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getElements", elements.elements());
        }
        return elements.elements();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void set(String name, Object obj) throws IOException {
        block28: {
            block29: {
                if (debug != null) {
                    debug.entry(16384L, className, "set", name, obj);
                }
                if (!name.equalsIgnoreCase(DISTRIBUTION_PT)) break block29;
                if (obj instanceof GeneralNames) {
                    this.dPoint = (GeneralNames)((GeneralNames)obj).clone();
                    break block28;
                } else if (obj instanceof RDN) {
                    this.dPoint = (RDN)obj;
                    break block28;
                } else {
                    if (debug != null) {
                        debug.text(16384L, className, "set", "Attribute value should be of type DistributionPointName.");
                    }
                    throw new IOException("Attribute value should be of type DistributionPointName.");
                }
            }
            if (name.equalsIgnoreCase(USER_CERTS_ONLY)) {
                if (!(obj instanceof Boolean)) {
                    if (debug != null) {
                        debug.text(16384L, className, "set", "Attribute value should be of type Boolean.");
                    }
                    throw new IOException("Attribute value should be of type Boolean.");
                }
                this.userCerts = (Boolean)obj;
            } else if (name.equalsIgnoreCase(CA_CERTS_ONLY)) {
                if (!(obj instanceof Boolean)) {
                    if (debug != null) {
                        debug.text(16384L, className, "set", "Attribute value should be of type Boolean.");
                    }
                    throw new IOException("Attribute value should be of type Boolean.");
                }
                this.caCerts = (Boolean)obj;
            } else if (name.equalsIgnoreCase(ONLY_ATTRIBUTE_CERTS)) {
                if (!(obj instanceof Boolean)) {
                    if (debug != null) {
                        debug.text(16384L, className, "set", "Attribute value should be of type Boolean.");
                    }
                    throw new IOException("Attribute value should be of type Boolean.");
                }
                this.attributeCerts = (Boolean)obj;
            } else if (name.equalsIgnoreCase(LIMITED_REASONS)) {
                if (!(obj instanceof ReasonFlags)) {
                    if (debug != null) {
                        debug.text(16384L, className, "set", "Attribute value should be of type ReasonFlags.");
                    }
                    throw new IOException("Attribute value should be of type ReasonFlags.");
                }
                DerOutputStream derout = new DerOutputStream();
                ((ReasonFlags)obj).encode(derout);
                DerInputStream derin = new DerInputStream(derout.toByteArray());
                this.reasons = new ReasonFlags(derin);
            } else if (name.equalsIgnoreCase(INDIRECT_CRL)) {
                if (!(obj instanceof Boolean)) {
                    if (debug != null) {
                        debug.text(16384L, className, "set", "Attribute value should be of type Boolean.");
                    }
                    throw new IOException("Attribute value should be of type Boolean.");
                }
                this.indirectCRL = (Boolean)obj;
            } else {
                if (debug != null) {
                    debug.text(16384L, className, "set", "Attribute name not recognized by CertAttrSet:IssuingDistributionPoint.");
                }
                throw new IOException("Attribute name not recognized by CertAttrSet:IssuingDistributionPoint.");
            }
        }
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "set");
        }
    }

    @Override
    public Object get(String name) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "get", name);
        }
        if (name.equalsIgnoreCase(DISTRIBUTION_PT)) {
            if (this.dPoint instanceof GeneralNames) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "get_1", (GeneralNames)((GeneralNames)this.dPoint).clone());
                }
                return (GeneralNames)((GeneralNames)this.dPoint).clone();
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_2", this.dPoint);
            }
            return this.dPoint;
        }
        if (name.equalsIgnoreCase(USER_CERTS_ONLY)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_3", new Boolean(this.userCerts));
            }
            return new Boolean(this.userCerts);
        }
        if (name.equalsIgnoreCase(CA_CERTS_ONLY)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_4", new Boolean(this.caCerts));
            }
            return new Boolean(this.caCerts);
        }
        if (name.equalsIgnoreCase(ONLY_ATTRIBUTE_CERTS)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_5", new Boolean(this.attributeCerts));
            }
            return new Boolean(this.attributeCerts);
        }
        if (name.equalsIgnoreCase(LIMITED_REASONS)) {
            if (this.reasons != null) {
                DerOutputStream derout = new DerOutputStream();
                this.reasons.encode(derout);
                DerInputStream derin = new DerInputStream(derout.toByteArray());
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "get_6", new ReasonFlags(derin));
                }
                return new ReasonFlags(derin);
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_7", this.reasons);
            }
            return this.reasons;
        }
        if (name.equalsIgnoreCase(INDIRECT_CRL)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_8", new Boolean(this.indirectCRL));
            }
            return new Boolean(this.indirectCRL);
        }
        if (debug != null) {
            debug.text(16384L, className, "get_9", "Attribute name not recognized by CertAttrSet:IssuingDistributionPoint.");
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:IssuingDistributionPoint.");
    }

    @Override
    public void delete(String name) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "delete", name);
        }
        if (name.equalsIgnoreCase(DISTRIBUTION_PT)) {
            this.dPoint = null;
        } else if (name.equalsIgnoreCase(USER_CERTS_ONLY)) {
            this.userCerts = false;
        } else if (name.equalsIgnoreCase(CA_CERTS_ONLY)) {
            this.caCerts = false;
        } else if (name.equalsIgnoreCase(ONLY_ATTRIBUTE_CERTS)) {
            this.attributeCerts = false;
        } else if (name.equalsIgnoreCase(LIMITED_REASONS)) {
            this.reasons = null;
        } else if (name.equalsIgnoreCase(INDIRECT_CRL)) {
            this.indirectCRL = false;
        } else {
            if (debug != null) {
                debug.text(16384L, className, "delete", "Attribute name not recognized by CertAttrSet:IssuingDistributionPoint.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet:IssuingDistributionPoint.");
        }
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "delete");
        }
    }

    @Override
    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        String out = super.toString();
        out = out + this.getName() + " [\r\n";
        out = this.dPoint == null ? out + "Distribution Point: null\r\n" : out + this.dPoint.toString() + "\r\n";
        if (this.userCerts) {
            out = out + "Revokes end-entity certificates\r\n";
        }
        if (this.caCerts) {
            out = out + "Revokes CA certificates\r\n";
        }
        if (this.attributeCerts) {
            out = out + "Revokes attribute certificates\r\n";
        }
        out = this.reasons == null ? out + "Reason Flags: null\r\n" : out + this.reasons.toString();
        if (this.indirectCRL) {
            out = out + "CRL distribution point name is indirect\r\n";
        }
        out = out + "]\r\n";
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", out);
        }
        return out;
    }

    @Override
    public String getName() {
        if (debug != null) {
            debug.entry(16384L, className, "getName");
            debug.exit(16384L, (Object)className, "getName", NAME);
        }
        return NAME;
    }

    public DistributionPointName getDistributionPoint() throws IOException, GeneralNamesException {
        if (debug != null) {
            debug.entry(16384L, className, "getDistributionPoint");
        }
        if (this.dPoint == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getDistributionPoint_1", null);
            }
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DistributionPointName result = null;
        this.dPoint.encode(out);
        if (this.dPoint instanceof GeneralNames) {
            result = new GeneralNames(new DerValue(out.toByteArray()));
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getDistributionPoint_2", result);
            }
            return result;
        }
        result = new RDN(new DerValue(out.toByteArray()));
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getDistributionPoint_3", result);
        }
        return result;
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", out);
        }
        DerOutputStream tmp = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.IssuingDistributionPoint_Id;
            this.critical = true;
            this.encodeThis();
        }
        super.encode(tmp);
        out.write(tmp.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    @Override
    public void decode(InputStream in) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", in);
            debug.text(16384L, className, "decode", "Method not to be called directly.");
        }
        throw new IOException("Method not to be called directly.");
    }

    private void encodeThis() throws IOException {
        DerOutputStream tmp1;
        if (debug != null) {
            debug.entry(8192L, className, "encodeThis");
        }
        DerOutputStream os = new DerOutputStream();
        DerOutputStream tmp = new DerOutputStream();
        if (!(this.dPoint != null || this.reasons != null || this.userCerts || this.caCerts || this.indirectCRL || this.attributeCerts)) {
            this.extensionValue = null;
            if (debug != null) {
                debug.exit(8192L, className, "encodeThis_1");
            }
            return;
        }
        if (this.dPoint != null) {
            tmp1 = new DerOutputStream();
            DerOutputStream tmp2 = new DerOutputStream();
            this.dPoint.encode(tmp1);
            if (this.dPoint instanceof GeneralNames) {
                tmp2.writeImplicit(DerValue.createTag((byte)-128, true, (byte)0), tmp1);
            } else {
                tmp2.writeImplicit(DerValue.createTag((byte)-128, true, (byte)1), tmp1);
            }
            tmp.write(DerValue.createTag((byte)-128, true, (byte)0), tmp2);
        }
        if (this.userCerts) {
            tmp1 = new DerOutputStream();
            tmp1.putBoolean(this.userCerts);
            tmp.writeImplicit(DerValue.createTag((byte)-128, false, (byte)1), tmp1);
        }
        if (this.caCerts) {
            tmp1 = new DerOutputStream();
            tmp1.putBoolean(this.caCerts);
            tmp.writeImplicit(DerValue.createTag((byte)-128, false, (byte)2), tmp1);
        }
        if (this.attributeCerts) {
            tmp1 = new DerOutputStream();
            tmp1.putBoolean(this.attributeCerts);
            tmp.writeImplicit(DerValue.createTag((byte)-128, false, (byte)5), tmp1);
        }
        if (this.reasons != null) {
            tmp1 = new DerOutputStream();
            this.reasons.encode(tmp1);
            tmp.writeImplicit(DerValue.createTag((byte)-128, false, (byte)3), tmp1);
        }
        if (this.indirectCRL) {
            tmp1 = new DerOutputStream();
            tmp1.putBoolean(this.indirectCRL);
            tmp.writeImplicit(DerValue.createTag((byte)-128, false, (byte)4), tmp1);
        }
        os.write((byte)48, tmp);
        this.extensionValue = os.toByteArray();
        if (debug != null) {
            debug.exit(8192L, className, "encodeThis_2");
        }
    }

    private void decodeThis() throws IOException {
        DerValue derVal;
        if (debug != null) {
            debug.entry(8192L, className, "decodeThis");
        }
        if ((derVal = new DerValue(this.extensionValue)).getTag() != 48) {
            if (debug != null) {
                debug.text(8192L, className, "decodeThis", "IssuingDistributionPointExtension parsing error: not a SEQUENCE.");
            }
            throw new IOException("IssuingDistributionPointExtension parsing error: not a SEQUENCE.");
        }
        while (derVal.getData() != null && derVal.getData().available() != 0) {
            DerValue derVal2 = derVal.getData().getDerValue();
            if (derVal2.isContextSpecific((byte)0) && derVal2.isConstructed()) {
                DerValue derVal3 = derVal2.getData().getDerValue();
                if (derVal3.isContextSpecific((byte)0) && derVal3.isConstructed()) {
                    derVal3.resetTag((byte)48);
                    try {
                        this.dPoint = new GeneralNames(derVal3);
                        continue;
                    }
                    catch (GeneralNamesException e2) {
                        if (debug != null) {
                            debug.exception(8192L, className, "decodeThis", e2);
                        }
                        throw new IOException("Error constructing distribution point name.");
                    }
                }
                if (derVal3.isContextSpecific((byte)1) && derVal2.isConstructed()) {
                    derVal3.resetTag((byte)49);
                    this.dPoint = new RDN(derVal3);
                    continue;
                }
                if (debug != null) {
                    debug.text(8192L, className, "decodeThis", "IssuingDistributionPoint parsing error.");
                }
                throw new IOException("IssuingDistributionPoint parsing error.");
            }
            if (derVal2.isContextSpecific((byte)1) && !derVal2.isConstructed()) {
                derVal2.resetTag((byte)1);
                this.userCerts = derVal2.getBoolean();
                continue;
            }
            if (derVal2.isContextSpecific((byte)2) && !derVal2.isConstructed()) {
                derVal2.resetTag((byte)1);
                this.caCerts = derVal2.getBoolean();
                continue;
            }
            if (derVal2.isContextSpecific((byte)5) && !derVal2.isConstructed()) {
                derVal2.resetTag((byte)1);
                this.attributeCerts = derVal2.getBoolean();
                continue;
            }
            if (derVal2.isContextSpecific((byte)3) && !derVal2.isConstructed()) {
                derVal2.resetTag((byte)3);
                this.reasons = new ReasonFlags(derVal2);
                continue;
            }
            if (derVal2.isContextSpecific((byte)4) && !derVal2.isConstructed()) {
                derVal2.resetTag((byte)1);
                this.indirectCRL = derVal2.getBoolean();
                continue;
            }
            if (debug != null) {
                debug.text(8192L, className, "decodeThis", "IssuingDistributionPoint parsing error.");
            }
            throw new IOException("IssuingDistributionPoint parsing error.");
        }
        if (debug != null) {
            debug.exit(8192L, className, "decodeThis");
        }
    }
}

