/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmputil;

import com.ibm.misc.BASE64Decoder;
import com.ibm.misc.BASE64Encoder;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public abstract class CMPDerObject
implements Cloneable {
    public CMPDerObject() {
    }

    public CMPDerObject(String string, boolean bl) throws IOException {
        if (bl) {
            this.readBASE64(string);
        } else {
            this.read(string);
        }
    }

    public CMPDerObject(byte[] byArray) throws IOException {
        this.decode(byArray);
    }

    protected abstract void decode(DerValue var1) throws IOException;

    protected void decode(byte[] byArray) throws IOException {
        DerInputStream derInputStream = new DerInputStream(byArray);
        DerValue derValue = derInputStream.getDerValue();
        this.decode(derValue);
    }

    public byte[] encode() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        this.encode(derOutputStream);
        return derOutputStream.toByteArray();
    }

    public abstract void encode(OutputStream var1) throws IOException;

    public abstract boolean equals(Object var1);

    public int hashCode() {
        return this.toString().hashCode();
    }

    protected void read(String string) throws IOException {
        FileInputStream fileInputStream;
        try {
            fileInputStream = new FileInputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IOException("File " + string + " not found.");
        }
        int n2 = fileInputStream.available();
        byte[] byArray = new byte[n2];
        fileInputStream.read(byArray);
        fileInputStream.close();
        this.decode(byArray);
    }

    protected void readBASE64(String string) throws IOException {
        FileInputStream fileInputStream;
        try {
            fileInputStream = new FileInputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IOException("File " + string + " not found.");
        }
        BASE64Decoder bASE64Decoder = new BASE64Decoder();
        byte[] byArray = bASE64Decoder.decodeBuffer(fileInputStream);
        fileInputStream.close();
        this.decode(byArray);
    }

    public abstract String toString();

    protected void write(String string) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        this.encode(fileOutputStream);
        fileOutputStream.close();
    }

    public void write(String string, boolean bl) throws IOException {
        if (bl) {
            this.writeBASE64(string);
        } else {
            this.write(string);
        }
    }

    protected void writeBASE64(String string) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        DerOutputStream derOutputStream = new DerOutputStream();
        this.encode(derOutputStream);
        byte[] byArray = derOutputStream.toByteArray();
        BASE64Encoder bASE64Encoder = new BASE64Encoder();
        bASE64Encoder.encode(byArray, (OutputStream)fileOutputStream);
        fileOutputStream.close();
    }
}

