/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.openapi.impl.validation;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.microprofile.openapi.impl.validation.OASValidationResult;
import com.ibm.ws.microprofile.openapi.impl.validation.TypeValidator;
import com.ibm.ws.microprofile.openapi.impl.validation.ValidationHelper;
import com.ibm.ws.microprofile.openapi.impl.validation.ValidatorUtils;
import com.ibm.ws.microprofile.openapi.utils.OpenAPIModelWalker;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.Paths;
import org.eclipse.microprofile.openapi.models.links.Link;

public class LinkValidator
extends TypeValidator<Link> {
    private static final TraceComponent tc = Tr.register(LinkValidator.class);
    private static final LinkValidator INSTANCE = new LinkValidator();

    public static LinkValidator getInstance() {
        return INSTANCE;
    }

    private LinkValidator() {
    }

    @Override
    public void validate(ValidationHelper helper, OpenAPIModelWalker.Context context, String key, Link t) {
        block32: {
            boolean isValid;
            block35: {
                block36: {
                    String op;
                    String[] operationRef;
                    block34: {
                        boolean operationIdDefined;
                        boolean operationRefDefined;
                        block33: {
                            String message;
                            if (t == null) break block32;
                            String reference = t.getRef();
                            if (reference != null && !reference.isEmpty()) {
                                ValidatorUtils.referenceValidatorHelper(reference, t, helper, context, key);
                                return;
                            }
                            operationRefDefined = t.getOperationRef() != null && !t.getOperationRef().isEmpty();
                            boolean bl = operationIdDefined = t.getOperationId() != null && !t.getOperationId().isEmpty();
                            if (operationRefDefined && operationIdDefined) {
                                message = Tr.formatMessage((TraceComponent)tc, (String)"linkOperationRefAndId", (Object[])new Object[]{key});
                                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.WARNING, context.getLocation(), message));
                            }
                            if (operationRefDefined || operationIdDefined) break block33;
                            message = Tr.formatMessage((TraceComponent)tc, (String)"linkMustSpecifyOperationRefOrId", (Object[])new Object[]{key});
                            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
                            break block32;
                        }
                        if (operationIdDefined) {
                            helper.addLinkOperationId(t.getOperationId(), context.getLocation());
                        }
                        if (!operationRefDefined || !t.getOperationRef().startsWith("#")) break block32;
                        isValid = true;
                        if (t.getOperationRef().startsWith("#/paths/") && (operationRef = t.getOperationRef().split("/")).length == 4) break block34;
                        isValid = false;
                        break block35;
                    }
                    String pathKey = operationRef[2].replace("~1", "/").replace("~0", "~");
                    Paths paths = context.getModel().getPaths();
                    if (paths == null || paths.get((Object)pathKey) == null) break block36;
                    switch (op = operationRef[3]) {
                        case "get": {
                            if (((PathItem)paths.get((Object)pathKey)).getGET() == null) {
                                isValid = false;
                                break;
                            }
                            break block35;
                        }
                        case "put": {
                            if (((PathItem)paths.get((Object)pathKey)).getPUT() == null) {
                                isValid = false;
                                break;
                            }
                            break block35;
                        }
                        case "post": {
                            if (((PathItem)paths.get((Object)pathKey)).getPOST() == null) {
                                isValid = false;
                                break;
                            }
                            break block35;
                        }
                        case "delete": {
                            if (((PathItem)paths.get((Object)pathKey)).getDELETE() == null) {
                                isValid = false;
                                break;
                            }
                            break block35;
                        }
                        case "trace": {
                            if (((PathItem)paths.get((Object)pathKey)).getTRACE() == null) {
                                isValid = false;
                                break;
                            }
                            break block35;
                        }
                        case "head": {
                            if (((PathItem)paths.get((Object)pathKey)).getHEAD() == null) {
                                isValid = false;
                                break;
                            }
                            break block35;
                        }
                        case "patch": {
                            if (((PathItem)paths.get((Object)pathKey)).getPATCH() == null) {
                                isValid = false;
                                break;
                            }
                            break block35;
                        }
                        case "options": {
                            if (((PathItem)paths.get((Object)pathKey)).getOPTIONS() == null) {
                                isValid = false;
                                break;
                            }
                            break block35;
                        }
                        default: {
                            isValid = false;
                            break;
                        }
                    }
                    break block35;
                }
                isValid = false;
            }
            if (!isValid) {
                String message = Tr.formatMessage((TraceComponent)tc, (String)"linkOperationRefInvalidOrMissing", (Object[])new Object[]{key, t.getOperationRef()});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
            }
        }
    }
}

