/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.boot.internal.commands;

import com.ibm.ws.kernel.boot.BootstrapConfig;
import com.ibm.ws.kernel.boot.ReturnCode;
import com.ibm.ws.kernel.boot.archive.Archive;
import com.ibm.ws.kernel.boot.archive.ArchiveEntryConfig;
import com.ibm.ws.kernel.boot.archive.ArchiveFactory;
import com.ibm.ws.kernel.boot.archive.DirEntryConfig;
import com.ibm.ws.kernel.boot.archive.DirPattern;
import com.ibm.ws.kernel.boot.archive.FileEntryConfig;
import com.ibm.ws.kernel.boot.archive.FilteredDirEntryConfig;
import com.ibm.ws.kernel.boot.cmdline.Utils;
import com.ibm.ws.kernel.boot.internal.BootstrapConstants;
import com.ibm.ws.kernel.boot.internal.commands.ArchiveProcessor;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class DumpProcessor
implements ArchiveProcessor {
    private final String serverName;
    private final String regexServerName;
    private final File serverConfigDir;
    private final File serverOutputDir;
    private final File serverAltLogDir;
    private final BootstrapConfig bootProps;
    private final List<String> javaDumps;
    private final File dumpFile;
    private static final String SEP = REGEX_SEPARATOR;

    private static String format(String msgId, Object ... parms) {
        return MessageFormat.format(BootstrapConstants.messages.getString(msgId), parms);
    }

    public String getServerName() {
        return this.serverName;
    }

    public BootstrapConfig getBootProps() {
        return this.bootProps;
    }

    public DumpProcessor(String serverName, File dumpFile, BootstrapConfig bootProps, List<String> javaDumps) {
        this.serverName = serverName;
        this.regexServerName = Pattern.quote(serverName);
        this.serverConfigDir = new File(bootProps.getUserRoot(), "servers/" + serverName);
        this.serverOutputDir = bootProps.getOutputFile(null);
        this.serverAltLogDir = DumpProcessor.getAltLogDir(this.serverConfigDir, bootProps.getLogDirectory());
        this.bootProps = bootProps;
        this.javaDumps = javaDumps;
        this.dumpFile = dumpFile;
    }

    private static File getAltLogDir(File serverConfigDir, File serverLogDir) {
        File defaultLogDir;
        String defaultLogPath;
        if (serverLogDir == null) {
            return null;
        }
        String serverLogPath = serverLogDir.getAbsolutePath();
        if (!serverLogPath.equals(defaultLogPath = (defaultLogDir = new File(serverConfigDir, "logs")).getAbsolutePath())) {
            System.out.println(DumpProcessor.format("info.dump.server.alt.logs", serverLogPath));
            return serverLogDir;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReturnCode execute() {
        Archive archive = null;
        try {
            archive = ArchiveFactory.create(this.dumpFile);
            archive.addEntryConfigs(this.createDumpConfigs());
            archive.create();
        }
        catch (IOException | IllegalArgumentException e) {
            System.out.println(DumpProcessor.format("error.unableZipDir", e));
            ReturnCode returnCode = ReturnCode.ERROR_SERVER_DUMP;
            return returnCode;
        }
        finally {
            Utils.tryToClose(archive);
        }
        return ReturnCode.OK;
    }

    private Pattern serverPattern(String tail) {
        return Pattern.compile(SEP + this.regexServerName + SEP + tail);
    }

    private List<ArchiveEntryConfig> createDumpConfigs() throws IOException {
        ArrayList<ArchiveEntryConfig> entryConfigs = new ArrayList<ArchiveEntryConfig>();
        FilteredDirEntryConfig configFiles = new FilteredDirEntryConfig(this.serverConfigDir, false, DirPattern.PatternStrategy.ExcludePreference);
        configFiles.include(this.serverPattern(".*\\.xml"));
        configFiles.include(this.serverPattern(".*\\.properties"));
        configFiles.include(this.serverPattern("configDropins"));
        configFiles.exclude(this.serverPattern("dump_\\d\\d\\.\\d\\d\\.\\d\\d_\\d\\d\\.\\d\\d\\.\\d\\d"));
        configFiles.exclude(this.serverPattern("autopd"));
        entryConfigs.add(configFiles);
        DirEntryConfig nonConfigFiles = new DirEntryConfig("", this.serverConfigDir, true, DirPattern.PatternStrategy.ExcludePreference);
        nonConfigFiles.exclude(this.serverPattern("dropins"));
        nonConfigFiles.exclude(this.serverPattern("apps"));
        nonConfigFiles.exclude(Pattern.compile(SEP + "resources" + SEP + "security"));
        nonConfigFiles.exclude(Pattern.compile("\\.jks$"));
        nonConfigFiles.exclude(Pattern.compile("\\.p12$"));
        nonConfigFiles.exclude(this.serverPattern("dump_\\d\\d\\.\\d\\d\\.\\d\\d_\\d\\d\\.\\d\\d\\.\\d\\d"));
        nonConfigFiles.exclude(this.serverPattern("autopd"));
        nonConfigFiles.exclude(this.serverPattern("logs"));
        nonConfigFiles.exclude(this.serverPattern("workarea"));
        nonConfigFiles.exclude(Pattern.compile(SEP + this.regexServerName + "\\.(zip|pax)$"));
        nonConfigFiles.exclude(Pattern.compile(SEP + this.regexServerName + "\\.dump-" + "\\d\\d\\.\\d\\d\\.\\d\\d_\\d\\d\\.\\d\\d\\.\\d\\d" + "\\.(zip|pax)$"));
        nonConfigFiles.exclude(this.serverPattern("core\\.[^\\\\/]+\\.dmp"));
        nonConfigFiles.exclude(this.serverPattern("heapdump\\.[^\\\\/]+\\.phd"));
        nonConfigFiles.exclude(this.serverPattern("java\\.[^\\\\/]+\\.hprof"));
        nonConfigFiles.exclude(this.serverPattern("javacore\\.[^\\\\/]+\\.txt"));
        nonConfigFiles.exclude(this.serverPattern("javadump\\.[^\\\\/]+\\.txt"));
        entryConfigs.add(nonConfigFiles);
        DirEntryConfig outputConfigFiles = new DirEntryConfig("", this.serverOutputDir, false, DirPattern.PatternStrategy.ExcludePreference);
        outputConfigFiles.include(this.serverPattern("dump_\\d\\d\\.\\d\\d\\.\\d\\d_\\d\\d\\.\\d\\d\\.\\d\\d"));
        outputConfigFiles.include(this.serverPattern("autopd"));
        outputConfigFiles.include(this.serverPattern("logs"));
        outputConfigFiles.include(this.serverPattern("workarea"));
        outputConfigFiles.exclude(this.serverPattern("workarea" + SEP + "\\.sLock$"));
        outputConfigFiles.exclude(this.serverPattern("workarea" + SEP + "\\.sCommand$"));
        String OSGI_SUBPATH = "workarea" + SEP + ".*org\\.eclipse\\.osgi" + SEP;
        outputConfigFiles.exclude(this.serverPattern(OSGI_SUBPATH + "\\.manager"));
        String APP_CACHE_PATH = "bundles" + SEP + "\\d+" + SEP + "data" + SEP + ".*com\\.ibm\\.ws\\.app\\.manager_gen";
        outputConfigFiles.exclude(this.serverPattern(OSGI_SUBPATH + APP_CACHE_PATH));
        entryConfigs.add(outputConfigFiles);
        if (this.serverAltLogDir != null) {
            DirEntryConfig outputAltLogs = new DirEntryConfig("logs_external/" + this.serverAltLogDir.getName() + "/", this.serverAltLogDir, true, DirPattern.PatternStrategy.IncludePreference);
            entryConfigs.add(outputAltLogs);
        }
        for (String javaDump : this.javaDumps) {
            File f = new File(javaDump);
            if (f.exists()) {
                FileEntryConfig feg = new FileEntryConfig("", f);
                entryConfigs.add(feg);
                continue;
            }
            System.out.println(DumpProcessor.format("error.missingDumpFile", javaDump));
        }
        return entryConfigs;
    }
}

