/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.member.internal.publisher;

import com.ibm.websphere.kernel.server.ServerInfoMBean;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.collective.member.DockerEnvironmentUtil;
import com.ibm.ws.collective.utils.GatherMemberDataUtil;
import com.ibm.ws.collective.utils.RepositoryPathUtility;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.HashMap;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={GatherMemberDataUtil.class}, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class GatherMemberDataUtilImpl
implements GatherMemberDataUtil {
    private ServerInfoMBean serverIdentity = null;
    private Map<String, Object> memberData = null;
    static final long serialVersionUID = -9165277756331611354L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Reference(service=ServerInfoMBean.class)
    protected synchronized void setServerIdentityMBean(ServerInfoMBean reference) {
        this.serverIdentity = reference;
    }

    protected synchronized void unsetServerIdentityMBean(ServerInfoMBean reference) {
        if (this.serverIdentity == reference) {
            this.serverIdentity = null;
        }
    }

    @Activate
    protected synchronized void activate() {
        String hostName = this.serverIdentity.getDefaultHostname();
        String userDir = this.serverIdentity.getUserDirectory();
        String serverName = this.serverIdentity.getName();
        if (hostName == null || userDir == null || serverName == null) {
            throw new IllegalStateException("Null value found while gathering member data. host: " + hostName + " userdir: " + userDir + " servername: " + serverName);
        }
        this.memberData = new HashMap<String, Object>();
        if (DockerEnvironmentUtil.isMemberInDockerEnvironment()) {
            this.memberData.put("liberty.host", DockerEnvironmentUtil.getContainerPropertyFromEnvironment("containerHost"));
            this.memberData.put("liberty.userdir", "Docker");
            this.memberData.put("liberty.servername", DockerEnvironmentUtil.getContainerPropertyFromEnvironment("containerName"));
        } else {
            this.memberData.put("liberty.host", hostName);
            this.memberData.put("liberty.userdir", RepositoryPathUtility.getURLEncodedPath((String)userDir));
            this.memberData.put("liberty.servername", serverName);
        }
    }

    @Deactivate
    protected synchronized void deactivate() {
    }

    public Map<String, Object> getMemberData() {
        return this.memberData;
    }

    public boolean isController(Map<String, Object> memberData) {
        if (memberData == null) {
            throw new IllegalArgumentException("Invalid argument, memberData is null.");
        }
        return this.getMemberData().values().containsAll(memberData.values());
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.collective.member.internal.publisher.GatherMemberDataUtilImpl", GatherMemberDataUtilImpl.class, (String)"Collective", (String)"com.ibm.ws.collective.member.internal.resources.CollectiveMemberMessages");
    }
}

