/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.config;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ssl.Constants;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.common.crypto.CryptoUtils;
import java.security.Security;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLContext;

public class ProtocolHelper {
    private static final TraceComponent tc = Tr.register(ProtocolHelper.class, (String)"SSL", (String)"com.ibm.ws.ssl.resources.ssl");
    private static final List<String> validatedProtocols = new ArrayList<String>();
    private static final List<String> disabledList = new ArrayList<String>();
    private static boolean builtDisabledList = false;

    public void checkProtocolValueGood(String sslProtocol) throws SSLException, UnsupportedOperationException {
        List<String> allowedProtocols;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"checkProtocolValueGood", (Object[])new Object[]{sslProtocol});
        }
        String[] protocols = sslProtocol.split(",");
        boolean fips140_3Enabled = CryptoUtils.isFips140_3Enabled();
        if (fips140_3Enabled) {
            Tr.debug((TraceComponent)tc, (String)"FIPS is enabled, only allowing TLSv1.2 and TLSv1.3", (Object[])new Object[0]);
            allowedProtocols = Constants.FIPS_140_3_PROTOCOLS;
        } else {
            allowedProtocols = Constants.MULTI_PROTOCOL_LIST;
        }
        if (protocols.length > 1) {
            for (String protocol : protocols) {
                if (allowedProtocols.contains(protocol)) {
                    if (validatedProtocols.contains(protocol)) continue;
                    this.checkProtocol(protocol);
                    validatedProtocols.add(protocol);
                    continue;
                }
                Tr.error((TraceComponent)tc, (String)"ssl.protocol.error.CWPKI0832E", (Object[])new Object[]{protocol});
                throw new SSLException("Protocol provided is not appropriate for a protocol list.");
            }
        } else {
            String protocol = protocols[0];
            if (!validatedProtocols.contains(protocol)) {
                this.checkProtocol(protocol);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkProtocolValueGood");
        }
    }

    private void checkProtocol(String protocol) throws SSLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"checkProtocol", (Object[])new Object[]{protocol});
        }
        try {
            SSLContext.getInstance(protocol);
        }
        catch (Throwable t) {
            String tMsg = t.getMessage();
            Tr.error((TraceComponent)tc, (String)"ssl.protocol.error.CWPKI0831E", (Object[])new Object[]{protocol, tMsg});
            throw new SSLException("Error checking checking for valid protocol: " + tMsg);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkProtocol", (Object)protocol);
        }
    }

    private boolean isProtocolDisabled(String protocol) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isProtocolDisabled", (Object[])new Object[]{protocol});
        }
        boolean isDisabled = false;
        if (!builtDisabledList) {
            String[] algorithms;
            String disabled = Security.getProperty("jdk.tls.disabledAlgorithms");
            for (String algorithm : algorithms = disabled.split(",")) {
                if (!Constants.MULTI_PROTOCOL_LIST.contains(algorithm.trim())) continue;
                disabledList.add(algorithm.trim());
            }
            builtDisabledList = true;
        }
        if (!disabledList.isEmpty() && disabledList.contains(protocol)) {
            isDisabled = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isProtocolDisabled", (Object)protocol);
        }
        return isDisabled;
    }

    public String[] getSSLProtocol(String protocol) {
        String[] protocols;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getSSLProtocol", (Object[])new Object[0]);
        }
        if ((protocols = protocol.split(",")).length == 1 && (protocols[0].equals("TLS") || protocols[0].equals("SSL"))) {
            protocols = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getSSLProtocol " + protocols));
        }
        return protocols;
    }
}

