/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tx.jta.impl;

import com.ibm.tx.jta.impl.FailureScopeController;
import com.ibm.tx.jta.impl.JCARecoveryData;
import com.ibm.tx.jta.impl.PartnerLogTable;
import com.ibm.tx.jta.impl.TransactionImpl;
import com.ibm.tx.jta.impl.XidImpl;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.Transaction.JTA.Util;
import com.ibm.ws.Transaction.JTS.Configuration;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.recoverylog.spi.InternalLogException;
import com.ibm.ws.recoverylog.spi.LogFullException;
import com.ibm.ws.recoverylog.spi.RecoverableUnit;
import com.ibm.ws.recoverylog.spi.RecoverableUnitSection;
import jakarta.transaction.SystemException;

public class TransactionState {
    public static final int STATE_NONE = -1;
    public static final int STATE_ACTIVE = 0;
    public static final int STATE_PREPARING = 1;
    public static final int STATE_PREPARED = 2;
    public static final int STATE_COMMITTING_ONE_PHASE = 10;
    public static final int STATE_COMMITTING = 3;
    public static final int STATE_COMMITTED = 4;
    public static final int STATE_ROLLING_BACK = 5;
    public static final int STATE_ROLLED_BACK = 6;
    public static final int STATE_HEURISTIC_ON_COMMIT = 7;
    public static final int STATE_HEURISTIC_ON_ROLLBACK = 8;
    public static final int STATE_LAST_PARTICIPANT = 9;
    private static final TraceComponent tc = Tr.register(TransactionState.class, (String)"Transaction", (String)"com.ibm.ws.Transaction.resources.TransactionMsgs");
    protected int _state;
    protected TransactionImpl _tran;
    protected RecoverableUnit _tranLog;
    protected RecoverableUnitSection _logSection;
    protected boolean _loggingFailed;
    protected static final PartnerLogTable _partnerLogTable;
    protected byte[] byteData = new byte[1];
    protected static final boolean[][] validStateChange;

    public TransactionState(TransactionImpl tran) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"TransactionState", (Object[])new Object[]{this, tran});
        }
        this._state = 0;
        this._tran = tran;
    }

    public int reconstruct(RecoverableUnit log) throws SystemException {
        int result;
        block22: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"reconstruct", (Object[])new Object[]{this, log});
            }
            result = -1;
            int logState = 0;
            this._logSection = log.lookupSection(0);
            if (this._logSection != null) {
                try {
                    byte[] logData = this._logSection.lastData();
                    if (logData.length == 1) {
                        logState = logData[0] & 0xFF;
                        switch (logState) {
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: 
                            case 7: 
                            case 8: 
                            case 9: {
                                result = logState;
                                break block22;
                            }
                            default: {
                                throw new SystemException("Transaction recovered in invalid state");
                            }
                        }
                    }
                    throw new SystemException("Invalid transaction state record data in log");
                }
                catch (Throwable e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.tx.jta.impl.TransactionState.reconstruct", (String)"274", (Object)this);
                    Tr.fatal((TraceComponent)tc, (String)"WTRN0000_ERR_INT_ERROR", (Object[])new Object[]{"reconstruct", "com.ibm.tx.jta.impl.TransactionState", e});
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"Unable to access transaction state log record data", (Object[])new Object[0]);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"reconstruct");
                    }
                    throw new SystemException(e.toString());
                }
            }
            FFDCFilter.processException((Throwable)new InternalLogException(), (String)"com.ibm.tx.jta.impl.TransactionState.setState", (String)"277", (Object)this);
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"No log record data for transaction state - returning NONE", (Object[])new Object[0]);
            }
            this._state = -1;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"reconstruct", (Object)TransactionState.stateToString(this._state));
            }
            return this._state;
        }
        this._state = result;
        this._tranLog = log;
        RecoverableUnitSection gtidSection = log.lookupSection(3);
        if (gtidSection != null) {
            try {
                byte[] logData = gtidSection.lastData();
                if (logData.length <= 12) {
                    throw new SystemException("Invalid transaction global identifier record data in log");
                }
                XidImpl xid = new XidImpl(logData, 0);
                this._tran.setXidImpl(xid);
            }
            catch (Throwable e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.tx.jta.impl.TransactionState.reconstruct", (String)"334", (Object)this);
                Tr.fatal((TraceComponent)tc, (String)"WTRN0000_ERR_INT_ERROR", (Object[])new Object[]{"reconstruct", "com.ibm.tx.jta.impl.TransactionState", e});
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Unable to access global transaction id log record data", (Object[])new Object[0]);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"reconstruct");
                }
                throw new SystemException(e.toString());
            }
        } else {
            FFDCFilter.processException((Throwable)new InternalLogException(), (String)"com.ibm.tx.jta.impl.TransactionState.setState", (String)"336", (Object)this);
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"No log record data for global transaction id - returning NONE", (Object[])new Object[0]);
            }
            this._state = -1;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"reconstruct", (Object)TransactionState.stateToString(this._state));
            }
            return this._state;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"reconstruct", (Object)TransactionState.stateToString(result));
        }
        return result;
    }

    public void setState(int newState) throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setState", (Object[])new Object[]{"from " + TransactionState.stateToString(this._state) + " to " + TransactionState.stateToString(newState)});
        }
        int oldState = this._state;
        if (validStateChange[this._state][newState]) {
            block43: {
                this._state = newState;
                if (newState == 3 || newState == 9 || this._tran.isSubordinate() && (newState == 2 || newState == 7 || newState == 8)) {
                    this.byteData[0] = (byte)this._state;
                    if (this._logSection != null) {
                        try {
                            this._logSection.addData(this.byteData);
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"State logged ok", (Object[])new Object[0]);
                            }
                            break block43;
                        }
                        catch (Exception e) {
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.tx.jta.impl.TransactionState.setState", (String)"416", (Object)this);
                            if (tc.isEventEnabled()) {
                                Tr.event((TraceComponent)tc, (String)"addData failed during setState!", (Object[])new Object[0]);
                            }
                            break block43;
                        }
                    }
                    if (!this._loggingFailed) {
                        try {
                            this._tranLog = this._tran.getLog();
                            if (this._tranLog != null) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"Create sections in the Log for Recovery Coordinator", (Object[])new Object[0]);
                                }
                                if (this._tran.isRAImport()) {
                                    JCARecoveryData jcard = this._tran.getJCARecoveryData();
                                    if (tc.isEventEnabled()) {
                                        Tr.event((TraceComponent)tc, (String)("TX is imported from provider: " + jcard.getWrapper().getProviderId()), (Object[])new Object[0]);
                                    }
                                    jcard.logRecoveryEntry();
                                    RecoverableUnitSection raSection = this._tranLog.createSection(7, true);
                                    byte[] longBytes = Util.longToBytes(jcard.getRecoveryId());
                                    byte[] xidBytes = ((XidImpl)this._tran.getJCAXid()).toBytes();
                                    byte[] logBytes = new byte[xidBytes.length + longBytes.length];
                                    System.arraycopy(longBytes, 0, logBytes, 0, longBytes.length);
                                    System.arraycopy(xidBytes, 0, logBytes, longBytes.length, xidBytes.length);
                                    raSection.addData(logBytes);
                                } else if (this._tran.isSubordinate()) {
                                    this.logSupOrRecCoord();
                                } else if (tc.isEventEnabled()) {
                                    Tr.event((TraceComponent)tc, (String)"Superior transaction.", (Object[])new Object[0]);
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"Create sections in the Log for XID and TransactionState", (Object[])new Object[0]);
                                }
                                RecoverableUnitSection gtidSection = this._tranLog.createSection(3, true);
                                gtidSection.addData(this._tran.getXidImpl().toBytes());
                                this._logSection = this._tranLog.createSection(0, true);
                                this._logSection.addData(this.byteData);
                            }
                        }
                        catch (Exception e) {
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.tx.jta.impl.TransactionState.setState", (String)"408", (Object)this);
                            if (tc.isEntryEnabled()) {
                                Tr.exit((TraceComponent)tc, (String)"setState : CreateSection failed", (Object)e);
                            }
                            this._logSection = null;
                            this._loggingFailed = true;
                            throw new SystemException(e.toString());
                        }
                    }
                }
            }
            if (this._logSection != null) {
                block44: {
                    if (newState == 4 || newState == 6 || newState == 5 || this._tran.isSubordinate() && newState == 8) {
                        this.byteData[0] = (byte)this._state;
                        try {
                            this._logSection.addData(this.byteData);
                        }
                        catch (Exception e) {
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.tx.jta.impl.TransactionState.setState", (String)"500", (Object)this);
                            if (!tc.isEventEnabled()) break block44;
                            Tr.event((TraceComponent)tc, (String)"addData failed during setState!", (Object[])new Object[0]);
                        }
                    }
                }
                try {
                    switch (newState) {
                        case 2: {
                            if (!this._tran.isSubordinate()) break;
                            this._tranLog.forceSections();
                            break;
                        }
                        case 3: 
                        case 5: {
                            this._tranLog.forceSections();
                            break;
                        }
                        case 7: 
                        case 8: {
                            if (!this._tran.isSubordinate()) break;
                            this._tranLog.forceSections();
                            break;
                        }
                        case 4: 
                        case 6: {
                            break;
                        }
                        case 9: {
                            this._tranLog.forceSections();
                        }
                    }
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.tx.jta.impl.TransactionState.setState", (String)"505", (Object)this);
                    if (_partnerLogTable != null) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.Transaction.JTA.TransactionState.setState", (String)"506", (Object)_partnerLogTable);
                    }
                    if (e instanceof LogFullException) {
                        Tr.error((TraceComponent)tc, (String)"WTRN0083_LOG_FULL_ERROR", (Object[])new Object[]{this._tran.getTranName()});
                    } else {
                        Tr.error((TraceComponent)tc, (String)"WTRN0066_LOG_WRITE_ERROR", (Object[])new Object[]{e});
                    }
                    if (oldState == 1) {
                        this._logSection = null;
                        this._loggingFailed = true;
                        this._state = oldState;
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"setState: Error writing log record", (Object)e);
                    }
                    throw new SystemException(e.toString());
                }
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("TransactionState change FAILED from: " + TransactionState.stateToString(this._state) + ", to: " + TransactionState.stateToString(newState)), (Object[])new Object[0]);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"setState");
            }
            throw new SystemException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setState");
        }
    }

    protected void logSupOrRecCoord() throws Exception {
    }

    public void setCommittingStateUnlogged() {
        if (this._state == 1 || this._state == 9) {
            this._state = 3;
        }
    }

    public void setRollingBackStateUnlogged() {
        if (this._state == 1 || this._state == 9) {
            this._state = 5;
        }
    }

    public int getState() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getState: {0}", (Object[])new Object[]{TransactionState.stateToString(this._state)});
        }
        return this._state;
    }

    public void reset() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"reset", (Object[])new Object[0]);
        }
        this._state = -1;
    }

    public static String stateToString(int state) {
        switch (state) {
            case -1: {
                return "STATE_NONE";
            }
            case 0: {
                return "STATE_ACTIVE";
            }
            case 1: {
                return "STATE_PREPARING";
            }
            case 2: {
                return "STATE_PREPARED";
            }
            case 10: {
                return "STATE_COMMITTING_ONE_PHASE";
            }
            case 3: {
                return "STATE_COMMITTING";
            }
            case 4: {
                return "STATE_COMMITTED";
            }
            case 5: {
                return "STATE_ROLLING_BACK";
            }
            case 6: {
                return "STATE_ROLLED_BACK";
            }
            case 7: {
                return "STATE_HEURISTIC_ON_COMMIT";
            }
            case 8: {
                return "STATE_HEURISTIC_ON_ROLLBACK";
            }
            case 9: {
                return "STATE_LAST_PARTICIPANT";
            }
        }
        return "STATE_NONE";
    }

    public String toString() {
        return TransactionState.stateToString(this._state);
    }

    static {
        FailureScopeController fsc = Configuration.getFailureScopeController();
        _partnerLogTable = fsc != null ? fsc.getPartnerLogTable() : null;
        validStateChange = new boolean[][]{{false, true, false, false, true, true, false, false, false, false, true}, {false, false, true, true, true, true, true, true, true, true, false}, {false, false, false, true, false, true, false, false, false, true, false}, {false, false, false, false, true, false, false, true, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, true, false, true, false, false}, {false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, true, false, true, false, false, false, false}, {false, false, false, false, false, false, true, false, false, false, false}, {false, false, false, true, false, true, false, false, false, false, false}, {false, false, false, false, true, false, true, false, false, false, false}};
    }
}

