/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.validator;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;

public class KeyStores {
    private KeyStores() {
    }

    private static boolean isValid(X509Certificate cert, Date date) {
        try {
            cert.checkValidity(date);
            return true;
        }
        catch (CertificateExpiredException e2) {
            return false;
        }
        catch (CertificateNotYetValidException e3) {
            return true;
        }
    }

    public static Set getTrustedCerts(KeyStore ks) {
        HashSet<Certificate> set = new HashSet<Certificate>();
        Date date = new Date();
        try {
            Enumeration<String> e2 = ks.aliases();
            while (e2.hasMoreElements()) {
                X509Certificate cert;
                Certificate[] certs;
                String alias = e2.nextElement();
                if (ks.isCertificateEntry(alias)) {
                    Certificate cert2 = ks.getCertificate(alias);
                    if (!(cert2 instanceof X509Certificate) || !KeyStores.isValid((X509Certificate)cert2, date)) continue;
                    set.add(cert2);
                    continue;
                }
                if (!ks.isKeyEntry(alias) || (certs = ks.getCertificateChain(alias)) == null || certs.length <= 0 || !(certs[0] instanceof X509Certificate) || !KeyStores.isValid(cert = (X509Certificate)certs[0], date)) continue;
                set.add(cert);
            }
        }
        catch (KeyStoreException keyStoreException) {
            // empty catch block
        }
        return set;
    }
}

