/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.util.calendar;

public class CalendarUtils {
    public static final boolean isGregorianLeapYear(int gregorianYear) {
        return gregorianYear % 4 == 0 && (gregorianYear % 100 != 0 || gregorianYear % 400 == 0);
    }

    public static final boolean isJulianLeapYear(int normalizedJulianYear) {
        return normalizedJulianYear % 4 == 0;
    }

    public static final long floorDivide(long n2, long d2) {
        return n2 >= 0L ? n2 / d2 : (n2 + 1L) / d2 - 1L;
    }

    public static final int floorDivide(int n2, int d2) {
        return n2 >= 0 ? n2 / d2 : (n2 + 1) / d2 - 1;
    }

    public static final int floorDivide(int n2, int d2, int[] r2) {
        if (n2 >= 0) {
            r2[0] = n2 % d2;
            return n2 / d2;
        }
        int q2 = (n2 + 1) / d2 - 1;
        r2[0] = n2 - q2 * d2;
        return q2;
    }

    public static final int floorDivide(long n2, int d2, int[] r2) {
        if (n2 >= 0L) {
            r2[0] = (int)(n2 % (long)d2);
            return (int)(n2 / (long)d2);
        }
        int q2 = (int)((n2 + 1L) / (long)d2 - 1L);
        r2[0] = (int)(n2 - (long)(q2 * d2));
        return q2;
    }

    public static final long mod(long x2, long y2) {
        return x2 - y2 * CalendarUtils.floorDivide(x2, y2);
    }

    public static final int mod(int x2, int y2) {
        return x2 - y2 * CalendarUtils.floorDivide(x2, y2);
    }

    public static final int amod(int x2, int y2) {
        int z2 = CalendarUtils.mod(x2, y2);
        return z2 == 0 ? y2 : z2;
    }

    public static final long amod(long x2, long y2) {
        long z2 = CalendarUtils.mod(x2, y2);
        return z2 == 0L ? y2 : z2;
    }

    public static final StringBuilder sprintf0d(StringBuilder sb2, int value, int width) {
        int i2;
        long d2 = value;
        if (d2 < 0L) {
            sb2.append('-');
            d2 = -d2;
            --width;
        }
        int n2 = 10;
        for (i2 = 2; i2 < width; ++i2) {
            n2 *= 10;
        }
        for (i2 = 1; i2 < width && d2 < (long)n2; ++i2) {
            sb2.append('0');
            n2 /= 10;
        }
        sb2.append(d2);
        return sb2;
    }

    public static final StringBuffer sprintf0d(StringBuffer sb2, int value, int width) {
        int i2;
        long d2 = value;
        if (d2 < 0L) {
            sb2.append('-');
            d2 = -d2;
            --width;
        }
        int n2 = 10;
        for (i2 = 2; i2 < width; ++i2) {
            n2 *= 10;
        }
        for (i2 = 1; i2 < width && d2 < (long)n2; ++i2) {
            sb2.append('0');
            n2 /= 10;
        }
        sb2.append(d2);
        return sb2;
    }
}

