/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl.store.itemstreams;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.LinkHandler;
import com.ibm.ws.sib.processor.impl.store.itemstreams.PtoPLocalMsgsItemStream;
import com.ibm.ws.sib.processor.runtime.impl.ControlAdapter;
import com.ibm.ws.sib.processor.runtime.impl.MPRuntimeEvent;
import com.ibm.ws.sib.processor.runtime.impl.MQLinkQueuePoint;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.Properties;

public class MQLinkMessageItemStream
extends PtoPLocalMsgsItemStream {
    private static TraceComponent tc = SibTr.register(MQLinkMessageItemStream.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");

    public MQLinkMessageItemStream() {
    }

    public MQLinkMessageItemStream(BaseDestinationHandler destinationHandler, SIBUuid8 messagingEngineUuid) {
        super(destinationHandler, messagingEngineUuid);
    }

    @Override
    public void createControlAdapter() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createControlAdapter");
        }
        this.controlAdapter = new MQLinkQueuePoint(this.destinationHandler.getMessageProcessor(), this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createControlAdapter");
        }
    }

    public void fireDepthThresholdReachedEvent(ControlAdapter cAdapter, boolean reachedHigh, long numMsgs) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"fireDepthThresholdReachedEvent", (Object)new Object[]{cAdapter, new Boolean(reachedHigh), new Long(numMsgs)});
        }
        String destinationName = this.destinationHandler.getName();
        String meName = this.destinationHandler.getMessageProcessor().getMessagingEngineName();
        if (this.mp.getCustomProperties().getOutputLinkThresholdEventsToLog() && this.destinationHandler.isLink() || this.mp.getCustomProperties().getOutputDestinationThresholdEventsToLog() && !this.destinationHandler.isLink()) {
            if (reachedHigh) {
                SibTr.info((TraceComponent)tc, (String)"NOTIFY_MQLINK_DEPTH_THRESHOLD_REACHED_CWSIP0557", (Object)new Object[]{destinationName, meName});
            } else {
                SibTr.info((TraceComponent)tc, (String)"NOTIFY_MQLINK_DEPTH_THRESHOLD_REACHED_CWSIP0558", (Object)new Object[]{destinationName, meName});
            }
        }
        if (this._isEventNotificationEnabled) {
            if (cAdapter != null) {
                String message = null;
                message = reachedHigh ? nls.getFormattedMessage("NOTIFY_MQLINK_DEPTH_THRESHOLD_REACHED_CWSIP0557", new Object[]{destinationName, meName}, null) : nls.getFormattedMessage("NOTIFY_MQLINK_DEPTH_THRESHOLD_REACHED_CWSIP0558", new Object[]{destinationName, meName}, null);
                Properties props = new Properties();
                props.put("mqlink.name", destinationName);
                props.put("mqlink.UUID", this.destinationHandler.getUuid().toString());
                if (reachedHigh) {
                    props.put("depth.threshold.reached", "depth.threshold.reached.high");
                } else {
                    props.put("depth.threshold.reached", "depth.threshold.reached.low");
                }
                props.put("messages", String.valueOf(numMsgs));
                MPRuntimeEvent MPevent = new MPRuntimeEvent("SIB.mqlink.depth.threshold.reached", message, props);
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"fireDepthThresholdReachedEvent", (Object)("Drive runtimeEventOccurred against Control adapter: " + cAdapter));
                }
                cAdapter.runtimeEventOccurred(MPevent);
            } else if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"fireDepthThresholdReachedEvent", (Object)"Control adapter is null, cannot fire event");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"fireDepthThresholdReachedEvent");
        }
    }

    @Override
    protected void issueDepthIntervalMessage(long depth) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"issueDepthIntervalMessage", (Object)new Long(depth));
        }
        SibTr.info((TraceComponent)tc, (String)"REMOTE_LINK_DESTINATION_DEPTH_INTERVAL_REACHED_CWSIP0789", (Object)new Object[]{new Long(depth), this.destinationHandler.getMessageProcessor().getMessagingEngineName(), ((LinkHandler)this.destinationHandler).getBusName(), this.destinationHandler.getName()});
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"issueDepthIntervalMessage");
        }
    }
}

