/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.metrics30.internal.micrometer;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.NavigableSet;
import java.util.TreeSet;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class PercentileHistogramBuckets {
    private static final int DIGITS = 2;
    private static final NavigableSet<Double> PERCENTILE_BUCKETS;
    static final long serialVersionUID = -4872008376120497541L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static NavigableSet<Double> buckets(double minimumBucket, double maximumBucket) {
        return PERCENTILE_BUCKETS.subSet(minimumBucket, true, maximumBucket, true);
    }

    public static NavigableSet<Double> getDefaultBuckets(double minimumBucket, double maximumBucket, boolean isTimer) {
        TreeSet<Double> defaultBuckets = new TreeSet<Double>();
        if (isTimer) {
            for (double nextValue : PercentileHistogramBuckets.buckets(0.0, Double.MAX_VALUE)) {
                BigDecimal decimalValue = new BigDecimal(nextValue / 1.0E9);
                decimalValue = decimalValue.setScale(9, RoundingMode.HALF_UP).stripTrailingZeros();
                BigDecimal minValue = minimumBucket >= 0.001 ? new BigDecimal(minimumBucket) : new BigDecimal(0.001);
                BigDecimal maxValue = maximumBucket <= 30.0 ? new BigDecimal(maximumBucket) : new BigDecimal(30);
                if (decimalValue.compareTo(maxValue) >= 0 || decimalValue.compareTo(minValue) <= 0) continue;
                defaultBuckets.add(decimalValue.doubleValue());
            }
            if (!defaultBuckets.contains(minimumBucket) && minimumBucket >= 0.001) {
                BigDecimal minBucketValue = new BigDecimal(minimumBucket).setScale(9, RoundingMode.HALF_UP).stripTrailingZeros();
                defaultBuckets.add(minBucketValue.doubleValue());
            }
            if (!defaultBuckets.contains(maximumBucket) && maximumBucket <= 30.0) {
                BigDecimal maxBucketValue = new BigDecimal(maximumBucket).setScale(9, RoundingMode.HALF_UP).stripTrailingZeros();
                defaultBuckets.add(maxBucketValue.doubleValue());
            }
        } else {
            Double minValue = minimumBucket >= 1.0 ? minimumBucket : 1.0;
            Double maxValue = maximumBucket <= Double.MAX_VALUE ? maximumBucket : Double.MAX_VALUE;
            NavigableSet<Double> originalBuckets = PercentileHistogramBuckets.buckets(minValue, maxValue);
            defaultBuckets.addAll(originalBuckets);
            if (!defaultBuckets.contains(minimumBucket)) {
                BigDecimal minBucketValue = new BigDecimal(minimumBucket).setScale(9, RoundingMode.HALF_UP).stripTrailingZeros();
                defaultBuckets.add(minBucketValue.doubleValue());
            }
            if (!defaultBuckets.contains(maximumBucket)) {
                BigDecimal maxBucketValue = new BigDecimal(maximumBucket).setScale(9, RoundingMode.HALF_UP).stripTrailingZeros();
                defaultBuckets.add(maxBucketValue.doubleValue());
            }
        }
        return defaultBuckets;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.metrics30.internal.micrometer.PercentileHistogramBuckets", PercentileHistogramBuckets.class, null, null);
        PERCENTILE_BUCKETS = new TreeSet<Double>();
        PERCENTILE_BUCKETS.add(1.0);
        PERCENTILE_BUCKETS.add(2.0);
        PERCENTILE_BUCKETS.add(3.0);
        for (int exp = 2; exp < 64; exp += 2) {
            long current;
            long delta = current / 3L;
            long next = (current << 2) - delta;
            for (current = 1L << exp; current < next; current += delta) {
                PERCENTILE_BUCKETS.add(Double.valueOf(current));
            }
        }
        PERCENTILE_BUCKETS.add(Double.POSITIVE_INFINITY);
    }
}

