/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config.utility.actions;

import com.ibm.websphere.crypto.InvalidPasswordEncodingException;
import com.ibm.websphere.crypto.PasswordUtil;
import com.ibm.websphere.crypto.UnsupportedCryptoAlgorithmException;
import com.ibm.ws.config.utility.ConfigUtilityAction;
import com.ibm.ws.config.utility.IFileUtility;
import com.ibm.ws.config.utility.TaskErrorException;
import com.ibm.ws.config.utility.utils.CommandUtils;
import com.ibm.ws.config.utility.utils.ConsoleWrapper;
import com.ibm.ws.config.utility.utils.EncodingProperty;
import com.ibm.ws.config.utility.utils.RepositoryAccessUtility;
import com.ibm.ws.config.utility.utils.VariableSubstituter;
import com.ibm.ws.crypto.util.AesConfigFileParser;
import com.ibm.ws.crypto.util.UnsupportedConfigurationException;
import com.ibm.ws.install.InstallException;
import com.ibm.ws.kernel.productinfo.ProductInfo;
import com.ibm.ws.repository.exceptions.RepositoryException;
import com.ibm.wsspi.security.crypto.PasswordEncryptException;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class InstallAction
implements ConfigUtilityAction {
    protected static final boolean IS_BETA_EDITION = ProductInfo.getBetaEdition();
    private final IFileUtility fileUtility;
    private final String scriptName;
    static final String AES_ENCODING = "aes";
    static final String XOR_ENCODING = "xor";
    static final String ARG_OPT_INFO = "--info";
    static final String ARG_OPT_LOCAL = "--useLocalFile";
    static final String ARG_OPT_ENCODING = "--encoding";
    static final String ARG_OPT_KEY = "--key";
    static final String ARG_OPT_BASE64_KEY = "--base64Key";
    static final String ARG_OPT_AES_CONFIG_FILE = "--aesConfigFile";
    static final String ARG_REQ_CREATE_CONFIG_FILE = "--createConfigFile";
    static final String VAR_ADMIN_PASSWORD = "adminPassword";
    static final String VAR_KEYSTORE_PASSWORD = "keystorePassword";
    static final String VAR_HOST_NAME = "hostName";
    static final String VAR_HTTP_PORT = "httpPort";
    static final String VAR_HTTPS_PORT = "httpsPort";
    static final String VAR_WRITE_PATH = "writePath";
    static final String VAR_READ_PATH = "readPath";
    private final Map<String, String> defaultValues = new HashMap<String, String>();
    private final Map<String, String> multiValuedVariables = new HashMap<String, String>();
    static final String SLASH = "/";
    static final String NL = System.getProperty("line.separator");
    public static final char EXTENSION_SEPARATOR = '.';
    private static final char UNIX_SEPARATOR = '/';
    private static final char WINDOWS_SEPARATOR = '\\';
    private ConsoleWrapper stdin;
    private PrintStream stdout;
    private PrintStream stderr;
    private final Collection<String> knownArgs = new HashSet<String>();
    private final Collection<String> promptableArgs = new HashSet<String>();
    private final Collection<String> encodableVariables = new HashSet<String>();

    public InstallAction(String scriptName, IFileUtility fileUtility) {
        this.scriptName = scriptName;
        this.fileUtility = fileUtility;
        this.promptableArgs.add(VAR_ADMIN_PASSWORD);
        this.promptableArgs.add(VAR_KEYSTORE_PASSWORD);
        this.encodableVariables.add(VAR_ADMIN_PASSWORD);
        this.encodableVariables.add(VAR_KEYSTORE_PASSWORD);
        this.knownArgs.add(ARG_OPT_LOCAL);
        this.knownArgs.add(ARG_OPT_INFO);
        this.knownArgs.add(ARG_REQ_CREATE_CONFIG_FILE);
        this.knownArgs.add(ARG_OPT_ENCODING);
        this.knownArgs.add(ARG_OPT_KEY);
        this.knownArgs.add(ARG_OPT_BASE64_KEY);
        this.knownArgs.add(ARG_OPT_AES_CONFIG_FILE);
        this.defaultValues.put(VAR_HOST_NAME, "*");
        this.defaultValues.put(VAR_HTTP_PORT, "9080");
        this.defaultValues.put(VAR_HTTPS_PORT, "9443");
        this.multiValuedVariables.put(VAR_READ_PATH, "</readDir>" + NL + "        <readDir>%s");
        this.multiValuedVariables.put(VAR_WRITE_PATH, "</writeDir>" + NL + "        <writeDir>%s");
    }

    @Override
    public void handleAction(ConsoleWrapper stdin, PrintStream stdout, PrintStream stderr, String[] args) throws TaskErrorException, RepositoryException, InstallException {
        String snippetName;
        this.stdin = stdin;
        this.stdout = stdout;
        this.stderr = stderr;
        StringBuilder snippetText = null;
        Boolean localFile = false;
        localFile = this.checkForArgument(ARG_OPT_LOCAL, args);
        if (localFile.booleanValue()) {
            snippetName = "localConfigSnippet";
            snippetText = this.readConfigSnippet(this.getArgumentValue(ARG_OPT_LOCAL, args, null));
        } else {
            if (args.length < 2) {
                this.abort(this.getMessage("missingConfigSnippetName", new Object[0]));
            }
            if (!this.looksLikeSnippetName(snippetName = args[1]).booleanValue()) {
                this.abort(this.getMessage("missingConfigSnippetName", new Object[0]));
            }
            stdout.println(this.getMessage("generate.download", new Object[0]));
            snippetText = this.retrieveConfigSnippet(snippetName);
        }
        if (snippetText == null) {
            this.abort(this.getMessage("download.invalidSnippet", new Object[0]));
        }
        List<String> snippetVariables = VariableSubstituter.getAllVariables(snippetText);
        this.knownArgs.addAll(snippetVariables);
        this.validateArgumentList(args, snippetVariables, localFile);
        if (this.checkForArgument(ARG_OPT_INFO, args).booleanValue()) {
            if (!snippetName.equals("localConfigSnippet")) {
                stdout.println(NL + RepositoryAccessUtility.getConfigSnippetDescription(snippetName));
                stdout.println(this.getMessage("info.allVariables", new Object[0]));
                stdout.println(snippetVariables.toString());
                return;
            }
            stdout.println(this.getMessage("info.allVariables", new Object[0]));
            stdout.println(snippetVariables.toString());
            return;
        }
        HashMap<String, String> substitutionMap = this.createVariableSubstitutionMap(args, snippetVariables);
        String encoding = this.getArgumentValue(ARG_OPT_ENCODING, args, XOR_ENCODING);
        String aesConfigFile = this.getArgumentValue(ARG_OPT_AES_CONFIG_FILE, args, null);
        String key = this.getArgumentValue(ARG_OPT_KEY, args, null);
        String base64Key = this.getArgumentValue(ARG_OPT_BASE64_KEY, args, null);
        EncodingProperty prop = this.validateEncoding(encoding, key, aesConfigFile, base64Key);
        this.encodeAllEncodableVariables(substitutionMap, prop);
        StringBuilder sb = VariableSubstituter.substitute(snippetText, substitutionMap);
        stdout.println(NL + this.createConfigFile(args, snippetName, sb.toString()) + NL);
        stdout.println(this.getMessage("generate.configureSecurity", new Object[0]));
    }

    @Override
    public String getActionName() {
        return "install";
    }

    private Boolean looksLikeSnippetName(String arg) {
        if (arg == null || arg.isEmpty() || arg.startsWith("-")) {
            return false;
        }
        return true;
    }

    private Boolean checkForArgument(String arg, String[] args) {
        String argName = this.getArgName(arg);
        for (int i = 0; i < args.length; ++i) {
            String currentArgName = this.getArgName(args[i]);
            if (!currentArgName.equalsIgnoreCase(argName)) continue;
            return true;
        }
        return false;
    }

    private StringBuilder retrieveConfigSnippet(String configName) throws TaskErrorException, InstallException {
        StringBuilder snippet = null;
        try {
            snippet = RepositoryAccessUtility.getConfigSnippet(configName);
        }
        catch (RepositoryException e) {
            this.abort(this.getMessage("download.failedRepoAccess", new Object[0]));
        }
        catch (IOException e) {
            this.abort(this.getMessage("download.ioError", new Object[0]));
        }
        return snippet;
    }

    private void abort(String message) throws TaskErrorException {
        this.stdout.println(this.getMessage("generate.abort", new Object[0]));
        throw new TaskErrorException(message);
    }

    private void validateArgumentList(String[] args, List<String> snippetVariables, Boolean isLocalFile) {
        if (isLocalFile.booleanValue()) {
            if (args.length > 3 && this.checkForArgument(ARG_OPT_INFO, args).booleanValue()) {
                throw new IllegalArgumentException(this.getMessage("info.invalidUsage", new Object[0]));
            }
            for (int i = 1; i < args.length; ++i) {
                String argName = this.getArgName(args[i]);
                String value = this.getValue(args[i]);
                if (!this.isKnownArgument(argName)) {
                    throw new IllegalArgumentException(this.getMessage("invalidArg", argName));
                }
                if (this.promptableArgs.contains(argName) || value != null || this.isInfoArg(argName)) continue;
                throw new IllegalArgumentException(this.getMessage("missingValue", argName));
            }
        } else {
            if (args.length > 3 && this.isInfoArg(this.getArgName(args[1]))) {
                throw new IllegalArgumentException(this.getMessage("info.invalidUsage", new Object[0]));
            }
            for (int i = 2; i < args.length; ++i) {
                String argName = this.getArgName(args[i]);
                String value = this.getValue(args[i]);
                if (!this.isKnownArgument(argName)) {
                    throw new IllegalArgumentException(this.getMessage("invalidArg", argName));
                }
                if (this.promptableArgs.contains(argName) || value != null || this.isInfoArg(argName)) continue;
                throw new IllegalArgumentException(this.getMessage("missingValue", argName));
            }
        }
    }

    private String getMessage(String key, Object ... args) {
        return CommandUtils.getMessage(key, args);
    }

    private boolean isKnownArgument(String arg) {
        String argName = this.getArgName(arg);
        for (String key : this.knownArgs) {
            if (!key.equalsIgnoreCase(argName)) continue;
            return true;
        }
        return false;
    }

    private String getArgName(String arg) {
        if (this.isValueReplacementArg(arg)) {
            return arg.substring(3).split("=")[0];
        }
        return arg.split("=")[0];
    }

    private HashMap<String, String> createVariableSubstitutionMap(String[] args, List<String> allVariables) {
        HashMap<String, String> substitutionMap = new HashMap<String, String>();
        for (String var : allVariables) {
            String argumentValue;
            if (this.multiValuedVariables.containsKey(var)) {
                List<String> valueList = this.getArgumentList(var, args, null);
                argumentValue = null;
                if (valueList != null) {
                    StringBuilder buffer = new StringBuilder();
                    buffer.append(valueList.get(0));
                    for (int i = 1; i < valueList.size(); ++i) {
                        buffer.append(String.format(this.multiValuedVariables.get(var), valueList.get(i)));
                    }
                    argumentValue = buffer.toString();
                }
            } else {
                argumentValue = this.getArgumentValue(var, args, this.defaultValues.get(var));
            }
            substitutionMap.put(var, argumentValue);
        }
        return substitutionMap;
    }

    private void encodeAllEncodableVariables(HashMap<String, String> replacements, EncodingProperty prop) {
        for (Map.Entry<String, String> entry : replacements.entrySet()) {
            if (!this.encodableVariables.contains(entry.getKey()) || entry.getValue() == null || entry.getValue().isEmpty()) continue;
            String encodedPassword = this.encodePassword(entry.getKey(), entry.getValue(), prop);
            replacements.put(entry.getKey(), encodedPassword);
        }
    }

    private boolean isValueReplacementArg(String arg) {
        return arg.startsWith("--v") || arg.startsWith("--V");
    }

    protected EncodingProperty validateEncoding(String encoding, String key, String aesConfigFile, String base64Key) throws TaskErrorException {
        EncodingProperty prop = new EncodingProperty(encoding, null, null);
        if (AES_ENCODING.equals(encoding)) {
            List aesKeyInputs = Arrays.asList(aesConfigFile, key, base64Key).stream().filter(item -> item != null).collect(Collectors.toList());
            if (aesKeyInputs.isEmpty()) {
                this.abort(this.getMessage("encoding.aesRequiresKey", new Object[0]));
            } else if (aesKeyInputs.size() > 1) {
                this.abort(this.getMessage("encoding.tooManyKeys", new Object[0]));
            } else {
                prop = aesConfigFile != null ? this.parseAesEncryptionFile(aesConfigFile) : (key != null ? new EncodingProperty(encoding, "crypto.key", key) : new EncodingProperty(encoding, "aes.key", base64Key));
            }
        } else if (XOR_ENCODING.equals(encoding) && key != null) {
            this.abort(this.getMessage("encoding.xorDoesNotSupportKey", new Object[0]));
        } else if (!(XOR_ENCODING.equals(encoding) || AES_ENCODING.equals(encoding) || this.isSupportedCustomEncoding(encoding))) {
            this.abort(this.getMessage("encoding.unsupportedEncoding", encoding));
        }
        return prop;
    }

    private boolean isSupportedCustomEncoding(String encoding) {
        return encoding != null && encoding.length() > 0 && PasswordUtil.isValidCryptoAlgorithm((String)encoding);
    }

    private String getArgumentValue(String arg, String[] args, String defaultValue) {
        String argName = this.getArgName(arg);
        for (int i = 0; i < args.length; ++i) {
            String currentArgName = this.getArgName(args[i]);
            if (!currentArgName.equalsIgnoreCase(argName)) continue;
            String value = this.getValue(args[i]);
            if (value == null && this.promptableArgs.contains(argName)) {
                return this.promptForText(arg);
            }
            return value;
        }
        return defaultValue;
    }

    protected List<String> getArgumentList(String arg, String[] args, List<String> defalt) {
        ArrayList<String> ret = new ArrayList<String>();
        String argName = this.getArgName(arg);
        for (int i = 0; i < args.length; ++i) {
            String currentArgName = this.getArgName(args[i]);
            if (!currentArgName.equalsIgnoreCase(argName)) continue;
            String value = this.getValue(args[i]);
            ret.add(value);
        }
        if (ret.isEmpty()) {
            return defalt;
        }
        return ret;
    }

    private String getValue(String arg) {
        String[] split = arg.split("=");
        if (split.length == 1) {
            return null;
        }
        if (split.length == 2) {
            if (arg.endsWith("=")) {
                return split[1] + "=";
            }
            return split[1];
        }
        StringBuffer value = new StringBuffer();
        for (int i = 1; i < split.length; ++i) {
            value.append(split[i]);
            if (i >= split.length - 1) continue;
            value.append("=");
        }
        if (arg.endsWith("=")) {
            value.append("=");
        }
        return value.toString();
    }

    private String promptForText(String arg) {
        String read1 = this.stdin.readMaskedText(this.getMessage("password.enterText", arg) + " ");
        String read2 = this.stdin.readMaskedText(this.getMessage("password.reenterText", arg) + " ");
        if (read1 == null && read2 == null) {
            throw new IllegalArgumentException("Unable to read either entry. Aborting prompt.");
        }
        if (read1 == null || read2 == null) {
            this.stdout.println(this.getMessage("password.readError", new Object[0]));
            return this.promptForText(arg);
        }
        if (read1.equals(read2)) {
            return read1;
        }
        this.stdout.println(this.getMessage("password.entriesDidNotMatch", new Object[0]));
        return this.promptForText(arg);
    }

    private String encodePassword(String password, String arg, EncodingProperty prop) {
        String encoded = null;
        try {
            encoded = PasswordUtil.encode((String)password, (String)prop.getEncoding(), prop.getMap());
        }
        catch (InvalidPasswordEncodingException e) {
            e.printStackTrace(this.stderr);
        }
        catch (UnsupportedCryptoAlgorithmException e) {
            e.printStackTrace(this.stderr);
        }
        if (encoded == null) {
            this.stdout.println(this.getMessage("common.encodeError", arg));
        }
        return encoded;
    }

    private StringBuilder readConfigSnippet(String filePath) throws TaskErrorException {
        File localConfigSnippet;
        if (filePath == null || filePath.isEmpty()) {
            this.abort(this.getMessage("fileUtility.emptyPath", new Object[0]));
        }
        if (!this.fileUtility.exists(localConfigSnippet = new File(filePath))) {
            this.abort(this.getMessage("fileUtility.fileNotFound", new Object[0]));
        }
        StringBuilder configSnippet = null;
        try {
            configSnippet = this.fileUtility.readFileToStringBuilder(localConfigSnippet);
        }
        catch (IOException e) {
            this.abort(this.getMessage("fileUtility.failedToRead", new Object[0]));
        }
        return configSnippet;
    }

    private String createConfigFile(String[] args, String snippetName, String xmlSnippet) throws TaskErrorException {
        String utilityName = this.scriptName;
        String targetFilepath = this.getArgumentValue(ARG_REQ_CREATE_CONFIG_FILE, args, null);
        if (targetFilepath == null || targetFilepath.isEmpty()) {
            return xmlSnippet;
        }
        File outputFile = this.generateConfigFileName(utilityName, snippetName, targetFilepath);
        this.fileUtility.createParentDirectory(this.stdout, outputFile);
        this.fileUtility.writeToFile(this.stderr, xmlSnippet, outputFile);
        String includeSnippet = "    <include location=\"" + this.getIncludePath(outputFile) + "\" />" + NL;
        return includeSnippet;
    }

    private boolean isInfoArg(String arg) {
        return arg != null && arg.equalsIgnoreCase(ARG_OPT_INFO);
    }

    private File generateConfigFileName(String utilityName, String snippetName, String targetFilepath) throws TaskErrorException {
        File outputFile = new File(targetFilepath);
        if (this.fileUtility.isDirectory(outputFile)) {
            outputFile = new File(outputFile, utilityName + "-" + snippetName + "-include.xml");
        }
        if (this.fileUtility.exists(outputFile)) {
            String filePath = InstallAction.removeExtension(outputFile.getPath());
            String fileExt = InstallAction.getExtension(outputFile.getPath());
            int counter = 1;
            do {
                outputFile = new File(filePath + counter + "." + fileExt);
                ++counter;
            } while (this.fileUtility.exists(outputFile));
        }
        return outputFile;
    }

    private String getIncludePath(File outputFile) {
        File fWLP_USER = new File(this.fileUtility.getUserDir());
        if (outputFile.getAbsolutePath().startsWith(fWLP_USER.getAbsolutePath())) {
            return outputFile.getAbsolutePath().replace(fWLP_USER.getAbsolutePath(), "${wlp.user.dir}");
        }
        File fWLP_INSTALL = new File(this.fileUtility.getInstallDir());
        if (outputFile.getAbsolutePath().startsWith(fWLP_INSTALL.getAbsolutePath())) {
            return outputFile.getAbsolutePath().replace(fWLP_INSTALL.getAbsolutePath(), "${wlp.install.dir}");
        }
        return outputFile.getAbsolutePath();
    }

    public static String getExtension(String filename) {
        if (filename == null) {
            return null;
        }
        int index = InstallAction.indexOfExtension(filename);
        if (index == -1) {
            return "";
        }
        return filename.substring(index + 1);
    }

    public static String removeExtension(String filename) {
        if (filename == null) {
            return null;
        }
        int index = InstallAction.indexOfExtension(filename);
        if (index == -1) {
            return filename;
        }
        return filename.substring(0, index);
    }

    public static int indexOfExtension(String filename) {
        if (filename == null) {
            return -1;
        }
        int extensionPos = filename.lastIndexOf(46);
        int lastSeparator = InstallAction.indexOfLastSeparator(filename);
        return lastSeparator > extensionPos ? -1 : extensionPos;
    }

    public static int indexOfLastSeparator(String filename) {
        if (filename == null) {
            return -1;
        }
        int lastUnixPos = filename.lastIndexOf(47);
        int lastWindowsPos = filename.lastIndexOf(92);
        return Math.max(lastUnixPos, lastWindowsPos);
    }

    public EncodingProperty parseAesEncryptionFile(String pathToFile) throws TaskErrorException {
        try {
            Map props = AesConfigFileParser.parseAesEncryptionFile((String)pathToFile);
            EncodingProperty prop = props.containsKey("crypto.key") ? new EncodingProperty(AES_ENCODING, "crypto.key", (String)props.get("crypto.key")) : new EncodingProperty(AES_ENCODING, "aes.key", (String)props.get("aes.key"));
            return prop;
        }
        catch (PasswordEncryptException e) {
            this.abort(this.getMessage("encoding.failedToParseFile", pathToFile, e.getMessage()));
            return null;
        }
        catch (UnsupportedConfigurationException e) {
            throw new IllegalArgumentException(this.getMessage("encoding.aesConfigFileEncryptionAmbiguous", "wlp.aes.encryption.key", "wlp.password.encryption.key"), e);
        }
        catch (UnsupportedCryptoAlgorithmException e) {
            throw new IllegalArgumentException(this.getMessage("encoding.aesConfigFileMissingEncryptionVariables", pathToFile), e);
        }
    }

    private boolean isBlockedOption(String option) {
        if (IS_BETA_EDITION) {
            return false;
        }
        return this.getBetaOptions().stream().anyMatch(p -> option.endsWith((String)p));
    }

    protected List<String> getBetaOptions() {
        return new ArrayList<String>();
    }
}

