/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.cache.ref;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.CacheStatistics;
import com.ibm.ws.sib.msgstore.SevereMessageStoreException;
import com.ibm.ws.sib.msgstore.XmlConstants;
import com.ibm.ws.sib.msgstore.cache.ref.Indirection;
import com.ibm.ws.sib.msgstore.cache.ref.IndirectionCache;
import com.ibm.ws.sib.msgstore.cache.ref.IndirectionList;
import com.ibm.ws.sib.utils.ras.FormattedWriter;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.IOException;

final class StoredItemManager
extends IndirectionCache
implements XmlConstants {
    private static TraceComponent tc = SibTr.register(StoredItemManager.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private final IndirectionList _list = new IndirectionList();
    private long _maximumSize = 10000L;
    private long _maximumItemSize = 100000L;
    private long _totalCount = 0L;
    private long _totalDiscardCount = 0L;
    private long _totalDiscardSize = 0L;
    private long _totalRefusalCount = 0L;

    StoredItemManager(long maximumSize, long maximumItemSize) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)new Object[]{maximumSize, maximumItemSize});
        }
        this._maximumSize = maximumSize;
        this._maximumItemSize = maximumItemSize;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    private void _postAppendSlimming(Indirection indirection) {
        if (this._list.getCurrentSize() > this._maximumSize) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("begin discarding indirections as size (" + this._list.getCurrentSize() + ") > max (" + this._maximumSize + ")"));
            }
            while (this._list.getCurrentSize() > this._maximumSize) {
                Indirection removed = this._list.removeFirst();
                if (null == removed) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break;
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"list empty");
                    break;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("unlinking " + removed.getID()));
                }
                ++this._totalDiscardCount;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("end discarding indirections new size = " + this._list.getCurrentSize()));
            }
        }
    }

    public final long getCurrentCount() {
        return this._list.getCurrentCount();
    }

    public final long getCurrentSize() {
        return this._list.getCurrentSize();
    }

    public final long getDiscardableSize() {
        return this._list.getCurrentSize();
    }

    public final long getMaximumSize() {
        return this._maximumSize;
    }

    final CacheStatistics getStatistics() {
        return this;
    }

    public final long getTotalCount() {
        return this._totalCount;
    }

    public final long getTotalDiscardCount() {
        return this._totalDiscardCount;
    }

    public final long getTotalDiscardSize() {
        return this._totalDiscardSize;
    }

    public final long getTotalRefusalCount() {
        return this._totalRefusalCount;
    }

    public final long getTotalSize() {
        return this._totalDiscardSize;
    }

    @Override
    public final void unmanage(Indirection ind) throws SevereMessageStoreException {
        boolean unlinked = this._list.unlink(ind);
        if (unlinked && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("unlinked: " + ind.getID() + " (size=" + this._list.getCurrentCount() + ")"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void manage(Indirection ind, AbstractItem item) {
        if ((long)ind.getInMemoryItemSize() > this._maximumItemSize) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"item too large to cache, so just hold with weak reference");
            }
            StoredItemManager storedItemManager = this;
            synchronized (storedItemManager) {
                ++this._totalRefusalCount;
            }
        } else {
            boolean appended = this._list.append(ind, item);
            if (appended) {
                this._postAppendSlimming(ind);
            }
        }
    }

    public final synchronized void resetTotals() {
        this._totalDiscardCount = 0L;
        this._totalDiscardSize = 0L;
        this._totalCount = 0L;
        this._totalRefusalCount = 0L;
    }

    public final String toString() {
        return "StoredItemManager(" + this.hashCode() + ") size=" + this.getCurrentSize() + " max=" + this.getMaximumSize();
    }

    final void xmlWriteOn(FormattedWriter writer) throws IOException {
        writer.newLine();
        writer.startTag("storedItemManager");
        writer.indent();
        this._list.xmlWriteOn(writer);
        writer.outdent();
        writer.newLine();
        writer.endTag("storedItemManager");
    }
}

