/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs8;

import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.pkcsutil.PKCSAttribute;
import com.ibm.security.pkcsutil.PKCSAttributes;
import com.ibm.security.pkcsutil.PKCSDerObject;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Arrays;

public class PrivateKeyInfo
extends PKCSDerObject
implements PrivateKey {
    public static final BigInteger version = BigInteger.ZERO;
    protected AlgorithmId algid;
    protected byte[] key;
    protected PKCSAttributes attributes;
    private static final byte TAG_ATTRS = 0;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs8.PrivateKeyInfo";

    public PrivateKeyInfo() {
        if (debug != null) {
            debug.entry(16384L, className, "PrivateKeyInfo");
            debug.exit(16384L, className, "PrivateKeyInfo");
        }
    }

    public PrivateKeyInfo(String provider) {
        super(provider);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "PrivateKeyInfo", provider);
            debug.exit(16384L, className, "PrivateKeyInfo");
        }
    }

    public PrivateKeyInfo(byte[] der) throws IOException {
        super(der);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "PrivateKeyInfo", (Object)der);
            debug.exit(16384L, className, "PrivateKeyInfo");
        }
    }

    public PrivateKeyInfo(byte[] der, String provider) throws IOException {
        super(der, provider);
        if (debug != null) {
            debug.entry(16384L, className, "PrivateKeyInfo", der, provider);
            debug.exit(16384L, className, "PrivateKeyInfo");
        }
    }

    public PrivateKeyInfo(AlgorithmId algid, byte[] key, PKCSAttributes attrs) throws IOException {
        if (debug != null) {
            Object[] parms = new Object[]{algid, key, attrs};
            debug.entry(16384L, (Object)className, "PrivateKeyInfo", parms);
        }
        this.algid = algid;
        this.key = key;
        this.attributes = attrs;
        if (debug != null) {
            debug.exit(16384L, className, "PrivateKeyInfo");
        }
    }

    public PrivateKeyInfo(AlgorithmId algid, byte[] key, PKCSAttributes attrs, String provider) throws IOException {
        super(provider);
        if (debug != null) {
            Object[] parms = new Object[]{algid, key, attrs, provider};
            debug.entry(16384L, (Object)className, "PrivateKeyInfo", parms);
        }
        this.algid = algid;
        this.key = key;
        this.attributes = attrs;
        if (debug != null) {
            debug.exit(16384L, className, "PrivateKeyInfo");
        }
    }

    public PrivateKeyInfo(String filename, boolean base64) throws IOException {
        super(filename, base64);
        if (debug != null) {
            debug.entry(16384L, className, "PrivateKeyInfo", filename, new Boolean(base64));
            debug.exit(16384L, className, "PrivateKeyInfo");
        }
    }

    public PrivateKeyInfo(String filename, boolean base64, String provider) throws IOException {
        super(filename, base64, provider);
        if (debug != null) {
            Object[] parms = new Object[]{filename, new Boolean(base64), provider};
            debug.entry(16384L, (Object)className, "PrivateKeyInfo", parms);
            debug.exit(16384L, className, "PrivateKeyInfo");
        }
    }

    @Override
    public void encode(OutputStream os) throws IOException {
        DerOutputStream bytes = new DerOutputStream();
        DerOutputStream tmp = new DerOutputStream();
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", os);
        }
        bytes.putInteger(version);
        this.algid.encode(bytes);
        bytes.putOctetString(this.key);
        if (this.attributes != null && this.attributes.size() > 0) {
            DerOutputStream tmpout = new DerOutputStream();
            this.attributes.encode(tmpout);
            bytes.writeImplicit(DerValue.createTag((byte)-128, true, (byte)0), tmpout);
        }
        tmp.write((byte)48, bytes);
        os.write(tmp.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public static PrivateKey parseKey(DerValue in) throws IOException {
        if (debug != null) {
            debug.entry(49152L, (Object)className, "parseKey", in);
            debug.exit(49152L, className, "parseKey");
        }
        return PrivateKeyInfo.parseKey(in, null);
    }

    public static PrivateKey parseKey(DerValue in, String provider) throws IOException {
        PrivateKey privKey;
        if (debug != null) {
            debug.entry(49152L, className, "parseKey", in, provider);
        }
        if (in.getTag() != 48) {
            throw new IOException("corrupt private key");
        }
        BigInteger parsedVersion = in.getData().getInteger();
        if (!version.equals(parsedVersion)) {
            if (debug != null) {
                debug.text(49152L, className, "parseKey", "version mismatch: (supported: " + version + ") parsed: " + parsedVersion);
            }
            throw new IOException("version mismatch: (supported: " + version + ") parsed: " + parsedVersion);
        }
        AlgorithmId algorithm = AlgorithmId.parse(in.getData().getDerValue(), provider);
        byte[] keyBytes = in.getData().getOctetString();
        PKCSAttributes attrs = in.getData().available() != 0 ? new PKCSAttributes(in.getData(), provider) : null;
        try {
            privKey = PrivateKeyInfo.buildPrivateKeyInfo(algorithm, keyBytes, attrs, provider);
        }
        catch (InvalidKeyException e2) {
            if (debug != null) {
                debug.exception(49152L, className, "parseKey", e2);
            }
            throw new IOException("corrupt private key");
        }
        if (debug != null) {
            debug.exit(49152L, (Object)className, "parseKey", privKey);
        }
        return privKey;
    }

    public PrivateKeyInfo addAttributes(PKCSAttributes attribs) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "addAttributes", attribs);
        }
        PrivateKeyInfo pki = (PrivateKeyInfo)this.clone();
        if (attribs == null || attribs.size() == 0) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "addAttributes_1", pki);
            }
            return pki;
        }
        pki.attributes = pki.attributes == null ? attribs : pki.attributes.addAttributes(attribs);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "addAttributes_2", pki);
        }
        return pki;
    }

    public PrivateKeyInfo addAttribute(PKCSAttribute attrib) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "addAttribute", attrib);
        }
        PrivateKeyInfo pki = (PrivateKeyInfo)this.clone();
        if (attrib == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "addAttribute_1", pki);
            }
            return pki;
        }
        PKCSAttribute[] attribs = new PKCSAttribute[]{attrib};
        pki.attributes = pki.attributes == null ? new PKCSAttributes(attribs, this.provider) : pki.attributes.addAttributes(new PKCSAttributes(attribs, this.provider));
        if (debug != null) {
            debug.exit(16384L, (Object)className, "addAttribute_2", pki);
        }
        return pki;
    }

    @Override
    public String getAlgorithm() {
        if (debug != null) {
            debug.entry(16384L, className, "getAlgorithm");
            debug.exit(16384L, (Object)className, "getAlgorithm", this.algid.getName());
        }
        return this.algid.getName();
    }

    public AlgorithmId getAlgorithmId() {
        try {
            if (debug != null) {
                debug.entry(16384L, className, "getAlgorithmId");
                debug.exit(16384L, (Object)className, "getAlgorithmId", new AlgorithmId(this.algid.getOID(), this.algid.getParameters(), this.provider));
            }
            return new AlgorithmId(this.algid.getOID(), this.algid.getParameters(), this.provider);
        }
        catch (IOException e2) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getAlgorithmId", new AlgorithmId(this.algid.getOID(), this.provider));
            }
            return new AlgorithmId(this.algid.getOID(), this.provider);
        }
    }

    @Override
    public synchronized byte[] getEncoded() {
        byte[] result;
        block4: {
            result = null;
            if (debug != null) {
                debug.entry(16384L, className, "getEncoded");
            }
            try {
                result = this.encode();
            }
            catch (IOException e2) {
                if (debug == null) break block4;
                debug.exception(16384L, className, "getEncoded", e2);
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getEncoded", result);
        }
        return result;
    }

    @Override
    public String getFormat() {
        if (debug != null) {
            debug.entry(16384L, className, "getFormat");
            debug.exit(16384L, (Object)className, "getFormat", "PKCS#8");
        }
        return "PKCS#8";
    }

    public PKCSAttribute getAttribute(ObjectIdentifier oid) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getAttribute", oid);
        }
        if (oid == null || this.attributes == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getAttribute_1", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getAttribute_2", (PKCSAttribute)this.attributes.getAttribute(oid));
        }
        return (PKCSAttribute)this.attributes.getAttribute(oid);
    }

    public PKCSAttributes getAttributes() {
        if (debug != null) {
            debug.entry(16384L, className, "getAttributes");
            debug.exit(16384L, (Object)className, "getAttributes", this.attributes);
        }
        return this.attributes;
    }

    public boolean hasAttribute(ObjectIdentifier oid) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "hasAttribute", oid);
        }
        if (this.attributes == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "hasAttribute_1", false);
            }
            return false;
        }
        PKCSAttribute attrib = this.getAttribute(oid);
        if (attrib == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "hasAttribute_2", false);
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "hasAttribute_3", true);
        }
        return true;
    }

    public boolean hasAttributes() {
        if (debug != null) {
            debug.entry(16384L, className, "hasAttributes");
        }
        if (this.attributes != null && this.attributes.size() > 0) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "hasAttributes", true);
            }
            return true;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "hasAttributes", false);
        }
        return false;
    }

    @Override
    public boolean equals(Object other) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", other);
        }
        if (other instanceof PrivateKeyInfo) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", this.equals((PrivateKeyInfo)other));
            }
            return this.equals((PrivateKeyInfo)other);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals", false);
        }
        return false;
    }

    @Override
    public String toString() {
        HexDumpEncoder encoder = new HexDumpEncoder();
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        String out = "algorithm = " + this.algid.toString();
        out = out + "\r\nunparsed keybits =\r\n" + encoder.encodeBuffer(this.key);
        if (this.attributes != null) {
            out = out + "\r\nattributes:";
            out = out + "\r\n" + this.attributes.toString();
        } else {
            out = out + "\r\nno attributes";
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", out);
        }
        return out;
    }

    @Override
    public int hashCode() {
        int retval = 0;
        if (debug != null) {
            debug.entry(16384L, className, "hashCode");
        }
        byte[] b1 = this.getEncoded();
        for (int i2 = 1; i2 < b1.length; ++i2) {
            retval += b1[i2] * i2;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "hashCode", retval);
        }
        return retval;
    }

    public Object clone() {
        try {
            if (debug != null) {
                debug.entry(16384L, className, "clone");
            }
            DerOutputStream derout = new DerOutputStream();
            this.encode(derout);
            PrivateKeyInfo retobj = new PrivateKeyInfo(derout.toByteArray(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone_1", retobj);
            }
            return retobj;
        }
        catch (Exception e2) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone_2", null);
            }
            return null;
        }
    }

    @Override
    protected void decode(DerValue encoding) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", encoding);
        }
        if (encoding.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "PrivateKeyInfo parsing error.");
            }
            throw new IOException("PrivateKeyInfo parsing error.");
        }
        DerInputStream myDerInputStream = encoding.getData();
        BigInteger version = myDerInputStream.getInteger();
        if (!version.equals(PrivateKeyInfo.version)) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "Version mismatch: (supported: " + PrivateKeyInfo.version + ", parsed: " + version);
            }
            throw new IOException("Version mismatch: (supported: " + PrivateKeyInfo.version + ", parsed: " + version);
        }
        DerValue myAlgorithmIDDerValue = myDerInputStream.getDerValue();
        this.algid = AlgorithmId.parse(myAlgorithmIDDerValue);
        this.key = myDerInputStream.getOctetString();
        this.parseKeyBits();
        this.attributes = encoding.getData().available() != 0 ? new PKCSAttributes(encoding.getData(), this.provider) : null;
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    static void encode(DerOutputStream out, AlgorithmId algid, byte[] key, PKCSAttributes attrs) throws IOException {
        if (debug != null) {
            Object[] parms = new Object[]{out, algid, key, attrs};
            debug.entry(49152L, (Object)className, "encode", parms);
        }
        PrivateKeyInfo pkinfo = new PrivateKeyInfo(algid, key, attrs);
        pkinfo.encode(out);
        if (debug != null) {
            debug.exit(49152L, className, "encode");
        }
    }

    static void encode(DerOutputStream out, AlgorithmId algid, byte[] key, PKCSAttributes attrs, String provider) throws IOException {
        if (debug != null) {
            Object[] parms = new Object[]{out, algid, key, attrs, provider};
            debug.entry(49152L, (Object)className, "encode", parms);
        }
        PrivateKeyInfo pkinfo = new PrivateKeyInfo(algid, key, attrs, provider);
        pkinfo.encode(out);
        if (debug != null) {
            debug.exit(49152L, className, "encode");
        }
    }

    protected void parseKeyBits() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "parseKeyBits");
        }
        this.encode();
        if (debug != null) {
            debug.exit(16384L, className, "parseKeyBits");
        }
    }

    static PrivateKey buildPrivateKeyInfo(AlgorithmId algid, byte[] key, PKCSAttributes attrs) throws IOException, InvalidKeyException {
        if (debug != null) {
            Object[] parms = new Object[]{algid, key, attrs};
            debug.entry(49152L, (Object)className, "buildPrivateKeyInfo", parms);
            debug.exit(49152L, className, "buildPrivateKeyInfo");
        }
        return PrivateKeyInfo.buildPrivateKeyInfo(algid, key, attrs, null);
    }

    static PrivateKey buildPrivateKeyInfo(AlgorithmId algid, byte[] key, PKCSAttributes attrs, String provider) throws IOException, InvalidKeyException {
        block9: {
            if (debug != null) {
                Object[] parms = new Object[]{algid, key, attrs, provider};
                debug.entry(49152L, (Object)className, "buildPrivateKeyInfo", parms);
            }
            DerOutputStream pkcs8EncodedKeyStream = new DerOutputStream();
            PrivateKeyInfo.encode(pkcs8EncodedKeyStream, algid, key, attrs, provider);
            PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(pkcs8EncodedKeyStream.toByteArray());
            try {
                KeyFactory keyFac = provider != null ? KeyFactory.getInstance(algid.getName(), provider) : KeyFactory.getInstance(algid.getName());
                PrivateKey retkey = keyFac.generatePrivate(pkcs8KeySpec);
                if (debug != null) {
                    debug.exit(49152L, (Object)className, "buildPrivateKeyInfo_1", retkey);
                }
                return retkey;
            }
            catch (NoSuchAlgorithmException e2) {
                if (debug != null) {
                    debug.exception(49152L, className, "buildPrivateKeyInfo", e2);
                }
            }
            catch (NoSuchProviderException e3) {
                if (debug != null) {
                    debug.exception(49152L, className, "buildPrivateKeyInfo", e3);
                }
                throw new IOException("Provider " + provider + " not found");
            }
            catch (InvalidKeySpecException e4) {
                if (debug == null) break block9;
                debug.exception(49152L, className, "buildPrivateKeyInfo", e4);
            }
        }
        PrivateKeyInfo result = new PrivateKeyInfo(algid, key, attrs, provider);
        if (debug != null) {
            debug.exit(49152L, (Object)className, "buildPrivateKeyInfo", result);
        }
        return result;
    }

    private synchronized void writeObject(ObjectOutputStream stream) throws IOException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "writeObject", stream);
        }
        stream.write(this.getEncoded());
        if (debug != null) {
            debug.exit(8192L, className, "writeObject");
        }
    }

    private synchronized void readObject(ObjectInputStream stream) throws IOException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "readObject", stream);
        }
        if (stream == null) {
            if (debug != null) {
                debug.text(8192L, className, "readObject", "stream not specified.");
            }
            throw new IllegalArgumentException("stream not specified.");
        }
        try {
            DerValue der = new DerValue(stream);
            this.decode(der);
        }
        catch (IOException e2) {
            if (debug != null) {
                debug.exception(8192L, className, "readObject", e2);
            }
            throw new IOException("Deserialized key is invalid: " + e2.getMessage());
        }
        if (debug != null) {
            debug.exit(8192L, className, "readObject");
        }
    }

    public byte[] getKeyBytes() {
        if (debug != null) {
            debug.entry(16384L, className, "getKeyBytes");
        }
        if (this.key == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getKeyBytes_1", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getKeyBytes_2", (byte[])this.key.clone());
        }
        return (byte[])this.key.clone();
    }

    protected void finalize() {
        if (debug != null) {
            debug.entry(16384L, className, "finalize");
        }
        if (this.key != null) {
            Arrays.fill(this.key, (byte)0);
            this.key = null;
        }
        if (debug != null) {
            debug.exit(16384L, className, "finalize");
        }
    }

    private boolean equals(PrivateKeyInfo other) {
        DerValue otherDer;
        DerValue thisDer;
        if (debug != null) {
            debug.entry(8192L, (Object)className, "equals", other);
        }
        if (other == this) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals_1", true);
            }
            return true;
        }
        try {
            DerOutputStream thisOut = new DerOutputStream();
            DerOutputStream otherOut = new DerOutputStream();
            this.encode(thisOut);
            thisDer = new DerValue(thisOut.toByteArray());
            other.encode(otherOut);
            otherDer = new DerValue(otherOut.toByteArray());
        }
        catch (Exception e2) {
            if (debug != null) {
                debug.exception(8192L, className, "equals", e2);
                debug.exit(8192L, (Object)className, "equals_2", true);
            }
            return false;
        }
        if (!thisDer.equals(otherDer)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals_3", false);
            }
            return false;
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "equals_4", true);
        }
        return true;
    }
}

