/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs7;

import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.pkcsutil.PKCSDerObject;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public final class UserKeyingMaterial
extends PKCSDerObject
implements Cloneable {
    private AlgorithmId algorithm;
    private byte[] ukm;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs7.UserKeyingMaterial";
    private volatile int cachedHashVal = 0;

    public UserKeyingMaterial(byte[] der) throws IOException {
        super(der);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "UserKeyingMaterial", (Object)der);
            debug.exit(16384L, className, "UserKeyingMaterial");
        }
    }

    public UserKeyingMaterial(byte[] der, String provider) throws IOException {
        super(der, provider);
        if (debug != null) {
            debug.entry(16384L, className, "UserKeyingMaterial", der, provider);
            debug.exit(16384L, className, "UserKeyingMaterial");
        }
    }

    public UserKeyingMaterial(AlgorithmId alg, byte[] ukm) {
        if (debug != null) {
            debug.entry(16384L, className, "UserKeyingMaterial", alg, ukm);
        }
        this.algorithm = alg;
        this.ukm = ukm;
        if (debug != null) {
            debug.exit(16384L, className, "UserKeyingMaterial");
        }
    }

    public UserKeyingMaterial(AlgorithmId alg, byte[] ukm, String provider) {
        super(provider);
        if (debug != null) {
            debug.entry(16384L, className, "UserKeyingMaterial", ukm, provider);
        }
        this.algorithm = alg;
        this.ukm = ukm;
        if (debug != null) {
            debug.exit(16384L, className, "UserKeyingMaterial");
        }
    }

    public UserKeyingMaterial(String filename, boolean base64) throws IOException {
        super(filename, base64);
        if (debug != null) {
            debug.entry(16384L, className, "UserKeyingMaterial", filename, new Boolean(base64));
            debug.exit(16384L, className, "UserKeyingMaterial");
        }
    }

    public UserKeyingMaterial(String filename, boolean base64, String provider) throws IOException {
        super(filename, base64, provider);
        if (debug != null) {
            Object[] parms = new Object[]{filename, new Boolean(base64), provider};
            debug.entry(16384L, (Object)className, "UserKeyingMaterial", parms);
            debug.exit(16384L, className, "UserKeyingMaterial");
        }
    }

    @Override
    public void encode(OutputStream os) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", os);
        }
        DerOutputStream bytes = new DerOutputStream();
        DerOutputStream tmp = new DerOutputStream();
        this.algorithm.encode(bytes);
        bytes.putOctetString(this.ukm);
        tmp.write((byte)48, bytes);
        os.write(tmp.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    @Override
    protected void decode(DerValue encoding) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", encoding);
        }
        if (encoding.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "UserKeyingMaterial parsing error");
            }
            throw new IOException("UserKeyingMaterial parsing error");
        }
        this.algorithm = AlgorithmId.parse(encoding.getData().getDerValue());
        this.ukm = encoding.getData().getOctetString();
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    public AlgorithmId getKeyEncryptionAlgorithm() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getKeyEncryptionAlgorithm");
        }
        if (this.algorithm == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getKeyEncryptionAlgorithm", null);
            }
            return null;
        }
        AlgorithmId result = new AlgorithmId(this.algorithm.getOID(), this.algorithm.getParameters());
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getKeyEncryptionAlgorithm", result);
        }
        return result;
    }

    public byte[] getUserKeyringMaterial() {
        if (debug != null) {
            debug.entry(16384L, className, "getUserKeyringMaterial");
        }
        if (this.ukm == null || this.ukm.length == 0) {
            debug.exit(16384L, (Object)className, "getUserKeyringMaterial", null);
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getUserKeyringMaterial", this.ukm.clone());
        }
        return (byte[])this.ukm.clone();
    }

    @Override
    public boolean equals(Object other) {
        DerValue otherDer;
        DerValue thisDer;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", other);
        }
        if (other == this) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_2", new Boolean(true));
            }
            return true;
        }
        if (!(other instanceof UserKeyingMaterial)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", new Boolean(false));
            }
            return false;
        }
        try {
            DerOutputStream thisOut = new DerOutputStream();
            DerOutputStream otherOut = new DerOutputStream();
            this.encode(thisOut);
            thisDer = new DerValue(thisOut.toByteArray());
            ((UserKeyingMaterial)other).encode(otherOut);
            otherDer = new DerValue(otherOut.toByteArray());
        }
        catch (Exception e2) {
            if (debug != null) {
                debug.exception(16384L, className, "equals", e2);
                debug.exit(16384L, (Object)className, "equals_3", new Boolean(false));
            }
            return false;
        }
        if (!thisDer.equals(otherDer)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_4", new Boolean(false));
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals", new Boolean(true));
        }
        return true;
    }

    @Override
    public int hashCode() {
        if (this.cachedHashVal == 0) {
            try {
                DerOutputStream thisOut = new DerOutputStream();
                this.encode(thisOut);
                this.cachedHashVal = Arrays.hashCode(thisOut.toByteArray());
            }
            catch (Exception e2) {
                return 0;
            }
        }
        return this.cachedHashVal;
    }

    public Object clone() {
        if (debug != null) {
            debug.entry(16384L, className, "clone");
        }
        try {
            DerOutputStream derout = new DerOutputStream();
            this.encode(derout);
            UserKeyingMaterial result = new UserKeyingMaterial(derout.toByteArray());
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", result);
            }
            return result;
        }
        catch (Exception e2) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", null);
            }
            return null;
        }
    }

    @Override
    public String toString() {
        HexDumpEncoder hexDump = new HexDumpEncoder();
        String out = "";
        out = out + "\talgorithm: " + this.algorithm;
        out = out + "\r\n\tukm: \r\n" + hexDump.encodeBuffer(this.ukm) + "\r\n";
        return out;
    }
}

