/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.certclient.util;

import com.ibm.misc.Debug;
import com.ibm.security.certclient.PkEeFactory;
import com.ibm.security.certclient.base.PkException;
import com.ibm.security.certclient.base.PkNLSConstants;
import com.ibm.security.certclient.base.PkRejectionException;
import com.ibm.security.certclient.util.PkBase64InputStream;
import com.ibm.security.pkcs10.CertificationRequest;
import com.ibm.security.pkcs10.CertificationRequestInfo;
import com.ibm.security.pkcsutil.PKCSAttributes;
import com.ibm.security.pkcsutil.PKCSException;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.CertAndKeyGen;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509CertImpl;
import com.ibm.security.x509.X509Key;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;

public class PkCertUtils {
    private static final String sccsid = "@(#) 86 1.13    com/tivoli/pki/util/PkCertUtils.java, PkUtil, javapki2, 10222004 6/25/04 14:34:08";
    private static Debug debug = Debug.getInstance("keycertmanage");
    private static final Object className = "PkCertUtils";
    private static final String RSA_KEY = "RSA";
    private static final String DSA_KEY = "DSA";
    private static final String ECC_KEY = "EC";

    public static void screenCert(X509Certificate cert, boolean isCA) throws PkException {
        try {
            cert.checkValidity();
        }
        catch (CertificateExpiredException e2) {
            throw new PkRejectionException(e2.getMessage());
        }
        catch (CertificateNotYetValidException e3) {
            throw new PkRejectionException(e3.getMessage());
        }
        if (isCA && cert.getBasicConstraints() == -1) {
            throw new PkRejectionException(PkNLSConstants.CERT_MUST_BE_CA_CERT);
        }
    }

    public static void writeCrlToFile(X509CRL crl, String outFileName) {
        try {
            FileOutputStream file = new FileOutputStream(outFileName);
            file.write(crl.getEncoded());
            file.close();
        }
        catch (Exception e2) {
            System.out.println("Unable to write crl to file. Error = " + e2.getMessage());
        }
    }

    public static void writeCertToFile(X509Certificate cert, String outFileName) {
        try {
            FileOutputStream file = new FileOutputStream(outFileName);
            file.write(cert.getEncoded());
            file.close();
        }
        catch (Exception e2) {
            System.out.println("Unable to write cert to file. Error = " + e2.getMessage());
            System.out.println("cert file written to file tmp#$!.cer instead");
            try {
                FileOutputStream file = new FileOutputStream("tmp#$!.cer");
                file.write(cert.getEncoded());
            }
            catch (Exception e1) {
                System.out.println("Unable to write cert to file tmp#$!.cer . Error = " + e2.getMessage());
            }
        }
    }

    public static Key[] generateKeyPair0(boolean isRSAKey, int keySize) throws Exception {
        Key[] keyPair = new Key[2];
        CertAndKeyGen candg = isRSAKey ? new CertAndKeyGen(RSA_KEY, "SHA1WithRSA") : new CertAndKeyGen(DSA_KEY, "SHA1WithDSA");
        candg.generate(keySize);
        Key k2 = candg.newGetPublicKey();
        PrivateKey privateKey = candg.getPrivateKey();
        KeyFactory kf = isRSAKey ? KeyFactory.getInstance(RSA_KEY, PkEeFactory.getProvider()) : KeyFactory.getInstance(DSA_KEY, PkEeFactory.getProvider());
        X509Key publicKey = (X509Key)kf.translateKey(k2);
        keyPair[0] = publicKey;
        keyPair[1] = privateKey;
        return keyPair;
    }

    @Deprecated
    public static Key[] generateKeyPair(boolean isRSAKey, int keySize) throws Exception {
        return PkCertUtils.generateKeyPair(isRSAKey ? RSA_KEY : DSA_KEY, keySize, null);
    }

    public static Key[] generateKeyPair(String keyType, int keySize, String providerName) throws Exception {
        Key[] keyPair = new Key[2];
        KeyPair kp = null;
        String provider = PkEeFactory.getProvider();
        if (providerName != null && !"".equals(providerName)) {
            provider = providerName;
        }
        KeyPairGenerator kpg = KeyPairGenerator.getInstance(keyType, provider);
        kpg.initialize(keySize);
        kp = kpg.generateKeyPair();
        KeyFactory kf = KeyFactory.getInstance(keyType, provider);
        PublicKey publicKey = null;
        publicKey = RSA_KEY.equalsIgnoreCase(keyType) || DSA_KEY.equalsIgnoreCase(keyType) ? (X509Key)kf.translateKey(kp.getPublic()) : kp.getPublic();
        keyPair[0] = publicKey;
        keyPair[1] = kp.getPrivate();
        return keyPair;
    }

    private static X509CertImpl readCert(String fileName) throws Exception {
        FileInputStream fIn = new FileInputStream(fileName);
        byte[] b2 = new byte[fIn.available()];
        fIn.read(b2);
        ByteArrayInputStream inStream = new ByteArrayInputStream(b2);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        X509Certificate c2 = (X509Certificate)cf.generateCertificate(inStream);
        ((InputStream)inStream).close();
        fIn.close();
        X509CertImpl cert = new X509CertImpl(c2.getEncoded());
        return cert;
    }

    public static X509Certificate readCert64(String fileName) throws Exception {
        FileInputStream fIn = new FileInputStream(fileName);
        byte[] b2 = new byte[fIn.available()];
        fIn.read(b2);
        ByteArrayInputStream inStream = new ByteArrayInputStream(b2);
        PkBase64InputStream b64is = new PkBase64InputStream(inStream);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        X509Certificate c2 = (X509Certificate)cf.generateCertificate(b64is);
        ((InputStream)inStream).close();
        fIn.close();
        return c2;
    }

    public static X509CRL readCRL(String fileName) throws Exception {
        FileInputStream fIn = new FileInputStream(fileName);
        byte[] b2 = new byte[fIn.available()];
        fIn.read(b2);
        ByteArrayInputStream inStream = new ByteArrayInputStream(b2);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        X509CRL crl = (X509CRL)cf.generateCRL(inStream);
        ((InputStream)inStream).close();
        fIn.close();
        return crl;
    }

    private static CertificationRequest readPKCS10CertReq64(String fileName) throws Exception {
        FileInputStream fIn = new FileInputStream(fileName);
        byte[] b2 = new byte[fIn.available()];
        fIn.read(b2);
        fIn.close();
        return PkCertUtils.readPKCS10CertReq64(b2);
    }

    private static CertificationRequest readPKCS10CertReq64(byte[] base64pkcs10ReqAsByteArray) throws Exception {
        ByteArrayInputStream inStream = new ByteArrayInputStream(base64pkcs10ReqAsByteArray);
        DerValue der = new DerValue(new PkBase64InputStream(inStream));
        CertificationRequest certReq = new CertificationRequest(der.toByteArray());
        ((InputStream)inStream).close();
        return certReq;
    }

    private static CertificationRequest readPKCS10CertReq(String fileName, boolean base64) throws Exception {
        return new CertificationRequest(fileName, base64);
    }

    private static CertificationRequest createPKCS10CertReq(String subjectDn, PublicKey publicKey, PrivateKey privateKey, String digest) throws IOException, NoSuchAlgorithmException, PKCSException {
        CertificationRequest certReq = null;
        X500Name x500Name = new X500Name(subjectDn);
        PKCSAttributes attrs = null;
        CertificationRequestInfo certReqInfo = new CertificationRequestInfo(x500Name, publicKey, attrs);
        certReq = new CertificationRequest(certReqInfo, privateKey, digest);
        return certReq;
    }

    public static KeyStore keyStore(String keyStoreType, String fileName, char[] keyStorePwd) throws PkException {
        FileInputStream inp = null;
        KeyStore kstore = null;
        try {
            kstore = KeyStore.getInstance(keyStoreType, PkEeFactory.getProvider());
            try {
                inp = new FileInputStream(fileName);
                kstore.load(inp, keyStorePwd);
                inp.close();
            }
            catch (FileNotFoundException e2) {
                kstore.load(null, keyStorePwd);
                FileOutputStream file = new FileOutputStream(fileName);
                kstore.store(file, keyStorePwd);
                file.close();
            }
        }
        catch (GeneralSecurityException e3) {
            if (debug != null) {
                debug.exception(4L, className, "keyStore", e3);
            }
            throw new PkException(e3);
        }
        catch (IOException ioe) {
            if (debug != null) {
                debug.exception(4L, className, "keyStore", ioe);
            }
            throw new PkException(ioe);
        }
        return kstore;
    }
}

