/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.validation.idc;

import com.ibm.xml.xlxp2.datatype.ValidatedInfo;
import com.ibm.xml.xlxp2.datatype.XBinary;
import com.ibm.xml.xlxp2.datatype.XByte;
import com.ibm.xml.xlxp2.datatype.XDateTime;
import com.ibm.xml.xlxp2.datatype.XDecimal;
import com.ibm.xml.xlxp2.datatype.XDouble;
import com.ibm.xml.xlxp2.datatype.XFloat;
import com.ibm.xml.xlxp2.datatype.XInt;
import com.ibm.xml.xlxp2.datatype.XList;
import com.ibm.xml.xlxp2.datatype.XLong;
import com.ibm.xml.xlxp2.datatype.XShort;
import com.ibm.xml.xlxp2.grammar.Attribute;
import com.ibm.xml.xlxp2.runtime.VMContext;
import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.util.AttrList;
import com.ibm.xml.xlxp2.scan.util.QName;
import com.ibm.xml.xlxp2.scan.util.XMLString;
import com.ibm.xml.xlxp2.validation.idc.IValue;
import com.ibm.xml.xlxp2.validation.idc.IValueContainer;
import com.ibm.xml.xlxp2.validation.idc.QNameKey;
import com.ibm.xml.xlxp2.validation.idc.XMLStringKey;
import com.ibm.xml.xlxp2.validation.idc.XPathAction;
import com.ibm.xml.xlxp2.validation.idc.XPathAttribute;
import com.ibm.xml.xlxp2.validation.idc.XPathDFA;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2010. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class IDCContext {
    final VMContext vmContext;
    public int idcCount;
    public int xpathCount;
    public IValueContainer[][] idcContainers;
    public int[] idcContainerListLengths;
    public int[][] idcKeyContext;
    public int[] idcCurrentContext;
    public IValue[][] idcIValues4ActiveFields;
    public int[] idcIValuesListLengths;
    public IValuePool[] idcActiveIValuePools;
    public FValuePool[] idcActiveFValuePools;
    public XPathDFA[] xpathDFAs;
    public int[][] idcXPathStates;
    private int[] idcStateChangeHistory = new int[24];
    private int idcStateChangeHistorySize;
    private int[] idcStateChangeHistoryContext = new int[8];
    private int idcStateChangeHistoryCurrentContext;
    public Object[][] idcFValues;
    public int[][] idcFTypes;
    public int[][][] idcFItemTypes;
    public int[] idcFValueListLengths;
    public int[] emptyArray;
    private static final int INITIAL_POOL_SIZE = 4;
    private static final int DEFAULT_BUFFER_SIZE = 1024;
    private static final int INITIAL_LIST_SIZE = 8;
    IValueContainer fIVCPool = null;
    IValuePool fIVPoolPool = null;
    FValuePool fFVPoolPool = null;

    public IDCContext(VMContext vMContext) {
        this.vmContext = vMContext;
    }

    public void initialize(int n, XPathDFA[] xPathDFAArray) {
        this.idcCount = n;
        int n2 = this.xpathCount = xPathDFAArray != null ? xPathDFAArray.length : 0;
        if (this.idcCount == 0) {
            this.idcContainers = null;
            this.idcContainerListLengths = null;
            this.idcKeyContext = null;
            this.idcCurrentContext = null;
            this.idcIValues4ActiveFields = null;
            this.idcIValuesListLengths = null;
            this.idcActiveIValuePools = null;
            this.idcActiveFValuePools = null;
            this.xpathDFAs = null;
            this.idcXPathStates = null;
            this.idcFValues = null;
            this.idcFItemTypes = null;
            this.idcFValueListLengths = null;
            this.emptyArray = null;
            return;
        }
        this.idcContainers = new IValueContainer[this.idcCount][1];
        this.idcContainerListLengths = new int[this.idcCount];
        this.idcKeyContext = new int[this.idcCount][1];
        this.idcCurrentContext = new int[this.idcCount];
        this.idcIValues4ActiveFields = new IValue[this.idcCount][2];
        this.idcIValuesListLengths = new int[this.idcCount];
        this.idcActiveIValuePools = new IValuePool[this.idcCount];
        this.idcActiveFValuePools = new FValuePool[this.idcCount];
        this.xpathDFAs = xPathDFAArray;
        this.idcXPathStates = new int[this.xpathCount][4];
        this.idcFValues = new Object[this.idcCount][8];
        this.idcFTypes = new int[this.idcCount][8];
        this.idcFItemTypes = new int[this.idcCount][8][];
        this.idcFValueListLengths = new int[this.idcCount];
        this.emptyArray = new int[this.idcCount];
        this.reset();
    }

    void startSelectorXPaths(XPathAction[] xPathActionArray) {
        for (int i = 0; i < xPathActionArray.length; ++i) {
            XPathAction xPathAction = xPathActionArray[i];
            IValueContainer iValueContainer = this.startIDCSelectorXPathState(xPathAction);
            if (xPathAction.newState >= 0) continue;
            int n = this.getIValueHandle(iValueContainer);
            IValue iValue = this.idcIValues4ActiveFields[xPathAction.idcID][n];
            this.saveIDCStateHistory(-1, xPathAction.idcID, n);
            this.startFieldXPaths(xPathAction.startFieldActions, iValue.startOffset);
        }
    }

    void startFieldXPaths(XPathAction[] xPathActionArray, int n) {
        for (int i = 0; i < xPathActionArray.length; ++i) {
            XPathAction xPathAction = xPathActionArray[i];
            int n2 = this.startIDCFieldXPathState(xPathAction, n);
            if (xPathAction.newState >= 0 && xPathAction.finalAttrDecls == null) continue;
            this.matchedField(xPathAction, n2);
        }
    }

    public void processActiveXPaths() {
        int n = this.vmContext.elementDepth;
        for (int i = 0; i < this.idcXPathStates.length; ++i) {
            XPathDFA xPathDFA = this.xpathDFAs[i];
            int[] nArray = this.idcXPathStates[i];
            int n2 = nArray[0];
            for (int j = 1; j < n2; j += 3) {
                if (nArray[j + 1] != n) continue;
                this.matchXPathDFA(xPathDFA, nArray, j);
            }
        }
    }

    boolean matchXPathDFA(XPathDFA xPathDFA, int[] nArray, int n) {
        int n2 = xPathDFA.transition(nArray[n], this.vmContext.elementType.nsURI, this.vmContext.elementType.localName);
        if (n2 != 0) {
            XPathAttribute[] xPathAttributeArray = xPathDFA.getFinalAttrDecls(n2);
            if (n2 < 0 || xPathAttributeArray != null) {
                if (!xPathDFA.isSelector) {
                    this.matchedField(xPathDFA, n2, xPathAttributeArray, nArray[n + 2]);
                } else {
                    IValueContainer iValueContainer = this.idcContainers[xPathDFA.idcID][nArray[n + 2]];
                    int n3 = this.getIValueHandle(iValueContainer);
                    IValue iValue = this.idcIValues4ActiveFields[xPathDFA.idcID][n3];
                    this.saveIDCStateHistory(-1, xPathDFA.idcID, n3);
                    this.startFieldXPaths(xPathDFA.startFieldActions, iValue.startOffset);
                }
                this.saveIDCStateHistory(xPathDFA.xpathID, n, nArray[n]);
                nArray[n] = n2;
                if (xPathDFA.allowMoreInput(n2)) {
                    int n4 = n + 1;
                    nArray[n4] = nArray[n4] + 1;
                }
            } else {
                this.saveIDCStateHistory(xPathDFA.xpathID, n, nArray[n]);
                nArray[n] = n2;
                int n5 = n + 1;
                nArray[n5] = nArray[n5] + 1;
            }
            return true;
        }
        return false;
    }

    void matchedField(XPathAction xPathAction, int n) {
        XPathAttribute[] xPathAttributeArray;
        boolean bl = false;
        if (xPathAction.newState < 0) {
            bl = true;
            if (xPathAction.idcCategory == 1 && this.vmContext.eDecl != null && this.vmContext.eDecl.nillable) {
                this.vmContext.generateError(36, this.vmContext.elementType.localName);
            }
        }
        if ((xPathAttributeArray = xPathAction.finalAttrDecls) != null) {
            if (xPathAction.finalAttrs != null) {
                if (this.vmContext.attsSpecified.intersectsWith(xPathAction.finalAttrs)) {
                    this.matchAttributeFieldNoWC(xPathAttributeArray, xPathAction.idcID, n, bl);
                }
            } else {
                this.matchAttributeFieldWithWC(xPathAttributeArray, xPathAction.idcID, n, bl);
            }
        }
    }

    private void matchedField(XPathDFA xPathDFA, int n, XPathAttribute[] xPathAttributeArray, int n2) {
        boolean bl = false;
        if (n < 0) {
            bl = true;
            if (xPathDFA.idcCategory == 1 && this.vmContext.eDecl != null && this.vmContext.eDecl.nillable) {
                this.vmContext.generateError(36, this.vmContext.elementType.localName);
            }
        }
        if (xPathAttributeArray != null) {
            this.matchAttributeFieldWithWC(xPathAttributeArray, xPathDFA.idcID, n2, bl);
        }
    }

    private void matchAttributeFieldNoWC(XPathAttribute[] xPathAttributeArray, int n, int n2, boolean bl) {
        VMContext vMContext = this.vmContext;
        for (int i = 0; i < xPathAttributeArray.length; ++i) {
            XPathAttribute xPathAttribute = xPathAttributeArray[i];
            if (!this.vmContext.attsSpecified.getBit(xPathAttribute.index)) continue;
            if (!bl) {
                int n3 = this.findAttribute(xPathAttribute, this.vmContext.aDecls, vMContext.attributeCount());
                ValidatedInfo validatedInfo = this.vmContext.actualAttributeValue(n3);
                if (this.idcFValues[n][n2] == null) {
                    this.idcFValues[n][n2] = this.copyFValue(n, validatedInfo.actualValue, validatedInfo.typeValidator.builtInKind, validatedInfo.itemBuiltinKinds);
                    this.idcFTypes[n][n2] = validatedInfo.typeValidator.builtInKind;
                    this.idcFItemTypes[n][n2] = validatedInfo.itemBuiltinKinds;
                } else {
                    this.vmContext.generateError(32);
                }
                bl = true;
                continue;
            }
            this.vmContext.generateError(32);
        }
    }

    private void matchAttributeFieldWithWC(XPathAttribute[] xPathAttributeArray, int n, int n2, boolean bl) {
        VMContext vMContext = this.vmContext;
        for (int i = 0; i < xPathAttributeArray.length; ++i) {
            int n3 = this.findAttribute(xPathAttributeArray[i], vMContext);
            if (n3 < 0) continue;
            if (!bl) {
                ValidatedInfo validatedInfo = this.vmContext.actualAttributeValue(n3);
                if (this.idcFValues[n][n2] == null) {
                    this.idcFValues[n][n2] = this.copyFValue(n, validatedInfo.actualValue, validatedInfo.typeValidator.builtInKind, validatedInfo.itemBuiltinKinds);
                    this.idcFTypes[n][n2] = validatedInfo.typeValidator.builtInKind;
                    this.idcFItemTypes[n][n2] = validatedInfo.itemBuiltinKinds;
                } else {
                    this.vmContext.generateError(32);
                }
                bl = true;
                continue;
            }
            this.vmContext.generateError(32);
        }
    }

    private int findAttribute(XPathAttribute xPathAttribute, Attribute[] attributeArray, int n) {
        for (int i = 0; i < n; ++i) {
            Attribute attribute = attributeArray[i];
            if (attribute == null || attribute.localName != xPathAttribute.localName || attribute.nsURI != xPathAttribute.nsURI) continue;
            return i;
        }
        return -1;
    }

    private int findAttribute(XPathAttribute xPathAttribute, AttrList attrList) {
        if (xPathAttribute.localName != null) {
            int n = attrList.attributeCount();
            for (int i = 0; i < n; ++i) {
                QName qName = attrList.attributeName(i);
                if (qName.localName != xPathAttribute.localName || qName.nsURI != xPathAttribute.nsURI) continue;
                return i;
            }
            return -1;
        }
        if (xPathAttribute.nsURI != null) {
            return this.matchRestrictedAttrWC(xPathAttribute, attrList);
        }
        return this.matchUnrestrictedAttrWC(xPathAttribute, attrList);
    }

    private int matchRestrictedAttrWC(XPathAttribute xPathAttribute, AttrList attrList) {
        int n = attrList.attributeCount();
        int n2 = -1;
        for (int i = 0; i < n; ++i) {
            QName qName = attrList.attributeName(i);
            if (qName.nsURI != xPathAttribute.nsURI) continue;
            if (n2 < 0) {
                n2 = i;
                continue;
            }
            this.vmContext.generateError(32);
        }
        return n2;
    }

    private int matchUnrestrictedAttrWC(XPathAttribute xPathAttribute, AttrList attrList) {
        int n = attrList.attributeCount();
        if (n == 0) {
            return -1;
        }
        for (int i = 1; i < n; ++i) {
            this.vmContext.generateError(32);
        }
        return 0;
    }

    int getIValueHandle(IValueContainer iValueContainer) {
        int n;
        int n2;
        IValue iValue = this.idcActiveIValuePools[iValueContainer.idcID].getIValue();
        IValue[] iValueArray = this.idcIValues4ActiveFields[iValueContainer.idcID];
        int n3 = iValueContainer.idcID;
        int n4 = this.idcIValuesListLengths[n3];
        this.idcIValuesListLengths[n3] = n4 + 1;
        int n5 = n4;
        if (n5 >= iValueArray.length) {
            IValue[] iValueArray2 = new IValue[iValueArray.length << 1];
            System.arraycopy(iValueArray, 0, iValueArray2, 0, iValueArray.length);
            iValueArray = iValueArray2;
            this.idcIValues4ActiveFields[iValueContainer.idcID] = iValueArray2;
        }
        iValueArray[n5] = iValue;
        iValue.startOffset = this.idcFValueListLengths[iValueContainer.idcID];
        this.idcFValueListLengths[iValueContainer.idcID] = n2 = iValue.startOffset + iValueContainer.fieldCount;
        Object[] objectArray = this.idcFValues[iValueContainer.idcID];
        if (n2 > objectArray.length) {
            n = objectArray.length;
            int n6 = n << 1;
            if (n2 > n6) {
                n6 = n2;
            }
            Object[] objectArray2 = new Object[n6];
            System.arraycopy(objectArray, 0, objectArray2, 0, n);
            objectArray = objectArray2;
            this.idcFValues[iValueContainer.idcID] = objectArray2;
            int[] nArray = new int[n6];
            System.arraycopy(this.idcFTypes[iValueContainer.idcID], 0, nArray, 0, n);
            this.idcFTypes[iValueContainer.idcID] = nArray;
            int[][] nArrayArray = new int[n6][];
            System.arraycopy(this.idcFItemTypes[iValueContainer.idcID], 0, nArrayArray, 0, n);
            this.idcFItemTypes[iValueContainer.idcID] = nArrayArray;
        }
        for (n = iValueContainer.fieldCount; n > 0; --n) {
            objectArray[--n2] = null;
        }
        iValue.container = iValueContainer;
        return n5;
    }

    IValueContainer startIDCSelectorXPathState(XPathAction xPathAction) {
        Object object;
        int[] nArray = this.idcXPathStates[xPathAction.xpathID];
        int n = nArray[0];
        Object object2 = this.idcContainers[xPathAction.idcID];
        int n2 = xPathAction.idcID;
        int n3 = this.idcContainerListLengths[n2];
        this.idcContainerListLengths[n2] = n3 + 1;
        int n4 = n3;
        int[] nArray2 = this.idcKeyContext[xPathAction.idcID];
        int n5 = xPathAction.idcID;
        int n6 = this.idcCurrentContext[n5];
        this.idcCurrentContext[n5] = n6 + 1;
        int n7 = n6;
        if (n4 == 0) {
            this.idcActiveIValuePools[xPathAction.idcID] = this.getIVPool();
            this.idcActiveFValuePools[xPathAction.idcID] = this.getFVPool();
        }
        if (n + 2 >= nArray.length) {
            object = new int[nArray.length << 1];
            System.arraycopy(nArray, 0, object, 0, nArray.length);
            nArray = object;
            this.idcXPathStates[xPathAction.xpathID] = object;
        }
        this.saveIDCStateHistory(xPathAction.xpathID, n, 0);
        nArray[n++] = xPathAction.newState;
        nArray[n++] = this.vmContext.elementDepth + xPathAction.depthIncrement;
        nArray[n++] = n4;
        nArray[0] = n;
        if (xPathAction.idcCategory != 2) {
            if (n7 >= nArray2.length) {
                object = new int[nArray2.length << 1];
                System.arraycopy(nArray2, 0, object, 0, nArray2.length);
                nArray2 = object;
                this.idcKeyContext[xPathAction.idcID] = object;
            }
            nArray2[n7] = n4;
        }
        if (n4 >= ((IValueContainer[])object2).length) {
            object = new IValueContainer[((IValueContainer[])object2).length << 1];
            System.arraycopy(object2, 0, object, 0, ((IValueContainer[])object2).length);
            object2 = object;
            this.idcContainers[xPathAction.idcID] = (IValueContainer[])object;
        }
        object = this.getIVContainer();
        object.idcID = xPathAction.idcID;
        object.idcCategory = xPathAction.idcCategory;
        object.keyID = xPathAction.idcID4Key;
        object.fieldCount = xPathAction.fieldCount;
        object2[n4] = object;
        return object;
    }

    int startIDCFieldXPathState(XPathAction xPathAction, int n) {
        int[] nArray = this.idcXPathStates[xPathAction.xpathID];
        int n2 = nArray[0];
        int n3 = xPathAction.fieldIndex + n;
        if (n2 + 2 >= nArray.length) {
            int[] nArray2 = new int[nArray.length << 1];
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            nArray = nArray2;
            this.idcXPathStates[xPathAction.xpathID] = nArray2;
        }
        this.saveIDCStateHistory(xPathAction.xpathID, n2, 0);
        nArray[n2++] = xPathAction.newState;
        nArray[n2++] = this.vmContext.elementDepth + xPathAction.depthIncrement;
        nArray[n2++] = n3;
        nArray[0] = n2;
        return n3;
    }

    void saveIDCStateHistory(int n, int n2, int n3) {
        if (this.idcStateChangeHistorySize + 2 >= this.idcStateChangeHistory.length) {
            int[] nArray = new int[this.idcStateChangeHistory.length << 1];
            System.arraycopy(this.idcStateChangeHistory, 0, nArray, 0, this.idcStateChangeHistory.length);
            this.idcStateChangeHistory = nArray;
        }
        this.idcStateChangeHistory[this.idcStateChangeHistorySize++] = n;
        this.idcStateChangeHistory[this.idcStateChangeHistorySize++] = n2;
        this.idcStateChangeHistory[this.idcStateChangeHistorySize++] = n3;
    }

    public void startIDCStateHistoryContext() {
        if (this.idcStateChangeHistoryContext.length == ++this.idcStateChangeHistoryCurrentContext) {
            int[] nArray = new int[this.idcStateChangeHistoryContext.length << 1];
            System.arraycopy(this.idcStateChangeHistoryContext, 0, nArray, 0, this.idcStateChangeHistoryContext.length);
            this.idcStateChangeHistoryContext = nArray;
        }
        this.idcStateChangeHistoryContext[this.idcStateChangeHistoryCurrentContext] = this.idcStateChangeHistorySize;
    }

    public void endIDCStateHistoryContext() {
        int n = this.idcStateChangeHistorySize;
        int n2 = this.vmContext.elementDepth;
        this.idcStateChangeHistorySize = this.idcStateChangeHistoryContext[this.idcStateChangeHistoryCurrentContext--];
        while (n > this.idcStateChangeHistorySize) {
            Object object;
            int n3;
            int n4 = this.idcStateChangeHistory[--n];
            int n5 = this.idcStateChangeHistory[--n];
            if ((n3 = this.idcStateChangeHistory[--n]) >= 0) {
                int n6;
                object = this.idcXPathStates[n3];
                if (n3 >= this.idcIValues4ActiveFields.length && object[n5] < 0) {
                    if (!this.vmContext.currentElementHasSimpleContent()) {
                        this.vmContext.generateError(35, this.vmContext.elementType.localName);
                    } else {
                        ValidatedInfo validatedInfo = this.vmContext.currentElementActualValue();
                        int n7 = this.xpathDFAs[n3].idcID;
                        n6 = object[n5 + 2];
                        if (this.idcFValues[n7][n6] == null) {
                            this.idcFValues[n7][n6] = this.copyFValue(n7, validatedInfo.actualValue, validatedInfo.typeValidator.builtInKind, validatedInfo.itemBuiltinKinds);
                            this.idcFTypes[n7][n6] = validatedInfo.typeValidator.builtInKind;
                            this.idcFItemTypes[n7][n6] = validatedInfo.itemBuiltinKinds;
                        } else {
                            this.vmContext.generateError(32);
                        }
                    }
                }
                if (n4 != 0) {
                    object[n5] = n4;
                    object[n5 + 1] = n2;
                    continue;
                }
                if (n3 < this.idcIValues4ActiveFields.length) {
                    int n8 = this.idcContainerListLengths[n3] - 1;
                    IValueContainer iValueContainer = this.idcContainers[n3][n8];
                    if (iValueContainer.idcCategory == 2) {
                        n6 = this.idcCurrentContext[iValueContainer.keyID];
                        if (!iValueContainer.resolveKeyref(this.idcContainers[iValueContainer.keyID], this.idcContainerListLengths[iValueContainer.keyID], this.idcKeyContext[iValueContainer.keyID][n6])) {
                            this.vmContext.generateError(34);
                        }
                        int n9 = n3;
                        this.idcContainerListLengths[n9] = this.idcContainerListLengths[n9] - 1;
                        this.returnIVContainer(iValueContainer);
                        if (n8 == 0) {
                            this.returnIVPool(this.idcActiveIValuePools[n3]);
                            this.returnFVPool(this.idcActiveFValuePools[n3]);
                        }
                    } else {
                        int n10;
                        int n11 = n3;
                        int n12 = this.idcCurrentContext[n11] - 1;
                        this.idcCurrentContext[n11] = n12;
                        n6 = n12;
                        int n13 = this.idcKeyContext[n3][n6];
                        iValueContainer = this.idcContainers[n3][n13];
                        for (n10 = n13 + 1; n10 < n8; ++n10) {
                            iValueContainer.removeConflictKeys(this.idcContainers[n3][n10], true);
                        }
                        n10 = this.idcCurrentContext[n3] - 1;
                        if (n10 >= 0) {
                            int n14 = this.idcKeyContext[n3][n10] + 1;
                            for (int i = n13; i < n8; ++i) {
                                for (int j = n14; j < n13; ++j) {
                                    this.idcContainers[n3][i].removeConflictKeys(this.idcContainers[n3][j], false);
                                }
                            }
                        }
                    }
                }
                object[0] = object[0] - 3;
                continue;
            }
            object = this.idcIValues4ActiveFields[n5][n4];
            object.container.add((IValue)object);
        }
    }

    Object copyFValue(int n, Object object, int n2, int[] nArray) {
        switch (n2) {
            case 1: 
            case 2: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                XMLStringKey xMLStringKey = this.idcActiveFValuePools[n].getXMLString();
                xMLStringKey.fill((XMLString)object);
                return xMLStringKey;
            }
            case 3: {
                return object;
            }
            case 4: 
            case 30: 
            case 31: 
            case 32: 
            case 37: 
            case 38: 
            case 42: {
                if (object == XDecimal.ZERO) {
                    return object;
                }
                XDecimal xDecimal = this.idcActiveFValuePools[n].getXDecimal();
                XDecimal xDecimal2 = (XDecimal)object;
                xDecimal.sign = xDecimal2.sign;
                xDecimal.totalDigits = xDecimal2.totalDigits;
                xDecimal.intDigits = xDecimal2.intDigits;
                xDecimal.fracDigits = xDecimal2.fracDigits;
                xDecimal.rawData.setValues(xDecimal2.rawData);
                return xDecimal;
            }
            case 16: 
            case 17: {
                XBinary xBinary = this.idcActiveFValuePools[n].getXBinary();
                XBinary xBinary2 = (XBinary)object;
                xBinary.length = xBinary2.length;
                if (xBinary.value.length < xBinary.length) {
                    xBinary.value = new byte[xBinary.length];
                }
                System.arraycopy(xBinary2.value, 0, xBinary.value, 0, xBinary.length);
                return xBinary;
            }
            case 33: 
            case 39: {
                return this.idcActiveFValuePools[n].getXLong(((XLong)object).value);
            }
            case 34: 
            case 40: {
                return this.idcActiveFValuePools[n].getXInt(((XInt)object).value);
            }
            case 35: 
            case 41: {
                return this.idcActiveFValuePools[n].getXShort(((XShort)object).value);
            }
            case 36: {
                return this.idcActiveFValuePools[n].getXByte(((XByte)object).value);
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                XDateTime xDateTime = this.idcActiveFValuePools[n].getXDateTime();
                XDateTime xDateTime2 = (XDateTime)object;
                xDateTime.year = xDateTime2.year;
                xDateTime.month = xDateTime2.month;
                xDateTime.day = xDateTime2.day;
                xDateTime.hour = xDateTime2.hour;
                xDateTime.minute = xDateTime2.minute;
                xDateTime.utc = xDateTime2.utc;
                xDateTime.second = xDateTime2.second;
                xDateTime.timezoneHr = xDateTime2.timezoneHr;
                xDateTime.timezoneMin = xDateTime2.timezoneMin;
                xDateTime.position = xDateTime2.position;
                xDateTime.type = xDateTime2.type;
                return xDateTime;
            }
            case 5: {
                return this.idcActiveFValuePools[n].getXFloat(((XFloat)object).value);
            }
            case 6: {
                return this.idcActiveFValuePools[n].getXDouble(((XDouble)object).value);
            }
            case 19: {
                QNameKey qNameKey = this.idcActiveFValuePools[n].getQName();
                QName qName = (QName)object;
                qNameKey.fill(qName.nsURI, qName.localName);
                return qNameKey;
            }
            case 44: {
                XList xList = this.idcActiveFValuePools[n].getXList();
                XList xList2 = (XList)object;
                if (xList2.length > xList.value.length) {
                    xList2.value = new Object[xList2.length << 1];
                }
                for (int i = 0; i < xList2.length; ++i) {
                    xList.value[i] = this.copyFValue(n, xList2.value[i], nArray[i], null);
                }
                xList.length = xList2.length;
                return xList;
            }
        }
        return null;
    }

    public void reset() {
        if (this.idcCount == 0) {
            return;
        }
        this.idcStateChangeHistoryCurrentContext = -1;
        this.idcStateChangeHistorySize = 0;
        for (int i = 0; i < this.xpathCount; ++i) {
            this.idcXPathStates[i][0] = 1;
        }
        System.arraycopy(this.emptyArray, 0, this.idcContainerListLengths, 0, this.idcCount);
        System.arraycopy(this.emptyArray, 0, this.idcIValuesListLengths, 0, this.idcCount);
        System.arraycopy(this.emptyArray, 0, this.idcFValueListLengths, 0, this.idcCount);
    }

    IValueContainer getIVContainer() {
        if (this.fIVCPool == null) {
            return new IValueContainer(this);
        }
        IValueContainer iValueContainer = this.fIVCPool;
        this.fIVCPool = this.fIVCPool.nextInPool;
        iValueContainer.clear();
        return iValueContainer;
    }

    void returnIVContainer(IValueContainer iValueContainer) {
        iValueContainer.nextInPool = this.fIVCPool;
        this.fIVCPool = iValueContainer;
    }

    IValuePool getIVPool() {
        if (this.fIVPoolPool == null) {
            return new IValuePool();
        }
        IValuePool iValuePool = this.fIVPoolPool;
        this.fIVPoolPool = this.fIVPoolPool.nextInPool;
        return iValuePool;
    }

    void returnIVPool(IValuePool iValuePool) {
        iValuePool.resetIVPool(true);
        iValuePool.nextInPool = this.fIVPoolPool;
        this.fIVPoolPool = iValuePool;
    }

    FValuePool getFVPool() {
        if (this.fFVPoolPool == null) {
            return new FValuePool();
        }
        FValuePool fValuePool = this.fFVPoolPool;
        this.fFVPoolPool = this.fFVPoolPool.nextInPool;
        return fValuePool;
    }

    void returnFVPool(FValuePool fValuePool) {
        fValuePool.resetFVPools();
        fValuePool.nextInPool = this.fFVPoolPool;
        this.fFVPoolPool = fValuePool;
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2010. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    static final class FValuePool {
        FValuePool nextInPool;
        private XByte[] idcXBytePool;
        private int idcXBytePoolResetCount = 0;
        private int idcXBytePoolOffset = 0;
        private XMLStringKey[] idcXMLStringPool;
        private int idcXMLStringPoolResetCount = 0;
        private int idcXMLStringPoolOffset = 0;
        private QNameKey[] idcQNamePool;
        private int idcQNamePoolResetCount = 0;
        private int idcQNamePoolOffset = 0;
        private XList[] idcXListPool;
        private int idcXListPoolResetCount = 0;
        private int idcXListPoolOffset;
        private XDateTime[] idcXDateTimePool;
        private int idcXDateTimePoolResetCount = 0;
        private int idcXDateTimePoolOffset = 0;
        private XBinary[] idcXBinaryPool;
        private int idcXBinaryPoolResetCount = 0;
        private int idcXBinaryPoolOffset = 0;
        private XShort[] idcXShortPool;
        private int idcXShortPoolResetCount = 0;
        private int idcXShortPoolOffset = 0;
        private XInt[] idcXIntPool;
        private int idcXIntPoolResetCount = 0;
        private int idcXIntPoolOffset = 0;
        private XLong[] idcXLongPool;
        private int idcXLongPoolResetCount = 0;
        private int idcXLongPoolOffset = 0;
        private XFloat[] idcXFloatPool;
        private int idcXFloatPoolResetCount = 0;
        private int idcXFloatPoolOffset = 0;
        private XDouble[] idcXDoublePool;
        private int idcXDoublePoolResetCount = 0;
        private int idcXDoublePoolOffset = 0;
        private XDecimal[] idcXDecimalPool;
        private int idcXDecimalPoolResetCount = 0;
        private int idcXDecimalPoolOffset = 0;
        private int idcObjectPoolsResetCount = 0;

        FValuePool() {
            this.createObjectPools();
        }

        private void createObjectPools() {
            int n;
            this.idcXBytePool = new XByte[4];
            for (n = 0; n < 4; ++n) {
                this.idcXBytePool[n] = new XByte();
            }
            this.idcXMLStringPool = new XMLStringKey[4];
            for (n = 0; n < 4; ++n) {
                this.idcXMLStringPool[n] = new XMLStringKey();
            }
            this.idcQNamePool = new QNameKey[4];
            for (n = 0; n < 4; ++n) {
                this.idcQNamePool[n] = new QNameKey();
            }
            this.idcXListPool = new XList[4];
            for (n = 0; n < 4; ++n) {
                this.idcXListPool[n] = new XList();
                this.idcXListPool[n].value = new Object[8];
            }
            this.idcXDateTimePool = new XDateTime[4];
            for (n = 0; n < 4; ++n) {
                this.idcXDateTimePool[n] = new XDateTime();
            }
            this.idcXBinaryPool = new XBinary[4];
            for (n = 0; n < 4; ++n) {
                this.idcXBinaryPool[n] = new XBinary();
                this.idcXBinaryPool[n].value = new byte[1024];
            }
            this.idcXShortPool = new XShort[4];
            for (n = 0; n < 4; ++n) {
                this.idcXShortPool[n] = new XShort();
            }
            this.idcXIntPool = new XInt[4];
            for (n = 0; n < 4; ++n) {
                this.idcXIntPool[n] = new XInt();
            }
            this.idcXLongPool = new XLong[4];
            for (n = 0; n < 4; ++n) {
                this.idcXLongPool[n] = new XLong();
            }
            this.idcXFloatPool = new XFloat[4];
            for (n = 0; n < 4; ++n) {
                this.idcXFloatPool[n] = new XFloat();
            }
            this.idcXDoublePool = new XDouble[4];
            for (n = 0; n < 4; ++n) {
                this.idcXDoublePool[n] = new XDouble();
            }
            this.idcXDecimalPool = new XDecimal[4];
            for (n = 0; n < 4; ++n) {
                this.idcXDecimalPool[n] = new XDecimal();
                this.idcXDecimalPool[n].rawData = new XMLString();
            }
        }

        XByte getXByte(byte by) {
            if (this.idcXBytePoolResetCount != this.idcObjectPoolsResetCount) {
                this.idcXBytePoolResetCount = this.idcObjectPoolsResetCount;
                this.idcXBytePoolOffset = 0;
            } else if (++this.idcXBytePoolOffset == this.idcXBytePool.length) {
                this.growXBytePool();
            }
            XByte xByte = this.idcXBytePool[this.idcXBytePoolOffset];
            xByte.value = by;
            return xByte;
        }

        private void growXBytePool() {
            int n = this.idcXBytePool.length;
            int n2 = n << 1;
            XByte[] xByteArray = new XByte[n2];
            System.arraycopy(this.idcXBytePool, 0, xByteArray, 0, n);
            this.idcXBytePool = xByteArray;
            for (int i = n2 - 1; i >= n; --i) {
                this.idcXBytePool[i] = new XByte();
            }
        }

        XMLStringKey getXMLString() {
            if (this.idcXMLStringPoolResetCount != this.idcObjectPoolsResetCount) {
                this.idcXMLStringPoolResetCount = this.idcObjectPoolsResetCount;
                this.idcXMLStringPoolOffset = 0;
            } else if (++this.idcXMLStringPoolOffset == this.idcXMLStringPool.length) {
                this.growXMLStringPool();
            }
            XMLStringKey xMLStringKey = this.idcXMLStringPool[this.idcXMLStringPoolOffset];
            return xMLStringKey;
        }

        private void growXMLStringPool() {
            int n = this.idcXMLStringPool.length;
            int n2 = n << 1;
            XMLStringKey[] xMLStringKeyArray = new XMLStringKey[n2];
            System.arraycopy(this.idcXMLStringPool, 0, xMLStringKeyArray, 0, n);
            this.idcXMLStringPool = xMLStringKeyArray;
            for (int i = n2 - 1; i >= n; --i) {
                this.idcXMLStringPool[i] = new XMLStringKey();
            }
        }

        QNameKey getQName() {
            if (this.idcQNamePoolResetCount != this.idcObjectPoolsResetCount) {
                this.idcQNamePoolResetCount = this.idcObjectPoolsResetCount;
                this.idcQNamePoolOffset = 0;
            } else if (++this.idcQNamePoolOffset == this.idcQNamePool.length) {
                this.growQNamePool();
            }
            QNameKey qNameKey = this.idcQNamePool[this.idcQNamePoolOffset];
            return qNameKey;
        }

        private void growQNamePool() {
            int n = this.idcQNamePool.length;
            int n2 = n << 1;
            QNameKey[] qNameKeyArray = new QNameKey[n2];
            System.arraycopy(this.idcQNamePool, 0, qNameKeyArray, 0, n);
            this.idcQNamePool = qNameKeyArray;
            for (int i = n2 - 1; i >= n; --i) {
                this.idcQNamePool[i] = new QNameKey();
            }
        }

        XList getXList() {
            if (this.idcXListPoolResetCount != this.idcObjectPoolsResetCount) {
                this.idcXListPoolResetCount = this.idcObjectPoolsResetCount;
                this.idcXListPoolOffset = 0;
            } else if (++this.idcXListPoolOffset == this.idcXListPool.length) {
                this.growXListPool();
            }
            XList xList = this.idcXListPool[this.idcXListPoolOffset];
            return xList;
        }

        private void growXListPool() {
            int n = this.idcXListPool.length;
            int n2 = n << 1;
            XList[] xListArray = new XList[n2];
            System.arraycopy(this.idcXListPool, 0, xListArray, 0, n);
            this.idcXListPool = xListArray;
            for (int i = n2 - 1; i >= n; --i) {
                this.idcXListPool[i] = new XList();
                this.idcXListPool[i].value = new Object[8];
            }
        }

        XDateTime getXDateTime() {
            if (this.idcXDateTimePoolResetCount != this.idcObjectPoolsResetCount) {
                this.idcXDateTimePoolResetCount = this.idcObjectPoolsResetCount;
                this.idcXDateTimePoolOffset = 0;
            } else if (++this.idcXDateTimePoolOffset == this.idcXDateTimePool.length) {
                this.growXDateTimePool();
            }
            XDateTime xDateTime = this.idcXDateTimePool[this.idcXDateTimePoolOffset];
            return xDateTime;
        }

        private void growXDateTimePool() {
            int n = this.idcXDateTimePool.length;
            int n2 = n << 1;
            XDateTime[] xDateTimeArray = new XDateTime[n2];
            System.arraycopy(this.idcXDateTimePool, 0, xDateTimeArray, 0, n);
            this.idcXDateTimePool = xDateTimeArray;
            for (int i = n2 - 1; i >= n; --i) {
                this.idcXDateTimePool[i] = new XDateTime();
            }
        }

        XBinary getXBinary() {
            if (this.idcXBinaryPoolResetCount != this.idcObjectPoolsResetCount) {
                this.idcXBinaryPoolResetCount = this.idcObjectPoolsResetCount;
                this.idcXBinaryPoolOffset = 0;
            } else if (++this.idcXBinaryPoolOffset == this.idcXBinaryPool.length) {
                this.growXBinaryPool();
            }
            XBinary xBinary = this.idcXBinaryPool[this.idcXBinaryPoolOffset];
            return xBinary;
        }

        private void growXBinaryPool() {
            int n = this.idcXBinaryPool.length;
            int n2 = n << 1;
            XBinary[] xBinaryArray = new XBinary[n2];
            System.arraycopy(this.idcXBinaryPool, 0, xBinaryArray, 0, n);
            this.idcXBinaryPool = xBinaryArray;
            for (int i = n2 - 1; i >= n; --i) {
                this.idcXBinaryPool[i] = new XBinary();
                this.idcXBinaryPool[i].value = new byte[1024];
            }
        }

        XShort getXShort(short s) {
            if (this.idcXShortPoolResetCount != this.idcObjectPoolsResetCount) {
                this.idcXShortPoolResetCount = this.idcObjectPoolsResetCount;
                this.idcXShortPoolOffset = 0;
            } else if (++this.idcXShortPoolOffset == this.idcXShortPool.length) {
                this.growXShortPool();
            }
            XShort xShort = this.idcXShortPool[this.idcXShortPoolOffset];
            xShort.value = s;
            return xShort;
        }

        private void growXShortPool() {
            int n = this.idcXShortPool.length;
            int n2 = n << 1;
            XShort[] xShortArray = new XShort[n2];
            System.arraycopy(this.idcXShortPool, 0, xShortArray, 0, n);
            this.idcXShortPool = xShortArray;
            for (int i = n2 - 1; i >= n; --i) {
                this.idcXShortPool[i] = new XShort();
            }
        }

        XInt getXInt(int n) {
            if (this.idcXIntPoolResetCount != this.idcObjectPoolsResetCount) {
                this.idcXIntPoolResetCount = this.idcObjectPoolsResetCount;
                this.idcXIntPoolOffset = 0;
            } else if (++this.idcXIntPoolOffset == this.idcXIntPool.length) {
                this.growXIntPool();
            }
            XInt xInt = this.idcXIntPool[this.idcXIntPoolOffset];
            xInt.value = n;
            return xInt;
        }

        private void growXIntPool() {
            int n = this.idcXIntPool.length;
            int n2 = n << 1;
            XInt[] xIntArray = new XInt[n2];
            System.arraycopy(this.idcXIntPool, 0, xIntArray, 0, n);
            this.idcXIntPool = xIntArray;
            for (int i = n2 - 1; i >= n; --i) {
                this.idcXIntPool[i] = new XInt();
            }
        }

        XLong getXLong(long l) {
            if (this.idcXLongPoolResetCount != this.idcObjectPoolsResetCount) {
                this.idcXLongPoolResetCount = this.idcObjectPoolsResetCount;
                this.idcXLongPoolOffset = 0;
            } else if (++this.idcXLongPoolOffset == this.idcXLongPool.length) {
                this.growXLongPool();
            }
            XLong xLong = this.idcXLongPool[this.idcXLongPoolOffset];
            xLong.value = l;
            return xLong;
        }

        private void growXLongPool() {
            int n = this.idcXLongPool.length;
            int n2 = n << 1;
            XLong[] xLongArray = new XLong[n2];
            System.arraycopy(this.idcXLongPool, 0, xLongArray, 0, n);
            this.idcXLongPool = xLongArray;
            for (int i = n2 - 1; i >= n; --i) {
                this.idcXLongPool[i] = new XLong();
            }
        }

        XFloat getXFloat(float f) {
            if (this.idcXFloatPoolResetCount != this.idcObjectPoolsResetCount) {
                this.idcXFloatPoolResetCount = this.idcObjectPoolsResetCount;
                this.idcXFloatPoolOffset = 0;
            } else if (++this.idcXFloatPoolOffset == this.idcXFloatPool.length) {
                this.growXFloatPool();
            }
            XFloat xFloat = this.idcXFloatPool[this.idcXFloatPoolOffset];
            xFloat.value = f;
            return xFloat;
        }

        private void growXFloatPool() {
            int n = this.idcXFloatPool.length;
            int n2 = n << 1;
            XFloat[] xFloatArray = new XFloat[n2];
            System.arraycopy(this.idcXFloatPool, 0, xFloatArray, 0, n);
            this.idcXFloatPool = xFloatArray;
            for (int i = n2 - 1; i >= n; --i) {
                this.idcXFloatPool[i] = new XFloat();
            }
        }

        XDouble getXDouble(double d) {
            if (this.idcXDoublePoolResetCount != this.idcObjectPoolsResetCount) {
                this.idcXDoublePoolResetCount = this.idcObjectPoolsResetCount;
                this.idcXDoublePoolOffset = 0;
            } else if (++this.idcXDoublePoolOffset == this.idcXDoublePool.length) {
                this.growXDoublePool();
            }
            XDouble xDouble = this.idcXDoublePool[this.idcXDoublePoolOffset];
            xDouble.value = d;
            return xDouble;
        }

        private void growXDoublePool() {
            int n = this.idcXDoublePool.length;
            int n2 = n << 1;
            XDouble[] xDoubleArray = new XDouble[n2];
            System.arraycopy(this.idcXDoublePool, 0, xDoubleArray, 0, n);
            this.idcXDoublePool = xDoubleArray;
            for (int i = n2 - 1; i >= n; --i) {
                this.idcXDoublePool[i] = new XDouble();
            }
        }

        XDecimal getXDecimal() {
            if (this.idcXDecimalPoolResetCount != this.idcObjectPoolsResetCount) {
                this.idcXDecimalPoolResetCount = this.idcObjectPoolsResetCount;
                this.idcXDecimalPoolOffset = 0;
            } else if (++this.idcXDecimalPoolOffset == this.idcXDecimalPool.length) {
                this.growXDecimalPool();
            }
            return this.idcXDecimalPool[this.idcXDecimalPoolOffset];
        }

        private void growXDecimalPool() {
            int n = this.idcXDecimalPool.length;
            int n2 = n << 1;
            XDecimal[] xDecimalArray = new XDecimal[n2];
            System.arraycopy(this.idcXDecimalPool, 0, xDecimalArray, 0, n);
            this.idcXDecimalPool = xDecimalArray;
            for (int i = n2 - 1; i >= n; --i) {
                this.idcXDecimalPool[i] = new XDecimal();
                this.idcXDecimalPool[i].rawData = new XMLString();
            }
        }

        void resetFVPools() {
            if (++this.idcObjectPoolsResetCount < 0) {
                this.resetObjectPoolResetCounts();
            }
        }

        private void resetObjectPoolResetCounts() {
            this.idcObjectPoolsResetCount = 1;
            this.idcXBytePoolResetCount = 0;
            this.idcXMLStringPoolResetCount = 0;
            this.idcQNamePoolResetCount = 0;
            this.idcXListPoolResetCount = 0;
            this.idcXDateTimePoolResetCount = 0;
            this.idcXBinaryPoolResetCount = 0;
            this.idcXShortPoolResetCount = 0;
            this.idcXIntPoolResetCount = 0;
            this.idcXLongPoolResetCount = 0;
            this.idcXFloatPoolResetCount = 0;
            this.idcXDoublePoolResetCount = 0;
            this.idcXDecimalPoolResetCount = 0;
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2010. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    static final class IValuePool {
        IValuePool nextInPool;
        private IValue[] fIVPool = new IValue[4];
        private int fIVPoolOffset = 0;

        IValuePool() {
            for (int i = 0; i < 4; ++i) {
                this.fIVPool[i] = new IValue();
            }
        }

        IValue getIValue() {
            if (++this.fIVPoolOffset == this.fIVPool.length) {
                this.growIValuePool();
            }
            return this.fIVPool[this.fIVPoolOffset];
        }

        private void growIValuePool() {
            int n = this.fIVPool.length;
            int n2 = n << 1;
            IValue[] iValueArray = new IValue[n2];
            System.arraycopy(this.fIVPool, 0, iValueArray, 0, n);
            this.fIVPool = iValueArray;
            for (int i = n2 - 1; i >= n; --i) {
                this.fIVPool[i] = new IValue();
            }
        }

        void resetIVPool(boolean bl) {
            this.fIVPoolOffset = 0;
            if (!bl && this.fIVPool.length > 4) {
                IValue[] iValueArray = new IValue[4];
                System.arraycopy(this.fIVPool, 0, iValueArray, 0, 4);
                this.fIVPool = iValueArray;
            }
        }
    }
}

