/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.scan.util;

import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.util.DataBuffer;
import com.ibm.xml.xlxp2.scan.util.XMLString;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class QName
extends XMLString {
    public String rawName;
    public String nsURI;
    public String localName;
    public String prefix;

    public QName() {
    }

    public QName(QName qName) {
        super(qName);
        this.rawName = qName.rawName;
        this.nsURI = qName.nsURI;
        this.localName = qName.localName;
        this.prefix = qName.prefix;
    }

    public void clear() {
        if (this.firstBuffer != null) {
            super.clear();
            this.rawName = null;
            this.nsURI = null;
            this.localName = null;
            this.prefix = null;
        }
    }

    public void setValues(QName qName) {
        if (qName != null && qName.firstBuffer != null) {
            super.setValues(qName);
            this.rawName = qName.rawName;
            this.nsURI = qName.nsURI;
            this.localName = qName.localName;
            this.prefix = qName.prefix;
        } else {
            this.clear();
        }
    }

    public int getSepOffset(DataBuffer dataBuffer, int n) {
        int n2;
        if (dataBuffer == this.firstBuffer) {
            n2 = n - this.startOffset;
        } else {
            DataBuffer dataBuffer2 = this.firstBuffer;
            n2 = dataBuffer2.endOffset - this.startOffset;
            dataBuffer2 = dataBuffer2.next;
            while (dataBuffer2 != dataBuffer) {
                n2 += dataBuffer2.endOffset - dataBuffer2.startOffset;
                dataBuffer2 = dataBuffer2.next;
            }
            n2 += n - dataBuffer.startOffset;
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof QName) {
            QName qName = (QName)object;
            return this.localName.equals(qName.localName) && this.nsURI.equals(qName.nsURI);
        }
        if (object instanceof XMLString) {
            throw new RuntimeException("QName.equals(XMLString) called");
        }
        return false;
    }
}

