/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.jaxb.codegen.fcg;

import com.ibm.fcg.FcgClassReferenceType;
import com.ibm.fcg.FcgCodeGen;
import com.ibm.fcg.FcgType;
import com.ibm.xml.xlxp2.scan.Copyright;
import java.math.BigDecimal;
import java.math.BigInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2007, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class FCGTypeUtil {
    private FCGTypeUtil() {
    }

    public static FcgType getFcgType(Class<?> clazz, FcgCodeGen fcgCodeGen) {
        if (clazz.isArray()) {
            return FCGTypeUtil.getFcgArrayType(clazz, fcgCodeGen);
        }
        FcgType fcgType = FCGTypeUtil.getFcgBuiltinType(clazz, fcgCodeGen);
        if (fcgType != null) {
            return fcgType;
        }
        if (clazz.isMemberClass()) {
            return fcgCodeGen.getInnerClassReferenceType(clazz.getEnclosingClass().getName(), clazz.getSimpleName());
        }
        String string = clazz.getCanonicalName();
        if (clazz.isInterface()) {
            return fcgCodeGen.getInterfaceType(string);
        }
        return fcgCodeGen.getClassReferenceType(string);
    }

    private static FcgType getFcgBuiltinType(Class<?> clazz, FcgCodeGen fcgCodeGen) {
        if (clazz == Void.TYPE) {
            return FcgType.VOID;
        }
        if (clazz == Boolean.TYPE) {
            return FcgType.BOOLEAN;
        }
        if (clazz == Byte.TYPE) {
            return FcgType.BYTE;
        }
        if (clazz == Short.TYPE) {
            return FcgType.SHORT;
        }
        if (clazz == Character.TYPE) {
            return FcgType.CHAR;
        }
        if (clazz == Integer.TYPE) {
            return FcgType.INT;
        }
        if (clazz == Long.TYPE) {
            return FcgType.LONG;
        }
        if (clazz == Float.TYPE) {
            return FcgType.FLOAT;
        }
        if (clazz == Double.TYPE) {
            return FcgType.DOUBLE;
        }
        if (clazz == BigDecimal.class) {
            return FcgType.BIG_DECIMAL;
        }
        if (clazz == BigInteger.class) {
            return FcgType.BIG_INTEGER;
        }
        if (clazz == String.class) {
            return FcgType.STRING;
        }
        return null;
    }

    private static FcgType getFcgArrayType(Class<?> clazz, FcgCodeGen fcgCodeGen) {
        if (clazz == boolean[].class) {
            return FcgType.BOOLEAN_ARRAY;
        }
        if (clazz == byte[].class) {
            return FcgType.BYTE_ARRAY;
        }
        if (clazz == short[].class) {
            return FcgType.SHORT_ARRAY;
        }
        if (clazz == char[].class) {
            return FcgType.CHAR_ARRAY;
        }
        if (clazz == int[].class) {
            return FcgType.INT_ARRAY;
        }
        if (clazz == long[].class) {
            return FcgType.LONG_ARRAY;
        }
        if (clazz == float[].class) {
            return FcgType.FLOAT_ARRAY;
        }
        if (clazz == double[].class) {
            return FcgType.DOUBLE_ARRAY;
        }
        int n = 0;
        while (clazz.isArray()) {
            ++n;
            clazz = clazz.getComponentType();
        }
        FcgType fcgType = FCGTypeUtil.getFcgType(clazz, fcgCodeGen);
        for (int i = 0; i < n; ++i) {
            fcgType = fcgCodeGen.getArrayType(fcgType);
        }
        return fcgType;
    }

    public static FcgClassReferenceType getPrimitiveWrapperType(FcgCodeGen fcgCodeGen, FcgType fcgType) {
        if (fcgType == FcgType.BOOLEAN) {
            return fcgCodeGen.getClassReferenceType("java.lang.Boolean");
        }
        if (fcgType == FcgType.BYTE) {
            return fcgCodeGen.getClassReferenceType("java.lang.Byte");
        }
        if (fcgType == FcgType.SHORT) {
            return fcgCodeGen.getClassReferenceType("java.lang.Short");
        }
        if (fcgType == FcgType.INT) {
            return fcgCodeGen.getClassReferenceType("java.lang.Integer");
        }
        if (fcgType == FcgType.LONG) {
            return fcgCodeGen.getClassReferenceType("java.lang.Long");
        }
        if (fcgType == FcgType.FLOAT) {
            return fcgCodeGen.getClassReferenceType("java.lang.Float");
        }
        if (fcgType == FcgType.DOUBLE) {
            return fcgCodeGen.getClassReferenceType("java.lang.Double");
        }
        if (fcgType == FcgType.CHAR) {
            return fcgCodeGen.getClassReferenceType("java.lang.Character");
        }
        return null;
    }

    public static String getPrimitiveMethodName(FcgType fcgType) {
        if (fcgType == FcgType.BOOLEAN) {
            return "booleanValue";
        }
        if (fcgType == FcgType.BYTE) {
            return "byteValue";
        }
        if (fcgType == FcgType.SHORT) {
            return "shortValue";
        }
        if (fcgType == FcgType.INT) {
            return "intValue";
        }
        if (fcgType == FcgType.LONG) {
            return "longValue";
        }
        if (fcgType == FcgType.FLOAT) {
            return "floatValue";
        }
        if (fcgType == FcgType.DOUBLE) {
            return "doubleValue";
        }
        if (fcgType == FcgType.CHAR) {
            return "charValue";
        }
        return null;
    }

    public static boolean isPrimitiveClass(Class<?> clazz) {
        return clazz == Boolean.TYPE || clazz == Byte.TYPE || clazz == Short.TYPE || clazz == Integer.TYPE || clazz == Long.TYPE || clazz == Float.TYPE || clazz == Double.TYPE || clazz == Character.TYPE;
    }

    public static boolean isPrimitiveType(FcgType fcgType) {
        return fcgType == FcgType.BOOLEAN || fcgType == FcgType.BYTE || fcgType == FcgType.SHORT || fcgType == FcgType.INT || fcgType == FcgType.LONG || fcgType == FcgType.FLOAT || fcgType == FcgType.DOUBLE || fcgType == FcgType.CHAR;
    }

    public static boolean isPrimitiveWrapperClass(Class<?> clazz) {
        return clazz == Boolean.class || clazz == Byte.class || clazz == Short.class || clazz == Integer.class || clazz == Long.class || clazz == Float.class || clazz == Double.class || clazz == Character.class;
    }

    public static boolean isPrimitiveWrapperType(FcgType fcgType) {
        String string = fcgType.getTypeName();
        return "java.lang.Boolean".equals(string) || "java.lang.Byte".equals(string) || "java.lang.Short".equals(string) || "java.lang.Integer".equals(string) || "java.lang.Long".equals(string) || "java.lang.Float".equals(string) || "java.lang.Double".equals(string) || "java.lang.Character".equals(string);
    }
}

