/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.datatype.validation;

import com.ibm.xml.xlxp2.datatype.ValidatedInfo;
import com.ibm.xml.xlxp2.datatype.XBinary;
import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.util.ArrayAllocator;
import com.ibm.xml.xlxp2.scan.util.DataBuffer;
import com.ibm.xml.xlxp2.scan.util.ParsedEntity;
import com.ibm.xml.xlxp2.scan.util.XMLString;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2010. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public class XSBase64BinaryUtil {
    private static final byte[] base64CharTo6BitGroupMap = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private static final XBinary ZERO_LENGTH_BASE64_BINARY = new XBinary(ArrayAllocator.newByteArray(0), 0);

    public static XBinary parseBase64Binary(XMLString xMLString) {
        if (xMLString.length == 0) {
            return ZERO_LENGTH_BASE64_BINARY;
        }
        if (xMLString.bytes != null) {
            return XSBase64BinaryUtil.parseBase64BinaryUnbuffered(xMLString);
        }
        return XSBase64BinaryUtil.parseBase64BinaryBuffered(xMLString);
    }

    private static XBinary parseBase64BinaryUnbuffered(XMLString xMLString) {
        int n = xMLString.startOffset;
        int n2 = xMLString.endOffset;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        n3 = xMLString.bytes[n2 - 1];
        if (n3 == 61) {
            ++n5;
            n3 = xMLString.bytes[n2 - 2];
            if (n3 == 61) {
                ++n5;
            }
        }
        byte[] byArray = ArrayAllocator.newByteArray(xMLString.length - (xMLString.length >> 2) - n5);
        int n6 = 0;
        byte[] byArray2 = ArrayAllocator.newByteArray(4);
        int n7 = 0;
        block0: while (true) {
            n7 = 0;
            while (n < n2) {
                n3 = xMLString.bytes[n];
                if (n3 == 32 || n3 == 10 || n3 == 9 || n3 == 13) {
                    ++n;
                    continue;
                }
                if (n3 == 61) break block0;
                n4 = n3;
                byArray2[n7] = base64CharTo6BitGroupMap[n3 & 0xFF];
                if (byArray2[n7] == -1) {
                    return null;
                }
                if (++n7 == 4) break;
                ++n;
            }
            if (n == n2) break;
            ++n;
            byArray[n6++] = (byte)(byArray2[0] << 2 | byArray2[1] >> 4);
            byArray[n6++] = (byte)(byArray2[1] << 4 | byArray2[2] >> 2);
            byArray[n6++] = (byte)(byArray2[2] << 6 | byArray2[3]);
        }
        while (n < n2) {
            n3 = xMLString.bytes[n];
            if (n3 == 32 || n3 == 10 || n3 == 9 || n3 == 13) {
                ++n;
                continue;
            }
            if (n3 == 61) {
                if (n7 < 2) {
                    return null;
                }
                if (n7 == 3) {
                    if (n4 != 61 && n4 != 65 && n4 != 69 && n4 != 73 && n4 != 77 && n4 != 81 && n4 != 85 && n4 != 89 && n4 != 99 && n4 != 103 && n4 != 107 && n4 != 111 && n4 != 115 && n4 != 119 && n4 != 48 && n4 != 52 && n4 != 56) {
                        return null;
                    }
                    if (n4 == 61) {
                        byArray[n6++] = (byte)(byArray2[0] << 2 | byArray2[1] >> 4);
                    } else {
                        byArray[n6++] = (byte)(byArray2[0] << 2 | byArray2[1] >> 4);
                        byArray[n6++] = (byte)(byArray2[1] << 4 | byArray2[2] >> 2);
                    }
                    ++n7;
                    ++n;
                    continue;
                }
                if (n7 == 2) {
                    if (n4 != 65 && n4 != 81 && n4 != 103 && n4 != 119) {
                        return null;
                    }
                    n4 = 61;
                    ++n;
                    ++n7;
                    continue;
                }
                return null;
            }
            return null;
        }
        if (n7 > 0 && n7 < 4) {
            return null;
        }
        return new XBinary(byArray, n6);
    }

    private static XBinary parseBase64BinaryBuffered(XMLString xMLString) {
        DataBuffer dataBuffer = xMLString.firstBuffer;
        DataBuffer dataBuffer2 = xMLString.lastBuffer == null ? dataBuffer : xMLString.lastBuffer;
        int n = xMLString.endOffset;
        int n2 = xMLString.startOffset;
        int n3 = dataBuffer == dataBuffer2 ? n : dataBuffer.endOffset;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        if (n - dataBuffer2.startOffset >= 2 && (n5 = dataBuffer2.bytes[n - 1]) == 61) {
            ++n6;
            n5 = dataBuffer2.bytes[n - 2];
            if (n5 == 61) {
                ++n6;
            }
        }
        byte[] byArray = ArrayAllocator.newByteArray(xMLString.length - (xMLString.length >> 2) - n6);
        int n7 = 0;
        byte[] byArray2 = ArrayAllocator.newByteArray(4);
        int n8 = 0;
        block0: while (true) {
            n4 = 0;
            while (true) {
                if (n2 < n3) {
                    n5 = dataBuffer.bytes[n2];
                    if (n5 == 32 || n5 == 10 || n5 == 9 || n5 == 13) {
                        ++n2;
                        continue;
                    }
                    if (n5 == 61) break block0;
                    n7 = n5;
                    byArray2[n4] = base64CharTo6BitGroupMap[n5 & 0xFF];
                    if (byArray2[n4] == -1) {
                        return null;
                    }
                    if (++n4 == 4) break;
                    ++n2;
                    continue;
                }
                if (dataBuffer == dataBuffer2) break block0;
                dataBuffer = dataBuffer.next;
                n2 = dataBuffer.startOffset;
                n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
            }
            if (n2 == n3) break;
            ++n2;
            byArray[n8++] = (byte)(byArray2[0] << 2 | byArray2[1] >> 4);
            byArray[n8++] = (byte)(byArray2[1] << 4 | byArray2[2] >> 2);
            byArray[n8++] = (byte)(byArray2[2] << 6 | byArray2[3]);
        }
        while (true) {
            if (n2 < n3) {
                n5 = dataBuffer.bytes[n2];
                if (n5 == 32 || n5 == 10 || n5 == 9 || n5 == 13) {
                    ++n2;
                    continue;
                }
                if (n5 == 61) {
                    if (n4 < 2) {
                        return null;
                    }
                    if (n4 == 3) {
                        if (n7 != 61 && n7 != 65 && n7 != 69 && n7 != 73 && n7 != 77 && n7 != 81 && n7 != 85 && n7 != 89 && n7 != 99 && n7 != 103 && n7 != 107 && n7 != 111 && n7 != 115 && n7 != 119 && n7 != 48 && n7 != 52 && n7 != 56) {
                            return null;
                        }
                        if (n7 == 61) {
                            byArray[n8++] = (byte)(byArray2[0] << 2 | byArray2[1] >> 4);
                        } else {
                            byArray[n8++] = (byte)(byArray2[0] << 2 | byArray2[1] >> 4);
                            byArray[n8++] = (byte)(byArray2[1] << 4 | byArray2[2] >> 2);
                        }
                        ++n4;
                        ++n2;
                        continue;
                    }
                    if (n4 == 2) {
                        if (n7 != 65 && n7 != 81 && n7 != 103 && n7 != 119) {
                            return null;
                        }
                        n7 = 61;
                        ++n2;
                        ++n4;
                        continue;
                    }
                    return null;
                }
                return null;
            }
            if (dataBuffer == dataBuffer2) break;
            dataBuffer = dataBuffer.next;
            n2 = dataBuffer.startOffset;
            n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
        }
        if (n4 > 0 && n4 < 4) {
            return null;
        }
        return new XBinary(byArray, n8);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int parseBase64BinaryBuffered(ParsedEntity parsedEntity, XBinary xBinary, ValidatedInfo validatedInfo) {
        int n = parsedEntity.offset;
        int n2 = parsedEntity.endOffset;
        byte[] byArray = parsedEntity.bytes;
        xBinary.length = 0;
        if (xBinary.value == null || xBinary.value.length >= 4096) {
            xBinary.value = ArrayAllocator.newByteArray(256);
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        byte[] byArray2 = ArrayAllocator.newByteArray(4);
        block0: while (true) {
            n3 = 0;
            while (true) {
                if (n < n2) {
                    n4 = byArray[n];
                    if (n4 != 32 && n4 != 10 && n4 != 9 && n4 != 13) {
                        if (n4 == 61) break block0;
                        n5 = n4;
                        byArray2[n3] = base64CharTo6BitGroupMap[n4 & 0xFF];
                        if (byArray2[n3] == -1) {
                            if (n3 != 0) return -1;
                            int n6 = n;
                            return n6;
                        }
                        if (++n3 == 4) break;
                    }
                    ++n;
                    continue;
                }
                if (parsedEntity.loadMore() == 0) {
                    return -1;
                }
                byArray = parsedEntity.bytes;
                n = parsedEntity.offset;
                n2 = parsedEntity.endOffset;
            }
            ++n;
            if (xBinary.length + 3 >= xBinary.value.length) {
                xBinary.value = ArrayAllocator.resizeByteArray(xBinary.value, xBinary.value.length * 2);
            }
            xBinary.value[xBinary.length++] = (byte)(byArray2[0] << 2 | byArray2[1] >> 4);
            xBinary.value[xBinary.length++] = (byte)(byArray2[1] << 4 | byArray2[2] >> 2);
            xBinary.value[xBinary.length++] = (byte)(byArray2[2] << 6 | byArray2[3]);
        }
        while (true) {
            if (n < n2) {
                n4 = byArray[n];
                if (n4 != 32 && n4 != 10 && n4 != 9 && n4 != 13) {
                    if (n4 != 61) return -1;
                    if (n3 == 3) {
                        if (n5 != 61 && n5 != 65 && n5 != 69 && n5 != 73 && n5 != 77 && n5 != 81 && n5 != 85 && n5 != 89 && n5 != 99 && n5 != 103 && n5 != 107 && n5 != 111 && n5 != 115 && n5 != 119 && n5 != 48 && n5 != 52 && n5 != 56) {
                            return -1;
                        }
                        if (xBinary.length + 2 >= xBinary.value.length) {
                            xBinary.value = ArrayAllocator.resizeByteArray(xBinary.value, xBinary.value.length * 2);
                        }
                        if (n5 == 61) {
                            xBinary.value[xBinary.length++] = (byte)(byArray2[0] << 2 | byArray2[1] >> 4);
                            return n;
                        } else {
                            xBinary.value[xBinary.length++] = (byte)(byArray2[0] << 2 | byArray2[1] >> 4);
                            xBinary.value[xBinary.length++] = (byte)(byArray2[1] << 4 | byArray2[2] >> 2);
                        }
                        return n;
                    }
                    if (n3 != 2) return -1;
                    if (n5 != 65 && n5 != 81 && n5 != 103 && n5 != 119) {
                        return -1;
                    }
                    n5 = 61;
                    ++n3;
                }
                ++n;
                continue;
            }
            if (parsedEntity.loadMore() == 0) {
                return -1;
            }
            byArray = parsedEntity.bytes;
            n = parsedEntity.offset;
            n2 = parsedEntity.endOffset;
        }
    }

    private XSBase64BinaryUtil() {
    }
}

