/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.datatype.validation;

import com.ibm.xml.xlxp2.datatype.TypeValidator;
import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.util.ArrayAllocator;
import com.ibm.xml.xlxp2.scan.util.DataBuffer;
import com.ibm.xml.xlxp2.scan.util.ParsedEntity;
import com.ibm.xml.xlxp2.scan.util.XMLCharacterProperties;
import com.ibm.xml.xlxp2.scan.util.XMLString;
import java.util.ArrayList;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class XMLStringUtil {
    private static final int[] fgMultiByteLength = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 3, 3, 4, 0};
    private static final int[] fgFirstByteValueMask = new int[]{0, 0, 31, 15, 7};

    public static int getUnicodeCharLength(XMLString xMLString) {
        if (xMLString.length == 0) {
            return 0;
        }
        return xMLString.bytes != null ? XMLStringUtil.getUnicodeCharLengthUnbuffered(xMLString) : XMLStringUtil.getUnicodeCharLengthBuffered(xMLString);
    }

    private static int getUnicodeCharLengthUnbuffered(XMLString xMLString) {
        int n = xMLString.startOffset;
        int n2 = xMLString.endOffset;
        while (n < n2) {
            if (xMLString.bytes[n++] >= 0) continue;
            --n;
            break;
        }
        if (n == n2) {
            return xMLString.length;
        }
        int n3 = n - xMLString.startOffset;
        while (n < n2) {
            ++n3;
            byte by = xMLString.bytes[n];
            if (by >= 0) {
                ++n;
                continue;
            }
            n += fgMultiByteLength[(by & 0xFF) >> 3];
        }
        return n3;
    }

    private static int getUnicodeCharLengthBuffered(XMLString xMLString) {
        int n;
        DataBuffer dataBuffer = xMLString.firstBuffer;
        DataBuffer dataBuffer2 = xMLString.lastBuffer == null ? dataBuffer : xMLString.lastBuffer;
        int n2 = xMLString.startOffset;
        block0: while (true) {
            int n3 = n = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
            while (n2 < n) {
                if (dataBuffer.bytes[n2] < 0) break block0;
                ++n2;
            }
            if (dataBuffer == dataBuffer2) {
                return xMLString.length;
            }
            dataBuffer = dataBuffer.next;
            n2 = dataBuffer.startOffset;
        }
        int n4 = n2 - dataBuffer.startOffset;
        DataBuffer dataBuffer3 = xMLString.firstBuffer;
        if (dataBuffer3 != dataBuffer) {
            n4 += dataBuffer3.endOffset - xMLString.startOffset;
            DataBuffer dataBuffer4 = dataBuffer3.next;
            while (dataBuffer4 != dataBuffer) {
                n4 += dataBuffer4.endOffset - dataBuffer4.startOffset;
                dataBuffer4 = dataBuffer4.next;
            }
        }
        while (true) {
            if (n2 < n) {
                ++n4;
                byte by = dataBuffer.bytes[n2];
                if (by >= 0) {
                    ++n2;
                    continue;
                }
                n2 += fgMultiByteLength[(by & 0xFF) >> 3];
                continue;
            }
            if (dataBuffer == dataBuffer2) {
                return n4;
            }
            dataBuffer = dataBuffer.next;
            n2 = dataBuffer.startOffset + (n2 - n);
            n = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
        }
    }

    public static boolean isNMTOKEN(XMLString xMLString) {
        if (xMLString.length == 0) {
            return false;
        }
        return xMLString.bytes != null ? XMLStringUtil.isNMTOKENUnbuffered(xMLString) : XMLStringUtil.isNMTOKENBuffered(xMLString);
    }

    private static boolean isNMTOKENUnbuffered(XMLString xMLString) {
        int n;
        int n2;
        int n3 = xMLString.endOffset;
        for (n2 = xMLString.startOffset; n2 < n3 && (n = xMLString.bytes[n2]) >= 0; ++n2) {
            if (XMLCharacterProperties.nameChar10(n)) continue;
            return false;
        }
        if (n2 == n3) {
            return true;
        }
        while (n2 < n3) {
            if ((n = xMLString.bytes[n2++]) >= 0) {
                if (XMLCharacterProperties.nameChar10(n)) continue;
                return false;
            }
            int n4 = fgMultiByteLength[(n &= 0xFF) >> 3];
            int n5 = n & fgFirstByteValueMask[n4];
            switch (n4) {
                case 2: {
                    n5 = (n5 << 6) + (0x3F & xMLString.bytes[n2++]);
                    break;
                }
                case 3: {
                    n5 = (n5 << 12) + ((0x3F & xMLString.bytes[n2++]) << 6) + (0x3F & xMLString.bytes[n2++]);
                    break;
                }
                default: {
                    n5 = (n5 << 18) + ((0x3F & xMLString.bytes[n2++]) << 12) + ((0x3F & xMLString.bytes[n2++]) << 6) + (0x3F & xMLString.bytes[n2++]);
                }
            }
            if (XMLCharacterProperties.nameChar10(n5)) continue;
            return false;
        }
        return true;
    }

    private static boolean isNMTOKENBuffered(XMLString xMLString) {
        int n;
        int n2;
        DataBuffer dataBuffer = xMLString.firstBuffer;
        DataBuffer dataBuffer2 = xMLString.lastBuffer == null ? dataBuffer : xMLString.lastBuffer;
        int n3 = xMLString.startOffset;
        int n4 = n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
        while (true) {
            if (n3 < n2) {
                n = dataBuffer.bytes[n3];
                if (n < 0) break;
                if (!XMLCharacterProperties.nameChar10(n)) {
                    return false;
                }
                ++n3;
                continue;
            }
            if (dataBuffer == dataBuffer2) break;
            dataBuffer = dataBuffer.next;
            n3 = dataBuffer.startOffset;
            n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
        }
        if (n3 == n2) {
            return true;
        }
        while (true) {
            if (n3 < n2) {
                if ((n = dataBuffer.bytes[n3++]) >= 0) {
                    if (XMLCharacterProperties.nameChar10(n)) continue;
                    return false;
                }
                int n5 = fgMultiByteLength[(n &= 0xFF) >> 3];
                int n6 = n & fgFirstByteValueMask[n5];
                byte by = 0;
                byte by2 = 0;
                byte by3 = 0;
                switch (n5) {
                    case 2: {
                        while (true) {
                            if (n3 < n2) {
                                by = dataBuffer.bytes[n3++];
                                break;
                            }
                            if (dataBuffer == dataBuffer2) break;
                            dataBuffer = dataBuffer.next;
                            n3 = dataBuffer.startOffset;
                            n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                        }
                        n6 = (n6 << 6) + (0x3F & by);
                        break;
                    }
                    case 3: {
                        while (true) {
                            if (n3 < n2) {
                                by = dataBuffer.bytes[n3++];
                                break;
                            }
                            if (dataBuffer == dataBuffer2) break;
                            dataBuffer = dataBuffer.next;
                            n3 = dataBuffer.startOffset;
                            n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                        }
                        while (true) {
                            if (n3 < n2) {
                                by2 = dataBuffer.bytes[n3++];
                                break;
                            }
                            if (dataBuffer == dataBuffer2) break;
                            dataBuffer = dataBuffer.next;
                            n3 = dataBuffer.startOffset;
                            n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                        }
                        n6 = (n6 << 12) + ((0x3F & by) << 6) + (0x3F & by2);
                        break;
                    }
                    default: {
                        while (true) {
                            if (n3 < n2) {
                                by = dataBuffer.bytes[n3++];
                                break;
                            }
                            if (dataBuffer == dataBuffer2) break;
                            dataBuffer = dataBuffer.next;
                            n3 = dataBuffer.startOffset;
                            n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                        }
                        while (true) {
                            if (n3 < n2) {
                                by2 = dataBuffer.bytes[n3++];
                                break;
                            }
                            if (dataBuffer == dataBuffer2) break;
                            dataBuffer = dataBuffer.next;
                            n3 = dataBuffer.startOffset;
                            n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                        }
                        while (true) {
                            if (n3 < n2) {
                                by3 = dataBuffer.bytes[n3++];
                                break;
                            }
                            if (dataBuffer == dataBuffer2) break;
                            dataBuffer = dataBuffer.next;
                            n3 = dataBuffer.startOffset;
                            n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                        }
                        n6 = (n6 << 18) + ((0x3F & by) << 12) + ((0x3F & by2) << 6) + (0x3F & by3);
                    }
                }
                if (XMLCharacterProperties.nameChar10(n6)) continue;
                return false;
            }
            if (dataBuffer == dataBuffer2) break;
            dataBuffer = dataBuffer.next;
            n3 = dataBuffer.startOffset;
            n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
        }
        return true;
    }

    public static int parseNMTOKENUnbuffered(ParsedEntity parsedEntity, XMLString xMLString, boolean[] blArray) {
        byte[] byArray = parsedEntity.bytes;
        int n = parsedEntity.offset;
        int n2 = parsedEntity.endOffset;
        if ((n = TypeValidator.removeWhitespace(byArray, n, n2, blArray)) >= n2) {
            return -1;
        }
        int n3 = n;
        while (n < n2) {
            int n4 = byArray[n];
            if (n4 >= 0) {
                if (!XMLCharacterProperties.nameChar10(n4)) {
                    break;
                }
            } else {
                int n5 = fgMultiByteLength[(n4 &= 0xFF) >> 3];
                int n6 = n4 & fgFirstByteValueMask[n5];
                switch (n5) {
                    case 2: {
                        if (++n >= n2) {
                            return -1;
                        }
                        n6 = (n6 << 6) + (0x3F & byArray[n]);
                        break;
                    }
                    case 3: {
                        if (++n + 1 >= n2) {
                            return -1;
                        }
                        n6 = (n6 << 12) + ((0x3F & byArray[n]) << 6) + (0x3F & byArray[++n]);
                        break;
                    }
                    default: {
                        if (++n + 2 >= n2) {
                            return -1;
                        }
                        n6 = (n6 << 18) + ((0x3F & byArray[n]) << 12) + ((0x3F & byArray[++n]) << 6) + (0x3F & byArray[++n]);
                    }
                }
                if (!XMLCharacterProperties.nameChar10(n6)) {
                    return -1;
                }
            }
            ++n;
        }
        int n7 = n;
        if ((n = TypeValidator.removeWhitespace(byArray, n, n2, blArray)) >= n2) {
            return -1;
        }
        xMLString.setValues(parsedEntity.buffer, n3, n7);
        xMLString.flags = 1;
        return n;
    }

    public static boolean isName(XMLString xMLString) {
        if (xMLString.length == 0) {
            return false;
        }
        return xMLString.bytes != null ? XMLStringUtil.isNameUnbuffered(xMLString) : XMLStringUtil.isNameBuffered(xMLString);
    }

    private static boolean isNameUnbuffered(XMLString xMLString) {
        int n;
        int n2;
        int n3;
        int n4 = xMLString.startOffset;
        int n5 = xMLString.endOffset;
        if ((n3 = xMLString.bytes[n4++]) >= 0) {
            if (!XMLCharacterProperties.nameStartChar10(n3)) {
                return false;
            }
        } else {
            n2 = fgMultiByteLength[(n3 &= 0xFF) >> 3];
            n = n3 & fgFirstByteValueMask[n2];
            switch (n2) {
                case 2: {
                    n = (n << 6) + (0x3F & xMLString.bytes[n4++]);
                    break;
                }
                case 3: {
                    n = (n << 12) + ((0x3F & xMLString.bytes[n4++]) << 6) + (0x3F & xMLString.bytes[n4++]);
                    break;
                }
                default: {
                    n = (n << 18) + ((0x3F & xMLString.bytes[n4++]) << 12) + ((0x3F & xMLString.bytes[n4++]) << 6) + (0x3F & xMLString.bytes[n4++]);
                }
            }
            if (!XMLCharacterProperties.nameStartChar10(n)) {
                return false;
            }
        }
        while (n4 < n5 && (n3 = xMLString.bytes[n4]) >= 0) {
            if (!XMLCharacterProperties.nameChar10(n3)) {
                return false;
            }
            ++n4;
        }
        if (n4 == n5) {
            return true;
        }
        while (n4 < n5) {
            if ((n3 = xMLString.bytes[n4++]) >= 0) {
                if (XMLCharacterProperties.nameChar10(n3)) continue;
                return false;
            }
            n = fgMultiByteLength[(n3 &= 0xFF) >> 3];
            n2 = n3 & fgFirstByteValueMask[n];
            switch (n) {
                case 2: {
                    n2 = (n2 << 6) + (0x3F & xMLString.bytes[n4++]);
                    break;
                }
                case 3: {
                    n2 = (n2 << 12) + ((0x3F & xMLString.bytes[n4++]) << 6) + (0x3F & xMLString.bytes[n4++]);
                    break;
                }
                default: {
                    n2 = (n2 << 18) + ((0x3F & xMLString.bytes[n4++]) << 12) + ((0x3F & xMLString.bytes[n4++]) << 6) + (0x3F & xMLString.bytes[n4++]);
                }
            }
            if (XMLCharacterProperties.nameChar10(n2)) continue;
            return false;
        }
        return true;
    }

    private static boolean isNameBuffered(XMLString xMLString) {
        return true;
    }

    public static int parseNameUnbuffered(ParsedEntity parsedEntity, XMLString xMLString, boolean[] blArray) {
        int n;
        int n2;
        byte[] byArray = parsedEntity.bytes;
        int n3 = parsedEntity.offset;
        int n4 = parsedEntity.endOffset;
        if ((n3 = TypeValidator.removeWhitespace(byArray, n3, n4, blArray)) >= n4) {
            return -1;
        }
        int n5 = n3;
        int n6 = byArray[n3];
        if (n6 >= 0) {
            if (!XMLCharacterProperties.nameStartChar10(n6)) {
                return -1;
            }
        } else {
            n2 = fgMultiByteLength[(n6 &= 0xFF) >> 3];
            n = n6 & fgFirstByteValueMask[n2];
            switch (n2) {
                case 2: {
                    if (++n3 >= n4) {
                        return -1;
                    }
                    n = (n << 6) + (0x3F & byArray[n3]);
                    break;
                }
                case 3: {
                    if (++n3 + 1 >= n4) {
                        return -1;
                    }
                    n = (n << 12) + ((0x3F & byArray[n3]) << 6) + (0x3F & byArray[++n3]);
                    break;
                }
                default: {
                    if (++n3 + 2 >= n4) {
                        return -1;
                    }
                    n = (n << 18) + ((0x3F & byArray[n3]) << 12) + ((0x3F & byArray[++n3]) << 6) + (0x3F & byArray[++n3]);
                }
            }
            if (!XMLCharacterProperties.nameStartChar10(n)) {
                return -1;
            }
        }
        while (n3 < n4) {
            n6 = byArray[n3];
            if (n6 >= 0) {
                if (!XMLCharacterProperties.nameChar10(n6)) {
                    break;
                }
            } else {
                n2 = fgMultiByteLength[(n6 &= 0xFF) >> 3];
                n = n6 & fgFirstByteValueMask[n2];
                switch (n2) {
                    case 2: {
                        if (++n3 >= n4) {
                            return -1;
                        }
                        n = (n << 6) + (0x3F & byArray[n3++]);
                        break;
                    }
                    case 3: {
                        if (++n3 + 1 >= n4) {
                            return -1;
                        }
                        n = (n << 12) + ((0x3F & byArray[n3++]) << 6) + (0x3F & byArray[n3++]);
                        break;
                    }
                    default: {
                        if (++n3 + 2 >= n4) {
                            return -1;
                        }
                        n = (n << 18) + ((0x3F & byArray[n3++]) << 12) + ((0x3F & byArray[n3++]) << 6) + (0x3F & byArray[n3++]);
                    }
                }
                if (!XMLCharacterProperties.nameChar10(n)) {
                    return -1;
                }
            }
            ++n3;
        }
        int n7 = n3;
        if ((n3 = TypeValidator.removeWhitespace(byArray, n3, n4, blArray)) >= n4) {
            return -1;
        }
        xMLString.setValues(parsedEntity.buffer, n5, n7);
        xMLString.flags = 1;
        return n3;
    }

    public static boolean isNCName(XMLString xMLString) {
        if (xMLString.length == 0) {
            return false;
        }
        return xMLString.bytes != null ? XMLStringUtil.isNCNameUnbuffered(xMLString) : XMLStringUtil.isNCNameBuffered(xMLString);
    }

    private static boolean isNCNameUnbuffered(XMLString xMLString) {
        int n;
        int n2;
        int n3;
        int n4 = xMLString.startOffset;
        int n5 = xMLString.endOffset;
        if ((n3 = xMLString.bytes[n4++]) >= 0) {
            if (n3 == 58 || !XMLCharacterProperties.nameStartChar10(n3)) {
                return false;
            }
        } else {
            n2 = fgMultiByteLength[(n3 &= 0xFF) >> 3];
            n = n3 & fgFirstByteValueMask[n2];
            switch (n2) {
                case 2: {
                    n = (n << 6) + (0x3F & xMLString.bytes[n4++]);
                    break;
                }
                case 3: {
                    n = (n << 12) + ((0x3F & xMLString.bytes[n4++]) << 6) + (0x3F & xMLString.bytes[n4++]);
                    break;
                }
                default: {
                    n = (n << 18) + ((0x3F & xMLString.bytes[n4++]) << 12) + ((0x3F & xMLString.bytes[n4++]) << 6) + (0x3F & xMLString.bytes[n4++]);
                }
            }
            if (!XMLCharacterProperties.nameStartChar10(n)) {
                return false;
            }
        }
        while (n4 < n5 && (n3 = xMLString.bytes[n4]) >= 0) {
            if (n3 == 58 || !XMLCharacterProperties.nameChar10(n3)) {
                return false;
            }
            ++n4;
        }
        if (n4 == n5) {
            return true;
        }
        while (n4 < n5) {
            if ((n3 = xMLString.bytes[n4++]) >= 0) {
                if (n3 != 58 && XMLCharacterProperties.nameChar10(n3)) continue;
                return false;
            }
            n = fgMultiByteLength[(n3 &= 0xFF) >> 3];
            n2 = n3 & fgFirstByteValueMask[n];
            switch (n) {
                case 2: {
                    n2 = (n2 << 6) + (0x3F & xMLString.bytes[n4++]);
                    break;
                }
                case 3: {
                    n2 = (n2 << 12) + ((0x3F & xMLString.bytes[n4++]) << 6) + (0x3F & xMLString.bytes[n4++]);
                    break;
                }
                default: {
                    n2 = (n2 << 18) + ((0x3F & xMLString.bytes[n4++]) << 12) + ((0x3F & xMLString.bytes[n4++]) << 6) + (0x3F & xMLString.bytes[n4++]);
                }
            }
            if (XMLCharacterProperties.nameChar10(n2)) continue;
            return false;
        }
        return true;
    }

    private static boolean isNCNameBuffered(XMLString xMLString) {
        return true;
    }

    public static int parseNCNameUnbuffered(ParsedEntity parsedEntity, XMLString xMLString, boolean[] blArray) {
        int n;
        int n2;
        byte[] byArray = parsedEntity.bytes;
        int n3 = parsedEntity.offset;
        int n4 = parsedEntity.endOffset;
        if ((n3 = TypeValidator.removeWhitespace(byArray, n3, n4, blArray)) >= n4) {
            return -1;
        }
        int n5 = n3;
        int n6 = byArray[n3];
        if (n6 >= 0) {
            if (n6 == 58 || !XMLCharacterProperties.nameStartChar10(n6)) {
                return -1;
            }
        } else {
            n2 = fgMultiByteLength[(n6 &= 0xFF) >> 3];
            n = n6 & fgFirstByteValueMask[n2];
            switch (n2) {
                case 2: {
                    if (++n3 >= n4) {
                        return -1;
                    }
                    n = (n << 6) + (0x3F & byArray[n3]);
                    break;
                }
                case 3: {
                    if (++n3 + 1 >= n4) {
                        return -1;
                    }
                    n = (n << 12) + ((0x3F & byArray[n3]) << 6) + (0x3F & byArray[++n3]);
                    break;
                }
                default: {
                    if (++n3 + 2 >= n4) {
                        return -1;
                    }
                    n = (n << 18) + ((0x3F & byArray[n3]) << 12) + ((0x3F & byArray[++n3]) << 6) + (0x3F & byArray[++n3]);
                }
            }
            if (!XMLCharacterProperties.nameStartChar10(n)) {
                return -1;
            }
        }
        while (n3 < n4) {
            n6 = byArray[n3];
            if (n6 >= 0) {
                if (n6 == 58) {
                    return -1;
                }
                if (!XMLCharacterProperties.nameChar10(n6)) {
                    break;
                }
            } else {
                n2 = fgMultiByteLength[(n6 &= 0xFF) >> 3];
                n = n6 & fgFirstByteValueMask[n2];
                switch (n2) {
                    case 2: {
                        if (++n3 >= n4) {
                            return -1;
                        }
                        n = (n << 6) + (0x3F & byArray[n3++]);
                        break;
                    }
                    case 3: {
                        if (++n3 + 1 >= n4) {
                            return -1;
                        }
                        n = (n << 12) + ((0x3F & byArray[n3++]) << 6) + (0x3F & byArray[n3++]);
                        break;
                    }
                    default: {
                        if (++n3 + 2 >= n4) {
                            return -1;
                        }
                        n = (n << 18) + ((0x3F & byArray[n3++]) << 12) + ((0x3F & byArray[n3++]) << 6) + (0x3F & byArray[n3++]);
                    }
                }
                if (!XMLCharacterProperties.nameChar10(n)) {
                    return -1;
                }
            }
            ++n3;
        }
        int n7 = n3;
        if ((n3 = TypeValidator.removeWhitespace(byArray, n3, n4, blArray)) >= n4) {
            return -1;
        }
        xMLString.setValues(parsedEntity.buffer, n5, n7);
        xMLString.flags = 1;
        return n3;
    }

    private XMLStringUtil() {
    }

    public static XMLString[] tokenizeToXMLStringList(XMLString xMLString) {
        if (xMLString.length == 0) {
            return null;
        }
        if (xMLString.bytes != null) {
            return XMLStringUtil.tokenizeUnbuffered(xMLString);
        }
        return XMLStringUtil.tokenizeBuffered(xMLString);
    }

    private static XMLString[] tokenizeBuffered(XMLString xMLString) {
        DataBuffer dataBuffer = xMLString.firstBuffer;
        DataBuffer dataBuffer2 = xMLString.lastBuffer == null ? dataBuffer : xMLString.lastBuffer;
        int n = xMLString.startOffset;
        int n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
        byte by = dataBuffer.bytes[n];
        if (by <= 32) {
            while (true) {
                if ((by == 32 || by == 10 || by == 9 || by == 13) && ++n < n2) {
                    by = dataBuffer.bytes[n];
                    continue;
                }
                if (n != n2 || dataBuffer == dataBuffer2) break;
                dataBuffer = dataBuffer.next;
                n = dataBuffer.startOffset;
                n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                by = dataBuffer.bytes[n];
            }
        }
        if (n == n2) {
            return null;
        }
        ArrayList<XMLString> arrayList = new ArrayList<XMLString>();
        XMLString xMLString2 = new XMLString(xMLString);
        block1: while (true) {
            if (n < n2) {
                by = dataBuffer.bytes[n];
                if (by == 32 || by == 10 || by == 9 || by == 13) {
                    while (true) {
                        if (n + 1 < n2) break;
                        if (dataBuffer == dataBuffer2) break block1;
                        dataBuffer = dataBuffer.next;
                        n = dataBuffer.startOffset - 1;
                        n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                    }
                    by = dataBuffer.bytes[n + 1];
                    if (by != 32 && by != 10 && by != 9 && by != 13) {
                        xMLString2.startOffset = n + 1;
                        xMLString2.firstBuffer = dataBuffer;
                    }
                } else {
                    XMLString xMLString3;
                    while (true) {
                        if (n + 1 < n2) break;
                        if (dataBuffer == dataBuffer2) {
                            xMLString2.endOffset = n + 1;
                            xMLString2.lastBuffer = dataBuffer;
                            xMLString3 = new XMLString(xMLString2);
                            arrayList.add(xMLString3);
                            break block1;
                        }
                        dataBuffer = dataBuffer.next;
                        n = dataBuffer.startOffset - 1;
                        n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                    }
                    by = dataBuffer.bytes[n + 1];
                    if (by == 32 || by == 10 || by == 9 || by == 13) {
                        xMLString2.endOffset = n + 1;
                        xMLString2.lastBuffer = dataBuffer;
                        xMLString3 = new XMLString(xMLString2);
                        arrayList.add(xMLString3);
                    }
                }
                ++n;
                continue;
            }
            if (dataBuffer == dataBuffer2) break;
            dataBuffer = dataBuffer.next;
            n = dataBuffer.startOffset - 1;
            n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
        }
        xMLString2.unregister();
        return arrayList.toArray(ArrayAllocator.newObjectArray(XMLString.class, arrayList.size()));
    }

    private static XMLString[] tokenizeUnbuffered(XMLString xMLString) {
        int n = xMLString.startOffset;
        int n2 = xMLString.endOffset;
        if ((n = XMLStringUtil.removeWhitespace(xMLString.bytes, n, n2)) == n2) {
            return null;
        }
        byte by = 0;
        ArrayList<XMLString> arrayList = new ArrayList<XMLString>();
        XMLString xMLString2 = new XMLString(xMLString);
        xMLString2.startOffset = n;
        while (n < n2) {
            XMLString xMLString3;
            by = xMLString.bytes[n];
            if (by == 32 || by == 10 || by == 9 || by == 13) {
                if (n + 1 < n2 && (by = xMLString.bytes[n + 1]) != 32 && by != 10 && by != 9 && by != 13) {
                    xMLString2.startOffset = n + 1;
                }
            } else if (n + 1 < n2) {
                by = xMLString.bytes[n + 1];
                if (by == 32 || by == 10 || by == 9 || by == 13) {
                    xMLString2.endOffset = n + 1;
                    xMLString2.length = xMLString2.endOffset - xMLString2.startOffset;
                    xMLString3 = new XMLString(xMLString2);
                    arrayList.add(xMLString3);
                }
            } else {
                xMLString2.endOffset = n + 1;
                xMLString2.length = xMLString2.endOffset - xMLString2.startOffset;
                xMLString3 = new XMLString(xMLString2);
                arrayList.add(xMLString3);
                break;
            }
            ++n;
        }
        xMLString2.unregister();
        return arrayList.toArray(ArrayAllocator.newObjectArray(XMLString.class, arrayList.size()));
    }

    public static int removeWhitespace(byte[] byArray, int n, int n2) {
        if (n < n2) {
            byte by = byArray[n];
            while ((by == 32 || by == 10 || by == 9 || by == 13) && ++n < n2) {
                by = byArray[n];
            }
        }
        return n;
    }
}

