/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.datatype.validation;

import com.ibm.xml.xlxp2.datatype.TypeValidator;
import com.ibm.xml.xlxp2.datatype.ValidatedInfo;
import com.ibm.xml.xlxp2.datatype.ValidationContext;
import com.ibm.xml.xlxp2.datatype.XQName;
import com.ibm.xml.xlxp2.runtime.VMContext;
import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.util.ArrayAllocator;
import com.ibm.xml.xlxp2.scan.util.DataBuffer;
import com.ibm.xml.xlxp2.scan.util.ParsedEntity;
import com.ibm.xml.xlxp2.scan.util.UTF8Support;
import com.ibm.xml.xlxp2.scan.util.XMLCharacterProperties;
import com.ibm.xml.xlxp2.scan.util.XMLString;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class QNameDV
extends TypeValidator {
    private final XQName[] enumeration;

    public QNameDV(String string, String string2) {
        this(string, string2, null, null, null, 0, 19);
    }

    public QNameDV(String string, String string2, String string3, String[] stringArray, XQName[] xQNameArray, int n, int n2) {
        super(string, string2, string3, n2, n2, stringArray, n, false);
        this.enumeration = xQNameArray;
        this.fMultiBuffered = true;
    }

    public Object getActualValue(XMLString xMLString, ValidatedInfo validatedInfo) {
        throw new RuntimeException("Should never be called.");
    }

    public Object getActualValue(String string, String[] stringArray, String string2, ValidatedInfo validatedInfo) {
        if (validatedInfo != null) {
            validatedInfo.typeValidator = this;
        }
        return QNameDV.parse(string, stringArray, string2, validatedInfo);
    }

    public static XQName parse(String string, String[] stringArray, String string2, ValidatedInfo validatedInfo) {
        XQName xQName = new XQName();
        int n = string.indexOf(58);
        if (n > 0) {
            String string3 = string.substring(0, n).intern();
            xQName.localName = string.substring(n + 1).intern();
            for (int i = 0; i < stringArray.length; i += 2) {
                if (string3 != stringArray[i]) continue;
                xQName.nsURI = stringArray[i + 1];
                break;
            }
        } else {
            xQName.localName = string.intern();
            xQName.nsURI = string2;
        }
        if (validatedInfo != null) {
            validatedInfo.actualValue = xQName;
        }
        return xQName;
    }

    public void validate(XMLString xMLString, ValidatedInfo validatedInfo, ValidationContext validationContext, ValidatedInfo validatedInfo2) {
        validatedInfo2.typeValidator = this;
        int[] nArray = validationContext.tempErrorCode;
        XQName xQName = this.parse(xMLString, validationContext, nArray);
        validatedInfo2.actualValue = xQName;
        if (nArray[0] != 0) {
            validatedInfo2.errorCode = nArray[0];
            return;
        }
        if (validatedInfo != null && validatedInfo.actualValue != null) {
            validatedInfo2.errorCode = xQName.equals(validatedInfo.actualValue) ? 0 : 1;
            validatedInfo2.actualValue = validatedInfo.actualValue;
            return;
        }
        if (this.definedFacets != 0) {
            validatedInfo2.errorCode = this.checkFacets(xQName, xMLString);
            if (validatedInfo2.errorCode != 0) {
                return;
            }
        }
        validatedInfo2.errorCode = 0;
    }

    private XQName parse(XMLString xMLString, ValidationContext validationContext, int[] nArray) {
        if (xMLString.length == 0) {
            nArray[0] = 1;
            return null;
        }
        nArray[0] = 0;
        if (xMLString.bytes != null) {
            return this.parseQNameUnbuffered(xMLString, validationContext, nArray);
        }
        return this.parseQNameBuffered(xMLString, validationContext, nArray);
    }

    private XQName parseQNameBuffered(XMLString xMLString, ValidationContext validationContext, int[] nArray) {
        DataBuffer dataBuffer = xMLString.firstBuffer;
        DataBuffer dataBuffer2 = xMLString.lastBuffer == null ? dataBuffer : xMLString.lastBuffer;
        int n = xMLString.startOffset;
        int n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
        byte by = 0;
        int[] nArray2 = ArrayAllocator.newIntArray(2);
        byte[] byArray = ArrayAllocator.newByteArray(4);
        XMLString xMLString2 = validationContext.getXMLString();
        xMLString2.setValues(xMLString);
        XQName xQName = validationContext.getXQName();
        xQName.nsURI = "";
        String string = "";
        while (true) {
            if (n < n2) break;
            if (dataBuffer == dataBuffer2) {
                nArray[0] = 1;
                return null;
            }
            dataBuffer = dataBuffer.next;
            n = dataBuffer.startOffset - 1;
            n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
        }
        by = dataBuffer.bytes[n];
        if (!XMLCharacterProperties.nameStartChar10(by)) {
            nArray[0] = 1;
            return null;
        }
        ++n;
        while (true) {
            if (n < n2) {
                by = dataBuffer.bytes[n];
                if (by >= 0) {
                    if (by == 58) {
                        if (string != "" || n + 1 == n2 && dataBuffer == dataBuffer2 || xMLString.startOffset == n && dataBuffer == xMLString.firstBuffer) {
                            nArray[0] = 1;
                            return null;
                        }
                        xMLString2.setEndPos(dataBuffer, n);
                        string = validationContext.getSymbol(xMLString2);
                        xMLString2.setStartPos(dataBuffer, n + 1);
                        xMLString2.length = n2 - (n + 1);
                    } else if (!XMLCharacterProperties.nameChar10(by)) {
                        nArray[0] = 1;
                        return null;
                    }
                    ++n;
                    continue;
                }
                byArray[0] = by;
                int n3 = 1;
                while (true) {
                    if (n3 < 4 && n + n3 < n2) {
                        byArray[n3++] = dataBuffer.bytes[n + n3 - 1];
                        continue;
                    }
                    if (dataBuffer == dataBuffer2) break;
                    dataBuffer = dataBuffer.next;
                    n = dataBuffer.startOffset - n3;
                    n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                }
                UTF8Support.decodeCharacter(byArray, 0, n3, nArray2);
                if (!XMLCharacterProperties.nameChar10(nArray2[0])) {
                    nArray[0] = 1;
                    return null;
                }
                n += nArray2[1];
                continue;
            }
            if (dataBuffer == dataBuffer2) break;
            dataBuffer = dataBuffer.next;
            n = dataBuffer.startOffset;
            n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
        }
        xQName.nsURI = validationContext.prefixMapping(string);
        if (xQName.nsURI == null && string != "") {
            nArray[0] = 1;
            return null;
        }
        xMLString2.setEndPos(dataBuffer, n);
        xQName.localName = validationContext.getSymbol(xMLString2);
        xMLString2.unregister();
        nArray[0] = 0;
        return xQName;
    }

    private XQName parseQNameUnbuffered(XMLString xMLString, ValidationContext validationContext, int[] nArray) {
        String string;
        int n = xMLString.startOffset;
        int n2 = xMLString.endOffset;
        byte by = 0;
        int[] nArray2 = ArrayAllocator.newIntArray(2);
        byte[] byArray = ArrayAllocator.newByteArray(4);
        XMLString xMLString2 = validationContext.getXMLString();
        xMLString2.setValues(xMLString);
        XQName xQName = validationContext.getXQName();
        xQName.nsURI = "";
        String string2 = "";
        if (n < n2) {
            by = xMLString.bytes[n];
            if (!XMLCharacterProperties.nameStartChar10(by)) {
                nArray[0] = 1;
                return null;
            }
            ++n;
            while (n < n2) {
                by = xMLString.bytes[n];
                if (by >= 0) {
                    if (by == 58) {
                        if (string2 != "" || n + 1 == n2 || xMLString.startOffset == n) {
                            nArray[0] = 1;
                            return null;
                        }
                        xMLString2.endOffset = n;
                        xMLString2.length = xMLString2.endOffset - xMLString.startOffset;
                        string2 = validationContext.getSymbol(xMLString2);
                        xMLString2.startOffset = n + 1;
                        xMLString2.length = n2 - (n + 1);
                        xMLString2.endOffset = n2;
                        xMLString2.hashcode = 0;
                    } else if (!XMLCharacterProperties.nameChar10(by)) {
                        nArray[0] = 1;
                        return null;
                    }
                    ++n;
                    continue;
                }
                byArray[0] = by;
                int n3 = 1;
                while (n3 < 4 && n + n3 < n2) {
                    byArray[n3++] = xMLString.bytes[n + n3 - 1];
                }
                UTF8Support.decodeCharacter(byArray, 0, n3, nArray2);
                if (!XMLCharacterProperties.nameChar10(nArray2[0])) {
                    nArray[0] = 1;
                    return null;
                }
                n += nArray2[1];
            }
        }
        if ((string = validationContext.prefixMapping(string2)) != null) {
            xQName.nsURI = string;
        } else if (string2 != "") {
            nArray[0] = 1;
            return null;
        }
        xQName.localName = validationContext.getSymbol(xMLString2);
        xMLString2.unregister();
        nArray[0] = 0;
        return xQName;
    }

    private static int parseQNameUnbuffered(ParsedEntity parsedEntity, XQName xQName, ValidationContext validationContext, boolean[] blArray) {
        byte[] byArray = parsedEntity.bytes == null ? parsedEntity.buffer.bytes : parsedEntity.bytes;
        int n = parsedEntity.offset;
        int n2 = parsedEntity.endOffset;
        byte by = 0;
        int[] nArray = ArrayAllocator.newIntArray(2);
        byte[] byArray2 = ArrayAllocator.newByteArray(4);
        XMLString xMLString = validationContext.getXMLString();
        xQName.nsURI = "";
        String string = "";
        if ((n = QNameDV.removeWhitespace(byArray, n, n2, blArray)) >= n2 || !XMLCharacterProperties.nameStartChar10(byArray[n])) {
            return -1;
        }
        xMLString.setValues(parsedEntity.buffer, n, n2);
        xMLString.flags |= 1;
        ++n;
        while (n < n2) {
            by = byArray[n];
            if (by >= 0) {
                if (by == 58) {
                    if (string != "" || n + 1 >= n2) {
                        return -1;
                    }
                    xMLString.length = n - xMLString.startOffset;
                    xMLString.endOffset = n;
                    string = validationContext.getSymbol(xMLString);
                    xMLString.startOffset = n + 1;
                } else if (!XMLCharacterProperties.nameChar10(by)) break;
                ++n;
                continue;
            }
            byArray2[0] = by;
            int n3 = 1;
            while (n3 < 4 && n + n3 < n2) {
                byArray2[n3++] = byArray[n + n3 - 1];
            }
            UTF8Support.decodeCharacter(byArray2, 0, n3, nArray);
            if (!XMLCharacterProperties.nameChar10(nArray[0])) {
                return -1;
            }
            n += nArray[1];
        }
        xQName.nsURI = validationContext.prefixMapping(string);
        xMLString.length = n - xMLString.startOffset;
        xMLString.endOffset = n;
        if ((n = QNameDV.removeWhitespace(byArray, n, n2, blArray)) >= n2 || xQName.nsURI == null && string != "") {
            return -1;
        }
        xQName.localName = validationContext.getSymbol(xMLString);
        return n;
    }

    public int preCheckFacets(XQName xQName, XMLString xMLString) {
        if (this.definedFacets != 0) {
            return this.checkFacets(xQName, xMLString);
        }
        return 0;
    }

    private int checkFacets(XQName xQName, XMLString xMLString) {
        if ((this.definedFacets & 8) != 0 && !this.pattern.matches(xMLString)) {
            return 1;
        }
        if ((this.definedFacets & 0x800) != 0) {
            for (int i = 0; i < this.enumeration.length; ++i) {
                if (this.enumeration[i].nsURI != xQName.nsURI || this.enumeration[i].localName != xQName.localName) continue;
                return 0;
            }
            return 1;
        }
        return 0;
    }

    protected Object parseValue(ParsedEntity parsedEntity, ValidatedInfo validatedInfo, VMContext vMContext) {
        return null;
    }

    protected int preCheckFacets(Object object, XMLString xMLString) {
        return this.preCheckFacets((XQName)object, xMLString);
    }
}

