/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.datatype.validation;

import com.ibm.xml.xlxp2.datatype.TypeValidator;
import com.ibm.xml.xlxp2.datatype.ValidatedInfo;
import com.ibm.xml.xlxp2.datatype.ValidationContext;
import com.ibm.xml.xlxp2.datatype.XDecimal;
import com.ibm.xml.xlxp2.datatype.validation.Pattern;
import com.ibm.xml.xlxp2.datatype.validation.XMLStringUtil;
import com.ibm.xml.xlxp2.runtime.VMContext;
import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.util.ArrayAllocator;
import com.ibm.xml.xlxp2.scan.util.DataBuffer;
import com.ibm.xml.xlxp2.scan.util.ParsedEntity;
import com.ibm.xml.xlxp2.scan.util.XMLString;
import java.util.ArrayList;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class IntegerDV
extends TypeValidator {
    private final int totalDigits;
    private final XDecimal[] enumeration;
    private final XDecimal maxInclusive;
    private final XDecimal maxExclusive;
    private final XDecimal minInclusive;
    private final XDecimal minExclusive;

    public IntegerDV(String string, String string2, String string3, String[] stringArray, XDecimal[] xDecimalArray, XDecimal xDecimal, XDecimal xDecimal2, XDecimal xDecimal3, XDecimal xDecimal4, int n, int n2, int n3) {
        super(string, string2, string3, n3, 4, stringArray, n2, false);
        this.totalDigits = n;
        this.enumeration = xDecimalArray;
        this.maxInclusive = xDecimal3;
        this.maxExclusive = xDecimal4;
        this.minInclusive = xDecimal;
        this.minExclusive = xDecimal2;
    }

    public Object getActualValue(XMLString xMLString, ValidatedInfo validatedInfo) {
        XDecimal xDecimal = IntegerDV.parse(xMLString);
        if (validatedInfo != null) {
            validatedInfo.typeValidator = this;
            validatedInfo.actualValue = xDecimal;
            validatedInfo.errorCode = 0;
        }
        return xDecimal;
    }

    public void validate(XMLString xMLString, ValidatedInfo validatedInfo, ValidationContext validationContext, ValidatedInfo validatedInfo2) {
        validatedInfo2.typeValidator = this;
        XDecimal xDecimal = null;
        if (xMLString.length != 0) {
            XDecimal xDecimal2 = xDecimal = xMLString.bytes != null ? IntegerDV.parseIntegerUnbuffered(xMLString, validationContext.getXDecimal()) : IntegerDV.parseIntegerBuffered(xMLString, validationContext.getXDecimal());
        }
        if (xDecimal == null) {
            validatedInfo2.errorCode = 1;
            return;
        }
        if (validatedInfo != null && validatedInfo.actualValue != null) {
            validatedInfo2.errorCode = validatedInfo.actualValue.equals(xDecimal) ? 0 : 1;
            validatedInfo2.actualValue = validatedInfo.actualValue;
            return;
        }
        validatedInfo2.errorCode = this.preCheckFacets(xDecimal, xMLString);
        if (validatedInfo2.errorCode != 0) {
            return;
        }
        validatedInfo2.errorCode = 0;
        validatedInfo2.actualValue = xDecimal;
    }

    public int preCheckFacets(XDecimal xDecimal, XMLString xMLString) {
        if (this.definedFacets != 0) {
            return this.checkFacets(xDecimal, xMLString);
        }
        return 0;
    }

    private final int checkFacets(XDecimal xDecimal, XMLString xMLString) {
        if ((this.definedFacets & 0x200) != 0 && xDecimal.totalDigits > this.totalDigits) {
            return 1;
        }
        if ((this.definedFacets & 0x100) != 0 && xDecimal.compareTo(this.minInclusive) == -1) {
            return 1;
        }
        if ((this.definedFacets & 0x80) != 0 && xDecimal.compareTo(this.minExclusive) != 1) {
            return 1;
        }
        if ((this.definedFacets & 0x20) != 0 && xDecimal.compareTo(this.maxInclusive) == 1) {
            return 1;
        }
        if ((this.definedFacets & 0x40) != 0 && xDecimal.compareTo(this.maxExclusive) != -1) {
            return 1;
        }
        if ((this.definedFacets & 8) != 0 && !this.pattern.matches(xMLString)) {
            return 1;
        }
        if ((this.definedFacets & 0x800) != 0) {
            boolean bl = false;
            for (int i = 0; i < this.enumeration.length; ++i) {
                if (!this.enumeration[i].equals(xDecimal)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return 1;
            }
        }
        return 0;
    }

    private int parseIntegerUnbuffered(ParsedEntity parsedEntity, XDecimal xDecimal, boolean[] blArray) {
        int n;
        int n2;
        byte[] byArray = parsedEntity.bytes;
        int n3 = parsedEntity.offset;
        int n4 = parsedEntity.endOffset;
        int n5 = 1;
        int n6 = IntegerDV.removeWhitespace(byArray, n3, n4, blArray);
        if (n6 >= n4) {
            return 0;
        }
        if (byArray[n6] == 43) {
            ++n6;
        } else if (byArray[n6] == 45) {
            ++n6;
            n5 = -1;
        }
        for (n2 = n6; n2 < n4 && byArray[n2] == 48; ++n2) {
        }
        for (n = n2; n < n4 && byArray[n] >= 48 && byArray[n] <= 57; ++n) {
        }
        n3 = IntegerDV.removeWhitespace(byArray, n, n4, blArray);
        if (n3 >= n4) {
            return 0;
        }
        if (n2 == n) {
            if (n6 == n2) {
                return 0;
            }
            return -n3;
        }
        xDecimal.setValues(parsedEntity.buffer, n2, parsedEntity.buffer, n, n - n2, 0, n5);
        return n3;
    }

    private static XDecimal parseIntegerUnbuffered(XMLString xMLString, XDecimal xDecimal) {
        int n;
        byte[] byArray = xMLString.bytes;
        int n2 = xMLString.startOffset;
        int n3 = xMLString.endOffset;
        int n4 = 1;
        if (byArray[n2 = XMLStringUtil.removeWhitespace(byArray, n2, n3)] == 43) {
            ++n2;
        } else if (byArray[n2] == 45) {
            ++n2;
            n4 = -1;
        }
        int n5 = n2;
        while (n2 < n3 && byArray[n2] == 48) {
            ++n2;
        }
        for (n = n2; n < n3 && byArray[n] >= 48 && byArray[n] <= 57; ++n) {
        }
        int n6 = XMLStringUtil.removeWhitespace(byArray, n, n3);
        if (n6 < n3) {
            return null;
        }
        if (n2 == n3) {
            if (n5 == n2) {
                return null;
            }
            return XDecimal.ZERO;
        }
        xDecimal.setValues(xMLString.firstBuffer, n2, xMLString.firstBuffer, n, n - n2, 0, n4);
        return xDecimal;
    }

    private static XDecimal parseIntegerBuffered(XMLString xMLString, XDecimal xDecimal) {
        int n;
        DataBuffer dataBuffer = xMLString.firstBuffer;
        DataBuffer dataBuffer2 = xMLString.lastBuffer == null ? dataBuffer : xMLString.lastBuffer;
        int n2 = 1;
        int n3 = xMLString.startOffset;
        int n4 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
        byte[] byArray = dataBuffer.bytes;
        byte by = byArray[n3];
        if (by <= 32) {
            while (true) {
                if ((by == 32 || by == 10 || by == 9 || by == 13) && ++n3 < n4) {
                    by = byArray[n3];
                    continue;
                }
                if (n3 != n4 || dataBuffer == dataBuffer2) break;
                dataBuffer = dataBuffer.next;
                byArray = dataBuffer.bytes;
                n3 = dataBuffer.startOffset;
                n4 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                by = byArray[n3];
            }
        }
        if (n3 == n4) {
            return null;
        }
        if (by == 43) {
            ++n3;
        } else if (by == 45) {
            ++n3;
            n2 = -1;
        }
        if (n3 == n4 && dataBuffer == dataBuffer2) {
            return null;
        }
        while (true) {
            n4 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
            n = n3;
            while (n3 < n4 && byArray[n3] == 48) {
                ++n3;
            }
            if (n3 != n4) break;
            if (dataBuffer == dataBuffer2) {
                return XDecimal.ZERO;
            }
            dataBuffer = dataBuffer.next;
            byArray = dataBuffer.bytes;
            n3 = dataBuffer.startOffset;
        }
        n = n3;
        DataBuffer dataBuffer3 = dataBuffer;
        int n5 = 0;
        while (true) {
            if (n3 < n4) {
                if (byArray[n3] < 48 || byArray[n3] > 57) break;
                ++n5;
                ++n3;
                continue;
            }
            if (dataBuffer == dataBuffer2) {
                xDecimal.setValues(dataBuffer3, n, dataBuffer2, n4, n5, 0, n2);
                return xDecimal;
            }
            dataBuffer = dataBuffer.next;
            byArray = dataBuffer.bytes;
            n3 = dataBuffer.startOffset;
            n4 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
        }
        DataBuffer dataBuffer4 = dataBuffer;
        int n6 = n3;
        by = byArray[n3];
        if (by <= 32) {
            while (true) {
                if ((by == 32 || by == 10 || by == 9 || by == 13) && ++n3 < n4) {
                    by = byArray[n3];
                    continue;
                }
                if (n3 != n4 || dataBuffer == dataBuffer2) break;
                dataBuffer = dataBuffer.next;
                byArray = dataBuffer.bytes;
                n3 = dataBuffer.startOffset;
                n4 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                by = byArray[n3];
            }
        }
        if (n3 != n4) {
            return null;
        }
        xDecimal.setValues(dataBuffer3, n, dataBuffer4, n6, n5, 0, n2);
        return xDecimal;
    }

    protected Pattern createPattern(String[] stringArray, int n) {
        int n2;
        if ((n & 8) == 0 || stringArray.length == 1 && "[\\-+]?[0-9]+".equals(stringArray[0])) {
            return null;
        }
        int n3 = n2 = stringArray != null ? stringArray.length : 0;
        if (n2 == 0) {
            return null;
        }
        return new Pattern(this.filterPatterns(stringArray));
    }

    private String[] filterPatterns(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("[\\-+]?[0-9]+")) continue;
            arrayList.add(stringArray[i]);
        }
        return arrayList.toArray(ArrayAllocator.newStringArray(arrayList.size()));
    }

    public static XDecimal parse(XMLString xMLString) {
        XDecimal xDecimal = null;
        if (xMLString.length != 0) {
            xDecimal = xMLString.bytes != null ? IntegerDV.parseIntegerUnbuffered(xMLString, new XDecimal()) : IntegerDV.parseIntegerBuffered(xMLString, new XDecimal());
        }
        return xDecimal;
    }

    protected Object parseValue(ParsedEntity parsedEntity, ValidatedInfo validatedInfo, VMContext vMContext) {
        XDecimal xDecimal = vMContext.dvContext.getXDecimal();
        int n = this.parseIntegerUnbuffered(parsedEntity, xDecimal, this.fNormalized);
        if (n == 0) {
            return null;
        }
        if (n < 0) {
            xDecimal = XDecimal.ZERO;
            parsedEntity.offset = -n;
        } else {
            parsedEntity.offset = n;
        }
        return xDecimal;
    }

    protected int preCheckFacets(Object object, XMLString xMLString) {
        return this.preCheckFacets((XDecimal)object, xMLString);
    }
}

