/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.converter;

import com.ibm.xml.xlxp2.converter.DVFactory;
import com.ibm.xml.xlxp2.converter.SimpleTypeUtil;
import com.ibm.xml.xlxp2.converter.ValueInfo;
import com.ibm.xml.xlxp2.converter.XSFacets;
import com.ibm.xml.xlxp2.datatype.TypeValidator;
import com.ibm.xml.xlxp2.datatype.ValidatedInfo;
import com.ibm.xml.xlxp2.datatype.validation.AnySimpleTypeDV;
import com.ibm.xml.xlxp2.datatype.validation.ListDV;
import com.ibm.xml.xlxp2.datatype.validation.QNameDV;
import com.ibm.xml.xlxp2.datatype.validation.UnionDV;
import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.util.XMLString;
import java.util.HashMap;
import org.apache.xerces.impl.dv.xs.XSSimpleTypeDecl;
import org.apache.xerces.xs.ShortList;
import org.apache.xerces.xs.StringList;
import org.apache.xerces.xs.XSFacet;
import org.apache.xerces.xs.XSMultiValueFacet;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.apache.xerces.xs.XSTypeDefinition;
import org.apache.xerces.xs.datatypes.ObjectList;
import org.apache.xerces.xs.datatypes.XSDateTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class TypeValidatorFactoryImpl
extends DVFactory {
    @Override
    public TypeValidator createSimpleType(String string, String string2, XSSimpleTypeDefinition xSSimpleTypeDefinition, HashMap<XSTypeDefinition, TypeValidator> hashMap, SimpleTypeUtil simpleTypeUtil) {
        TypeValidator typeValidator = hashMap.get(xSSimpleTypeDefinition);
        if (typeValidator != null) {
            return typeValidator;
        }
        XSFacets xSFacets = new XSFacets();
        this.getFacets(xSSimpleTypeDefinition, xSFacets);
        short s = xSSimpleTypeDefinition.getBuiltInKind();
        switch (s) {
            case 45: {
                XSObjectList xSObjectList = xSSimpleTypeDefinition.getMemberTypes();
                int n = xSObjectList.getLength();
                TypeValidator[] typeValidatorArray = new TypeValidator[n];
                for (int i = 0; i < n; ++i) {
                    typeValidatorArray[i] = this.createSimpleType(string, string2, (XSSimpleTypeDefinition)xSObjectList.item(i), hashMap, simpleTypeUtil);
                }
                typeValidator = simpleTypeUtil.createUnionDV(string, string2, xSSimpleTypeDefinition.getName(), xSFacets, typeValidatorArray);
                break;
            }
            case 1: {
                typeValidator = new AnySimpleTypeDV(string, string2, xSSimpleTypeDefinition.getName());
                break;
            }
            case 2: 
            case 21: 
            case 22: {
                typeValidator = simpleTypeUtil.createStringDV(string, string2, xSSimpleTypeDefinition.getName(), xSFacets, s);
                break;
            }
            case 3: {
                typeValidator = simpleTypeUtil.createBooleanDV(string, string2, xSSimpleTypeDefinition.getName(), xSFacets);
                break;
            }
            case 4: {
                typeValidator = simpleTypeUtil.createDecimalDV(string, string2, xSSimpleTypeDefinition.getName(), xSFacets);
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 37: 
            case 38: 
            case 42: {
                typeValidator = simpleTypeUtil.createIntegerDV(string, string2, xSSimpleTypeDefinition.getName(), xSFacets, s);
                break;
            }
            case 16: {
                typeValidator = simpleTypeUtil.createHexBinaryDV(string, string2, xSSimpleTypeDefinition.getName(), xSFacets);
                break;
            }
            case 24: {
                typeValidator = simpleTypeUtil.createNMTOKENDV(string, string2, xSSimpleTypeDefinition.getName(), xSFacets);
                break;
            }
            case 25: {
                typeValidator = simpleTypeUtil.createNameDV(string, string2, xSSimpleTypeDefinition.getName(), xSFacets);
                break;
            }
            case 26: {
                typeValidator = simpleTypeUtil.createNCNameDV(string, string2, xSSimpleTypeDefinition.getName(), xSFacets);
                break;
            }
            case 33: {
                typeValidator = simpleTypeUtil.createLongDV(string, string2, xSSimpleTypeDefinition.getName(), xSFacets);
                break;
            }
            case 34: {
                typeValidator = simpleTypeUtil.createIntDV(string, string2, xSSimpleTypeDefinition.getName(), xSFacets);
                break;
            }
            case 35: {
                typeValidator = simpleTypeUtil.createShortDV(string, string2, xSSimpleTypeDefinition.getName(), xSFacets);
                break;
            }
            case 36: {
                typeValidator = simpleTypeUtil.createByteDV(string, string2, xSSimpleTypeDefinition.getName(), xSFacets);
                break;
            }
            case 39: {
                typeValidator = simpleTypeUtil.createUnsignedIntDV(string, string2, xSSimpleTypeDefinition.getName(), xSFacets);
                break;
            }
            case 40: {
                typeValidator = simpleTypeUtil.createUnsignedShortDV(string, string2, xSSimpleTypeDefinition.getName(), xSFacets);
                break;
            }
            case 41: {
                typeValidator = simpleTypeUtil.createUnsignedByteDV(string, string2, xSSimpleTypeDefinition.getName(), xSFacets);
                break;
            }
            case 7: {
                typeValidator = simpleTypeUtil.createDurationDV(string, string2, xSSimpleTypeDefinition.getName(), xSFacets);
                break;
            }
            case 12: {
                typeValidator = simpleTypeUtil.createYearDV(string, string2, xSSimpleTypeDefinition.getName(), xSFacets);
                break;
            }
            case 15: {
                typeValidator = simpleTypeUtil.createMonthDV(string, string2, xSSimpleTypeDefinition.getName(), xSFacets);
                break;
            }
            case 14: {
                typeValidator = simpleTypeUtil.createDayDV(string, string2, xSSimpleTypeDefinition.getName(), xSFacets);
                break;
            }
            case 11: {
                typeValidator = simpleTypeUtil.createYearMonthDV(string, string2, xSSimpleTypeDefinition.getName(), xSFacets);
                break;
            }
            case 13: {
                typeValidator = simpleTypeUtil.createMonthDayDV(string, string2, xSSimpleTypeDefinition.getName(), xSFacets);
                break;
            }
            case 10: {
                typeValidator = simpleTypeUtil.createDateDV(string, string2, xSSimpleTypeDefinition.getName(), xSFacets);
                break;
            }
            case 9: {
                typeValidator = simpleTypeUtil.createTimeDV(string, string2, xSSimpleTypeDefinition.getName(), xSFacets);
                break;
            }
            case 8: {
                typeValidator = simpleTypeUtil.createDateTimeDV(string, string2, xSSimpleTypeDefinition.getName(), xSFacets);
                break;
            }
            case 5: {
                typeValidator = simpleTypeUtil.createFloatDV(string, string2, xSSimpleTypeDefinition.getName(), xSFacets);
                break;
            }
            case 6: {
                typeValidator = simpleTypeUtil.createDoubleDV(string, string2, xSSimpleTypeDefinition.getName(), xSFacets);
                break;
            }
            case 18: {
                typeValidator = simpleTypeUtil.createAnyURIDV(string, string2, xSSimpleTypeDefinition.getName(), xSFacets);
                break;
            }
            case 19: 
            case 20: {
                typeValidator = simpleTypeUtil.createQNameDV(string, string2, xSSimpleTypeDefinition.getName(), xSFacets, s);
                break;
            }
            case 43: 
            case 44: {
                XSSimpleTypeDefinition xSSimpleTypeDefinition2 = xSSimpleTypeDefinition.getItemType();
                TypeValidator typeValidator2 = this.createSimpleType(string, string2, xSSimpleTypeDefinition2, hashMap, simpleTypeUtil);
                typeValidator = simpleTypeUtil.createListDV(string, string2, xSSimpleTypeDefinition.getName(), xSFacets, s, typeValidator2);
                break;
            }
            case 27: {
                typeValidator = simpleTypeUtil.createIDDV(string, string2, xSSimpleTypeDefinition.getName(), xSFacets);
                break;
            }
            case 28: {
                typeValidator = simpleTypeUtil.createIDREFDV(string, string2, xSSimpleTypeDefinition.getName(), xSFacets);
                break;
            }
            case 29: {
                typeValidator = simpleTypeUtil.createENTITYDV(string, string2, xSSimpleTypeDefinition.getName(), xSFacets);
                break;
            }
            case 23: {
                typeValidator = simpleTypeUtil.createLanguageDV(string, string2, xSSimpleTypeDefinition.getName(), xSFacets);
                break;
            }
            case 17: {
                typeValidator = simpleTypeUtil.createBase64BinaryDV(string, string2, xSSimpleTypeDefinition.getName(), xSFacets);
                break;
            }
            default: {
                throw new RuntimeException("TypeValidatorFactory: unsupported or unknown built-in type.");
            }
        }
        hashMap.put((XSTypeDefinition)xSSimpleTypeDefinition, typeValidator);
        return typeValidator;
    }

    @Override
    public TypeValidator createListType(String string, String string2, TypeValidator typeValidator, SimpleTypeUtil simpleTypeUtil) {
        XSFacets xSFacets = new XSFacets();
        return simpleTypeUtil.createListDV(string, string2, null, xSFacets, 44, typeValidator);
    }

    @Override
    public ValidatedInfo getActualValue(TypeValidator typeValidator, ValueInfo valueInfo, SimpleTypeUtil simpleTypeUtil) {
        ValidatedInfo validatedInfo = new ValidatedInfo();
        if (typeValidator == null) {
            return simpleTypeUtil.parseUntypedValue(validatedInfo, valueInfo);
        }
        int n = typeValidator.builtInKind;
        String string = valueInfo.lexicalValue();
        Object object = null;
        String string2 = simpleTypeUtil.getSymbol(valueInfo.defaultNamespace());
        String[] stringArray = simpleTypeUtil.getSymbols(valueInfo.namespaceMapping());
        if (n == 45) {
            object = ((UnionDV)typeValidator).getActualValue(string, valueInfo.type(), valueInfo.itemTypes(), stringArray, string2, validatedInfo, simpleTypeUtil);
        } else if (n == 19 || n == 20) {
            object = ((QNameDV)typeValidator).getActualValue(string, stringArray, string2, validatedInfo);
        } else if (n == 44 || n == 43) {
            object = ((ListDV)typeValidator).getActualValue(string, valueInfo.itemTypes(), stringArray, string2, validatedInfo, simpleTypeUtil);
        } else {
            XMLString xMLString = new XMLString();
            simpleTypeUtil.addString(string, xMLString);
            object = typeValidator.getActualValue(xMLString, validatedInfo);
            xMLString.unregister();
        }
        return object != null ? validatedInfo : null;
    }

    private void getFacets(XSSimpleTypeDefinition xSSimpleTypeDefinition, XSFacets xSFacets) {
        XSFacet xSFacet;
        int n;
        xSFacets.definedFacets = 0;
        XSObjectList xSObjectList = xSSimpleTypeDefinition.getFacets();
        XSObjectList xSObjectList2 = xSSimpleTypeDefinition.getMultiValueFacets();
        XSSimpleTypeDecl xSSimpleTypeDecl = (XSSimpleTypeDecl)xSSimpleTypeDefinition;
        block16: for (n = 0; n < xSObjectList.getLength(); ++n) {
            xSFacet = (XSFacet)xSObjectList.item(n);
            switch (xSFacet.getFacetKind()) {
                case 1: {
                    xSFacets.length = Integer.parseInt(xSFacet.getLexicalFacetValue());
                    xSFacets.definedFacets |= 1;
                    continue block16;
                }
                case 2: {
                    xSFacets.minLength = Integer.parseInt(xSFacet.getLexicalFacetValue());
                    xSFacets.definedFacets |= 2;
                    continue block16;
                }
                case 4: {
                    xSFacets.maxLength = Integer.parseInt(xSFacet.getLexicalFacetValue());
                    xSFacets.definedFacets |= 4;
                    continue block16;
                }
                case 16: {
                    if ("preserve".equals(xSFacet.getLexicalFacetValue())) {
                        xSFacets.whiteSpace = 0;
                    } else if ("replace".equals(xSFacet.getLexicalFacetValue())) {
                        xSFacets.whiteSpace = 1;
                    } else if ("collapse".equals(xSFacet.getLexicalFacetValue())) {
                        xSFacets.whiteSpace = (byte)2;
                    } else {
                        throw new RuntimeException("TypeValidatorFactory: whiteSpace facet must be preserve/replace/collapse.");
                    }
                    xSFacets.definedFacets |= 0x10;
                    continue block16;
                }
                case 32: {
                    xSFacets.maxInclusive = this.getMinMaxFacetValue(xSSimpleTypeDecl, xSFacet);
                    xSFacets.definedFacets |= 0x20;
                    continue block16;
                }
                case 64: {
                    xSFacets.maxExclusive = this.getMinMaxFacetValue(xSSimpleTypeDecl, xSFacet);
                    xSFacets.definedFacets |= 0x40;
                    continue block16;
                }
                case 128: {
                    xSFacets.minExclusive = this.getMinMaxFacetValue(xSSimpleTypeDecl, xSFacet);
                    xSFacets.definedFacets |= 0x80;
                    continue block16;
                }
                case 256: {
                    xSFacets.minInclusive = this.getMinMaxFacetValue(xSSimpleTypeDecl, xSFacet);
                    xSFacets.definedFacets |= 0x100;
                    continue block16;
                }
                case 512: {
                    xSFacets.totalDigits = Integer.parseInt(xSFacet.getLexicalFacetValue());
                    xSFacets.definedFacets |= 0x200;
                    continue block16;
                }
                case 1024: {
                    xSFacets.fractionDigits = Integer.parseInt(xSFacet.getLexicalFacetValue());
                    xSFacets.definedFacets |= 0x400;
                }
            }
        }
        block17: for (n = 0; n < xSObjectList2.getLength(); ++n) {
            xSFacet = (XSMultiValueFacet)xSObjectList2.item(n);
            switch (xSFacet.getFacetKind()) {
                case 8: {
                    StringList stringList = xSFacet.getLexicalFacetValues();
                    int n2 = stringList.getLength();
                    String[] stringArray = new String[n2];
                    for (int i = 0; i < n2; ++i) {
                        stringArray[i] = stringList.item(i);
                    }
                    xSFacets.pattern = stringArray;
                    xSFacets.definedFacets |= 8;
                    continue block17;
                }
                case 2048: {
                    StringList stringList = xSSimpleTypeDefinition.getLexicalEnumeration();
                    ShortList shortList = xSSimpleTypeDecl.getEnumerationTypeList();
                    ObjectList objectList = xSSimpleTypeDecl.getActualEnumeration();
                    ObjectList objectList2 = xSSimpleTypeDecl.getEnumerationItemTypeList();
                    int n2 = stringList.getLength();
                    ValueInfo[] valueInfoArray = new ValueInfo[n2];
                    for (int i = 0; i < n2; ++i) {
                        valueInfoArray[i] = new ValueInfo(stringList.item(i), objectList.item(i), shortList.item(i), (ShortList)objectList2.item(i));
                    }
                    xSFacets.enumeration = valueInfoArray;
                    xSFacets.definedFacets |= 0x800;
                }
            }
        }
    }

    private String getMinMaxFacetValue(XSSimpleTypeDecl xSSimpleTypeDecl, XSFacet xSFacet) {
        switch (xSSimpleTypeDecl.getBuiltInKind()) {
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                short s = xSFacet.getFacetKind();
                if (s == 256) {
                    return ((XSDateTime)xSSimpleTypeDecl.getMinInclusiveValue()).getLexicalValue();
                }
                if (s == 128) {
                    return ((XSDateTime)xSSimpleTypeDecl.getMinExclusiveValue()).getLexicalValue();
                }
                if (s == 32) {
                    return ((XSDateTime)xSSimpleTypeDecl.getMaxInclusiveValue()).getLexicalValue();
                }
                if (s != 64) break;
                return ((XSDateTime)xSSimpleTypeDecl.getMaxExclusiveValue()).getLexicalValue();
            }
        }
        return xSFacet.getLexicalFacetValue();
    }
}

