/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.converter;

import com.ibm.xml.xlxp.compiler.impl.idc.IDCSymbol;
import com.ibm.xml.xlxp.compiler.impl.idc.XPathAction;
import com.ibm.xml.xlxp.compiler.impl.idc.XPathActionFinalNilSelector;
import com.ibm.xml.xlxp.compiler.impl.idc.XPathActionImpl;
import com.ibm.xml.xlxp.compiler.impl.idc.XPathActionInvalid;
import com.ibm.xml.xlxp.compiler.impl.idc.XPathAttributeInfo;
import com.ibm.xml.xlxp.compiler.impl.idc.XPathAttributeInfoImpl;
import com.ibm.xml.xlxp.compiler.impl.idc.XPathDFA;
import com.ibm.xml.xlxp2.converter.Converter;
import com.ibm.xml.xlxp2.converter.IDCInstructionBuilder;
import com.ibm.xml.xlxp2.grammar.Attribute;
import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.util.BitSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModelGroup;
import org.apache.xerces.xs.XSNamedMap;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSParticle;
import org.apache.xerces.xs.XSTerm;
import org.apache.xerces.xs.XSTypeDefinition;
import org.apache.xerces.xs.XSWildcard;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
final class IDCMatcher {
    private final Converter fConverter;
    private final Stack<MatcherInfo> fInfoStack = new Stack();
    private final MatcherInfoPool fInfoPool = new MatcherInfoPool();
    private final AnnotatedMap fAnnotatedMap = new AnnotatedMap();

    public IDCMatcher(Converter converter) {
        this.fConverter = converter;
    }

    public void match(HashMap hashMap) {
        this.clear();
        this.startSelectors(hashMap);
        this.processInfoStack();
    }

    private void clear() {
        this.fAnnotatedMap.clear();
    }

    private void startSelectors(HashMap hashMap) {
        for (Map.Entry entry : hashMap.entrySet()) {
            XSElementDeclaration xSElementDeclaration = (XSElementDeclaration)entry.getKey();
            ArrayList arrayList = (ArrayList)entry.getValue();
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                this.startSelector(xSElementDeclaration, (IDCSymbol)arrayList.get(i));
            }
        }
    }

    private void startSelector(XSElementDeclaration xSElementDeclaration, IDCSymbol iDCSymbol) {
        XPathDFA xPathDFA = iDCSymbol.getSelector();
        boolean bl = xPathDFA.isStateFinal(1);
        boolean bl2 = xPathDFA.allowMoreInput(1);
        int n = bl ? -1 : 1;
        IDCInstructionBuilder iDCInstructionBuilder = this.fConverter.getIDCInstructionBuilder(xSElementDeclaration);
        XPathActionImpl xPathActionImpl = new XPathActionImpl(iDCSymbol, 1, true, xPathDFA.id(), 0, n, bl, bl2);
        xPathActionImpl.setFieldCount(iDCSymbol.getFieldCount());
        iDCInstructionBuilder.addAction((XPathAction)xPathActionImpl);
        this.addStartFieldActions(xPathDFA, iDCSymbol, xSElementDeclaration, bl);
        if (bl2) {
            MatcherInfo matcherInfo = this.fInfoPool.matcherInfo();
            matcherInfo.setValues(xSElementDeclaration, iDCSymbol, xPathDFA, n, n, -1);
            this.fInfoStack.push(matcherInfo);
        }
        if (bl) {
            this.endSelector(xSElementDeclaration, iDCSymbol, xPathActionImpl);
        }
    }

    private void endSelector(XSElementDeclaration xSElementDeclaration, IDCSymbol iDCSymbol, XPathActionImpl xPathActionImpl) {
        int n = iDCSymbol.getFieldCount();
        if (xSElementDeclaration.getNillable()) {
            this.fConverter.getIDCInstructionBuilder(xSElementDeclaration).addNilAction((XPathAction)new XPathActionFinalNilSelector(xPathActionImpl));
        }
        for (int i = 0; i < n; ++i) {
            XPathDFA xPathDFA = iDCSymbol.getFieldAt(i);
            this.startField(xSElementDeclaration, iDCSymbol, xPathDFA, i, xPathActionImpl);
        }
    }

    private void startField(XSElementDeclaration xSElementDeclaration, IDCSymbol iDCSymbol, XPathDFA xPathDFA, int n, XPathActionImpl xPathActionImpl) {
        boolean bl = xPathDFA.allowMoreInput(1);
        boolean bl2 = xPathDFA.isStateFinal(1);
        boolean bl3 = xPathDFA.isStateFinalA(1);
        int n2 = bl2 ? -1 : 1;
        XPathActionImpl xPathActionImpl2 = new XPathActionImpl(iDCSymbol, 1, false, xPathDFA.id(), 0, n2, bl2 || bl3, bl);
        xPathActionImpl2.setFieldIndex(n);
        xPathActionImpl.addFieldAction((XPathAction)xPathActionImpl2);
        if (bl3) {
            this.setFieldAttributes(xSElementDeclaration, xPathActionImpl2, xPathDFA.attributes(1));
        }
        if (bl) {
            MatcherInfo matcherInfo = this.fInfoPool.matcherInfo();
            matcherInfo.setValues(xSElementDeclaration, iDCSymbol, xPathDFA, n2, n2, n);
            this.fInfoStack.push(matcherInfo);
        }
    }

    private XPathAction createStartFieldAction(XSElementDeclaration xSElementDeclaration, IDCSymbol iDCSymbol, XPathDFA xPathDFA, int n, boolean bl) {
        boolean bl2 = xPathDFA.allowMoreInput(1);
        boolean bl3 = xPathDFA.isStateFinal(1);
        boolean bl4 = xPathDFA.isStateFinalA(1);
        int n2 = bl3 ? -1 : 1;
        XPathActionImpl xPathActionImpl = new XPathActionImpl(iDCSymbol, 1, false, xPathDFA.id(), 0, n2, bl3 || bl4, bl2);
        xPathActionImpl.setFieldIndex(n);
        if (bl4) {
            if (bl) {
                this.setFieldAttributes(xSElementDeclaration, xPathActionImpl, xPathDFA.attributes(1));
            } else {
                xPathActionImpl.setAttributes(xPathDFA.attributes(1));
            }
        }
        return xPathActionImpl;
    }

    private void addStartFieldActions(XPathDFA xPathDFA, IDCSymbol iDCSymbol, XSElementDeclaration xSElementDeclaration, boolean bl) {
        int n = iDCSymbol.getFieldCount();
        for (int i = 0; i < n; ++i) {
            XPathDFA xPathDFA2 = iDCSymbol.getFieldAt(i);
            XPathAction xPathAction = this.createStartFieldAction(xSElementDeclaration, iDCSymbol, xPathDFA2, i, bl);
            xPathDFA.addStartFieldAction(xPathAction);
        }
    }

    private void processInfoStack() {
        while (!this.fInfoStack.isEmpty()) {
            MatcherInfo matcherInfo = this.fInfoStack.pop();
            this.processInfo(matcherInfo);
            this.fInfoPool.returnMatcherInfo(matcherInfo);
        }
    }

    private void processInfo(MatcherInfo matcherInfo) {
        XSTypeDefinition xSTypeDefinition = matcherInfo.fElement.getTypeDefinition();
        if (xSTypeDefinition.getTypeCategory() == 15) {
            XSComplexTypeDefinition xSComplexTypeDefinition = (XSComplexTypeDefinition)xSTypeDefinition;
            if (xSComplexTypeDefinition.getBaseType() == xSComplexTypeDefinition) {
                this.fConverter.getIDCInstructionBuilder(matcherInfo.fElement).addAction((XPathAction)new XPathActionImpl(matcherInfo.fIDCSymbol, 2, matcherInfo.isSelector(), matcherInfo.fXPathDFA.id(), matcherInfo.fCurrentState, 0, false, true));
                return;
            }
            XSParticle xSParticle = xSComplexTypeDefinition.getParticle();
            if (xSParticle != null) {
                this.matchParticle(matcherInfo, xSParticle, matcherInfo.isSelector());
            }
            this.matchDerivedTypes(matcherInfo, matcherInfo.isSelector());
        }
    }

    private void matchParticle(MatcherInfo matcherInfo, XSParticle xSParticle, boolean bl) {
        XSTerm xSTerm = xSParticle.getTerm();
        short s = xSTerm.getType();
        if (s == 2) {
            XSElementDeclaration xSElementDeclaration = (XSElementDeclaration)xSTerm;
            this.matchTermElement(matcherInfo, xSElementDeclaration, bl);
            return;
        }
        if (s == 9) {
            XSWildcard xSWildcard = (XSWildcard)xSTerm;
            this.matchTermWildcard(matcherInfo, xSWildcard, bl);
            return;
        }
        XSModelGroup xSModelGroup = (XSModelGroup)xSTerm;
        XSObjectList xSObjectList = xSModelGroup.getParticles();
        for (int i = 0; i < xSObjectList.getLength(); ++i) {
            this.matchParticle(matcherInfo, (XSParticle)xSObjectList.item(i), bl);
        }
    }

    private void matchTermElement(MatcherInfo matcherInfo, XSElementDeclaration xSElementDeclaration, boolean bl) {
        this.matchElement(matcherInfo, xSElementDeclaration, bl);
        if (xSElementDeclaration.getScope() == 1) {
            XSObjectList xSObjectList = this.fConverter.getSubstitutionGroup(xSElementDeclaration);
            int n = xSObjectList.getLength();
            for (int i = 0; i < n; ++i) {
                XSElementDeclaration xSElementDeclaration2 = (XSElementDeclaration)xSObjectList.item(i);
                if (xSElementDeclaration2 == xSElementDeclaration) continue;
                this.matchElement(matcherInfo, xSElementDeclaration2, bl);
            }
        }
    }

    private void matchElement(MatcherInfo matcherInfo, XSElementDeclaration xSElementDeclaration, boolean bl) {
        MatcherInfo matcherInfo2;
        int n = matcherInfo.fXPathDFA.transition(Math.abs(matcherInfo.fCurrentState), xSElementDeclaration.getName(), xSElementDeclaration.getNamespace());
        if (n == 0 || this.fAnnotatedMap.contains(xSElementDeclaration, matcherInfo.fXPathDFA, Math.abs(matcherInfo.fCurrentState))) {
            return;
        }
        this.fAnnotatedMap.put(xSElementDeclaration, matcherInfo.fXPathDFA, Math.abs(matcherInfo.fCurrentState));
        boolean bl2 = matcherInfo.fXPathDFA.isStateFinal(Math.abs(n));
        boolean bl3 = matcherInfo.fXPathDFA.allowMoreInput(Math.abs(n));
        boolean bl4 = matcherInfo.fXPathDFA.isStateFinalA(Math.abs(n));
        if (bl3) {
            matcherInfo2 = this.fInfoPool.matcherInfo();
            matcherInfo2.setValues(xSElementDeclaration, matcherInfo.fIDCSymbol, matcherInfo.fXPathDFA, matcherInfo.fCurrentState, n, matcherInfo.fFieldIndex);
            this.fInfoStack.push(matcherInfo2);
        }
        matcherInfo2 = new XPathActionImpl(matcherInfo.fIDCSymbol, 2, bl, matcherInfo.fXPathDFA.id(), matcherInfo.fCurrentState, n, bl2 || bl4, bl3);
        if (bl) {
            this.fConverter.getIDCInstructionBuilder(xSElementDeclaration).addAction((XPathAction)matcherInfo2);
            if (bl2) {
                this.endSelector(xSElementDeclaration, matcherInfo.fIDCSymbol, (XPathActionImpl)matcherInfo2);
            }
            return;
        }
        matcherInfo2.setFieldIndex(matcherInfo.fFieldIndex);
        if (bl4) {
            this.setFieldAttributes(xSElementDeclaration, (XPathActionImpl)matcherInfo2, matcherInfo.fXPathDFA.attributes(Math.abs(n)));
        }
        if (xSElementDeclaration.getNillable()) {
            MatcherInfo matcherInfo3 = matcherInfo2;
            if (n < 0) {
                matcherInfo3 = new XPathActionInvalid((XPathActionImpl)matcherInfo2);
                if (matcherInfo.fIDCSymbol.getCategory() == 1) {
                    this.fConverter.getIDCInstructionBuilder(xSElementDeclaration).addAction((XPathAction)matcherInfo3);
                } else {
                    this.fConverter.getIDCInstructionBuilder(xSElementDeclaration).addAction((XPathAction)matcherInfo2);
                }
            } else {
                this.fConverter.getIDCInstructionBuilder(xSElementDeclaration).addAction((XPathAction)matcherInfo2);
            }
            if (bl2 || bl4) {
                this.fConverter.getIDCInstructionBuilder(xSElementDeclaration).addNilAction((XPathAction)matcherInfo3);
            }
        } else {
            this.fConverter.getIDCInstructionBuilder(xSElementDeclaration).addAction((XPathAction)matcherInfo2);
        }
    }

    private void matchDerivedTypes(MatcherInfo matcherInfo, boolean bl) {
        BitSet bitSet = this.fConverter.getElement((XSElementDeclaration)matcherInfo.fElement).xsiTypes;
        if (bitSet == null || bitSet.isZero()) {
            return;
        }
        int n = bitSet.getLength();
        for (int i = 0; i < n; ++i) {
            XSComplexTypeDefinition xSComplexTypeDefinition;
            XSParticle xSParticle;
            XSTypeDefinition xSTypeDefinition;
            if (!bitSet.getBit(i) || (xSTypeDefinition = this.fConverter.getGlobalTypeAtIndex(i)).getTypeCategory() != 15 || (xSParticle = (xSComplexTypeDefinition = (XSComplexTypeDefinition)xSTypeDefinition).getParticle()) == null) continue;
            this.matchParticle(matcherInfo, xSParticle, bl);
        }
    }

    private void matchTermWildcard(MatcherInfo matcherInfo, XSWildcard xSWildcard, boolean bl) {
        if (xSWildcard.getProcessContents() == 2) {
            return;
        }
        XSNamedMap xSNamedMap = this.fConverter.getGlobalElementDeclarations();
        int n = xSNamedMap.getLength();
        for (int i = 0; i < n; ++i) {
            XSElementDeclaration xSElementDeclaration = (XSElementDeclaration)xSNamedMap.item(i);
            if (!Converter.wildcardAllows(xSWildcard, xSElementDeclaration.getNamespace(), xSElementDeclaration.getName()) || xSElementDeclaration.getAbstract()) continue;
            this.matchTermElement(matcherInfo, xSElementDeclaration, bl);
        }
        if (this.fAnnotatedMap.contains(xSWildcard, matcherInfo.fXPathDFA, Math.abs(matcherInfo.fCurrentState))) {
            return;
        }
        this.fAnnotatedMap.put(xSWildcard, matcherInfo.fXPathDFA, Math.abs(matcherInfo.fCurrentState));
        this.fConverter.getIDCInstructionBuilder(xSWildcard).addAction((XPathAction)new XPathActionImpl(matcherInfo.fIDCSymbol, 2, bl, matcherInfo.fXPathDFA.id(), matcherInfo.fCurrentState, 0, false, true));
    }

    private void setFieldAttributes(XSElementDeclaration xSElementDeclaration, XPathActionImpl xPathActionImpl, XPathAttributeInfo[] xPathAttributeInfoArray) {
        Attribute[] attributeArray = this.fConverter.getElement((XSElementDeclaration)xSElementDeclaration).type.ownedChoices;
        if (attributeArray != null && attributeArray.length > 6) {
            block0: for (int i = 0; i < xPathAttributeInfoArray.length; ++i) {
                XPathAttributeInfoImpl xPathAttributeInfoImpl = (XPathAttributeInfoImpl)xPathAttributeInfoArray[i];
                if (xPathAttributeInfoImpl.name() == null) continue;
                for (int j = 6; j < attributeArray.length; ++j) {
                    String string;
                    Attribute attribute = attributeArray[j];
                    String string2 = string = attribute.nsURI == null ? "" : attribute.nsURI;
                    if (!xPathAttributeInfoImpl.name().equals(attribute.nsURI) || !xPathAttributeInfoImpl.namespace().equals(string)) continue;
                    xPathAttributeInfoImpl.setIndex(j);
                    continue block0;
                }
            }
        }
        xPathActionImpl.setAttributes(xPathAttributeInfoArray);
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    private static final class AnnotatedMap {
        private HashMap<Object, ArrayList<int[]>> fMap = new HashMap();

        private AnnotatedMap() {
        }

        public void put(Object object, XPathDFA xPathDFA, int n) {
            ArrayList<Object> arrayList = this.fMap.get(object);
            if (arrayList == null) {
                arrayList = new ArrayList();
                this.fMap.put(object, arrayList);
            }
            int[] nArray = new int[2];
            this.setValue(nArray, xPathDFA, n);
            arrayList.add(nArray);
        }

        public boolean contains(Object object, XPathDFA xPathDFA, int n) {
            ArrayList<int[]> arrayList = this.fMap.get(object);
            if (arrayList != null) {
                int[] nArray = new int[2];
                Iterator<int[]> iterator = arrayList.iterator();
                this.setValue(nArray, xPathDFA, n);
                while (iterator.hasNext()) {
                    int[] nArray2 = iterator.next();
                    if (!this.equals(nArray, nArray2)) continue;
                    return true;
                }
            }
            return false;
        }

        public void clear() {
            this.fMap.clear();
        }

        private void setValue(int[] nArray, XPathDFA xPathDFA, int n) {
            nArray[0] = xPathDFA.id();
            nArray[1] = n;
        }

        private boolean equals(int[] nArray, int[] nArray2) {
            return nArray[0] == nArray2[0] && nArray[1] == nArray2[1];
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    private static final class MatcherInfoPool {
        private MatcherInfo head;

        private MatcherInfoPool() {
        }

        public MatcherInfo matcherInfo() {
            if (this.head == null) {
                return new MatcherInfo();
            }
            MatcherInfo matcherInfo = this.head;
            this.head = this.head.fNext;
            return matcherInfo;
        }

        public void returnMatcherInfo(MatcherInfo matcherInfo) {
            matcherInfo.fNext = this.head;
            this.head = matcherInfo;
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    private static final class MatcherInfo {
        public XSElementDeclaration fElement;
        public IDCSymbol fIDCSymbol;
        public XPathDFA fXPathDFA;
        public int fOldState;
        public int fCurrentState;
        public int fFieldIndex = -1;
        public MatcherInfo fNext;

        private MatcherInfo() {
        }

        public void setValues(XSElementDeclaration xSElementDeclaration, IDCSymbol iDCSymbol, XPathDFA xPathDFA, int n, int n2, int n3) {
            this.fElement = xSElementDeclaration;
            this.fIDCSymbol = iDCSymbol;
            this.fXPathDFA = xPathDFA;
            this.fOldState = n;
            this.fCurrentState = n2;
            this.fFieldIndex = n3;
        }

        public boolean isSelector() {
            return this.fFieldIndex == -1;
        }
    }
}

