/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.converter;

import com.ibm.xml.xlxp.compiler.impl.idc.IDCHandler;
import com.ibm.xml.xlxp.compiler.impl.idc.IDCSymbol;
import com.ibm.xml.xlxp2.converter.DVFactory;
import com.ibm.xml.xlxp2.converter.IDCInstructionBuilder;
import com.ibm.xml.xlxp2.converter.IDCMatcher;
import com.ibm.xml.xlxp2.converter.SimpleTypeUtil;
import com.ibm.xml.xlxp2.converter.ValueInfo;
import com.ibm.xml.xlxp2.datatype.TypeValidator;
import com.ibm.xml.xlxp2.datatype.ValidatedInfo;
import com.ibm.xml.xlxp2.grammar.Attribute;
import com.ibm.xml.xlxp2.grammar.Element;
import com.ibm.xml.xlxp2.grammar.ElementType;
import com.ibm.xml.xlxp2.grammar.Grammar;
import com.ibm.xml.xlxp2.grammar.NamedDeclaration;
import com.ibm.xml.xlxp2.grammar.Wildcard;
import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.util.BitSet;
import com.ibm.xml.xlxp2.validation.idc.EndIDC;
import com.ibm.xml.xlxp2.validation.idc.StartIDC;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.xerces.impl.dv.xs.XSSimpleTypeDecl;
import org.apache.xerces.xs.ShortList;
import org.apache.xerces.xs.StringList;
import org.apache.xerces.xs.XSAttributeDeclaration;
import org.apache.xerces.xs.XSAttributeUse;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSIDCDefinition;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSModelGroup;
import org.apache.xerces.xs.XSNamedMap;
import org.apache.xerces.xs.XSObject;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSParticle;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.apache.xerces.xs.XSTerm;
import org.apache.xerces.xs.XSTypeDefinition;
import org.apache.xerces.xs.XSWildcard;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class Converter {
    private final boolean fValidating;
    private static final int UNBOUNDED = -1;
    private static final String URI_XSD = "http://www.w3.org/2001/XMLSchema";
    private static final String NAME_ANYTYPE = "anyType";
    private static final String NAME_ANYURI = "anyURI";
    private static final String NAME_BOOLEAN = "boolean";
    private static final String NAME_QNAME = "QName";
    private static final String NAME_ID = "ID";
    private static final String NAME_STRING = "string";
    private static final String URI_XSI = "http://www.w3.org/2001/XMLSchema-instance";
    private static final String NAME_TYPE = "type";
    private static final String NAME_NIL = "nil";
    private static final String NAME_SL = "schemaLocation";
    private static final String NAME_NSL = "noNamespaceSchemaLocation";
    private static final ArrayList EMPTY_VECTOR = new ArrayList();
    private final HashMap fAtts = new HashMap();
    private final HashMap fUses = new HashMap();
    private final HashMap fElems = new HashMap();
    private final HashMap fElemIDCs = new HashMap();
    private final HashMap fIDCBuilders = new HashMap();
    private final HashMap fElemCopies = new HashMap();
    private final ArrayList fGElems = new ArrayList();
    private final HashMap fCMs = new HashMap();
    private final HashMap<XSTypeDefinition, TypeValidator> fSTs = new HashMap();
    private final HashMap fWCs = new HashMap();
    private final HashMap fWCCopies = new HashMap();
    private final NodePool fNodes = new NodePool();
    private final ArrayList fGlobalTypes = new ArrayList();
    private final ArrayList fAbstractTypes = new ArrayList();
    private final HashMap fSimpleTypes = new HashMap();
    private final HashMap fBuiltInTypes = new HashMap();
    private final HashMap fDerivedTypes = new HashMap();
    private final HashMap fWCDecls = new HashMap();
    private final ArrayList fPendingCMs = new ArrayList();
    private final HashMap fSeen = new HashMap();
    private final ArrayList fAllElems = new ArrayList();
    private final ArrayList fAllOpts = new ArrayList();
    private XSModel fXSModel;
    private DVFactory fDVFactory;
    private SimpleTypeUtil fTypeUtil;
    private Attribute[] fDefaultAttrs;
    private int fCount;
    private IDCHandler fIDCHandler;
    private final HashMap<String, String> fInternedStrings = new HashMap();

    public Converter() {
        this(true);
    }

    public Converter(boolean bl) {
        this.fValidating = bl;
    }

    public Grammar convert(XSModel xSModel, DVFactory dVFactory, String string, String string2) throws ConverterException {
        SimpleTypeUtil simpleTypeUtil = new SimpleTypeUtil(this.fInternedStrings);
        this.prepare(xSModel, dVFactory, simpleTypeUtil);
        Grammar grammar = new Grammar();
        grammar.xsModel = xSModel;
        this.analyzeSchema();
        this.convertGlobalSimpleTypes();
        this.prepareDefaultAttributes();
        this.convertGlobalAttributes();
        this.convertGlobalElements();
        this.convertGlobalTypes();
        this.processPendingCMs();
        this.fillInTypeHeirarchy();
        this.fillGrammar(grammar, string, string2);
        this.finish();
        return grammar;
    }

    private void prepare(XSModel xSModel, DVFactory dVFactory, SimpleTypeUtil simpleTypeUtil) {
        this.fXSModel = xSModel;
        this.fDVFactory = dVFactory;
        this.fTypeUtil = simpleTypeUtil;
        this.fIDCHandler = new IDCHandler();
    }

    private void finish() {
        this.fAtts.clear();
        this.fUses.clear();
        this.fElems.clear();
        this.fElemIDCs.clear();
        this.fIDCBuilders.clear();
        this.fElemCopies.clear();
        this.fGElems.clear();
        this.fCMs.clear();
        this.fSTs.clear();
        this.fWCs.clear();
        this.fWCCopies.clear();
        this.fNodes.reset();
        this.fXSModel = null;
        this.fDefaultAttrs = null;
        this.fGlobalTypes.clear();
        this.fAbstractTypes.clear();
        this.fSimpleTypes.clear();
        this.fBuiltInTypes.clear();
        this.fDerivedTypes.clear();
        this.fWCDecls.clear();
        this.fPendingCMs.clear();
        this.fSeen.clear();
        this.fTypeUtil = null;
        this.fIDCHandler = null;
    }

    private void analyzeSchema() {
        Object object;
        XSTypeDefinition xSTypeDefinition;
        int n;
        Object object2;
        XSNamedMap xSNamedMap = this.fXSModel.getComponents((short)3);
        int n2 = xSNamedMap.getLength();
        for (int i = 0; i < n2; ++i) {
            object2 = (XSTypeDefinition)xSNamedMap.item(i);
            if (object2 instanceof XSSimpleTypeDefinition || !((XSComplexTypeDefinition)object2).getAbstract()) {
                this.fGlobalTypes.add(object2);
                continue;
            }
            this.fAbstractTypes.add(object2);
        }
        XSTypeDefinition xSTypeDefinition2 = this.fXSModel.getTypeDefinition(NAME_ANYTYPE, URI_XSD);
        object2 = new ArrayList();
        this.fDerivedTypes.put(xSTypeDefinition2, object2);
        n2 = this.fGlobalTypes.size();
        for (n = 0; n < n2; ++n) {
            xSTypeDefinition = (XSTypeDefinition)this.fGlobalTypes.get(n);
            int n3 = 0;
            for (object = xSTypeDefinition.getBaseType(); object != null && object != xSTypeDefinition2; object = object.getBaseType()) {
                if (object.getAnonymous() || !(object instanceof XSSimpleTypeDefinition) && (((XSComplexTypeDefinition)object).getProhibitedSubstitutions() & (n3 |= xSTypeDefinition instanceof XSComplexTypeDefinition ? (int)((XSComplexTypeDefinition)xSTypeDefinition).getDerivationMethod() : 2)) != 0) continue;
                ArrayList<Integer> arrayList = (ArrayList<Integer>)this.fDerivedTypes.get(object);
                if (arrayList == null) {
                    arrayList = new ArrayList<Integer>();
                    this.fDerivedTypes.put(object, arrayList);
                }
                arrayList.add(Converter.getInteger(n));
            }
            ((ArrayList)object2).add(Converter.getInteger(n));
        }
        for (n = 0; n < n2; ++n) {
            xSTypeDefinition = (XSTypeDefinition)this.fGlobalTypes.get(n);
            object = (ArrayList)this.fDerivedTypes.get(xSTypeDefinition);
            if (object == null) continue;
            BitSet bitSet = new BitSet(this.fGlobalTypes.size());
            for (int i = 0; i < ((ArrayList)object).size(); ++i) {
                bitSet.setBit((Integer)((ArrayList)object).get(i));
            }
            bitSet.setBit(n);
            this.fDerivedTypes.put(xSTypeDefinition, bitSet);
        }
        n2 = this.fAbstractTypes.size();
        for (n = 0; n < n2; ++n) {
            xSTypeDefinition = (XSTypeDefinition)this.fAbstractTypes.get(n);
            object = (ArrayList)this.fDerivedTypes.get(xSTypeDefinition);
            if (object == null) continue;
            BitSet bitSet = new BitSet(this.fGlobalTypes.size());
            for (int i = 0; i < ((ArrayList)object).size(); ++i) {
                bitSet.setBit((Integer)((ArrayList)object).get(i));
            }
            this.fDerivedTypes.put(xSTypeDefinition, bitSet);
        }
        this.fBuiltInTypes.put(Converter.getInteger(1), this.fXSModel.getTypeDefinition("anySimpleType", URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(2), this.fXSModel.getTypeDefinition(NAME_STRING, URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(3), this.fXSModel.getTypeDefinition(NAME_BOOLEAN, URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(4), this.fXSModel.getTypeDefinition("decimal", URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(5), this.fXSModel.getTypeDefinition("float", URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(6), this.fXSModel.getTypeDefinition("double", URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(7), this.fXSModel.getTypeDefinition("duration", URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(8), this.fXSModel.getTypeDefinition("dateTime", URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(9), this.fXSModel.getTypeDefinition("time", URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(10), this.fXSModel.getTypeDefinition("date", URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(11), this.fXSModel.getTypeDefinition("gYearMonth", URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(12), this.fXSModel.getTypeDefinition("gYear", URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(13), this.fXSModel.getTypeDefinition("gMonthDay", URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(14), this.fXSModel.getTypeDefinition("gDay", URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(15), this.fXSModel.getTypeDefinition("gMonth", URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(16), this.fXSModel.getTypeDefinition("hexBinary", URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(17), this.fXSModel.getTypeDefinition("base64Binary", URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(18), this.fXSModel.getTypeDefinition(NAME_ANYURI, URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(19), this.fXSModel.getTypeDefinition(NAME_QNAME, URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(20), this.fXSModel.getTypeDefinition("NOTATION", URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(21), this.fXSModel.getTypeDefinition("normalizedString", URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(22), this.fXSModel.getTypeDefinition("token", URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(23), this.fXSModel.getTypeDefinition("language", URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(24), this.fXSModel.getTypeDefinition("NMTOKEN", URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(25), this.fXSModel.getTypeDefinition("Name", URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(26), this.fXSModel.getTypeDefinition("NCName", URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(27), this.fXSModel.getTypeDefinition(NAME_ID, URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(28), this.fXSModel.getTypeDefinition("IDREF", URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(29), this.fXSModel.getTypeDefinition("ENTITY", URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(30), this.fXSModel.getTypeDefinition("integer", URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(31), this.fXSModel.getTypeDefinition("nonPositiveInteger", URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(32), this.fXSModel.getTypeDefinition("negativeInteger", URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(33), this.fXSModel.getTypeDefinition("long", URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(34), this.fXSModel.getTypeDefinition("int", URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(35), this.fXSModel.getTypeDefinition("short", URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(36), this.fXSModel.getTypeDefinition("byte", URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(37), this.fXSModel.getTypeDefinition("nonNegativeInteger", URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(38), this.fXSModel.getTypeDefinition("unsignedLong", URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(39), this.fXSModel.getTypeDefinition("unsignedInt", URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(40), this.fXSModel.getTypeDefinition("unsignedShort", URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(41), this.fXSModel.getTypeDefinition("unsignedByte", URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(42), this.fXSModel.getTypeDefinition("positiveInteger", URI_XSD));
    }

    private void prepareDefaultAttributes() {
        this.fDefaultAttrs = new Attribute[4];
        XSTypeDefinition xSTypeDefinition = this.fXSModel.getTypeDefinition(NAME_QNAME, URI_XSD);
        TypeValidator typeValidator = this.fSTs.get(xSTypeDefinition);
        this.fDefaultAttrs[2] = new Attribute(URI_XSI, NAME_TYPE, typeValidator, null, false, null);
        xSTypeDefinition = this.fXSModel.getTypeDefinition(NAME_BOOLEAN, URI_XSD);
        typeValidator = this.fSTs.get(xSTypeDefinition);
        this.fDefaultAttrs[3] = new Attribute(URI_XSI, NAME_NIL, typeValidator, null, false, null);
        xSTypeDefinition = this.fXSModel.getTypeDefinition(NAME_ANYURI, URI_XSD);
        typeValidator = this.fSTs.get(xSTypeDefinition);
        this.fDefaultAttrs[0] = new Attribute(URI_XSI, NAME_NSL, typeValidator, null, false, null);
        typeValidator = this.fDVFactory.createListType(URI_XSI, NAME_SL, typeValidator, this.fTypeUtil);
        this.fDefaultAttrs[1] = new Attribute(URI_XSI, NAME_SL, typeValidator, null, false, null);
    }

    private void convertGlobalAttributes() {
        XSNamedMap xSNamedMap = this.fXSModel.getComponents((short)1);
        int n = xSNamedMap.getLength();
        for (int i = 0; i < n; ++i) {
            XSAttributeDeclaration xSAttributeDeclaration = (XSAttributeDeclaration)xSNamedMap.item(i);
            this.convertGAttr(xSAttributeDeclaration);
        }
    }

    private void convertGlobalElements() {
        XSNamedMap xSNamedMap = this.fXSModel.getComponents((short)2);
        int n = xSNamedMap.getLength();
        for (int i = 0; i < n; ++i) {
            XSElementDeclaration xSElementDeclaration = (XSElementDeclaration)xSNamedMap.item(i);
            if (this.fValidating && xSElementDeclaration.getAbstract()) continue;
            Element element = this.convertElem(xSElementDeclaration);
            this.fGElems.add(element);
        }
    }

    private void convertGlobalSimpleTypes() {
        XSNamedMap xSNamedMap = this.fXSModel.getComponents((short)3);
        int n = xSNamedMap.getLength();
        for (int i = 0; i < n; ++i) {
            XSTypeDefinition xSTypeDefinition = (XSTypeDefinition)xSNamedMap.item(i);
            if (!(xSTypeDefinition instanceof XSSimpleTypeDefinition)) continue;
            this.convertSType((XSSimpleTypeDefinition)xSTypeDefinition);
        }
    }

    private void convertGlobalTypes() {
        XSTypeDefinition xSTypeDefinition;
        int n = 0;
        while (n < this.fGlobalTypes.size()) {
            xSTypeDefinition = (XSTypeDefinition)this.fGlobalTypes.get(n);
            ElementType elementType = this.convertType(xSTypeDefinition);
            elementType.index = n++;
        }
        for (n = 0; n < this.fAbstractTypes.size(); ++n) {
            xSTypeDefinition = (XSTypeDefinition)this.fAbstractTypes.get(n);
            this.convertType(xSTypeDefinition);
        }
    }

    private void processPendingCMs() {
        for (int i = 0; i < this.fPendingCMs.size(); i += 2) {
            ElementType elementType = (ElementType)this.fPendingCMs.get(i);
            XSComplexTypeDefinition xSComplexTypeDefinition = (XSComplexTypeDefinition)this.fPendingCMs.get(i + 1);
            XSParticle xSParticle = xSComplexTypeDefinition.getParticle();
            if (xSParticle.getTerm() instanceof XSModelGroup && ((XSModelGroup)xSParticle.getTerm()).getCompositor() == 3) {
                this.convertAll(elementType, xSComplexTypeDefinition);
                continue;
            }
            this.convertDFA(elementType, xSComplexTypeDefinition);
            if (this.fValidating) continue;
            this.convertNVAll(elementType, xSComplexTypeDefinition);
        }
    }

    private void fillInTypeHeirarchy() {
        XSTypeDefinition xSTypeDefinition;
        NamedDeclaration namedDeclaration;
        XSTypeDefinition xSTypeDefinition2;
        Set set = this.fCMs.entrySet();
        for (Map.Entry entry : set) {
            xSTypeDefinition2 = (XSTypeDefinition)entry.getKey();
            namedDeclaration = (ElementType)entry.getValue();
            xSTypeDefinition = xSTypeDefinition2.getBaseType();
            namedDeclaration.baseType = xSTypeDefinition != null ? (ElementType)this.fCMs.get(xSTypeDefinition) : namedDeclaration;
        }
        set = this.fSimpleTypes.entrySet();
        for (Map.Entry entry : set) {
            xSTypeDefinition2 = (XSSimpleTypeDefinition)entry.getKey();
            namedDeclaration = (TypeValidator)entry.getValue();
            xSTypeDefinition = xSTypeDefinition2.getBaseType();
            TypeValidator typeValidator = xSTypeDefinition != null ? (TypeValidator)this.fSimpleTypes.get(xSTypeDefinition) : null;
            ((TypeValidator)namedDeclaration).baseType = typeValidator != null ? typeValidator : namedDeclaration;
            XSSimpleTypeDefinition xSSimpleTypeDefinition = (XSSimpleTypeDefinition)this.fBuiltInTypes.get(Converter.getInteger(xSTypeDefinition2.getBuiltInKind()));
            ((TypeValidator)namedDeclaration).builtInType = xSSimpleTypeDefinition != null ? (TypeValidator)this.fSimpleTypes.get(xSSimpleTypeDefinition) : null;
        }
    }

    private Grammar fillGrammar(Grammar grammar, String string, String string2) throws ConverterException {
        Object object;
        int n;
        XSNamedMap xSNamedMap;
        ElementType.DFAState dFAState = new ElementType.DFAState();
        grammar.root = dFAState;
        if (string2 != null) {
            xSNamedMap = this.fXSModel.getElementDeclaration(string, string2);
            if (xSNamedMap == null || xSNamedMap.getAbstract()) {
                throw new ConverterException("Can't find the specified root element, or it's abstract.");
            }
            dFAState.elements = new Element[]{(Element)this.fElems.get(xSNamedMap)};
            dFAState.elementTable = NamedDeclaration.createMap(dFAState.elements);
        } else {
            xSNamedMap = this.fXSModel.getComponents((short)2);
            n = xSNamedMap.getLength();
            for (int i = 0; i < n; ++i) {
                XSElementDeclaration xSElementDeclaration = (XSElementDeclaration)xSNamedMap.item(i);
                if (this.fValidating && xSElementDeclaration.getAbstract()) continue;
                this.fAllElems.add(this.fElems.get(xSElementDeclaration));
            }
            n = this.fAllElems.size();
            if (n > 0) {
                dFAState.elements = this.fAllElems.toArray(new Element[n]);
                dFAState.elementTable = NamedDeclaration.createMap(dFAState.elements);
            }
            this.fAllElems.clear();
            object = new Wildcard(1, true, null, null);
            dFAState.wc = new Wildcard[]{object};
        }
        int n2 = this.fGlobalTypes.size();
        grammar.globalTypes = new ElementType[n2];
        for (n = 0; n < n2; ++n) {
            grammar.globalTypes[((ElementType)object).index] = object = (ElementType)this.fCMs.get(this.fGlobalTypes.get(n));
        }
        grammar.globalTypesTable = NamedDeclaration.createMap(grammar.globalTypes);
        if (this.fValidating) {
            this.fIDCHandler.renumberXPathIds();
            new IDCMatcher(this).match(this.fElemIDCs);
            this.fillInIDCInstructions();
            List list = this.fIDCHandler.xpathDFAList();
            int n3 = this.fIDCHandler.idcCount();
            if (list != null && n3 > 0) {
                grammar.idcCount = n3;
                grammar.xpathDFAs = IDCInstructionBuilder.createXPathDFAs(list, this.fTypeUtil, n3);
            }
        }
        return grammar;
    }

    private void fillInIDCInstructions() {
        for (Map.Entry entry : this.fIDCBuilders.entrySet()) {
            Object k = entry.getKey();
            IDCInstructionBuilder iDCInstructionBuilder = (IDCInstructionBuilder)entry.getValue();
            if (k instanceof XSElementDeclaration) {
                this.fillInIDCInstructions(this.getElement((XSElementDeclaration)k), iDCInstructionBuilder);
                continue;
            }
            this.fillInIDCInstructions(this.getWildcard((XSWildcard)k), iDCInstructionBuilder);
        }
    }

    private void fillInIDCInstructions(Element element2, IDCInstructionBuilder iDCInstructionBuilder) {
        this.fillInIDCInstructions0(element2, iDCInstructionBuilder);
        HashSet hashSet = (HashSet)this.fElemCopies.get(element2);
        if (hashSet != null) {
            for (Element element2 : hashSet) {
                this.fillInIDCInstructions0(element2, iDCInstructionBuilder);
            }
        }
    }

    private void fillInIDCInstructions(Wildcard wildcard2, IDCInstructionBuilder iDCInstructionBuilder) {
        this.fillInIDCInstructions0(wildcard2, iDCInstructionBuilder);
        HashSet hashSet = (HashSet)this.fWCCopies.get(wildcard2);
        if (hashSet != null) {
            for (Wildcard wildcard2 : hashSet) {
                this.fillInIDCInstructions0(wildcard2, iDCInstructionBuilder);
            }
        }
    }

    private void fillInIDCInstructions0(Element element, IDCInstructionBuilder iDCInstructionBuilder) {
        EndIDC endIDC;
        StartIDC startIDC;
        if (iDCInstructionBuilder.hasActions(false)) {
            startIDC = iDCInstructionBuilder.createStartIDCInstruction(this.fTypeUtil, false);
            if (element.startIDC == null) {
                element.startIDC = new ArrayList();
            }
            element.startIDC.add(startIDC);
            endIDC = iDCInstructionBuilder.createEndIDCInstruction();
            if (element.endIDC == null) {
                element.endIDC = new ArrayList();
            }
            element.endIDC.add(endIDC);
        }
        if (iDCInstructionBuilder.hasActions(true)) {
            startIDC = iDCInstructionBuilder.createStartIDCInstruction(this.fTypeUtil, true);
            if (element.startIDCNil == null) {
                element.startIDCNil = new ArrayList();
            }
            element.startIDCNil.add(startIDC);
            endIDC = iDCInstructionBuilder.createEndIDCInstruction();
            if (element.endIDCNil == null) {
                element.endIDCNil = new ArrayList();
            }
            element.endIDCNil.add(endIDC);
        }
    }

    private void fillInIDCInstructions0(Wildcard wildcard, IDCInstructionBuilder iDCInstructionBuilder) {
        StartIDC startIDC = iDCInstructionBuilder.createStartIDCInstruction(this.fTypeUtil, false);
        if (wildcard.startIDC == null) {
            wildcard.startIDC = new ArrayList();
        }
        wildcard.startIDC.add(startIDC);
        EndIDC endIDC = iDCInstructionBuilder.createEndIDCInstruction();
        if (wildcard.endIDC == null) {
            wildcard.endIDC = new ArrayList();
        }
        wildcard.endIDC.add(endIDC);
    }

    private Wildcard convertWC(XSWildcard xSWildcard, XSComplexTypeDefinition xSComplexTypeDefinition) {
        return this.convertWC(xSWildcard, xSWildcard.getProcessContents());
    }

    private Attribute convertGAttr(XSAttributeDeclaration xSAttributeDeclaration) {
        Attribute attribute = this.convertLAttr(xSAttributeDeclaration);
        this.fAtts.put(xSAttributeDeclaration, attribute);
        return attribute;
    }

    private Attribute convertLAttr(XSAttributeDeclaration xSAttributeDeclaration) {
        String string = xSAttributeDeclaration.getNamespace();
        String string2 = xSAttributeDeclaration.getName();
        string = string != null ? this.fTypeUtil.internString(string) : "";
        string2 = string2 != null ? this.fTypeUtil.internString(string2) : "";
        XSSimpleTypeDefinition xSSimpleTypeDefinition = xSAttributeDeclaration.getTypeDefinition();
        TypeValidator typeValidator = this.convertSType(xSSimpleTypeDefinition);
        short s = xSAttributeDeclaration.getConstraintType();
        boolean bl = s != 0;
        boolean bl2 = s == 2;
        Object object = bl ? xSAttributeDeclaration.getActualVC() : null;
        String string3 = bl ? xSAttributeDeclaration.getConstraintValue() : null;
        ValidatedInfo validatedInfo = bl ? this.getActualValue(xSSimpleTypeDefinition, object, string3, xSAttributeDeclaration.getActualVCType(), xSAttributeDeclaration.getItemValueTypes()) : null;
        Attribute attribute = new Attribute(string, string2, typeValidator, validatedInfo, bl2, xSAttributeDeclaration);
        return attribute;
    }

    private Attribute convertAttrUse(XSAttributeUse xSAttributeUse) {
        ValidatedInfo validatedInfo;
        Attribute attribute = (Attribute)this.fUses.get(xSAttributeUse);
        if (attribute != null) {
            return attribute;
        }
        XSAttributeDeclaration xSAttributeDeclaration = xSAttributeUse.getAttrDeclaration();
        XSSimpleTypeDefinition xSSimpleTypeDefinition = xSAttributeDeclaration.getTypeDefinition();
        short s = xSAttributeUse.getConstraintType();
        boolean bl = s != 0;
        boolean bl2 = s == 2;
        Object object = bl ? xSAttributeUse.getActualVC() : null;
        String string = bl ? xSAttributeUse.getConstraintValue() : null;
        ValidatedInfo validatedInfo2 = validatedInfo = bl ? this.getActualValue(xSSimpleTypeDefinition, object, string, xSAttributeUse.getActualVCType(), xSAttributeUse.getItemValueTypes()) : null;
        if (xSAttributeDeclaration.getScope() == 1) {
            Attribute attribute2 = (Attribute)this.fAtts.get(xSAttributeDeclaration);
            attribute = bl ? this.cloneAttribute(attribute2, validatedInfo, bl2) : attribute2;
        } else {
            String string2 = xSAttributeDeclaration.getNamespace();
            String string3 = xSAttributeDeclaration.getName();
            string2 = string2 != null ? this.fTypeUtil.internString(string2) : "";
            string3 = string3 != null ? this.fTypeUtil.internString(string3) : "";
            TypeValidator typeValidator = this.convertSType(xSSimpleTypeDefinition);
            if (!bl) {
                s = xSAttributeDeclaration.getConstraintType();
                bl = s != 0;
                bl2 = s == 2;
                object = bl ? xSAttributeDeclaration.getActualVC() : null;
                string = bl ? xSAttributeDeclaration.getConstraintValue() : null;
                validatedInfo = bl ? this.getActualValue(xSSimpleTypeDefinition, object, string, xSAttributeDeclaration.getActualVCType(), xSAttributeDeclaration.getItemValueTypes()) : null;
            }
            attribute = new Attribute(string2, string3, typeValidator, validatedInfo, bl2, xSAttributeDeclaration);
        }
        this.fUses.put(xSAttributeUse, attribute);
        return attribute;
    }

    private Element convertElem(XSElementDeclaration xSElementDeclaration) {
        Object object;
        if (this.fValidating && xSElementDeclaration.getAbstract()) {
            throw new RuntimeException("panic");
        }
        Element element = (Element)this.fElems.get(xSElementDeclaration);
        if (element != null) {
            return element;
        }
        String string = xSElementDeclaration.getNamespace();
        String string2 = xSElementDeclaration.getName();
        string = string != null ? this.fTypeUtil.internString(string) : "";
        string2 = string2 != null ? this.fTypeUtil.internString(string2) : "";
        short s = xSElementDeclaration.getDisallowedSubstitutions();
        boolean bl = xSElementDeclaration.getNillable();
        short s2 = xSElementDeclaration.getConstraintType();
        boolean bl2 = s2 != 0;
        boolean bl3 = s2 == 2;
        XSTypeDefinition xSTypeDefinition = xSElementDeclaration.getTypeDefinition();
        Object object2 = bl2 ? xSElementDeclaration.getActualVC() : null;
        String string3 = bl2 ? xSElementDeclaration.getConstraintValue() : null;
        ValidatedInfo validatedInfo = null;
        if (bl2) {
            object = xSTypeDefinition instanceof XSSimpleTypeDefinition ? (XSSimpleTypeDefinition)xSTypeDefinition : ((XSComplexTypeDefinition)xSTypeDefinition).getSimpleType();
            validatedInfo = this.getActualValue((XSSimpleTypeDefinition)object, object2, string3, xSElementDeclaration.getActualVCType(), xSElementDeclaration.getItemValueTypes());
        }
        object = (BitSet)this.fDerivedTypes.get(xSTypeDefinition);
        BitSet bitSet = null;
        if (object != null) {
            int n = this.moreBlock(s, xSTypeDefinition);
            if (n != 0) {
                object = this.removeBlocked((BitSet)object, n, xSTypeDefinition);
            }
            if (bl2) {
                bitSet = this.removeBadVCs((BitSet)object, object2, string3);
            }
        }
        element = new Element(string, string2, null, validatedInfo, bl3, (BitSet)object, bitSet, bl, xSElementDeclaration);
        XSNamedMap xSNamedMap = xSElementDeclaration.getIdentityConstraints();
        for (int i = 0; i < xSNamedMap.getLength(); ++i) {
            XSIDCDefinition xSIDCDefinition = (XSIDCDefinition)xSNamedMap.item(i);
            ArrayList<IDCSymbol> arrayList = (ArrayList<IDCSymbol>)this.fElemIDCs.get(xSElementDeclaration);
            if (arrayList == null) {
                arrayList = new ArrayList<IDCSymbol>();
                this.fElemIDCs.put(xSElementDeclaration, arrayList);
            }
            arrayList.add(this.fIDCHandler.findOrCreate(xSIDCDefinition));
        }
        this.fElems.put(xSElementDeclaration, element);
        element.type = this.convertType(xSTypeDefinition);
        return element;
    }

    private int moreBlock(int n, XSTypeDefinition xSTypeDefinition) {
        int n2 = xSTypeDefinition instanceof XSComplexTypeDefinition ? ((XSComplexTypeDefinition)xSTypeDefinition).getProhibitedSubstitutions() : 0;
        int n3 = 3;
        return (n &= n3) & ~(n2 &= n3);
    }

    private BitSet removeBlocked(BitSet bitSet, int n, XSTypeDefinition xSTypeDefinition) {
        BitSet bitSet2 = null;
        boolean bl = false;
        int n2 = bitSet.getLength();
        for (int i = 0; i < n2; ++i) {
            if (!bitSet.getBit(i)) continue;
            boolean bl2 = true;
            for (XSTypeDefinition xSTypeDefinition2 = (XSTypeDefinition)this.fGlobalTypes.get(i); xSTypeDefinition2 != xSTypeDefinition && xSTypeDefinition2 != null && bl2; xSTypeDefinition2 = xSTypeDefinition2.getBaseType()) {
                if (xSTypeDefinition2 instanceof XSSimpleTypeDefinition) {
                    if ((n & 2) == 0) continue;
                    bl2 = false;
                    continue;
                }
                short s = ((XSComplexTypeDefinition)xSTypeDefinition2).getDerivationMethod();
                if ((n & s) == 0) continue;
                bl2 = false;
            }
            if (bl2) {
                if (bitSet2 == null) {
                    bitSet2 = new BitSet(n2);
                }
                bitSet2.setBit(i);
                continue;
            }
            bl = true;
        }
        return bl ? bitSet2 : bitSet;
    }

    private BitSet removeBadVCs(BitSet bitSet, Object object, String string) {
        BitSet bitSet2 = null;
        boolean bl = false;
        int n = bitSet.getLength();
        for (int i = 0; i < n; ++i) {
            if (!bitSet.getBit(i)) continue;
            XSTypeDefinition xSTypeDefinition = (XSTypeDefinition)this.fGlobalTypes.get(i);
            XSSimpleTypeDecl xSSimpleTypeDecl = null;
            xSSimpleTypeDecl = xSTypeDefinition instanceof XSSimpleTypeDecl ? (XSSimpleTypeDecl)xSTypeDefinition : (XSSimpleTypeDecl)((XSComplexTypeDefinition)xSTypeDefinition).getSimpleType();
            boolean bl2 = true;
            try {
                if (xSSimpleTypeDecl != null) {
                    xSSimpleTypeDecl.validate(object, null, null);
                }
            }
            catch (Exception exception) {
                bl2 = false;
            }
            if (bl2) {
                if (bitSet2 == null) {
                    bitSet2 = new BitSet(n);
                }
                bitSet2.setBit(i);
                continue;
            }
            bl = true;
        }
        return bl ? bitSet2 : bitSet;
    }

    private ElementType convertType(XSTypeDefinition xSTypeDefinition) {
        int n;
        int n2;
        Attribute[] attributeArray;
        ElementType elementType = (ElementType)this.fCMs.get(xSTypeDefinition);
        if (elementType != null) {
            return elementType;
        }
        String string = xSTypeDefinition.getNamespace();
        String string2 = xSTypeDefinition.getName();
        string = string != null ? this.fTypeUtil.internString(string) : "";
        String string3 = string2 = string2 != null ? this.fTypeUtil.internString(string2) : "";
        if (xSTypeDefinition instanceof XSSimpleTypeDefinition) {
            XSSimpleTypeDefinition xSSimpleTypeDefinition = (XSSimpleTypeDefinition)xSTypeDefinition;
            TypeValidator typeValidator = this.convertSType(xSSimpleTypeDefinition);
            boolean bl = this.allowEmpty(xSSimpleTypeDefinition);
            elementType = new ElementType(string, string2, -1, this.fCMs.size(), this.fDefaultAttrs, null, null, null, null, 0, null, 0, typeValidator, null, null, bl, null, false, xSTypeDefinition);
            this.fCMs.put(xSTypeDefinition, elementType);
            return elementType;
        }
        XSComplexTypeDefinition xSComplexTypeDefinition = (XSComplexTypeDefinition)xSTypeDefinition;
        XSWildcard xSWildcard = xSComplexTypeDefinition.getAttributeWildcard();
        Wildcard wildcard = null;
        if (xSWildcard != null && xSWildcard.getProcessContents() != 1) {
            wildcard = this.convertWC(xSWildcard, 2);
        }
        XSObjectList xSObjectList = xSComplexTypeDefinition.getAttributeUses();
        int n3 = xSObjectList.getLength();
        ArrayList arrayList = this.getWCDecls(xSWildcard, true);
        int n4 = arrayList.size();
        BitSet bitSet = null;
        int[] nArray = null;
        BitSet bitSet2 = null;
        int[] nArray2 = null;
        int n5 = -1;
        int n6 = n3 + n4 + 4;
        BitSet bitSet3 = null;
        if (n3 + n4 > 0) {
            int[] nArray3;
            XSAttributeUse xSAttributeUse;
            attributeArray = new Attribute[n6];
            System.arraycopy(this.fDefaultAttrs, 0, attributeArray, 0, 4);
            int[] nArray4 = null;
            n2 = 0;
            n = 4;
            int n7 = 0;
            while (n7 < n3) {
                xSAttributeUse = (XSAttributeUse)xSObjectList.item(n7);
                attributeArray[n] = this.convertAttrUse(xSAttributeUse);
                if (xSAttributeUse.getConstraintType() != 0 || xSAttributeUse.getAttrDeclaration().getConstraintType() != 0) {
                    if (bitSet == null) {
                        bitSet = new BitSet(n6);
                    }
                    bitSet.setBit(n);
                    if (nArray4 == null || nArray4.length == n2) {
                        nArray3 = new int[n2 + 10];
                        if (nArray4 != null) {
                            System.arraycopy(nArray4, 0, nArray3, 0, n2);
                        }
                        nArray4 = nArray3;
                    }
                    nArray4[n2++] = n;
                }
                if (xSAttributeUse.getRequired()) {
                    if (bitSet3 == null) {
                        bitSet3 = new BitSet(n6);
                    }
                    bitSet3.setBit(n);
                }
                if (this.isID((XSTypeDefinition)xSAttributeUse.getAttrDeclaration().getTypeDefinition())) {
                    n5 = n;
                }
                ++n7;
                ++n;
            }
            n6 = n2;
            if (n6 > 0) {
                nArray = new int[n6];
                System.arraycopy(nArray4, 0, nArray, 0, n6);
                n2 = 0;
            }
            n7 = 0;
            while (n7 < n4) {
                xSAttributeUse = (XSAttributeDeclaration)arrayList.get(n7);
                attributeArray[n] = this.convertLAttr((XSAttributeDeclaration)xSAttributeUse);
                if (this.isID((XSTypeDefinition)xSAttributeUse.getTypeDefinition())) {
                    if (bitSet2 == null) {
                        bitSet2 = new BitSet(n6);
                    }
                    bitSet2.setBit(n);
                    if (nArray4 == null || nArray4.length == n2) {
                        nArray3 = new int[n2 + 10];
                        if (nArray4 != null) {
                            System.arraycopy(nArray4, 0, nArray3, 0, n2);
                        }
                        nArray4 = nArray3;
                    }
                    nArray4[n2++] = n;
                }
                ++n7;
                ++n;
            }
            n6 = n2;
            if (n6 > 0) {
                nArray2 = new int[n6];
                System.arraycopy(nArray4, 0, nArray2, 0, n6);
            }
        } else {
            attributeArray = this.fDefaultAttrs;
        }
        short s = xSComplexTypeDefinition.getContentType();
        if (s == 1) {
            TypeValidator typeValidator = this.convertSType(xSComplexTypeDefinition.getSimpleType());
            n = this.allowEmpty(xSComplexTypeDefinition.getSimpleType()) ? 1 : 0;
            elementType = new ElementType(string, string2, -1, this.fCMs.size(), attributeArray, bitSet, nArray, bitSet2, nArray2, n5, wildcard, 3, typeValidator, null, null, n != 0, bitSet3, xSComplexTypeDefinition.getAbstract(), xSTypeDefinition);
            this.fCMs.put(xSTypeDefinition, elementType);
            return elementType;
        }
        n2 = s == 2 ? 2 : (s == 0 ? 0 : 3);
        elementType = new ElementType(string, string2, -1, this.fCMs.size(), attributeArray, bitSet, nArray, bitSet2, nArray2, n5, wildcard, n2, null, null, null, true, bitSet3, xSComplexTypeDefinition.getAbstract(), xSTypeDefinition);
        this.fCMs.put(xSTypeDefinition, elementType);
        XSParticle xSParticle = xSComplexTypeDefinition.getParticle();
        if (xSParticle != null) {
            this.convertParticle(xSParticle);
            this.fPendingCMs.add(elementType);
            this.fPendingCMs.add(xSTypeDefinition);
        }
        return elementType;
    }

    private ArrayList getWCDecls(XSWildcard xSWildcard, boolean bl) {
        if (xSWildcard == null || xSWildcard.getProcessContents() == 2) {
            return EMPTY_VECTOR;
        }
        ArrayList<XSObject> arrayList = (ArrayList<XSObject>)this.fWCDecls.get(xSWildcard);
        if (arrayList != null) {
            return arrayList;
        }
        XSNamedMap xSNamedMap = bl ? this.fXSModel.getComponents((short)1) : this.fXSModel.getComponents((short)2);
        int n = xSNamedMap.getLength();
        for (int i = 0; i < n; ++i) {
            XSObject xSObject = xSNamedMap.item(i);
            if (!Converter.wildcardAllows(xSWildcard, xSObject.getNamespace(), xSObject.getName()) || !bl && ((XSElementDeclaration)xSObject).getAbstract()) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<XSObject>();
            }
            arrayList.add(xSObject);
        }
        if (arrayList == null) {
            arrayList = EMPTY_VECTOR;
        }
        this.fWCDecls.put(xSWildcard, arrayList);
        return arrayList;
    }

    static boolean wildcardAllows(XSWildcard xSWildcard, String string, String string2) {
        short s = xSWildcard.getConstraintType();
        if (s == 1) {
            return true;
        }
        StringList stringList = xSWildcard.getNsConstraintList();
        if (stringList.contains(string)) {
            return s == 3;
        }
        return s == 2;
    }

    private void convertParticle(XSParticle xSParticle) {
        if (this.fSeen.get(xSParticle) != null) {
            return;
        }
        this.fSeen.put(xSParticle, xSParticle);
        XSTerm xSTerm = xSParticle.getTerm();
        if (this.fSeen.get(xSTerm) != null) {
            return;
        }
        this.fSeen.put(xSTerm, xSTerm);
        if (xSTerm.getType() == 2) {
            if (!((XSElementDeclaration)xSTerm).getAbstract()) {
                this.convertElem((XSElementDeclaration)xSTerm);
            }
        } else if (xSTerm.getType() == 9) {
            XSWildcard xSWildcard = (XSWildcard)xSTerm;
            this.convertWC(xSWildcard, xSWildcard.getProcessContents());
        } else {
            XSModelGroup xSModelGroup = (XSModelGroup)xSTerm;
            XSObjectList xSObjectList = xSModelGroup.getParticles();
            for (int i = 0; i < xSObjectList.getLength(); ++i) {
                this.convertParticle((XSParticle)xSObjectList.item(i));
            }
        }
    }

    private TypeValidator convertSType(XSSimpleTypeDefinition xSSimpleTypeDefinition) {
        TypeValidator typeValidator = (TypeValidator)this.fSimpleTypes.get(xSSimpleTypeDefinition);
        if (typeValidator != null) {
            return typeValidator;
        }
        String string = xSSimpleTypeDefinition.getNamespace();
        String string2 = xSSimpleTypeDefinition.getName();
        string = string != null ? this.fTypeUtil.internString(string) : "";
        string2 = string2 != null ? this.fTypeUtil.internString(string2) : "";
        typeValidator = this.fDVFactory.createSimpleType(string, string2, xSSimpleTypeDefinition, this.fSTs, this.fTypeUtil);
        typeValidator.xsTypeDefinition = xSSimpleTypeDefinition;
        this.fSimpleTypes.put(xSSimpleTypeDefinition, typeValidator);
        return typeValidator;
    }

    private boolean isID(XSTypeDefinition xSTypeDefinition) {
        int n = 27;
        return xSTypeDefinition.derivedFrom(URI_XSD, NAME_ID, (short)n);
    }

    private Attribute cloneAttribute(Attribute attribute, ValidatedInfo validatedInfo, boolean bl) {
        return new Attribute(attribute.nsURI, attribute.localName, attribute.type, validatedInfo, bl, attribute.xsAttributeDeclaration);
    }

    private Wildcard convertWC(XSWildcard xSWildcard, int n) {
        Wildcard wildcard = (Wildcard)this.fWCs.get(xSWildcard);
        if (wildcard != null) {
            return wildcard;
        }
        short s = xSWildcard.getConstraintType();
        boolean bl = s != 3;
        String[] stringArray = null;
        if (s != 1) {
            StringList stringList = xSWildcard.getNsConstraintList();
            int n2 = stringList.getLength();
            stringArray = new String[n2];
            for (int i = 0; i < n2; ++i) {
                String string = stringList.item(i);
                stringArray[i] = string = string != null ? this.fTypeUtil.internString(string) : "";
            }
        }
        wildcard = new Wildcard(n, bl, stringArray, xSWildcard);
        this.fWCs.put(xSWildcard, wildcard);
        return wildcard;
    }

    private ValidatedInfo getActualValue(XSSimpleTypeDefinition xSSimpleTypeDefinition, Object object, String string, short s, ShortList shortList) {
        if (xSSimpleTypeDefinition == null) {
            xSSimpleTypeDefinition = (XSSimpleTypeDefinition)this.fXSModel.getTypeDefinition(NAME_STRING, URI_XSD);
        }
        TypeValidator typeValidator = this.convertSType(xSSimpleTypeDefinition);
        ValueInfo valueInfo = new ValueInfo(string, object, s, shortList);
        return this.fDVFactory.getActualValue(typeValidator, valueInfo, this.fTypeUtil);
    }

    private boolean allowEmpty(XSSimpleTypeDefinition xSSimpleTypeDefinition) {
        try {
            ((XSSimpleTypeDecl)xSSimpleTypeDefinition).validate("", null, null);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private void convertAll(ElementType elementType, XSComplexTypeDefinition xSComplexTypeDefinition) {
        Object object;
        XSParticle xSParticle = xSComplexTypeDefinition.getParticle();
        XSObjectList xSObjectList = ((XSModelGroup)xSParticle.getTerm()).getParticles();
        int n = xSObjectList.getLength();
        boolean bl = false;
        BitSet bitSet = new BitSet(n);
        for (int i = 0; i < n; ++i) {
            object = (XSParticle)xSObjectList.item(i);
            XSElementDeclaration xSElementDeclaration = (XSElementDeclaration)object.getTerm();
            if (object.getMinOccurs() != 0) {
                bitSet.setBit(i);
                bl = true;
            }
            if (!xSElementDeclaration.getAbstract()) {
                this.fAllElems.add(this.convertElem(xSElementDeclaration));
                this.fAllOpts.add(Converter.getInteger(i));
            }
            if (xSElementDeclaration.getScope() != 1) continue;
            XSObjectList xSObjectList2 = this.fXSModel.getSubstitutionGroup(xSElementDeclaration);
            for (int j = 0; j < xSObjectList2.getLength(); ++j) {
                if (((XSElementDeclaration)xSObjectList2.item(j)).getAbstract()) continue;
                this.fAllElems.add(this.convertElem((XSElementDeclaration)xSObjectList2.item(j)));
                this.fAllOpts.add(Converter.getInteger(i));
            }
        }
        n = this.fAllElems.size();
        Element[] elementArray = new Element[n];
        object = new int[n];
        for (int i = 0; i < n; ++i) {
            elementArray[i] = (Element)this.fAllElems.get(i);
            object[i] = (XSParticle)((Integer)this.fAllOpts.get(i));
        }
        elementType.allowEmpty = !bl || xSParticle.getMinOccurs() == 0;
        elementType.all = new ElementType.AllContent(elementArray, (int[])object, bitSet);
        this.fAllElems.clear();
        this.fAllOpts.clear();
    }

    private void convertNVAll(ElementType elementType, XSComplexTypeDefinition xSComplexTypeDefinition) {
        XSParticle xSParticle = xSComplexTypeDefinition.getParticle();
        HashMap hashMap = new HashMap();
        this.gatherLeaves(xSParticle, xSComplexTypeDefinition, hashMap, this.fAllElems);
        int n = hashMap.size();
        Element[] elementArray = new Element[n];
        Iterator iterator = hashMap.values().iterator();
        for (int i = 0; i < n; ++i) {
            elementArray[i] = (Element)iterator.next();
        }
        elementType.all = new ElementType.AllContent(elementArray);
        if (this.fAllElems.size() > 0) {
            elementType.all.wc = this.fAllElems.toArray(new Wildcard[this.fAllElems.size()]);
        }
        this.fAllElems.clear();
    }

    private void gatherLeaves(XSParticle xSParticle, XSComplexTypeDefinition xSComplexTypeDefinition, HashMap hashMap, ArrayList arrayList) {
        XSTerm xSTerm = xSParticle.getTerm();
        if (xSTerm.getType() == 2) {
            XSElementDeclaration xSElementDeclaration = (XSElementDeclaration)xSTerm;
            XSObjectList xSObjectList = null;
            int n = 0;
            if (xSElementDeclaration.getScope() == 1) {
                xSObjectList = this.getSubstitutionGroup(xSElementDeclaration);
                n = xSObjectList.getLength();
            }
            String string = xSElementDeclaration.getName();
            if (xSElementDeclaration.getNamespace() != null) {
                string = string + "," + xSElementDeclaration.getNamespace();
            }
            if (hashMap.get(string) == null) {
                hashMap.put(string, this.convertElem(xSElementDeclaration));
            }
            for (int i = 0; i < n; ++i) {
                XSElementDeclaration xSElementDeclaration2 = (XSElementDeclaration)xSObjectList.item(i);
                string = xSElementDeclaration2.getName();
                if (xSElementDeclaration2.getNamespace() != null) {
                    string = string + "," + xSElementDeclaration2.getNamespace();
                }
                if (hashMap.get(string) != null) continue;
                hashMap.put(string, this.convertElem(xSElementDeclaration2));
            }
            return;
        }
        if (xSTerm.getType() == 9) {
            XSWildcard xSWildcard = (XSWildcard)xSTerm;
            arrayList.add(this.convertWC(xSWildcard, xSComplexTypeDefinition));
            ArrayList arrayList2 = this.getWCDecls(xSWildcard, false);
            int n = arrayList2.size();
            for (int i = 0; i < n; ++i) {
                XSElementDeclaration xSElementDeclaration = (XSElementDeclaration)arrayList2.get(i);
                String string = xSElementDeclaration.getName();
                if (xSElementDeclaration.getNamespace() != null) {
                    string = string + "," + xSElementDeclaration.getNamespace();
                }
                if (hashMap.get(string) != null) continue;
                hashMap.put(string, this.convertElem(xSElementDeclaration));
            }
            return;
        }
        XSModelGroup xSModelGroup = (XSModelGroup)xSTerm;
        XSObjectList xSObjectList = xSModelGroup.getParticles();
        int n = xSObjectList.getLength();
        for (int i = 0; i < n; ++i) {
            this.gatherLeaves((XSParticle)xSObjectList.item(i), xSComplexTypeDefinition, hashMap, arrayList);
        }
    }

    private void convertDFA(ElementType elementType, XSComplexTypeDefinition xSComplexTypeDefinition) {
        XSParticle xSParticle = xSComplexTypeDefinition.getParticle();
        this.fCount = 0;
        Node node = this.buildTree(xSParticle, xSComplexTypeDefinition);
        Node node2 = this.fNodes.leaf(1, null, this.fCount++);
        node = node == null ? node2 : this.fNodes.group(true, 1, new Node[]{node, node2});
        this.fillDFA(elementType, node);
        this.fNodes.returnNodes(node);
    }

    private Node buildTree(XSParticle xSParticle, XSComplexTypeDefinition xSComplexTypeDefinition) {
        int n = xSParticle.getMaxOccursUnbounded() ? -1 : xSParticle.getMaxOccurs();
        int n2 = xSParticle.getMinOccurs();
        XSTerm xSTerm = xSParticle.getTerm();
        if (xSTerm.getType() == 2) {
            XSElementDeclaration xSElementDeclaration = (XSElementDeclaration)xSTerm;
            XSObjectList xSObjectList = null;
            int n3 = xSElementDeclaration.getAbstract() ? 0 : 1;
            int n4 = 0;
            if (xSElementDeclaration.getScope() == 1) {
                xSObjectList = this.fXSModel.getSubstitutionGroup(xSElementDeclaration);
                n4 = xSObjectList.getLength();
                for (int i = 0; i < n4; ++i) {
                    if (((XSElementDeclaration)xSObjectList.item(i)).getAbstract()) continue;
                    ++n3;
                }
            }
            if (n3 == 0) {
                return null;
            }
            Node[] nodeArray = n3 > 1 ? new Node[n3] : null;
            Node node = null;
            if (!xSElementDeclaration.getAbstract()) {
                Element element = this.convertElem(xSElementDeclaration);
                node = this.fNodes.leaf(1, element, this.fCount++);
                if (n3 == 1) {
                    return this.expandNode(node, n2, n);
                }
                nodeArray[n3 - 1] = node;
            }
            int n5 = 0;
            for (int i = 0; i < n4; ++i) {
                if (((XSElementDeclaration)xSObjectList.item(i)).getAbstract()) continue;
                Element element = this.convertElem((XSElementDeclaration)xSObjectList.item(i));
                node = this.fNodes.leaf(1, element, this.fCount++);
                if (n3 == 1) {
                    return this.expandNode(node, n2, n);
                }
                nodeArray[n5++] = node;
            }
            node = this.fNodes.group(false, 1, nodeArray);
            return this.expandNode(node, n2, n);
        }
        if (xSTerm.getType() == 9) {
            XSWildcard xSWildcard = (XSWildcard)xSTerm;
            Object object = this.convertWC(xSWildcard, xSComplexTypeDefinition);
            Node node = this.fNodes.leaf(1, object, this.fCount++);
            ArrayList arrayList = this.getWCDecls(xSWildcard, false);
            int n6 = arrayList.size();
            if (n6 == 0) {
                return this.expandNode(node, n2, n);
            }
            Node[] nodeArray = new Node[n6 + 1];
            nodeArray[n6] = node;
            for (int i = 0; i < n6; ++i) {
                object = this.convertElem((XSElementDeclaration)arrayList.get(i));
                nodeArray[i] = this.fNodes.leaf(1, object, this.fCount++);
            }
            node = this.fNodes.group(false, 1, nodeArray);
            return this.expandNode(node, n2, n);
        }
        XSModelGroup xSModelGroup = (XSModelGroup)xSTerm;
        boolean bl = xSModelGroup.getCompositor() == 1;
        XSObjectList xSObjectList = xSModelGroup.getParticles();
        int n7 = xSObjectList.getLength();
        if (n7 == 0) {
            return null;
        }
        Node[] nodeArray = new Node[n7];
        int n8 = 0;
        for (int i = 0; i < n7; ++i) {
            Node node = this.buildTree((XSParticle)xSObjectList.item(i), xSComplexTypeDefinition);
            if (node == null) continue;
            nodeArray[n8++] = node;
        }
        if (n8 == 0) {
            return null;
        }
        if (n8 < n7) {
            Node[] nodeArray2 = new Node[n8];
            System.arraycopy(nodeArray, 0, nodeArray2, 0, n8);
            nodeArray = nodeArray2;
        }
        Node node = this.fNodes.group(bl, 1, nodeArray);
        if (xSModelGroup.getCompositor() == 2 && n8 == 1 && n7 > 1) {
            node.occurrence = 0;
            node = this.fNodes.group(true, 1, new Node[]{node});
        }
        return this.expandNode(node, n2, n);
    }

    private Node expandNode(Node node, int n, int n2) {
        if (n == 0 && n2 == -1) {
            node.occurrence = 2;
            return node;
        }
        if (n2 == -1) {
            node.occurrence = 3;
            if (n == 1) {
                return node;
            }
            Node[] nodeArray = new Node[n];
            nodeArray[n - 1] = node;
            this.copyNode(node, 1, nodeArray, 0, n - 1, true);
            return this.fNodes.group(true, 1, nodeArray);
        }
        Node[] nodeArray = new Node[n2];
        if (n > 0) {
            this.copyNode(node, 1, nodeArray, 0, n, false);
        }
        if (n2 > n) {
            this.copyNode(node, 0, nodeArray, n, n2, n != 0);
        }
        return this.fNodes.group(true, 1, nodeArray);
    }

    private void copyNode(Node node, int n, Node[] nodeArray, int n2, int n3, boolean bl) {
        if (!bl) {
            node.occurrence = n;
            nodeArray[n2++] = node;
        }
        while (n2 < n3) {
            nodeArray[n2] = this.copyNode(node);
            nodeArray[n2].occurrence = n;
            ++n2;
        }
    }

    private Node copyNode(Node node) {
        if (node.type == 0) {
            return this.fNodes.leaf(node.occurrence, node.leaf, this.fCount++);
        }
        int n = node.children.length;
        Node[] nodeArray = new Node[n];
        for (int i = 0; i < n; ++i) {
            nodeArray[i] = this.copyNode(node.children[i]);
        }
        return this.fNodes.group(node.type == 1, node.occurrence, nodeArray);
    }

    private void fillDFA(ElementType elementType, Node node) {
        Object object;
        Object object2;
        Object object3;
        int n;
        Object[] objectArray = new Node[this.fCount];
        this.collectLeaves(node, objectArray);
        BitSet[] bitSetArray = new BitSet[this.fCount];
        for (int i = 0; i < this.fCount; ++i) {
            bitSetArray[i] = new BitSet(this.fCount);
        }
        this.calcFollowList(node, bitSetArray, true);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (n = 0; n < this.fCount - 1; ++n) {
            object3 = ((Node)objectArray[n]).leaf;
            if (arrayList.contains(object3)) continue;
            arrayList.add(object3);
        }
        n = arrayList.size();
        object3 = new int[this.fCount + n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            object2 = arrayList.get(i);
            for (int j = 0; j < this.fCount; ++j) {
                if (object2 != ((Node)objectArray[j]).leaf) continue;
                object3[n2++] = j;
            }
            object3[n2++] = -1;
        }
        ArrayList<BitSet> arrayList2 = new ArrayList<BitSet>();
        object2 = new ArrayList();
        arrayList2.add(node.firstPos(this.fCount));
        ((ArrayList)object2).add((int[])Converter.makeDefStateList(n));
        HashMap<BitSet, Integer> hashMap = new HashMap<BitSet, Integer>();
        hashMap.put(node.firstPos(this.fCount), Converter.getInteger(0));
        for (int i = 0; i < arrayList2.size(); ++i) {
            object = (BitSet)arrayList2.get(i);
            int[] nArray = (int[])((ArrayList)object2).get(i);
            BitSet bitSet = null;
            int n3 = 0;
            for (int j = 0; j < n; ++j) {
                if (bitSet == null) {
                    bitSet = new BitSet(this.fCount);
                } else {
                    bitSet.clearAll();
                }
                Object object4 = object3[n3++];
                while (object4 != -1) {
                    if (((BitSet)object).getBit((int)object4)) {
                        bitSet.setBits(bitSetArray[object4]);
                    }
                    object4 = object3[n3++];
                }
                if (bitSet.isZero()) continue;
                Integer n4 = (Integer)hashMap.get(bitSet);
                int n5 = arrayList2.size();
                if (n4 == null) {
                    arrayList2.add(bitSet);
                    ((ArrayList)object2).add(Converter.makeDefStateList(n));
                    hashMap.put(bitSet, Converter.getInteger(n5));
                    bitSet = null;
                } else {
                    n5 = n4;
                }
                nArray[j] = n5;
            }
        }
        ElementType.DFAState[] dFAStateArray = new ElementType.DFAState[arrayList2.size()];
        for (int i = 0; i < arrayList2.size(); ++i) {
            object = this.buildState((int[])((ArrayList)object2).get(i), arrayList, ((BitSet)arrayList2.get(i)).getBit(this.fCount - 1));
            dFAStateArray[i] = ((ElementType.DFAState)object).elements == null && ((ElementType.DFAState)object).wc == null ? null : object;
        }
        if (dFAStateArray.length == 1 && dFAStateArray[0] == null) {
            elementType.allowEmpty = true;
            return;
        }
        elementType.allowEmpty = dFAStateArray[0].isFinal;
        elementType.dfa = dFAStateArray;
    }

    private void collectLeaves(Node node, Object[] objectArray) {
        if (node.type == 0) {
            objectArray[node.position] = node;
        } else {
            int n = node.children.length;
            for (int i = 0; i < n; ++i) {
                this.collectLeaves(node.children[i], objectArray);
            }
        }
    }

    private void calcFollowList(Node node, BitSet[] bitSetArray, boolean bl) {
        if (bl) {
            if (node.occurrence == 2 || node.occurrence == 3) {
                BitSet bitSet = node.firstPos(this.fCount);
                BitSet bitSet2 = node.lastPos(this.fCount);
                for (int i = 0; i < this.fCount; ++i) {
                    if (!bitSet2.getBit(i)) continue;
                    bitSetArray[i].setBits(bitSet);
                }
            }
            this.calcFollowList(node, bitSetArray, false);
            return;
        }
        if (node.type == 0) {
            return;
        }
        int n = node.children.length;
        block1: for (int i = 0; i < n - 1; ++i) {
            this.calcFollowList(node.children[i], bitSetArray, true);
            if (node.type != 1) continue;
            BitSet bitSet = node.children[i].lastPos(this.fCount);
            for (int j = i + 1; j < n; ++j) {
                BitSet bitSet3 = node.children[j].firstPos(this.fCount);
                for (int k = 0; k < this.fCount; ++k) {
                    if (!bitSet.getBit(k)) continue;
                    bitSetArray[k].setBits(bitSet3);
                }
                if (!node.children[j].emptiable()) continue block1;
            }
        }
        this.calcFollowList(node.children[n - 1], bitSetArray, true);
    }

    private static int[] makeDefStateList(int n) {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = -1;
        }
        return nArray;
    }

    private ElementType.DFAState buildState(int[] nArray, ArrayList arrayList, boolean bl) {
        int n = arrayList.size();
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            if (nArray[i] == -1) continue;
            if (arrayList.get(i) instanceof Wildcard) {
                ++n3;
                continue;
            }
            ++n2;
        }
        int[] nArray2 = new int[n2];
        Element[] elementArray = new Element[n2];
        int[] nArray3 = new int[n3];
        Wildcard[] wildcardArray = new Wildcard[n3];
        n2 = 0;
        n3 = 0;
        for (int i = 0; i < n; ++i) {
            if (nArray[i] == -1) continue;
            if (arrayList.get(i) instanceof Wildcard) {
                nArray3[n3] = nArray[i];
                wildcardArray[n3++] = (Wildcard)arrayList.get(i);
                continue;
            }
            nArray2[n2] = nArray[i];
            elementArray[n2++] = (Element)arrayList.get(i);
        }
        ElementType.DFAState dFAState = new ElementType.DFAState();
        if (n2 > 0) {
            dFAState.elements = elementArray;
            dFAState.elementTable = NamedDeclaration.createMap(dFAState.elements);
            dFAState.estates = nArray2;
        }
        if (n3 > 0) {
            dFAState.wc = wildcardArray;
            dFAState.wstates = nArray3;
        }
        dFAState.isFinal = bl;
        return dFAState;
    }

    Element getElement(XSElementDeclaration xSElementDeclaration) {
        return (Element)this.fElems.get(xSElementDeclaration);
    }

    Wildcard getWildcard(XSWildcard xSWildcard) {
        return (Wildcard)this.fWCs.get(xSWildcard);
    }

    XSObjectList getSubstitutionGroup(XSElementDeclaration xSElementDeclaration) {
        return this.fXSModel.getSubstitutionGroup(xSElementDeclaration);
    }

    XSNamedMap getGlobalElementDeclarations() {
        return this.fXSModel.getComponents((short)2);
    }

    XSTypeDefinition getGlobalTypeAtIndex(int n) {
        return (XSTypeDefinition)this.fGlobalTypes.get(n);
    }

    IDCInstructionBuilder getIDCInstructionBuilder(XSElementDeclaration xSElementDeclaration) {
        IDCInstructionBuilder iDCInstructionBuilder = (IDCInstructionBuilder)this.fIDCBuilders.get(xSElementDeclaration);
        if (iDCInstructionBuilder == null) {
            Attribute[] attributeArray = this.getElement((XSElementDeclaration)xSElementDeclaration).type.ownedChoices;
            int n = attributeArray != null && attributeArray.length > 4 ? attributeArray.length : 0;
            iDCInstructionBuilder = new IDCInstructionBuilder(n);
            this.fIDCBuilders.put(xSElementDeclaration, iDCInstructionBuilder);
        }
        return iDCInstructionBuilder;
    }

    IDCInstructionBuilder getIDCInstructionBuilder(XSWildcard xSWildcard) {
        IDCInstructionBuilder iDCInstructionBuilder = (IDCInstructionBuilder)this.fIDCBuilders.get(xSWildcard);
        if (iDCInstructionBuilder == null) {
            iDCInstructionBuilder = new IDCInstructionBuilder(0);
            this.fIDCBuilders.put(xSWildcard, iDCInstructionBuilder);
        }
        return iDCInstructionBuilder;
    }

    private static Integer getInteger(int n) {
        return n;
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    private static class Node {
        private static final int TYPE_LEAF = 0;
        private static final int TYPE_SEQ = 1;
        private static final int TYPE_CHOICE = 2;
        private static final int OCCUR_0 = 0;
        private static final int OCCUR_1 = 1;
        private static final int OCCUR_0N = 2;
        private static final int OCCUR_1N = 3;
        int type;
        int occurrence;
        Node[] children;
        Object leaf;
        int position;
        BitSet firstPos;
        BitSet lastPos;

        private Node() {
        }

        BitSet firstPos(int n) {
            if (this.firstPos == null) {
                this.firstPos = new BitSet(n);
            } else if (this.firstPos.getLength() != n) {
                this.firstPos.setLength(n);
            } else {
                this.firstPos.clearAll();
            }
            this.calcFirstPos(n);
            return this.firstPos;
        }

        BitSet lastPos(int n) {
            if (this.lastPos == null) {
                this.lastPos = new BitSet(n);
            } else if (this.lastPos.getLength() != n) {
                this.lastPos.setLength(n);
            }
            this.calcLastPos(n);
            return this.lastPos;
        }

        private boolean emptiable() {
            if (this.occurrence == 0 || this.occurrence == 2) {
                return true;
            }
            if (this.type == 2) {
                int n = this.children.length;
                for (int i = 0; i < n; ++i) {
                    if (!this.children[i].emptiable()) continue;
                    return true;
                }
            } else if (this.type == 1) {
                int n = this.children.length;
                for (int i = 0; i < n; ++i) {
                    if (this.children[i].emptiable()) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        private void calcFirstPos(int n) {
            if (this.type == 0) {
                this.firstPos.setBit(this.position);
                return;
            }
            if (this.type == 2) {
                int n2 = this.children.length;
                for (int i = 0; i < n2; ++i) {
                    this.firstPos.setBits(this.children[i].firstPos(n));
                }
                return;
            }
            this.firstPos.setBits(this.children[0].firstPos(n));
            int n3 = this.children.length;
            for (int i = 0; i < n3 - 1 && this.children[i].emptiable(); ++i) {
                this.firstPos.setBits(this.children[i + 1].firstPos(n));
            }
        }

        private void calcLastPos(int n) {
            if (this.type == 0) {
                this.lastPos.setBit(this.position);
                return;
            }
            if (this.type == 2) {
                int n2 = this.children.length;
                for (int i = 0; i < n2; ++i) {
                    this.lastPos.setBits(this.children[i].lastPos(n));
                }
                return;
            }
            int n3 = this.children.length;
            this.lastPos.setBits(this.children[n3 - 1].lastPos(n));
            for (int i = n3 - 1; i > 0 && this.children[i].emptiable(); --i) {
                this.lastPos.setBits(this.children[i - 1].lastPos(n));
            }
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    public static class ConverterException
    extends Exception {
        public ConverterException(String string) {
            super(string);
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    private static final class NodePool {
        private final Stack<Node> nodes = new Stack();

        private NodePool() {
        }

        private Node allocate() {
            if (this.nodes.empty()) {
                return new Node();
            }
            return this.nodes.pop();
        }

        Node leaf(int n, Object object, int n2) {
            Node node = this.allocate();
            node.type = 0;
            node.occurrence = n;
            node.leaf = object;
            node.position = n2;
            return node;
        }

        Node group(boolean bl, int n, Node[] nodeArray) {
            Node node = this.allocate();
            node.type = bl ? 1 : 2;
            node.occurrence = n;
            node.children = nodeArray;
            return node;
        }

        void returnNodes(Node node) {
            if (node.lastPos != null) {
                node.lastPos.setLength(0);
            }
            if (node.firstPos != null) {
                node.firstPos.setLength(0);
            }
            this.nodes.push(node);
            if (node.type != 0) {
                Node[] nodeArray = node.children;
                int n = nodeArray.length;
                for (int i = 0; i < n; ++i) {
                    this.returnNodes(nodeArray[i]);
                }
            }
        }

        void reset() {
            this.nodes.removeAllElements();
        }
    }
}

