/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.api.stax;

import com.ibm.xml.xlxp2.api.stax.EmptyLocation;
import com.ibm.xml.xlxp2.api.stax.JavaXNamespaceContext;
import com.ibm.xml.xlxp2.api.stax.StAXImplProperties;
import com.ibm.xml.xlxp2.api.stax.XMLStreamReaderBase;
import com.ibm.xml.xlxp2.api.stax.events.EntityDeclarationImpl;
import com.ibm.xml.xlxp2.api.stax.events.NotationDeclarationImpl;
import com.ibm.xml.xlxp2.api.stax.msg.StAXMessageProvider;
import com.ibm.xml.xlxp2.scan.Copyright;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Notation;
import org.w3c.dom.Text;
import org.w3c.dom.TypeInfo;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
final class DOMStreamReaderImpl
extends XMLStreamReaderBase {
    private StAXImplProperties fProperties;
    private JavaXNamespaceContext fNamespaceContext = new JavaXNamespaceContext();
    private ArrayList<Node> fAttributes;
    private String fTextContent;
    private Text fCoalescedCharacters;
    private StringBuilder fCoalescedBuffer;
    private Node fRoot;
    private Node fCurrent;
    private boolean fCurrentDone;
    private boolean fNextDone;
    private boolean fIsLevel3;

    DOMStreamReaderImpl(Node node, StAXImplProperties stAXImplProperties) throws XMLStreamException {
        this.fNSContext = this.fNamespaceContext;
        this.fAttributes = new ArrayList();
        this.fCoalescedCharacters = null;
        this.fCoalescedBuffer = new StringBuilder();
        this.setNode(node, stAXImplProperties);
    }

    void setNode(Node node, StAXImplProperties stAXImplProperties) throws XMLStreamException {
        this.fProperties = stAXImplProperties;
        this.fNamespaceContext.reset();
        this.fCurrentDone = false;
        this.fRoot = node;
        short s = this.fRoot.getNodeType();
        this.fCurrent = s == 9 ? node : node.getOwnerDocument();
        this.fIsLevel3 = ((Document)this.fCurrent).getImplementation().hasFeature("Core", "3.0");
        if (!this.fIsLevel3) {
            this.fCoalescedBuffer.setLength(0);
        }
        Document document = (Document)this.fCurrent;
        if (this.fIsLevel3) {
            this.fVersion = document.getXmlVersion();
            this.fXMLEncoding = document.getXmlEncoding();
            this.fStandalone = document.getXmlStandalone();
            this.fInputEncoding = document.getInputEncoding();
        } else {
            this.fVersion = null;
            this.fXMLEncoding = null;
            this.fInputEncoding = null;
            this.fStandalone = false;
        }
        this.enterCurrentNode();
    }

    private boolean enterCurrentNode() throws XMLStreamException {
        short s = this.fCurrent.getNodeType();
        switch (s) {
            case 1: {
                if (this.fCurrentDone) {
                    this.fEventType = 2;
                    break;
                }
                this.fNamespaceContext.startScope();
                this.fAttributes.clear();
                NamedNodeMap namedNodeMap = this.fCurrent.getAttributes();
                int n = namedNodeMap == null ? 0 : namedNodeMap.getLength();
                for (int i = 0; i < n; ++i) {
                    Node node = namedNodeMap.item(i);
                    if ("http://www.w3.org/2000/xmlns/".equals(node.getNamespaceURI())) {
                        if (node.getNodeName().length() == "xmlns".length()) {
                            this.fNamespaceContext.declareNamespace("", node.getNodeValue());
                            continue;
                        }
                        this.fNamespaceContext.declareNamespace(node.getLocalName(), node.getNodeValue());
                        continue;
                    }
                    this.fAttributes.add(node);
                }
                this.fEventType = 1;
                break;
            }
            case 3: {
                if (this.fProperties.isCoalescing) {
                    this.coalesceCharacters();
                    this.fEventType = 4;
                    break;
                }
                if (this.fIsLevel3) {
                    this.fEventType = ((Text)this.fCurrent).isElementContentWhitespace() ? 6 : 4;
                    break;
                }
                this.fEventType = 4;
                break;
            }
            case 4: {
                if (this.fProperties.isCoalescing) {
                    this.coalesceCharacters();
                    this.fEventType = 4;
                    break;
                }
                this.fEventType = 12;
                break;
            }
            case 5: {
                if (this.fProperties.isReplacingEntityReferences) {
                    return false;
                }
                this.fEventType = 9;
                this.coalesceChildText(this.fCurrent);
                this.fCurrentDone = true;
                break;
            }
            case 7: {
                this.fEventType = 3;
                break;
            }
            case 8: {
                this.fEventType = 5;
                break;
            }
            case 11: {
                return false;
            }
            case 9: {
                this.fEventType = this.fCurrentDone ? 8 : 7;
                break;
            }
            case 10: {
                Object object;
                this.fEventType = 11;
                DocumentType documentType = (DocumentType)this.fCurrent;
                this.fRootName = documentType.getName();
                this.fPubId = documentType.getPublicId();
                this.fSysId = documentType.getSystemId();
                NamedNodeMap namedNodeMap = documentType.getEntities();
                for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                    EntityDeclarationImpl entityDeclarationImpl;
                    Entity entity = (Entity)namedNodeMap.item(i);
                    if (entity.getNotationName() == null) {
                        if (entity.getSystemId() == null) {
                            if (this.fIsLevel3) {
                                object = entity.getTextContent();
                            } else {
                                this.coalesceChildText(entity);
                                object = this.fCoalescedBuffer.toString();
                            }
                            entityDeclarationImpl = new EntityDeclarationImpl(entity.getNodeName(), (String)object);
                            this.fEntityDecls.add(entityDeclarationImpl);
                            continue;
                        }
                        entityDeclarationImpl = new EntityDeclarationImpl(entity.getNodeName(), entity.getPublicId(), entity.getSystemId());
                        this.fEntityDecls.add(entityDeclarationImpl);
                        continue;
                    }
                    entityDeclarationImpl = new EntityDeclarationImpl(entity.getNodeName(), entity.getPublicId(), entity.getSystemId(), entity.getNotationName());
                    this.fEntityDecls.add(entityDeclarationImpl);
                }
                NamedNodeMap namedNodeMap2 = documentType.getNotations();
                for (int i = 0; i < namedNodeMap2.getLength(); ++i) {
                    object = (Notation)namedNodeMap2.item(i);
                    NotationDeclarationImpl notationDeclarationImpl = new NotationDeclarationImpl(object.getNodeName(), object.getPublicId(), object.getSystemId());
                    this.fNotationDecls.add(notationDeclarationImpl);
                }
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private void coalesceCharacters() {
        this.fCoalescedCharacters = (Text)this.fCurrent;
        if (!this.fProperties.isReplacingEntityReferences || !this.fIsLevel3) {
            this.fCoalescedBuffer.setLength(0);
            this.fCoalescedBuffer.append(((Text)this.fCurrent).getNodeValue());
        }
        boolean bl = false;
        while (!bl) {
            Node node = this.nextNode();
            if (node != null) {
                short s = node.getNodeType();
                if (s == 5) {
                    if (this.fProperties.isReplacingEntityReferences) {
                        this.fCurrent = node;
                        this.fCurrentDone = this.fNextDone;
                        continue;
                    }
                    bl = true;
                    continue;
                }
                if (s == 3 || s == 4) {
                    this.fCurrent = node;
                    this.fCurrentDone = this.fNextDone;
                    if (this.fProperties.isReplacingEntityReferences && this.fIsLevel3) continue;
                    this.fCoalescedBuffer.append(((Text)this.fCurrent).getNodeValue());
                    continue;
                }
                bl = true;
                continue;
            }
            bl = true;
        }
    }

    private void coalesceChildText(Node node) {
        this.fCoalescedBuffer.setLength(0);
        boolean bl = true;
        for (Node node2 = node.getFirstChild(); bl && node2 != null; node2 = node2.getNextSibling()) {
            short s = node2.getNodeType();
            if (s == 3 || s == 4) {
                this.fCoalescedBuffer.append(((Text)node2).getNodeValue());
                continue;
            }
            bl = false;
        }
        if (!bl) {
            this.fCoalescedBuffer.setLength(0);
        }
    }

    public int next() throws XMLStreamException {
        if (!this.hasNext()) {
            StAXMessageProvider.throwNoSuchElementException(StAXMessageProvider.createMessage(null, 28));
        }
        if (this.fEventType == 2) {
            this.fNamespaceContext.endScope();
        }
        this.fTextContent = null;
        do {
            this.fCurrent = this.nextNode();
            this.fCurrentDone = this.fNextDone;
        } while (!this.enterCurrentNode());
        return this.fEventType;
    }

    private Node nextNode() {
        if (this.fEventType == 8) {
            return null;
        }
        Node node = null;
        this.fNextDone = false;
        if (this.fCurrent == this.fRoot && this.fCurrentDone) {
            if (this.fCurrent.getNodeType() != 9) {
                this.fNextDone = true;
                return this.fRoot.getOwnerDocument();
            }
            return null;
        }
        if (this.fCurrent.getNodeType() == 9 && this.fRoot.getNodeType() != 9) {
            node = ((Document)this.fCurrent).getDoctype();
            if (node != null) {
                return node;
            }
            return this.fRoot;
        }
        if (this.fCurrent.getNodeType() == 10 && this.fRoot.getNodeType() != 9) {
            return this.fRoot;
        }
        short s = this.fCurrent.getNodeType();
        if (!this.fCurrentDone) {
            node = this.fCurrent.getFirstChild();
            if (node != null) {
                return node;
            }
            if (this.isNotifyOnLeavingType(s)) {
                this.fNextDone = true;
                return this.fCurrent;
            }
        }
        Node node2 = this.fCurrent;
        while (node2 != this.fRoot) {
            node = node2.getNextSibling();
            if (node != null) {
                return node;
            }
            if (!this.isNotifyOnLeavingType((node2 = node2.getParentNode()).getNodeType())) continue;
            this.fNextDone = true;
            return node2;
        }
        this.fNextDone = true;
        return this.fRoot.getOwnerDocument();
    }

    private boolean isNotifyOnLeavingType(int n) {
        return n == 1 || n == 9;
    }

    public boolean hasNext() throws XMLStreamException {
        return this.fEventType != 8;
    }

    public void close() {
        super.close();
        this.fCurrent = null;
        this.fRoot = null;
        this.fNamespaceContext.reset();
        this.fAttributes.clear();
        this.fCoalescedCharacters = null;
        this.fTextContent = null;
        this.fCurrentDone = false;
        this.fPoolableHelper.returnToPool();
    }

    public boolean isWhiteSpace() {
        if (this.fEventType == 4) {
            String string = this.getText();
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == ' ' || c == '\n' || c == '\t' || c == '\r') continue;
                return false;
            }
            return true;
        }
        return this.fEventType == 6;
    }

    public String getAttributeValue(String string, String string2) {
        super.getAttributeValue(string, string2);
        Element element = (Element)this.fCurrent;
        Attr attr = this.fProperties.isNamespaceAware ? element.getAttributeNodeNS(string, string2) : element.getAttributeNode(string2);
        return attr == null ? null : attr.getNodeValue();
    }

    public int getAttributeCount() {
        super.getAttributeCount();
        return this.fAttributes.size();
    }

    public QName getAttributeName(int n) {
        super.getAttributeName(n);
        if (n >= this.getAttributeCount()) {
            throw new IndexOutOfBoundsException();
        }
        Attr attr = (Attr)this.fAttributes.get(n);
        return this.createQName(attr);
    }

    public String getAttributeNamespace(int n) {
        super.getAttributeNamespace(n);
        if (n >= this.getAttributeCount()) {
            throw new IndexOutOfBoundsException();
        }
        if (!this.fProperties.isNamespaceAware) {
            return null;
        }
        Attr attr = (Attr)this.fAttributes.get(n);
        return attr.getNamespaceURI();
    }

    public String getAttributeLocalName(int n) {
        super.getAttributeLocalName(n);
        if (n >= this.getAttributeCount()) {
            throw new IndexOutOfBoundsException();
        }
        Attr attr = (Attr)this.fAttributes.get(n);
        if (this.fProperties.isNamespaceAware) {
            return attr.getLocalName();
        }
        return attr.getName();
    }

    public String getAttributePrefix(int n) {
        super.getAttributePrefix(n);
        if (n >= this.getAttributeCount()) {
            throw new IndexOutOfBoundsException();
        }
        if (!this.fProperties.isNamespaceAware) {
            return null;
        }
        Attr attr = (Attr)this.fAttributes.get(n);
        return attr.getPrefix();
    }

    public String getAttributeType(int n) {
        TypeInfo typeInfo;
        super.getAttributeType(n);
        if (n >= this.getAttributeCount()) {
            throw new IndexOutOfBoundsException();
        }
        Attr attr = (Attr)this.fAttributes.get(n);
        String string = this.fIsLevel3 ? ((typeInfo = attr.getSchemaTypeInfo()) != null && "http://www.w3.org/TR/REC-xml".equals(typeInfo.getTypeNamespace()) ? typeInfo.getTypeName() : "CDATA") : "CDATA";
        return string;
    }

    public String getAttributeValue(int n) {
        super.getAttributeValue(n);
        if (n >= this.getAttributeCount()) {
            throw new IndexOutOfBoundsException();
        }
        Attr attr = (Attr)this.fAttributes.get(n);
        return attr.getNodeValue();
    }

    public boolean isAttributeSpecified(int n) {
        super.isAttributeSpecified(n);
        if (n >= this.getAttributeCount()) {
            throw new IndexOutOfBoundsException();
        }
        Attr attr = (Attr)this.fAttributes.get(n);
        return attr.getSpecified();
    }

    public int getNamespaceCount() {
        super.getNamespaceCount();
        return this.fNamespaceContext.getNamespaceCount();
    }

    public String getNamespacePrefix(int n) {
        super.getNamespacePrefix(n);
        if (n >= this.getNamespaceCount()) {
            throw new IndexOutOfBoundsException();
        }
        String string = this.fNamespaceContext.getNamespacePrefix(n);
        return "".equals(string) ? null : string;
    }

    public String getNamespaceURI(int n) {
        super.getNamespaceURI(n);
        if (n >= this.getNamespaceCount()) {
            throw new IndexOutOfBoundsException();
        }
        return this.fNamespaceContext.getNamespaceURI(n);
    }

    public String getText() {
        if (this.fTextContent != null) {
            return this.fTextContent;
        }
        this.fTextContent = this.prepareText();
        return this.fTextContent;
    }

    private String prepareText() {
        if (this.fEventType == 4) {
            if (this.fProperties.isCoalescing) {
                if (this.fProperties.isReplacingEntityReferences && this.fIsLevel3) {
                    return this.fCoalescedCharacters.getWholeText();
                }
                return this.fCoalescedBuffer.toString();
            }
            return this.fCurrent.getNodeValue();
        }
        if (this.fEventType == 11) {
            DocumentType documentType = (DocumentType)this.fCurrent;
            return documentType.getInternalSubset();
        }
        if (this.fEventType == 9) {
            if (this.fCoalescedBuffer.length() > 0) {
                return this.fCoalescedBuffer.toString();
            }
            return null;
        }
        if (this.fEventType == 5 || this.fEventType == 12 || this.fEventType == 6) {
            return this.fCurrent.getNodeValue();
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 19));
        return null;
    }

    public char[] getTextCharacters() {
        super.getTextCharacters();
        return this.getText().toCharArray();
    }

    public int getTextCharacters(int n, char[] cArray, int n2, int n3) throws XMLStreamException {
        super.getTextCharacters(n, cArray, n2, n3);
        String string = this.getText();
        int n4 = string.length();
        if (n4 < n + n3) {
            n3 = n4 - n;
        }
        string.getChars(n, n + n3, cArray, n2);
        return n3;
    }

    public int getTextLength() {
        super.getTextLength();
        return this.getText().length();
    }

    public Location getLocation() {
        if (this.fLocation != null) {
            return this.fLocation;
        }
        this.fLocation = new EmptyLocation();
        return this.fLocation;
    }

    public QName getName() {
        super.getName();
        return this.createQName(this.fCurrent);
    }

    public String getLocalName() {
        super.getLocalName();
        if (this.fEventType == 9) {
            return this.fCurrent.getNodeName();
        }
        return this.fCurrent.getLocalName();
    }

    public String getNamespaceURI() {
        super.getNamespaceURI();
        if (this.fProperties.isNamespaceAware) {
            return this.fCurrent.getNamespaceURI();
        }
        return null;
    }

    public String getPrefix() {
        super.getPrefix();
        if (this.fProperties.isNamespaceAware) {
            return this.fCurrent.getPrefix();
        }
        return null;
    }

    public boolean standaloneSet() {
        super.standaloneSet();
        return this.fStandalone;
    }

    public String getPITarget() {
        super.getPITarget();
        return this.fCurrent.getNodeName();
    }

    public String getPIData() {
        super.getPIData();
        return this.fCurrent.getNodeValue();
    }

    private QName createQName(Node node) {
        QName qName;
        if (this.fProperties.isNamespaceAware) {
            String string = node.getPrefix();
            if (string == null) {
                string = "";
            }
            qName = new QName(node.getNamespaceURI(), node.getLocalName(), string);
        } else {
            qName = new QName(node.getLocalName());
        }
        return qName;
    }
}

