/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.api.jaxp.impl;

import com.ibm.xml.xlxp2.api.jaxp.impl.SAXParserImpl;
import com.ibm.xml.xlxp2.scan.Copyright;
import java.util.Hashtable;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public class SAXParserFactoryImpl
extends SAXParserFactory {
    public static final String SAX_NAMESPACES_FEATURE = "http://xml.org/sax/features/namespaces";
    public static final String SAX_VALIDATION_FEATURE = "http://xml.org/sax/features/validation";
    private boolean fEnableSecureProcessing = false;
    protected Hashtable<String, Object> fFeatures = null;

    public SAXParser newSAXParser() throws ParserConfigurationException, SAXException {
        return new SAXParserImpl(this, this.fFeatures);
    }

    public void setFeature(String string, boolean bl) throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException {
        if (string == null) {
            throw new NullPointerException();
        }
        if (string.equals("http://javax.xml.XMLConstants/feature/secure-processing")) {
            if (bl) {
                throw new SAXNotSupportedException("The JAXP 1.3 feature: http://javax.xml.XMLConstants/feature/secure-processing was recognized but the requested value " + bl + " could not be set.");
            }
            this.fEnableSecureProcessing = bl;
        }
        if (this.fFeatures == null) {
            this.fFeatures = new Hashtable();
        }
        this.fFeatures.put(string, bl);
        try {
            new SAXParserImpl(this, this.fFeatures);
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            this.fFeatures.remove(string);
            throw sAXNotRecognizedException;
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            this.fFeatures.remove(string);
            throw sAXNotSupportedException;
        }
        catch (SAXException sAXException) {
            this.fFeatures.remove(string);
            throw new ParserConfigurationException(sAXException.getMessage());
        }
    }

    public boolean getFeature(String string) throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException {
        boolean bl = false;
        if (string == null) {
            throw new NullPointerException();
        }
        if (string.equals("http://javax.xml.XMLConstants/feature/secure-processing")) {
            return this.fEnableSecureProcessing;
        }
        try {
            bl = new SAXParserImpl(this, this.fFeatures).getXMLReader().getFeature(string);
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            throw sAXNotRecognizedException;
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            throw sAXNotSupportedException;
        }
        catch (SAXException sAXException) {
            throw new ParserConfigurationException(sAXException.getMessage());
        }
        return bl;
    }

    public void setValidating(boolean bl) {
        super.setValidating(bl);
        if (this.fFeatures == null) {
            this.fFeatures = new Hashtable();
        }
        this.fFeatures.put(SAX_VALIDATION_FEATURE, bl);
    }

    public void setNamespaceAware(boolean bl) {
        super.setNamespaceAware(bl);
        if (this.fFeatures == null) {
            this.fFeatures = new Hashtable();
        }
        this.fFeatures.put(SAX_NAMESPACES_FEATURE, bl);
    }
}

