/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fcg.javasrc;

import com.ibm.fcg.FcgAttrs;
import com.ibm.fcg.FcgClassCollector;
import com.ibm.fcg.FcgClassGen;
import com.ibm.fcg.FcgClassReferenceType;
import com.ibm.fcg.FcgCodeGen;
import com.ibm.fcg.FcgField;
import com.ibm.fcg.FcgInstructionList;
import com.ibm.fcg.FcgMethodGen;
import com.ibm.fcg.FcgReferenceType;
import com.ibm.fcg.FcgType;
import com.ibm.fcg.ifacecore.FcgBasicType;
import com.ibm.fcg.impl.FcgClassGenImpl;
import com.ibm.fcg.impl.FcgFieldGenImpl;
import com.ibm.fcg.javasrc.FcgFieldJavaSrc;
import com.ibm.fcg.javasrc.FcgInstructionListJavaSrc;
import com.ibm.fcg.javasrc.FcgMethodGenJavaSrc;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;

public class FcgClassGenJavaSrc
extends FcgClassGenImpl
implements FcgClassGen {
    protected FcgClassReferenceType m_classReference;
    protected FcgClassReferenceType m_superClassReference;
    protected String m_fileName;
    protected String m_className;
    protected String m_packageName;
    protected FcgAttrs m_attrs;
    protected ArrayList attribute_vec = new ArrayList();
    protected ArrayList interface_vec = new ArrayList();
    protected int m_numberOfClassFields;
    FcgInstructionList m_classLoad;
    FcgMethodGen m_staticCode;
    private boolean m_defaultConstructorAdded = false;
    public static final char[] m_eol = System.getProperty("line.separator").toCharArray();

    public FcgClassGenJavaSrc(FcgCodeGen fcgCodeGen, FcgClassReferenceType fcgClassReferenceType, FcgClassReferenceType fcgClassReferenceType2, String string, FcgAttrs fcgAttrs, String[] stringArray) {
        super(fcgCodeGen);
        this.m_classReference = fcgClassReferenceType;
        this.m_superClassReference = fcgClassReferenceType2;
        this.m_fileName = string;
        this.m_attrs = fcgAttrs;
        String string2 = fcgClassReferenceType.getTypeName();
        int n = string2.lastIndexOf(46);
        if (n > 0) {
            this.m_className = string2.substring(n + 1);
            this.m_packageName = string2.substring(0, n);
        } else {
            this.m_className = string2;
            this.m_packageName = null;
        }
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.interface_vec.add(stringArray[i]);
            }
        }
    }

    @Override
    public void dump(File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(fileOutputStream));
        this.dump(bufferedWriter);
        bufferedWriter.flush();
    }

    public void dump(Writer writer) throws IOException {
        int n;
        if (this.m_packageName != null) {
            writer.write("package ");
            writer.write(this.m_packageName);
            writer.write(59);
            writer.write(m_eol);
        }
        String string = this.createAttrDeclaration(this.m_attrs);
        writer.write(string);
        writer.write("class ");
        writer.write(this.m_className);
        if (this.m_superClassReference != null) {
            writer.write(" extends ");
            writer.write(this.m_superClassReference.getTypeName());
        }
        if (0 < (n = this.interface_vec.size())) {
            writer.write(" implements ");
            for (int i = 0; i < n; ++i) {
                if (0 < i) {
                    writer.write(44);
                }
                writer.write((String)this.interface_vec.get(i));
            }
        }
        this.dumpContents(writer);
    }

    public void dumpContents(Writer writer) throws IOException {
        Object object;
        int n;
        writer.write(" {");
        writer.write(m_eol);
        for (n = 0; n < super.getNumFcgFields(); ++n) {
            object = super.getField(n);
            ((FcgFieldGenImpl)object).dump(writer);
        }
        if (this.m_classLoad != null) {
            writer.write("  static {");
            writer.write(m_eol);
            StringBuffer stringBuffer = ((FcgInstructionListJavaSrc)this.m_classLoad).getCode();
            writer.write(stringBuffer.toString());
            writer.write("  }");
            writer.write(m_eol);
        }
        for (n = 0; n < this.method_vec.size(); ++n) {
            object = (FcgMethodGenJavaSrc)this.method_vec.get(n);
            ((FcgMethodGenJavaSrc)object).dump(writer);
        }
        writer.write("}");
        writer.write(m_eol);
    }

    @Override
    public void dump(OutputStream outputStream) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
        this.dump(bufferedWriter);
        bufferedWriter.flush();
        bufferedWriter.close();
    }

    public String getClassName() {
        return this.m_classReference.getTypeName();
    }

    @Override
    public String getSuperClassName() {
        return this.m_superClassReference.getTypeName();
    }

    @Override
    public FcgClassReferenceType getClassType() {
        return this.m_classReference;
    }

    @Override
    public FcgClassReferenceType getSuperClassType() {
        return this.m_superClassReference;
    }

    @Override
    public FcgInstructionList newInstructionList() {
        return new FcgInstructionListJavaSrc(this);
    }

    @Override
    public FcgInstructionList newInstructionList(FcgMethodGen fcgMethodGen) {
        return new FcgInstructionListJavaSrc(this, fcgMethodGen);
    }

    @Override
    public FcgInstructionList getClassInstructionList() {
        if (this.m_classLoad == null) {
            this.m_classLoad = new FcgInstructionListJavaSrc(this);
        }
        return this.m_classLoad;
    }

    protected String createAttrDeclaration(FcgAttrs fcgAttrs) {
        String string = fcgAttrs != null ? this.toString(fcgAttrs) : "public ";
        return string;
    }

    protected String toString(FcgAttrs fcgAttrs) {
        StringBuffer stringBuffer = new StringBuffer();
        if (fcgAttrs.isAbstract()) {
            stringBuffer.append("abstract ");
        }
        if (fcgAttrs.isFinal()) {
            stringBuffer.append("final ");
        }
        if (fcgAttrs.isPublic()) {
            stringBuffer.append("public ");
        }
        if (fcgAttrs.isPrivate()) {
            stringBuffer.append("private ");
        }
        if (fcgAttrs.isProtected()) {
            stringBuffer.append("protected ");
        }
        if (fcgAttrs.isStatic()) {
            stringBuffer.append("static ");
        }
        if (fcgAttrs.isVolatile()) {
            stringBuffer.append("volatile ");
        }
        String string = stringBuffer.toString();
        return string;
    }

    String createDeclaration(String string, FcgAttrs fcgAttrs, FcgType fcgType) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.createAttrDeclaration(fcgAttrs));
        stringBuffer.append(this.fcgType2Name(fcgType));
        stringBuffer.append(' ');
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    @Override
    public FcgMethodGen getClassInitMethod() {
        if (this.m_staticCode == null) {
            this.m_staticCode = new FcgMethodGenJavaSrc(this, null, null, this.m_classReference, null, null);
        }
        return this.m_staticCode;
    }

    @Override
    public FcgField newInstanceField(FcgAttrs fcgAttrs, FcgType fcgType, String string) {
        if (fcgAttrs == null) {
            fcgAttrs = FcgAttrs.PUBLIC;
        }
        FcgFieldJavaSrc fcgFieldJavaSrc = new FcgFieldJavaSrc(this, fcgAttrs, fcgType, string);
        super.addField(fcgFieldJavaSrc);
        return fcgFieldJavaSrc;
    }

    @Override
    public FcgField newClassField(FcgAttrs fcgAttrs, FcgType fcgType, String string) {
        if (fcgAttrs == null) {
            fcgAttrs = FcgAttrs.PUBLIC_STATIC;
        }
        FcgFieldJavaSrc fcgFieldJavaSrc = new FcgFieldJavaSrc(this, fcgAttrs, fcgType, string);
        super.addField(fcgFieldJavaSrc);
        ++this.m_numberOfClassFields;
        return fcgFieldJavaSrc;
    }

    @Override
    public int getNumberOfClassFields() {
        return this.m_numberOfClassFields;
    }

    @Override
    public FcgMethodGen newConstructorGen(FcgAttrs fcgAttrs) {
        FcgMethodGenJavaSrc fcgMethodGenJavaSrc = new FcgMethodGenJavaSrc(this, fcgAttrs, null, this.m_fcgCodeGen.getClassReferenceType(this.m_className), null, null);
        return fcgMethodGenJavaSrc;
    }

    public FcgMethodGen newMethodGen(FcgAttrs fcgAttrs, FcgType fcgType, FcgReferenceType fcgReferenceType, String string, FcgType[] fcgTypeArray, FcgInstructionList fcgInstructionList) {
        FcgMethodGenJavaSrc fcgMethodGenJavaSrc = new FcgMethodGenJavaSrc(this, fcgAttrs, fcgType, fcgReferenceType, string, fcgInstructionList);
        return fcgMethodGenJavaSrc;
    }

    public FcgMethodGen newMethodGen(FcgAttrs fcgAttrs, FcgBasicType fcgBasicType, String string, FcgInstructionList fcgInstructionList) {
        FcgMethodGen fcgMethodGen = this.newMethodGen(fcgAttrs, fcgBasicType, string, fcgInstructionList);
        return fcgMethodGen;
    }

    @Override
    public void comment(String string) {
    }

    @Override
    public void finish() {
    }

    @Override
    public FcgMethodGen newMethodGen(FcgAttrs fcgAttrs, FcgType fcgType, String string, FcgInstructionList fcgInstructionList) {
        FcgClassReferenceType fcgClassReferenceType = this.getClassType();
        FcgMethodGenJavaSrc fcgMethodGenJavaSrc = new FcgMethodGenJavaSrc(this, fcgAttrs, fcgType, fcgClassReferenceType, string, fcgInstructionList);
        return fcgMethodGenJavaSrc;
    }

    @Override
    public FcgCodeGen getFcgCodeGen() {
        return this.m_fcgCodeGen;
    }

    public FcgMethodGen newConstructorGen(FcgAttrs fcgAttrs, String string, FcgInstructionList fcgInstructionList) {
        FcgMethodGenJavaSrc fcgMethodGenJavaSrc = new FcgMethodGenJavaSrc(this, fcgInstructionList);
        return fcgMethodGenJavaSrc;
    }

    @Override
    public void addDefaultConstructor(FcgCodeGen fcgCodeGen) {
        this.addDefaultConstructor(fcgCodeGen, null);
    }

    @Override
    public void addDefaultConstructor(FcgCodeGen fcgCodeGen, FcgInstructionList fcgInstructionList) {
        this.m_defaultConstructorAdded = true;
        String string = this.getClassName();
        FcgMethodGen fcgMethodGen = this.newConstructorGen(FcgAttrs.PUBLIC, string, fcgInstructionList);
        FcgInstructionList fcgInstructionList2 = fcgMethodGen.getInstructionList();
        fcgInstructionList2.beginMethod();
        fcgInstructionList2.endMethod();
    }

    @Override
    public void addInterface(String string) {
        if (!this.interface_vec.contains(string)) {
            this.interface_vec.add(string);
        }
    }

    public FcgMethodGen getCurrentMethod() {
        return null;
    }

    public void setCurrentMethod(FcgMethodGen fcgMethodGen) {
    }

    @Override
    public FcgMethodGen newMethodGen(FcgAttrs fcgAttrs, FcgType fcgType, String string) {
        return this.newMethodGen(fcgAttrs, fcgType, string, (FcgInstructionList)null);
    }

    public static FcgClassCollector newClassCollector(final File file) {
        return new FcgClassCollector(){

            @Override
            public void acceptGeneratedClass(FcgClassGen fcgClassGen) {
                try {
                    String string = fcgClassGen.getClassType().getTypeName() + ".java";
                    File file2 = new File(file, string);
                    fcgClassGen.dump(file2);
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            }
        };
    }
}

