/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.internal.adaptor;

import com.ibm.ws.install.InstallException;
import com.ibm.ws.install.internal.InstallLogUtils;
import com.ibm.ws.install.internal.InstallUtils;
import com.ibm.ws.install.internal.Product;
import com.ibm.ws.install.internal.adaptor.ArchiveAdaptor;
import com.ibm.ws.install.internal.asset.JarAsset;
import com.ibm.ws.kernel.boot.cmdline.Utils;
import com.ibm.ws.repository.connections.RestRepositoryConnectionProxy;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;

public class ServerPackageJarAdaptor
extends ArchiveAdaptor {
    private static Logger logger = Logger.getLogger("com.ibm.ws.install");

    public static void install(Product product, final JarAsset jarAsset, List<File> filesInstalled, boolean downloadDependencies, RestRepositoryConnectionProxy proxy) throws IOException, InstallException {
        Map<String, Object> extractor;
        final URLClassLoader[] loader = new URLClassLoader[]{null};
        try {
            extractor = AccessController.doPrivileged(new PrivilegedExceptionAction<Map<String, Object>>(){

                @Override
                public Map<String, Object> run() throws Exception {
                    loader[0] = new URLClassLoader(new URL[]{jarAsset.getAsset().toURI().toURL()}, null);
                    Class<?> clazz = loader[0].loadClass("wlp.lib.extract.MapBasedSelfExtractor");
                    return (Map)clazz.newInstance();
                }
            });
        }
        catch (PrivilegedActionException e) {
            ServerPackageJarAdaptor.close(loader[0]);
            throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_UNABLE_RUN_EXTRACTOR", jarAsset.getJarPath(), e.getMessage()), e, 21);
        }
        extractor.put("install.version", 1);
        extractor.put("install.dir", product.getInstallDir());
        extractor.put("target.user.directory", product.getUserDir());
        extractor.put("license.accept", Boolean.TRUE);
        extractor.put("download.deps", false);
        logger.log(Level.FINEST, "ServerPackageJarAdaptor downloadDependencies: " + downloadDependencies);
        List extDeps = (List)extractor.get("list.external.deps");
        List<File> filesToBeInstalled = ServerPackageJarAdaptor.getFilesToBeInstalled(jarAsset, downloadDependencies ? extDeps : Collections.EMPTY_LIST);
        for (File f : filesToBeInstalled) {
            logger.log(Level.FINEST, "ServerPackageJarAdaptor file to be installed: " + f.getAbsolutePath());
        }
        filesInstalled.addAll(filesToBeInstalled);
        int rc = (Integer)extractor.get("installer.init.code");
        logger.log(Level.FINEST, "ServerPackageJarAdaptor install: installer.init.code=" + rc);
        PrintStream orgOut = System.out;
        PrintStream orgErr = System.err;
        final StringBuilder sb = new StringBuilder();
        OutputStream outStream = new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                sb.append((char)b);
            }
        };
        PrintStream newOut = new PrintStream(outStream, true);
        System.setOut(newOut);
        System.setErr(newOut);
        rc = (Integer)extractor.get("install.code");
        logger.log(Level.FINEST, "ServerPackageJarAdaptor install: install.code=" + rc);
        System.setOut(orgOut);
        System.setErr(orgErr);
        logger.log(Level.FINEST, "ServerPackageJarAdaptor install stdout/stderr: " + sb.toString());
        String closeErrMsg = (String)extractor.get("close");
        if (closeErrMsg != null) {
            logger.log(Level.FINEST, "ServerPackageJarAdaptor failed to close extractor: " + closeErrMsg);
        }
        ServerPackageJarAdaptor.close(loader[0]);
        if (rc != 0) {
            String errorMsg = (String)extractor.get("install.error.message");
            InstallUtils.delete(filesInstalled);
            throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_UNABLE_RUN_EXTRACTOR", jarAsset.getJarPath(), errorMsg), 21);
        }
        if (downloadDependencies) {
            try {
                ServerPackageJarAdaptor.downloadExtDependencies(extDeps, proxy);
            }
            catch (InstallException ie) {
                InstallUtils.delete(filesInstalled);
                throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_UNABLE_RUN_EXTRACTOR", jarAsset.getJarPath(), ie.getMessage()), ie, ie.getRc());
            }
        }
        extDeps = null;
    }

    private static void close(URLClassLoader loader) {
        if (loader == null) {
            return;
        }
        try {
            Method m = loader.getClass().getDeclaredMethod("close", new Class[0]);
            m.invoke((Object)loader, new Object[0]);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("LOG_CANNOT_CLOSE_OBJECT", new Object[0]));
        }
    }

    private static List<File> getFilesToBeInstalled(JarAsset jarAsset, List extDeps) {
        File f;
        ArrayList<File> filesToBeInstalled = new ArrayList<File>();
        File userDir = Utils.getUserDir();
        Enumeration<JarEntry> entries = jarAsset.getJar().entries();
        while (entries.hasMoreElements()) {
            ZipEntry ze = entries.nextElement();
            String zeName = ze.getName().toLowerCase();
            if (!zeName.startsWith("wlp/usr") || ze.isDirectory()) continue;
            String entryName = ze.getName().substring("wlp/usr".length());
            f = new File(userDir, entryName);
            if (!f.exists()) {
                filesToBeInstalled.add(f);
            }
            if (!f.getName().equalsIgnoreCase("server.xml")) continue;
            filesToBeInstalled.add(f.getParentFile());
        }
        for (Object e : extDeps) {
            Map m = (Map)e;
            f = new File(userDir, (String)m.get("download.target"));
            if (f.exists()) continue;
            filesToBeInstalled.add(f);
        }
        return filesToBeInstalled;
    }

    private static void downloadExtDependencies(List extDeps, RestRepositoryConnectionProxy proxy) throws InstallException {
        if (extDeps == null || extDeps.isEmpty()) {
            return;
        }
        File userDir = Utils.getUserDir();
        Proxy javaNetProxy = null;
        if (proxy != null) {
            javaNetProxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxy.getProxyURL().getHost(), proxy.getProxyURL().getPort()));
        }
        for (Object extDep : extDeps) {
            Map m = (Map)extDep;
            URL url = (URL)m.get("download.url");
            if (url == null) continue;
            File targetFile = new File(userDir, (String)m.get("download.target"));
            if (targetFile.exists()) {
                logger.log(Level.FINEST, "External library " + url + " already exists in " + targetFile.getAbsolutePath());
                continue;
            }
            if (!targetFile.getParentFile().exists() && !targetFile.getParentFile().mkdirs()) {
                throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_TOOL_DOWNLOADONLY_UNABLE_TO_CREATE_DIR", targetFile.getParentFile().getAbsolutePath()), 25);
            }
            HttpURLConnection connection = null;
            try {
                logger.log(Level.FINE, InstallLogUtils.Messages.SELF_EXTRACTOR_MESSAGES.getLogMessage("downloadingFileNotice", url, targetFile.getAbsolutePath()));
                connection = (HttpURLConnection)(javaNetProxy == null ? url.openConnection() : url.openConnection(javaNetProxy));
                connection.setReadTimeout(30000);
                InstallUtils.download(connection.getInputStream(), targetFile);
                logger.log(Level.FINEST, "External library " + url + " was successfully downloaded to " + targetFile.getAbsolutePath());
            }
            catch (IOException e) {
                throw new InstallException(InstallLogUtils.Messages.SELF_EXTRACTOR_MESSAGES.getLogMessage("downloadFileError", url, targetFile.getAbsolutePath()), e, 33);
            }
            finally {
                if (connection == null) continue;
                connection.disconnect();
            }
        }
    }
}

